# -*- coding: utf-8 -*-

"""
whatsappcloudapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from whatsappcloudapi.api_helper import APIHelper
from whatsappcloudapi.models.component import Component
from whatsappcloudapi.models.language import Language


class Template(object):

    """Implementation of the 'Template' model.

    TODO: type model description here.

    Attributes:
        name (string): Name of the template.
        language (Language): Specifies the language the template may be
            rendered in. Only the deterministic language policy works with
            media template messages.
        components (list of Component): Array of components objects containing
            the parameters of the message.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "language": 'language',
        "components": 'components'
    }

    _optionals = [
        'components',
    ]

    def __init__(self,
                 name=None,
                 language=None,
                 components=APIHelper.SKIP):
        """Constructor for the Template class"""

        # Initialize members of the class
        self.name = name 
        self.language = language 
        if components is not APIHelper.SKIP:
            self.components = components 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        name = dictionary.get("name") if dictionary.get("name") else None
        language = Language.from_dictionary(dictionary.get('language')) if dictionary.get('language') else None
        components = None
        if dictionary.get('components') is not None:
            components = [Component.from_dictionary(x) for x in dictionary.get('components')]
        else:
            components = APIHelper.SKIP
        # Return an object of this model
        return cls(name,
                   language,
                   components)
