# -*- coding: utf-8 -*-

"""
whatsappcloudapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from whatsappcloudapi.api_helper import APIHelper
from whatsappcloudapi.models.currency import Currency
from whatsappcloudapi.models.date_time_object import DateTimeObject
from whatsappcloudapi.models.document import Document
from whatsappcloudapi.models.image import Image
from whatsappcloudapi.models.video import Video


class Parameter(object):

    """Implementation of the 'Parameter' model.

    TODO: type model description here.

    Attributes:
        mtype (ParameterTypeEnum): Describes the parameter type. For
            text-based templates, the only supported parameter types are text,
            currency, date_time.
        text (string): Required when type=text. The message’s text. For the
            header component, the character limit is 60 characters. For the
            body component, the character limit is 1024 characters.
        currency (Currency): Required when type=currency.
        date_time (DateTimeObject): Required when type=date_time.
        image (Image): Required when type=image.
        document (Document): Required when type=document. Only PDF documents
            are supported for media-based message templates.
        video (Video): Required when type=video.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "mtype": 'type',
        "text": 'text',
        "currency": 'currency',
        "date_time": 'date_time',
        "image": 'image',
        "document": 'document',
        "video": 'video'
    }

    _optionals = [
        'text',
        'currency',
        'date_time',
        'image',
        'document',
        'video',
    ]

    def __init__(self,
                 mtype=None,
                 text=APIHelper.SKIP,
                 currency=APIHelper.SKIP,
                 date_time=APIHelper.SKIP,
                 image=APIHelper.SKIP,
                 document=APIHelper.SKIP,
                 video=APIHelper.SKIP):
        """Constructor for the Parameter class"""

        # Initialize members of the class
        self.mtype = mtype 
        if text is not APIHelper.SKIP:
            self.text = text 
        if currency is not APIHelper.SKIP:
            self.currency = currency 
        if date_time is not APIHelper.SKIP:
            self.date_time = date_time 
        if image is not APIHelper.SKIP:
            self.image = image 
        if document is not APIHelper.SKIP:
            self.document = document 
        if video is not APIHelper.SKIP:
            self.video = video 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        mtype = dictionary.get("type") if dictionary.get("type") else None
        text = dictionary.get("text") if dictionary.get("text") else APIHelper.SKIP
        currency = Currency.from_dictionary(dictionary.get('currency')) if 'currency' in dictionary.keys() else APIHelper.SKIP 
        date_time = DateTimeObject.from_dictionary(dictionary.get('date_time')) if 'date_time' in dictionary.keys() else APIHelper.SKIP 
        image = Image.from_dictionary(dictionary.get('image')) if 'image' in dictionary.keys() else APIHelper.SKIP 
        document = Document.from_dictionary(dictionary.get('document')) if 'document' in dictionary.keys() else APIHelper.SKIP 
        video = Video.from_dictionary(dictionary.get('video')) if 'video' in dictionary.keys() else APIHelper.SKIP 
        # Return an object of this model
        return cls(mtype,
                   text,
                   currency,
                   date_time,
                   image,
                   document,
                   video)
