# -*- coding: utf-8 -*-

"""
whatsappcloudapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from whatsappcloudapi.api_helper import APIHelper
from whatsappcloudapi.models.audio import Audio
from whatsappcloudapi.models.contact import Contact
from whatsappcloudapi.models.document import Document
from whatsappcloudapi.models.image import Image
from whatsappcloudapi.models.interactive import Interactive
from whatsappcloudapi.models.location import Location
from whatsappcloudapi.models.sticker import Sticker
from whatsappcloudapi.models.template import Template
from whatsappcloudapi.models.text import Text
from whatsappcloudapi.models.video import Video


class Message(object):

    """Implementation of the 'Message' model.

    TODO: type model description here.

    Attributes:
        audio (Audio): A media object containing audio. Required when
            type=audio.
        contacts (list of Contact): A contact object. Required when
            type=contacts.
        document (Document): A media object containing a document. Required
            when type=document.
        image (Image): A media object containing an image. Required when
            type=image.
        interactive (Interactive): This option is used to send List Messages
            and Reply Buttons. The components of each interactive object
            generally follow a consistent pattern: header, body, footer, and
            action. Required when type=interactive.
        location (Location): A location object. Required when type=location.
        messaging_product (string): Messaging service used for the request.
        recipient_type (string): Currently, you can only send messages to
            individuals.
        sticker (Sticker): A media object containing a sticker. Currently, we
            support inbound both and outbound stickers: For outbound, we only
            support static third-party stickers. For inbound, we support all
            types of stickers. The sticker needs to be 512x512 pixels and the
            file’s size needs to be less than 100 KB. Required when
            type=sticker.
        template (Template): A template object. Required when type=template.
        text (Text): Required for text messages.
        to (string): WhatsApp ID or phone number for the person you want to
            send a message to.
        mtype (MessageTypeEnum): The type of message you want to send.
        video (Video): A media object containing a video. Required when
            type=video.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "messaging_product": 'messaging_product',
        "to": 'to',
        "audio": 'audio',
        "contacts": 'contacts',
        "document": 'document',
        "image": 'image',
        "interactive": 'interactive',
        "location": 'location',
        "recipient_type": 'recipient_type',
        "sticker": 'sticker',
        "template": 'template',
        "text": 'text',
        "mtype": 'type',
        "video": 'video'
    }

    _optionals = [
        'audio',
        'contacts',
        'document',
        'image',
        'interactive',
        'location',
        'recipient_type',
        'sticker',
        'template',
        'text',
        'mtype',
        'video',
    ]

    def __init__(self,
                 messaging_product=None,
                 to=None,
                 audio=APIHelper.SKIP,
                 contacts=APIHelper.SKIP,
                 document=APIHelper.SKIP,
                 image=APIHelper.SKIP,
                 interactive=APIHelper.SKIP,
                 location=APIHelper.SKIP,
                 recipient_type='individual',
                 sticker=APIHelper.SKIP,
                 template=APIHelper.SKIP,
                 text=APIHelper.SKIP,
                 mtype=APIHelper.SKIP,
                 video=APIHelper.SKIP):
        """Constructor for the Message class"""

        # Initialize members of the class
        if audio is not APIHelper.SKIP:
            self.audio = audio 
        if contacts is not APIHelper.SKIP:
            self.contacts = contacts 
        if document is not APIHelper.SKIP:
            self.document = document 
        if image is not APIHelper.SKIP:
            self.image = image 
        if interactive is not APIHelper.SKIP:
            self.interactive = interactive 
        if location is not APIHelper.SKIP:
            self.location = location 
        self.messaging_product = messaging_product 
        self.recipient_type = recipient_type 
        if sticker is not APIHelper.SKIP:
            self.sticker = sticker 
        if template is not APIHelper.SKIP:
            self.template = template 
        if text is not APIHelper.SKIP:
            self.text = text 
        self.to = to 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if video is not APIHelper.SKIP:
            self.video = video 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        messaging_product = dictionary.get("messaging_product") if dictionary.get("messaging_product") else None
        to = dictionary.get("to") if dictionary.get("to") else None
        audio = Audio.from_dictionary(dictionary.get('audio')) if 'audio' in dictionary.keys() else APIHelper.SKIP 
        contacts = None
        if dictionary.get('contacts') is not None:
            contacts = [Contact.from_dictionary(x) for x in dictionary.get('contacts')]
        else:
            contacts = APIHelper.SKIP
        document = Document.from_dictionary(dictionary.get('document')) if 'document' in dictionary.keys() else APIHelper.SKIP 
        image = Image.from_dictionary(dictionary.get('image')) if 'image' in dictionary.keys() else APIHelper.SKIP 
        interactive = Interactive.from_dictionary(dictionary.get('interactive')) if 'interactive' in dictionary.keys() else APIHelper.SKIP 
        location = Location.from_dictionary(dictionary.get('location')) if 'location' in dictionary.keys() else APIHelper.SKIP 
        recipient_type = dictionary.get("recipient_type") if dictionary.get("recipient_type") else 'individual'
        sticker = Sticker.from_dictionary(dictionary.get('sticker')) if 'sticker' in dictionary.keys() else APIHelper.SKIP 
        template = Template.from_dictionary(dictionary.get('template')) if 'template' in dictionary.keys() else APIHelper.SKIP 
        text = Text.from_dictionary(dictionary.get('text')) if 'text' in dictionary.keys() else APIHelper.SKIP 
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        video = Video.from_dictionary(dictionary.get('video')) if 'video' in dictionary.keys() else APIHelper.SKIP 
        # Return an object of this model
        return cls(messaging_product,
                   to,
                   audio,
                   contacts,
                   document,
                   image,
                   interactive,
                   location,
                   recipient_type,
                   sticker,
                   template,
                   text,
                   mtype,
                   video)
