# -*- coding: utf-8 -*-

"""
whatsappcloudapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from whatsappcloudapi.api_helper import APIHelper


class Location(object):

    """Implementation of the 'Location' model.

    TODO: type model description here.

    Attributes:
        latitude (string): Latitude of the location.
        longitude (string): Longitude of the location.
        name (string): Name of the location.
        address (string): Address of the location. Only displayed if name is
            present.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "latitude": 'latitude',
        "longitude": 'longitude',
        "name": 'name',
        "address": 'address'
    }

    _optionals = [
        'name',
        'address',
    ]

    def __init__(self,
                 latitude=None,
                 longitude=None,
                 name=APIHelper.SKIP,
                 address=APIHelper.SKIP):
        """Constructor for the Location class"""

        # Initialize members of the class
        self.latitude = latitude 
        self.longitude = longitude 
        if name is not APIHelper.SKIP:
            self.name = name 
        if address is not APIHelper.SKIP:
            self.address = address 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        latitude = dictionary.get("latitude") if dictionary.get("latitude") else None
        longitude = dictionary.get("longitude") if dictionary.get("longitude") else None
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        address = dictionary.get("address") if dictionary.get("address") else APIHelper.SKIP
        # Return an object of this model
        return cls(latitude,
                   longitude,
                   name,
                   address)
