# -*- coding: utf-8 -*-

"""
whatsappcloudapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from whatsappcloudapi.api_helper import APIHelper
from whatsappcloudapi.models.action import Action
from whatsappcloudapi.models.body import Body
from whatsappcloudapi.models.footer import Footer
from whatsappcloudapi.models.header import Header


class Interactive(object):

    """Implementation of the 'Interactive' model.

    TODO: type model description here.

    Attributes:
        action (Action): Action you want the user to perform after reading the
            message.
        body (Body): The body of the message. Emojis and markdown are
            supported.
        footer (Footer): The footer of the message. Emojis and markdown are
            supported.
        header (Header): Header content displayed on top of a message.
        mtype (InteractiveTypeEnum): The type of interactive message you want
            to send.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "action": 'action',
        "body": 'body',
        "mtype": 'type',
        "footer": 'footer',
        "header": 'header'
    }

    _optionals = [
        'footer',
        'header',
    ]

    def __init__(self,
                 action=None,
                 body=None,
                 mtype=None,
                 footer=APIHelper.SKIP,
                 header=APIHelper.SKIP):
        """Constructor for the Interactive class"""

        # Initialize members of the class
        self.action = action 
        self.body = body 
        if footer is not APIHelper.SKIP:
            self.footer = footer 
        if header is not APIHelper.SKIP:
            self.header = header 
        self.mtype = mtype 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        action = Action.from_dictionary(dictionary.get('action')) if dictionary.get('action') else None
        body = Body.from_dictionary(dictionary.get('body')) if dictionary.get('body') else None
        mtype = dictionary.get("type") if dictionary.get("type") else None
        footer = Footer.from_dictionary(dictionary.get('footer')) if 'footer' in dictionary.keys() else APIHelper.SKIP 
        header = Header.from_dictionary(dictionary.get('header')) if 'header' in dictionary.keys() else APIHelper.SKIP 
        # Return an object of this model
        return cls(action,
                   body,
                   mtype,
                   footer,
                   header)
