# -*- coding: utf-8 -*-

"""
whatsappcloudapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from whatsappcloudapi.api_helper import APIHelper


class Component(object):

    """Implementation of the 'Component' model.

    TODO: type model description here.

    Attributes:
        mtype (ComponentTypeEnum): Describes the component type. For
            text-based templates, we only support the type=body.
        sub_type (SubTypeEnum): Required when type=button. Not used for the
            other types. Type of button to create.
        parameters (list of object): Required when type=button. Array of
            parameter objects with the content of the message. For components
            of type=button, see the button parameter object.
        index (string): Required when type=button. Not used for the other
            types. Position index of the button. You can have up to 3 buttons
            using index values of 0 to 2.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "mtype": 'type',
        "parameters": 'parameters',
        "sub_type": 'sub_type',
        "index": 'index'
    }

    _optionals = [
        'sub_type',
        'index',
    ]

    def __init__(self,
                 mtype=None,
                 parameters=None,
                 sub_type=APIHelper.SKIP,
                 index=APIHelper.SKIP):
        """Constructor for the Component class"""

        # Initialize members of the class
        self.mtype = mtype 
        if sub_type is not APIHelper.SKIP:
            self.sub_type = sub_type 
        self.parameters = parameters 
        if index is not APIHelper.SKIP:
            self.index = index 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        mtype = dictionary.get("type") if dictionary.get("type") else None
        parameters = dictionary.get("parameters") if dictionary.get("parameters") else None
        sub_type = dictionary.get("sub_type") if dictionary.get("sub_type") else APIHelper.SKIP
        index = dictionary.get("index") if dictionary.get("index") else APIHelper.SKIP
        # Return an object of this model
        return cls(mtype,
                   parameters,
                   sub_type,
                   index)
