# -*- coding: utf-8 -*-

"""
whatsappcloudapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from whatsappcloudapi.api_helper import APIHelper


class BusinessProfile(object):

    """Implementation of the 'BusinessProfile' model.

    TODO: type model description here.

    Attributes:
        id (string): ID of the business profile object.
        messaging_product (string): The messaging service used for the
            request. Always set it to "whatsapp" if you are using the WhatsApp
            Business API.
        address (string): Address of the business.
        description (string): Description of the business.
        vertical (VerticalEnum): Industry of the business. This can be either
            an empty string or one of the accepted values.
        email (string): The contact email address (in valid email format) of
            the business.
        websites (list of string): The URLs associated with the business. For
            instance, a website, Facebook Page, or Instagram. You must include
            the http:// or https:// portion of the URL.
        profile_picture_url (string): URL of the profile picture generated
            from a call to the Resumable Upload API.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "messaging_product": 'messaging_product',
        "address": 'address',
        "description": 'description',
        "vertical": 'vertical',
        "email": 'email',
        "websites": 'websites',
        "profile_picture_url": 'profile_picture_url'
    }

    _optionals = [
        'vertical',
        'email',
        'websites',
        'profile_picture_url',
    ]

    def __init__(self,
                 id=None,
                 messaging_product=None,
                 address=None,
                 description=None,
                 vertical=APIHelper.SKIP,
                 email=APIHelper.SKIP,
                 websites=APIHelper.SKIP,
                 profile_picture_url=APIHelper.SKIP):
        """Constructor for the BusinessProfile class"""

        # Initialize members of the class
        self.id = id 
        self.messaging_product = messaging_product 
        self.address = address 
        self.description = description 
        if vertical is not APIHelper.SKIP:
            self.vertical = vertical 
        if email is not APIHelper.SKIP:
            self.email = email 
        if websites is not APIHelper.SKIP:
            self.websites = websites 
        if profile_picture_url is not APIHelper.SKIP:
            self.profile_picture_url = profile_picture_url 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        id = dictionary.get("id") if dictionary.get("id") else None
        messaging_product = dictionary.get("messaging_product") if dictionary.get("messaging_product") else None
        address = dictionary.get("address") if dictionary.get("address") else None
        description = dictionary.get("description") if dictionary.get("description") else None
        vertical = dictionary.get("vertical") if dictionary.get("vertical") else APIHelper.SKIP
        email = dictionary.get("email") if dictionary.get("email") else APIHelper.SKIP
        websites = dictionary.get("websites") if dictionary.get("websites") else APIHelper.SKIP
        profile_picture_url = dictionary.get("profile_picture_url") if dictionary.get("profile_picture_url") else APIHelper.SKIP
        # Return an object of this model
        return cls(id,
                   messaging_product,
                   address,
                   description,
                   vertical,
                   email,
                   websites,
                   profile_picture_url)
