# -*- coding: utf-8 -*-

"""
whatsappcloudapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from whatsappcloudapi.api_helper import APIHelper


class Address(object):

    """Implementation of the 'Address' model.

    TODO: type model description here.

    Attributes:
        street (string): Street number and name
        city (string): City name.
        state (string): State abbreviation.
        zip (string): ZIP code.
        country (string): Full country name.
        country_code (string): Two-letter country abbreviation.
        mtype (PersonalInformationTypeEnum): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "street": 'street',
        "city": 'city',
        "state": 'state',
        "zip": 'zip',
        "country": 'country',
        "country_code": 'country_code',
        "mtype": 'type'
    }

    _optionals = [
        'street',
        'city',
        'state',
        'zip',
        'country',
        'country_code',
        'mtype',
    ]

    def __init__(self,
                 street=APIHelper.SKIP,
                 city=APIHelper.SKIP,
                 state=APIHelper.SKIP,
                 zip=APIHelper.SKIP,
                 country=APIHelper.SKIP,
                 country_code=APIHelper.SKIP,
                 mtype=APIHelper.SKIP):
        """Constructor for the Address class"""

        # Initialize members of the class
        if street is not APIHelper.SKIP:
            self.street = street 
        if city is not APIHelper.SKIP:
            self.city = city 
        if state is not APIHelper.SKIP:
            self.state = state 
        if zip is not APIHelper.SKIP:
            self.zip = zip 
        if country is not APIHelper.SKIP:
            self.country = country 
        if country_code is not APIHelper.SKIP:
            self.country_code = country_code 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        street = dictionary.get("street") if dictionary.get("street") else APIHelper.SKIP
        city = dictionary.get("city") if dictionary.get("city") else APIHelper.SKIP
        state = dictionary.get("state") if dictionary.get("state") else APIHelper.SKIP
        zip = dictionary.get("zip") if dictionary.get("zip") else APIHelper.SKIP
        country = dictionary.get("country") if dictionary.get("country") else APIHelper.SKIP
        country_code = dictionary.get("country_code") if dictionary.get("country_code") else APIHelper.SKIP
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        # Return an object of this model
        return cls(street,
                   city,
                   state,
                   zip,
                   country,
                   country_code,
                   mtype)
