# -*- coding: utf-8 -*-

"""
whatsappcloudapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from whatsappcloudapi.api_helper import APIHelper
from whatsappcloudapi.models.button import Button
from whatsappcloudapi.models.section import Section


class Action(object):

    """Implementation of the 'Action' model.

    TODO: type model description here.

    Attributes:
        button (string): Required for List Messages. Button content. It cannot
            be an empty string and must be unique within the message. Emojis
            are supported, markdown is not.
        buttons (list of Button): Required for Reply Buttons. You can have up
            to 3 buttons. You cannot have leading or trailing spaces when
            setting the ID.
        sections (list of Section): Required for List Messages.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "button": 'button',
        "buttons": 'buttons',
        "sections": 'sections'
    }

    _optionals = [
        'button',
        'buttons',
        'sections',
    ]

    def __init__(self,
                 button=APIHelper.SKIP,
                 buttons=APIHelper.SKIP,
                 sections=APIHelper.SKIP):
        """Constructor for the Action class"""

        # Initialize members of the class
        if button is not APIHelper.SKIP:
            self.button = button 
        if buttons is not APIHelper.SKIP:
            self.buttons = buttons 
        if sections is not APIHelper.SKIP:
            self.sections = sections 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        button = dictionary.get("button") if dictionary.get("button") else APIHelper.SKIP
        buttons = None
        if dictionary.get('buttons') is not None:
            buttons = [Button.from_dictionary(x) for x in dictionary.get('buttons')]
        else:
            buttons = APIHelper.SKIP
        sections = None
        if dictionary.get('sections') is not None:
            sections = [Section.from_dictionary(x) for x in dictionary.get('sections')]
        else:
            sections = APIHelper.SKIP
        # Return an object of this model
        return cls(button,
                   buttons,
                   sections)
