# -*- coding: utf-8 -*-

"""
whatsappcloudapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from whatsappcloudapi.api_helper import APIHelper
from whatsappcloudapi.configuration import Server
from whatsappcloudapi.controllers.base_controller import BaseController
from whatsappcloudapi.models.success_response import SuccessResponse
from whatsappcloudapi.models.get_phone_number_by_id_response import GetPhoneNumberByIDResponse


class PhoneNumbersController(BaseController):

    """A Controller to access Endpoints in the whatsappcloudapi API."""
    def __init__(self, config, auth_managers):
        super(PhoneNumbersController, self).__init__(config, auth_managers)

    def verify_code(self,
                    phone_number_id,
                    code):
        """Does a POST request to /{Phone-Number-ID}/verify_code.

        Used to verify a phone number's ownership. After you have received a
        SMS or Voice request code for verification, you need to verify the
        code that was sent to you.

        Args:
            phone_number_id (string): TODO: type description here.
            code (string): The code you received after calling
                FROM_PHONE_NUMBER_ID/request_code.

        Returns:
            SuccessResponse: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/{Phone-Number-ID}/verify_code'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'Phone-Number-ID': {'value': phone_number_id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare form parameters
        _form_parameters = {
            'code': code
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=_form_parameters)
        # Apply authentication scheme on request
        self.apply_auth_schemes(_request, 'global')

        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, SuccessResponse.from_dictionary)

        return decoded

    def get_phone_number_by_id(self,
                               phone_number_id):
        """Does a GET request to /{Phone-Number-ID}.

        When you query all the phone numbers for a WhatsApp Business Account,
        each phone number has an id. You can directly query for a phone number
        using this id.

        Args:
            phone_number_id (string): TODO: type description here.

        Returns:
            GetPhoneNumberByIDResponse: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/{Phone-Number-ID}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'Phone-Number-ID': {'value': phone_number_id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        # Apply authentication scheme on request
        self.apply_auth_schemes(_request, 'global')

        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, GetPhoneNumberByIDResponse.from_dictionary)

        return decoded

    def request_verification_code(self,
                                  phone_number_id,
                                  code_method,
                                  locale):
        """Does a POST request to /{Phone-Number-ID}/request_code.

        Used to request a code to verify a phone number's ownership. You need
        to verify the phone number you want to use to send messages to your
        customers. Phone numbers must be verified through SMS/voice call. The
        verification process can be done through the Graph API calls specified
        below.

        Args:
            phone_number_id (string): TODO: type description here.
            code_method (RequestVerificationCodeMethodEnum): Chosen method for
                verification.
            locale (string): Your locale. For example: "en_US".

        Returns:
            SuccessResponse: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/{Phone-Number-ID}/request_code'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'Phone-Number-ID': {'value': phone_number_id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare form parameters
        _form_parameters = {
            'code_method': code_method,
            'locale': locale
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=_form_parameters)
        # Apply authentication scheme on request
        self.apply_auth_schemes(_request, 'global')

        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, SuccessResponse.from_dictionary)

        return decoded
