# -*- coding: utf-8 -*-

"""
whatsappcloudapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from whatsappcloudapi.api_helper import APIHelper
from whatsappcloudapi.configuration import Server
from whatsappcloudapi.controllers.base_controller import BaseController
from whatsappcloudapi.models.success_response import SuccessResponse
from whatsappcloudapi.models.retrieve_media_url_response import RetrieveMediaURLResponse
from whatsappcloudapi.models.upload_media import UploadMedia


class MediaController(BaseController):

    """A Controller to access Endpoints in the whatsappcloudapi API."""
    def __init__(self, config, auth_managers):
        super(MediaController, self).__init__(config, auth_managers)

    def delete_media(self,
                     media_id):
        """Does a DELETE request to /{Media-ID}.

        This endpoint can be used for deleting a media object.

        Args:
            media_id (string): Media object ID from either uploading media
                endpoint or media message Webhooks

        Returns:
            SuccessResponse: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/{Media-ID}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'Media-ID': {'value': media_id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url, headers=_headers)
        # Apply authentication scheme on request
        self.apply_auth_schemes(_request, 'global')

        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, SuccessResponse.from_dictionary)

        return decoded

    def retrieve_media_url(self,
                           media_id):
        """Does a GET request to /{Media-ID}.

        To retrieve your media’s URL, make a request to this endpoint. Later,
        you can use this URL to download the media file.

        Args:
            media_id (string): Media object ID from either uploading media
                endpoint or media message Webhooks

        Returns:
            RetrieveMediaURLResponse: Response from the API. OK. A successful
                response includes an object with a media URL. The URL is only
                valid for 5 minutes.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/{Media-ID}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'Media-ID': {'value': media_id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        # Apply authentication scheme on request
        self.apply_auth_schemes(_request, 'global')

        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, RetrieveMediaURLResponse.from_dictionary)

        return decoded

    def upload_media(self,
                     phone_number_id,
                     messaging_product,
                     file,
                     mtype):
        """Does a POST request to /{Phone-Number-ID}/media.

        Used to upload media. All media files sent through this endpoint are
        encrypted and persist for 30 days.

        Args:
            phone_number_id (string): TODO: type description here.
            messaging_product (string): Messaging service used for the
                request. In this case, use whatsapp.
            file (string): Path to the file stored in your local directory.
                For example: "@/local/path/file.jpg".
            mtype (string): Type of media file being uploaded. See Supported
                Media Types for more information.    Supported options for
                images are: `image/jpeg`, `image/png`    Supported options for
                documents are: `text/plain`, `application/pdf`,
                `application/vnd.ms-powerpoint`, `application/msword`,
                `application/vnd.ms-excel`,
                `application/vnd.openxmlformats-officedocument.wordprocessingml
                .document`,
                `application/vnd.openxmlformats-officedocument.presentationml.p
                resentation`,
                `application/vnd.openxmlformats-officedocument.spreadsheetml.sh
                eet`  Supported options for audio are: `audio/aac`,
                `audio/mp4`, `audio/mpeg`, `audio/amr`, `audio/ogg`,
                `audio/opus`  Supported options for video are: `video/mp4`,
                `video/3gp`  Supported options for stickers are: `image/webp`

        Returns:
            UploadMedia: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/{Phone-Number-ID}/media'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'Phone-Number-ID': {'value': phone_number_id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare form parameters
        _form_parameters = {
            'messaging_product': messaging_product,
            'file': file,
            'type': mtype
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=_form_parameters)
        # Apply authentication scheme on request
        self.apply_auth_schemes(_request, 'global')

        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, UploadMedia.from_dictionary)

        return decoded
