"""pocli (Python OwnCloud Client) -- setup script

Copyright (c) 2016 - 2025
Florian Kaiser (florian.kaiser@mpcdf.mpg.de), Klaus Reuter (klaus.reuter@mpcdf.mpg.de)
"""

import os
from setuptools import setup, Command

from pocli import __version__

class CleanCommand(Command):
    """Custom clean command to tidy up the project root."""
    # https://stackoverflow.com/questions/3779915/why-does-python-setup-py-sdist-create-unwanted-project-egg-info-in-project-r
    user_options = []
    def initialize_options(self):
        pass
    def finalize_options(self):
        pass
    def run(self):
        os.system('rm -vrf build')
        os.system('rm -vrf dist')
        os.system('rm -vrf pocli.egg-info')
        os.system('rm -vrf pocli/__pycache__')
        os.system("find pocli -name '*.pyc' -delete -print")

entry_points = {
    'console_scripts': ['oc=pocli.cli:main',  # oc stands for OwnCloud
                        'ds=pocli.cli:main']  # ds stands for DataShare
}

with open('README.md') as fp:
    long_description = fp.read()

with open('requirements.txt') as fp:
    install_requires = fp.read().splitlines()

setup(name='pocli',
      version=__version__,
      description='Python-based command-line client for Nextcloud',
      long_description=long_description,
      author='Florian Kaiser, Klaus Reuter',
      author_email='klaus.reuter@gmail.com',
      packages=['pocli'],
      install_requires=install_requires,
      cmdclass={'clean': CleanCommand},
      entry_points=entry_points,
      scripts=['ocpasswd.bash'],
      zip_safe=False)

