# Python Nextcloud (formerly ownCloud) Client (pocli)

Copyright (c) 2016 - 2025 Florian Kaiser, Klaus Reuter

<https://gitlab.mpcdf.mpg.de/mpcdf/pocli>

<https://pypi.python.org/pypi/pocli>

Released under the MIT License (MIT), see the LICENSE file.

## Introduction

The pocli package provides a lightweight Nextcloud (formerly ownCloud)
command line client for basic file operations such as upload, download,
directory creation and listing, and deletion. It is written in Python
and built upon the nc-py-api (pyocclient in earlier versions) Python
package.

The development of pocli was motivated by the need for a tool to quickly
up- or download single (or few) files on a computer which is operated
without any graphical user interface (i.e. a typical HPC system), and
where it may not be desirable to install the official client software.
In case you have more complex requirements (continuous synchronization),
please use the official client.

A typical use case is:

-   Upload a tarball from the login node of a HPC system to your
    Nextcloud server using pocli.
-   Log in to a Nextcloud server from your laptop via the web browser
    and share the tarball with other users (e.g. by sending a download
    URL via email).

Another use case would be:

-   Upload a tarball from HPC system A to your Nextcloud server using
    pocli.
-   Download the tarball to HPC system B from your Nextcloud server using
    pocli.

Note that intentionally no recursive operations are supported.

## Requirements and installation

pocli was developed and tested with Python 2.7 (now deprecated) and
Python 3.X.  Please drop us a line in case pocli does not work with
other (newer) Python versions.

The package including its dependencies can be installed easily via pip:

`pip install --user pocli`

Alternatively, the package can be installed from the source
distribution.

Make sure to add the installation directory to the PATH environment
variable, on a Unix system this is for example \"\~/.local/bin\". The
previous examples pass the \"\--user\" flag in order to work purely in
the user\'s homedirectory. In case this flag is omitted, system-wide
locations are chosen. Alternatively, virtual environments can be used.

## Functionality examples (optional arguments are given in parentheses)

The pocli package provides the `oc` command. Moreover, the alias `ds`
can be used interchangeably to comply with the naming of the MPCDF
DataShare service. It takes positional and named arguments in analogy to
e.g. `git`. The following examples illustrate the basic usage:

-   basic help

`oc --help`

-   command-specific help

`oc command --help`

-   list remote files and folders, defaults to \"/\"

`oc ls <remote_folder>`

-   create remote directory \"temp\"

`oc mkdir temp`

-   upload single file to the Nextcloud root directory

`oc put file1`

-   upload multiple files to the Nextcloud \"temp\" directory

`oc put --directory=temp file1 file2 file3`

-   download single file from Nextcloud to the current working directory

`oc get file1`

-   download multiple files to the local \"temp\" directory

`oc get --directory=temp file1 file2 file3`

-   remove remote file(s)

`oc rm file1 file2`

-   check if a connection to the server can be established successfully
    based on the present configuration

`oc check`

## Configuration

The connection to an Nextcloud instance requires a valid configuration.
The configuration file in JSON format is located at \"\~/.ocrc\" and is
created at the first invocation of the `oc` command. The initial default
configuration is for the MPCDF DataShare service, however, it can be
configured freely to connect to other Nextcloud instances. Simply adapt
the configuration file to your needs. No credentials are ever stored in
\"\~/.ocrc\".

Further configuration can be overridden by environment variables:

- `OC_CONFIG_FILE` can override the location of the configuration file
- `OC_USER` can override the username of the configuration file
- `OC_SERVER` can override the server address of the configuration file
- `OC_DEBUG` can override the DEBUG setting of the configuration file

## Password handling

Security concerns arise in particular if the Nextcloud password is
identical to the password used for other services at the same site. To
this end, by default, the `oc` executable asks the user to type the
password at each invocation.

