# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2013 Kristian Høgsberg
# Copyright © 2013      Rafael Antognolli
# Copyright © 2013      Jasper St. Pierre
# Copyright © 2010-2013 Intel Corporation
# Copyright © 2015-2017 Samsung Electronics Co., Ltd
# Copyright © 2015-2017 Red Hat Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

import enum

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from ..wayland import WlOutput
from ..wayland import WlSeat


class XdgToplevel(Interface):
    """Toplevel surface

    This interface defines an :class:`~pywayland.protocol.xdg_shell.XdgSurface`
    role which allows a surface to, among other things, set window-like
    properties such as maximize, fullscreen, and minimize, set application-
    specific metadata like title and id, and well as trigger user interactive
    operations such as interactive resize and move.

    Unmapping an :class:`XdgToplevel` means that the surface cannot be shown by
    the compositor until it is explicitly mapped again. All active operations
    (e.g., move, resize) are canceled and all attributes (e.g. title, state,
    stacking, ...) are discarded for an :class:`XdgToplevel` surface when it is
    unmapped.

    Attaching a null buffer to a toplevel unmaps the surface.
    """

    name = "xdg_toplevel"
    version = 3

    class resize_edge(enum.IntEnum):
        none = 0
        top = 1
        bottom = 2
        left = 4
        top_left = 5
        bottom_left = 6
        right = 8
        top_right = 9
        bottom_right = 10

    class state(enum.IntEnum):
        maximized = 1
        fullscreen = 2
        resizing = 3
        activated = 4
        tiled_left = 5
        tiled_right = 6
        tiled_top = 7
        tiled_bottom = 8


class XdgToplevelProxy(Proxy):
    interface = XdgToplevel

    @XdgToplevel.request()
    def destroy(self):
        """Destroy the :class:`XdgToplevel`

        This request destroys the role surface and unmaps the surface; see
        "Unmapping" behavior in interface section for details.
        """
        self._marshal(0)
        self._destroy()

    @XdgToplevel.request(
        Argument(ArgumentType.Object, interface=XdgToplevel, nullable=True),
    )
    def set_parent(self, parent):
        """Set the parent of this surface

        Set the "parent" of this surface. This surface should be stacked above
        the parent surface and all other ancestor surfaces.

        Parent windows should be set on dialogs, toolboxes, or other
        "auxiliary" surfaces, so that the parent is raised when the dialog is
        raised.

        Setting a null parent for a child window removes any parent-child
        relationship for the child. Setting a null parent for a window which
        currently has no parent is a no-op.

        If the parent is unmapped then its children are managed as though the
        parent of the now-unmapped parent has become the parent of this
        surface. If no parent exists for the now-unmapped parent then the
        children are managed as though they have no parent surface.

        :param parent:
        :type parent:
            :class:`XdgToplevel` or `None`
        """
        self._marshal(1, parent)

    @XdgToplevel.request(
        Argument(ArgumentType.String),
    )
    def set_title(self, title):
        """Set surface title

        Set a short title for the surface.

        This string may be used to identify the surface in a task bar, window
        list, or other user interface elements provided by the compositor.

        The string must be encoded in UTF-8.

        :param title:
        :type title:
            `ArgumentType.String`
        """
        self._marshal(2, title)

    @XdgToplevel.request(
        Argument(ArgumentType.String),
    )
    def set_app_id(self, app_id):
        """Set application id

        Set an application identifier for the surface.

        The app ID identifies the general class of applications to which the
        surface belongs. The compositor can use this to group multiple surfaces
        together, or to determine how to launch a new application.

        For D-Bus activatable applications, the app ID is used as the D-Bus
        service name.

        The compositor shell will try to group application surfaces together by
        their app ID. As a best practice, it is suggested to select app ID's
        that match the basename of the application's .desktop file. For
        example, "org.freedesktop.FooViewer" where the .desktop file is
        "org.freedesktop.FooViewer.desktop".

        Like other properties, a set_app_id request can be sent after the
        :class:`XdgToplevel` has been mapped to update the property.

        See the desktop-entry specification [0] for more details on application
        identifiers and how they relate to well-known D-Bus names and .desktop
        files.

        [0] http://standards.freedesktop.org/desktop-entry-spec/

        :param app_id:
        :type app_id:
            `ArgumentType.String`
        """
        self._marshal(3, app_id)

    @XdgToplevel.request(
        Argument(ArgumentType.Object, interface=WlSeat),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def show_window_menu(self, seat, serial, x, y):
        """Show the window menu

        Clients implementing client-side decorations might want to show a
        context menu when right-clicking on the decorations, giving the user a
        menu that they can use to maximize or minimize the window.

        This request asks the compositor to pop up such a window menu at the
        given position, relative to the local surface coordinates of the parent
        surface. There are no guarantees as to what menu items the window menu
        contains.

        This request must be used in response to some sort of user action like
        a button press, key press, or touch down event.

        :param seat:
            the :class:`~pywayland.protocol.wayland.WlSeat` of the user event
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :param serial:
            the serial of the user event
        :type serial:
            `ArgumentType.Uint`
        :param x:
            the x position to pop up the window menu at
        :type x:
            `ArgumentType.Int`
        :param y:
            the y position to pop up the window menu at
        :type y:
            `ArgumentType.Int`
        """
        self._marshal(4, seat, serial, x, y)

    @XdgToplevel.request(
        Argument(ArgumentType.Object, interface=WlSeat),
        Argument(ArgumentType.Uint),
    )
    def move(self, seat, serial):
        """Start an interactive move

        Start an interactive, user-driven move of the surface.

        This request must be used in response to some sort of user action like
        a button press, key press, or touch down event. The passed serial is
        used to determine the type of interactive move (touch, pointer, etc).

        The server may ignore move requests depending on the state of the
        surface (e.g. fullscreen or maximized), or if the passed serial is no
        longer valid.

        If triggered, the surface will lose the focus of the device
        (:class:`~pywayland.protocol.wayland.WlPointer`,
        :class:`~pywayland.protocol.wayland.WlTouch`, etc) used for the move.
        It is up to the compositor to visually indicate that the move is taking
        place, such as updating a pointer cursor, during the move. There is no
        guarantee that the device focus will return when the move is completed.

        :param seat:
            the :class:`~pywayland.protocol.wayland.WlSeat` of the user event
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :param serial:
            the serial of the user event
        :type serial:
            `ArgumentType.Uint`
        """
        self._marshal(5, seat, serial)

    @XdgToplevel.request(
        Argument(ArgumentType.Object, interface=WlSeat),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def resize(self, seat, serial, edges):
        """Start an interactive resize

        Start a user-driven, interactive resize of the surface.

        This request must be used in response to some sort of user action like
        a button press, key press, or touch down event. The passed serial is
        used to determine the type of interactive resize (touch, pointer, etc).

        The server may ignore resize requests depending on the state of the
        surface (e.g. fullscreen or maximized).

        If triggered, the client will receive configure events with the
        "resize" state enum value and the expected sizes. See the "resize" enum
        value for more details about what is required. The client must also
        acknowledge configure events using "ack_configure". After the resize is
        completed, the client will receive another "configure" event without
        the resize state.

        If triggered, the surface also will lose the focus of the device
        (:class:`~pywayland.protocol.wayland.WlPointer`,
        :class:`~pywayland.protocol.wayland.WlTouch`, etc) used for the resize.
        It is up to the compositor to visually indicate that the resize is
        taking place, such as updating a pointer cursor, during the resize.
        There is no guarantee that the device focus will return when the resize
        is completed.

        The edges parameter specifies how the surface should be resized, and is
        one of the values of the resize_edge enum. The compositor may use this
        information to update the surface position for example when dragging
        the top left corner. The compositor may also use this information to
        adapt its behavior, e.g. choose an appropriate cursor image.

        :param seat:
            the :class:`~pywayland.protocol.wayland.WlSeat` of the user event
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :param serial:
            the serial of the user event
        :type serial:
            `ArgumentType.Uint`
        :param edges:
            which edge or corner is being dragged
        :type edges:
            `ArgumentType.Uint`
        """
        self._marshal(6, seat, serial, edges)

    @XdgToplevel.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def set_max_size(self, width, height):
        """Set the maximum size

        Set a maximum size for the window.

        The client can specify a maximum size so that the compositor does not
        try to configure the window beyond this size.

        The width and height arguments are in window geometry coordinates. See
        :func:`XdgSurface.set_window_geometry()
        <pywayland.protocol.xdg_shell.XdgSurface.set_window_geometry>`.

        Values set in this way are double-buffered. They will get applied on
        the next commit.

        The compositor can use this information to allow or disallow different
        states like maximize or fullscreen and draw accurate animations.

        Similarly, a tiling window manager may use this information to place
        and resize client windows in a more effective way.

        The client should not rely on the compositor to obey the maximum size.
        The compositor may decide to ignore the values set by the client and
        request a larger size.

        If never set, or a value of zero in the request, means that the client
        has no expected maximum size in the given dimension. As a result, a
        client wishing to reset the maximum size to an unspecified state can
        use zero for width and height in the request.

        Requesting a maximum size to be smaller than the minimum size of a
        surface is illegal and will result in a protocol error.

        The width and height must be greater than or equal to zero. Using
        strictly negative values for width and height will result in a protocol
        error.

        :param width:
        :type width:
            `ArgumentType.Int`
        :param height:
        :type height:
            `ArgumentType.Int`
        """
        self._marshal(7, width, height)

    @XdgToplevel.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def set_min_size(self, width, height):
        """Set the minimum size

        Set a minimum size for the window.

        The client can specify a minimum size so that the compositor does not
        try to configure the window below this size.

        The width and height arguments are in window geometry coordinates. See
        :func:`XdgSurface.set_window_geometry()
        <pywayland.protocol.xdg_shell.XdgSurface.set_window_geometry>`.

        Values set in this way are double-buffered. They will get applied on
        the next commit.

        The compositor can use this information to allow or disallow different
        states like maximize or fullscreen and draw accurate animations.

        Similarly, a tiling window manager may use this information to place
        and resize client windows in a more effective way.

        The client should not rely on the compositor to obey the minimum size.
        The compositor may decide to ignore the values set by the client and
        request a smaller size.

        If never set, or a value of zero in the request, means that the client
        has no expected minimum size in the given dimension. As a result, a
        client wishing to reset the minimum size to an unspecified state can
        use zero for width and height in the request.

        Requesting a minimum size to be larger than the maximum size of a
        surface is illegal and will result in a protocol error.

        The width and height must be greater than or equal to zero. Using
        strictly negative values for width and height will result in a protocol
        error.

        :param width:
        :type width:
            `ArgumentType.Int`
        :param height:
        :type height:
            `ArgumentType.Int`
        """
        self._marshal(8, width, height)

    @XdgToplevel.request()
    def set_maximized(self):
        """Maximize the window

        Maximize the surface.

        After requesting that the surface should be maximized, the compositor
        will respond by emitting a configure event. Whether this configure
        actually sets the window maximized is subject to compositor policies.
        The client must then update its content, drawing in the configured
        state. The client must also acknowledge the configure when committing
        the new content (see ack_configure).

        It is up to the compositor to decide how and where to maximize the
        surface, for example which output and what region of the screen should
        be used.

        If the surface was already maximized, the compositor will still emit a
        configure event with the "maximized" state.

        If the surface is in a fullscreen state, this request has no direct
        effect. It may alter the state the surface is returned to when
        unmaximized unless overridden by the compositor.
        """
        self._marshal(9)

    @XdgToplevel.request()
    def unset_maximized(self):
        """Unmaximize the window

        Unmaximize the surface.

        After requesting that the surface should be unmaximized, the compositor
        will respond by emitting a configure event. Whether this actually un-
        maximizes the window is subject to compositor policies. If available
        and applicable, the compositor will include the window geometry
        dimensions the window had prior to being maximized in the configure
        event. The client must then update its content, drawing it in the
        configured state. The client must also acknowledge the configure when
        committing the new content (see ack_configure).

        It is up to the compositor to position the surface after it was
        unmaximized; usually the position the surface had before maximizing, if
        applicable.

        If the surface was already not maximized, the compositor will still
        emit a configure event without the "maximized" state.

        If the surface is in a fullscreen state, this request has no direct
        effect. It may alter the state the surface is returned to when
        unmaximized unless overridden by the compositor.
        """
        self._marshal(10)

    @XdgToplevel.request(
        Argument(ArgumentType.Object, interface=WlOutput, nullable=True),
    )
    def set_fullscreen(self, output):
        """Set the window as fullscreen on an output

        Make the surface fullscreen.

        After requesting that the surface should be fullscreened, the
        compositor will respond by emitting a configure event. Whether the
        client is actually put into a fullscreen state is subject to compositor
        policies. The client must also acknowledge the configure when
        committing the new content (see ack_configure).

        The output passed by the request indicates the client's preference as
        to which display it should be set fullscreen on. If this value is NULL,
        it's up to the compositor to choose which display will be used to map
        this surface.

        If the surface doesn't cover the whole output, the compositor will
        position the surface in the center of the output and compensate with
        with border fill covering the rest of the output. The content of the
        border fill is undefined, but should be assumed to be in some way that
        attempts to blend into the surrounding area (e.g. solid black).

        If the fullscreened surface is not opaque, the compositor must make
        sure that other screen content not part of the same surface tree (made
        up of subsurfaces, popups or similarly coupled surfaces) are not
        visible below the fullscreened surface.

        :param output:
        :type output:
            :class:`~pywayland.protocol.wayland.WlOutput` or `None`
        """
        self._marshal(11, output)

    @XdgToplevel.request()
    def unset_fullscreen(self):
        """Unset the window as fullscreen

        Make the surface no longer fullscreen.

        After requesting that the surface should be unfullscreened, the
        compositor will respond by emitting a configure event. Whether this
        actually removes the fullscreen state of the client is subject to
        compositor policies.

        Making a surface unfullscreen sets states for the surface based on the
        following: * the state(s) it may have had before becoming fullscreen *
        any state(s) decided by the compositor * any state(s) requested by the
        client while the surface was fullscreen

        The compositor may include the previous window geometry dimensions in
        the configure event, if applicable.

        The client must also acknowledge the configure when committing the new
        content (see ack_configure).
        """
        self._marshal(12)

    @XdgToplevel.request()
    def set_minimized(self):
        """Set the window as minimized

        Request that the compositor minimize your surface. There is no way to
        know if the surface is currently minimized, nor is there any way to
        unset minimization on this surface.

        If you are looking to throttle redrawing when minimized, please instead
        use the :func:`WlSurface.frame()
        <pywayland.protocol.wayland.WlSurface.frame>` event for this, as this
        will also work with live previews on windows in Alt-Tab, Expose or
        similar compositor features.
        """
        self._marshal(13)


class XdgToplevelResource(Resource):
    interface = XdgToplevel

    @XdgToplevel.event(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Array),
    )
    def configure(self, width, height, states):
        """Suggest a surface change

        This configure event asks the client to resize its toplevel surface or
        to change its state. The configured state should not be applied
        immediately. See :func:`XdgSurface.configure()
        <pywayland.protocol.xdg_shell.XdgSurface.configure>` for details.

        The width and height arguments specify a hint to the window about how
        its surface should be resized in window geometry coordinates. See
        set_window_geometry.

        If the width or height arguments are zero, it means the client should
        decide its own window dimension. This may happen when the compositor
        needs to configure the state of the surface but doesn't have any
        information about any previous or expected dimension.

        The states listed in the event specify how the width/height arguments
        should be interpreted, and possibly how it should be drawn.

        Clients must send an ack_configure in response to this event. See
        :func:`XdgSurface.configure()
        <pywayland.protocol.xdg_shell.XdgSurface.configure>` and
        :func:`XdgSurface.ack_configure()
        <pywayland.protocol.xdg_shell.XdgSurface.ack_configure>` for details.

        :param width:
        :type width:
            `ArgumentType.Int`
        :param height:
        :type height:
            `ArgumentType.Int`
        :param states:
        :type states:
            `ArgumentType.Array`
        """
        self._post_event(0, width, height, states)

    @XdgToplevel.event()
    def close(self):
        """Surface wants to be closed

        The close event is sent by the compositor when the user wants the
        surface to be closed. This should be equivalent to the user clicking
        the close button in client-side decorations, if your application has
        any.

        This is only a request that the user intends to close the window. The
        client may choose to ignore this request, or show a dialog to ask the
        user to save their data, etc.
        """
        self._post_event(1)


class XdgToplevelGlobal(Global):
    interface = XdgToplevel


XdgToplevel._gen_c()
XdgToplevel.proxy_class = XdgToplevelProxy
XdgToplevel.resource_class = XdgToplevelResource
XdgToplevel.global_class = XdgToplevelGlobal
