/*
 * Decompiled with CFR 0.152.
 */
package bsearch.space;

import bsearch.space.ParameterSpec;
import java.util.ArrayList;
import java.util.List;

public strictfp class SearchSpace {
    private final ArrayList<ParameterSpec> paramSpecs = new ArrayList();

    public SearchSpace(List<String> list) {
        for (String string : list) {
            if (string.trim().length() <= 0) continue;
            this.addParamSpec(ParameterSpec.fromString(string));
        }
    }

    public List<ParameterSpec> getParamSpecs() {
        return this.paramSpecs;
    }

    private void addParamSpec(ParameterSpec parameterSpec) {
        this.paramSpecs.add(parameterSpec);
    }

    public long size() {
        long l = 1L;
        for (ParameterSpec parameterSpec : this.paramSpecs) {
            long l2 = parameterSpec.choiceCount();
            if (l2 < 0L) {
                return -1L;
            }
            l *= l2;
        }
        return l;
    }

    public String sizeText() {
        long l = 1L;
        int n = 0;
        for (ParameterSpec parameterSpec : this.paramSpecs) {
            long l2 = parameterSpec.choiceCount();
            if (l2 < 0L) {
                ++n;
                continue;
            }
            l *= l2;
        }
        Object object = Long.toString(l);
        if (n > 0) {
            object = (String)object + "* R^" + n;
        }
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ParameterSpec parameterSpec : this.paramSpecs) {
            stringBuilder.append(parameterSpec.toString() + "\n");
        }
        return stringBuilder.toString();
    }
}

