import os
import sys
import logging
import warnings
import json
from setuptools import setup, find_packages
from distutils.sysconfig import get_python_lib
import versioneer
ygg_ver = versioneer.get_version()


print("In setup.py", sys.argv)
logging.critical("In setup.py: %s" % sys.argv)
        

# Create .rst README from .md and get long description
if os.path.isfile('README.rst'):
    with open('README.rst', 'r') as file:
        long_description = file.read()
elif os.path.isfile('README.md'):
    try:
        import pypandoc
        pypandoc.convert_file('README.md', 'rst', outputfile='README.rst')
        long_description = pypandoc.convert_file('README.md', 'rst')
    except (ImportError, IOError):
        with open('README.md', 'r') as file:
            long_description = file.read()
else:
    raise IOError("Could not find README.rst or README.md")


# Create requirements list based on platform
req_dir = os.path.join("utils", "requirements")
with open("requirements.txt", 'r') as fd:
    requirements = fd.read().splitlines()
with open(os.path.join(req_dir, "requirements_testing.txt"), 'r') as fd:
    test_requirements = fd.read().splitlines()
extras_requirements = json.load(
    open(os.path.join(req_dir, "requirements_extras.json"), 'r'))
with open("console_scripts.txt", 'r') as fd:
    console_scripts = fd.read().splitlines()


# Warn that local install may not have entry points on path
if '--user' in sys.argv:
    script_dir = os.path.realpath(os.path.join(get_python_lib(),
                                               '../../../bin/'))
    warnings.warn("When installing locally, you may need to add the script "
                  + "directory to your path manually in order to have access "
                  + "to the command line entry points (e.g. yggrun). "
                  + "If 'yggrun' is not a recognized command, try adding "
                  + "'%s' to your PATH." % script_dir)
    
    
setup(
    name="yggdrasil-framework",
    packages=find_packages(),
    include_package_data=True,
    version=ygg_ver,
    cmdclass=versioneer.get_cmdclass(),
    description=("A framework for combining interdependent models from "
                 "multiple languages."),
    long_description=long_description,
    author="Meagan Lang",
    author_email="langmm.astro@gmail.com",
    url="https://github.com/cropsinsilico/yggdrasil",
    download_url=(
        "https://github.com/cropsinsilico/yggdrasil/archive/%s.tar.gz" % ygg_ver),
    keywords=["plants", "simulation", "models", "framework"],
    install_requires=requirements,
    tests_require=test_requirements,
    extras_require=extras_requirements,
    classifiers=[
        "Programming Language :: C",
        "Programming Language :: C++",
        "Programming Language :: ML",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Operating System :: OS Independent",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: BSD License",
        "Natural Language :: English",
        "Topic :: Scientific/Engineering",
        "Development Status :: 5 - Production/Stable",
    ],
    entry_points={
        'console_scripts': console_scripts,
    },
    license="BSD",
    python_requires='>=3.5',
)
