from datetime import datetime

from sdccli.printer import print_item, print_list


def formats():
    return {
        "vulnerabilityDetails": _print_vuln_details,
        "vulnExceptionBundlesList": _print_vuln_bundle_list,
        "vulnExceptionBundlesAdded": _print_vuln_bundle_added,
        "vulnExceptionBundle": _print_vuln_budle,
        "vulnerabilityExceptionAdded": _print_vuln_added,
    }


def _print_vuln_details(vuln_detail):
    vuln_detail["description"] = vuln_detail["description"] or "No description found"
    print_item(vuln_detail, ["id", "severity", "description", "link"])
    if "nvd_data" in vuln_detail and vuln_detail["nvd_data"]:
        print("\nCVE Scores:")
        cvss_v2 = [{
            "id": f"{nvd_data['id']} CVSS v2",
            "severity": f"{nvd_data['cvss_v2']['severity']}",
            "access vector": f"{nvd_data['cvss_v2']['base_metrics']['access_vector']}",
            "base score": f"{nvd_data['cvss_v2']['base_metrics']['base_score']}",
            "exploitability score": f"{nvd_data['cvss_v2']['base_metrics']['exploitability_score']}",
            "impact score": f"{nvd_data['cvss_v2']['base_metrics']['impact_score']}",
        } for nvd_data in vuln_detail["nvd_data"] if "cvss_v2" in nvd_data and nvd_data["cvss_v2"]]

        print_list(cvss_v2, ["id", "severity", "access vector", "base score", "exploitability score", "impact score"])

    if "references" in vuln_detail and vuln_detail["references"]:
        print("\nReferences:")
        print_list(vuln_detail["references"], ["source", "url"])

    if "affected_packages" in vuln_detail and vuln_detail["affected_packages"]:
        print("\nAffected Packages:")
        print_list(vuln_detail["affected_packages"], ["name", "version"])


def _print_vuln_bundle_list(bundle_list):
    for bundle in bundle_list:
        bundle["item number"] = len(bundle["items"]) if "items" in bundle and bundle["items"] else 0

    print_list(bundle_list, ["id", "name", "comment", "item number"])


def _print_vuln_bundle_added(bundle):
    print_item(bundle, ["id", "name", "comment"])


def _print_vuln_budle(bundle):
    bundle["item number"] = len(bundle["items"]) if "items" in bundle and bundle["items"] else 0
    print_item(bundle, ["id", "name", "comment", "item number"])
    if "items" in bundle and bundle["items"]:
        print("\nItems:")
        items = [{
            "enabled": item["enabled"],
            "name": item["trigger_id"],
            "description": f"{item['description'][0:50]}..." if len(item["description"]) > 50 else (
                        item["description"] or "---"),
            "notes": item["notes"] if "notes" in item and item["notes"] else "---",
            "expiration date": datetime.fromtimestamp(item["expiration_date"]) if "expiration_date" in item and item[
                "expiration_date"] else "Never"
        } for item in bundle["items"]]
        print_list(items, ["enabled", "name", "description", "notes", "expiration date"])

def _print_vuln_added(vuln):
    item = {
        "enabled": vuln["enabled"],
        "name": vuln["trigger_id"],
        "description": f"{vuln['description'][0:100]}..." if len(vuln["description"]) > 100 else (
                vuln["description"] or "---"),
        "notes": vuln["notes"] if "notes" in vuln and vuln["notes"] else "---",
        "expiration date": datetime.fromtimestamp(vuln["expiration_date"]) if "expiration_date" in vuln and vuln[
            "expiration_date"] else "Never"
    }
    print_item(item, ["enabled", "name", "description", "notes", "expiration date"])