"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DateTimeAttribute = exports.BooleanAttribute = exports.NumberAttribute = exports.StringAttribute = void 0;
const core_1 = require("@aws-cdk/core");
/**
 * (experimental) The String custom attribute type.
 *
 * @experimental
 */
class StringAttribute {
    /**
     * @experimental
     */
    constructor(props = {}) {
        if (props.minLen && !core_1.Token.isUnresolved(props.minLen) && props.minLen < 0) {
            throw new Error(`minLen cannot be less than 0 (value: ${props.minLen}).`);
        }
        if (props.maxLen && !core_1.Token.isUnresolved(props.maxLen) && props.maxLen > 2048) {
            throw new Error(`maxLen cannot be greater than 2048 (value: ${props.maxLen}).`);
        }
        this.minLen = props === null || props === void 0 ? void 0 : props.minLen;
        this.maxLen = props === null || props === void 0 ? void 0 : props.maxLen;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    /**
     * (experimental) Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @experimental
     */
    bind() {
        let stringConstraints;
        if (this.minLen || this.maxLen) {
            stringConstraints = {
                minLen: this.minLen,
                maxLen: this.maxLen,
            };
        }
        return {
            dataType: 'String',
            stringConstraints,
            mutable: this.mutable,
        };
    }
}
exports.StringAttribute = StringAttribute;
/**
 * (experimental) The Number custom attribute type.
 *
 * @experimental
 */
class NumberAttribute {
    /**
     * @experimental
     */
    constructor(props = {}) {
        this.min = props === null || props === void 0 ? void 0 : props.min;
        this.max = props === null || props === void 0 ? void 0 : props.max;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    /**
     * (experimental) Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @experimental
     */
    bind() {
        let numberConstraints;
        if (this.min || this.max) {
            numberConstraints = {
                min: this.min,
                max: this.max,
            };
        }
        return {
            dataType: 'Number',
            numberConstraints,
            mutable: this.mutable,
        };
    }
}
exports.NumberAttribute = NumberAttribute;
/**
 * (experimental) The Boolean custom attribute type.
 *
 * @experimental
 */
class BooleanAttribute {
    /**
     * @experimental
     */
    constructor(props = {}) {
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    /**
     * (experimental) Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @experimental
     */
    bind() {
        return {
            dataType: 'Boolean',
            mutable: this.mutable,
        };
    }
}
exports.BooleanAttribute = BooleanAttribute;
/**
 * (experimental) The DateTime custom attribute type.
 *
 * @experimental
 */
class DateTimeAttribute {
    /**
     * @experimental
     */
    constructor(props = {}) {
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    /**
     * (experimental) Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @experimental
     */
    bind() {
        return {
            dataType: 'DateTime',
            mutable: this.mutable,
        };
    }
}
exports.DateTimeAttribute = DateTimeAttribute;
//# sourceMappingURL=data:application/json;base64,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