import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::Cognito::IdentityPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html
 * @external
 */
export interface CfnIdentityPoolProps {
    /**
     * `AWS::Cognito::IdentityPool.AllowUnauthenticatedIdentities`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowunauthenticatedidentities
     * @external
     */
    readonly allowUnauthenticatedIdentities: boolean | cdk.IResolvable;
    /**
     * `AWS::Cognito::IdentityPool.AllowClassicFlow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowclassicflow
     * @external
     */
    readonly allowClassicFlow?: boolean | cdk.IResolvable;
    /**
     * `AWS::Cognito::IdentityPool.CognitoEvents`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoevents
     * @external
     */
    readonly cognitoEvents?: any | cdk.IResolvable;
    /**
     * `AWS::Cognito::IdentityPool.CognitoIdentityProviders`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoidentityproviders
     * @external
     */
    readonly cognitoIdentityProviders?: Array<CfnIdentityPool.CognitoIdentityProviderProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Cognito::IdentityPool.CognitoStreams`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitostreams
     * @external
     */
    readonly cognitoStreams?: CfnIdentityPool.CognitoStreamsProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::IdentityPool.DeveloperProviderName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-developerprovidername
     * @external
     */
    readonly developerProviderName?: string;
    /**
     * `AWS::Cognito::IdentityPool.IdentityPoolName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-identitypoolname
     * @external
     */
    readonly identityPoolName?: string;
    /**
     * `AWS::Cognito::IdentityPool.OpenIdConnectProviderARNs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-openidconnectproviderarns
     * @external
     */
    readonly openIdConnectProviderArns?: string[];
    /**
     * `AWS::Cognito::IdentityPool.PushSync`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-pushsync
     * @external
     */
    readonly pushSync?: CfnIdentityPool.PushSyncProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::IdentityPool.SamlProviderARNs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-samlproviderarns
     * @external
     */
    readonly samlProviderArns?: string[];
    /**
     * `AWS::Cognito::IdentityPool.SupportedLoginProviders`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-supportedloginproviders
     * @external
     */
    readonly supportedLoginProviders?: any | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Cognito::IdentityPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html
 * @external
 * @cloudformationResource AWS::Cognito::IdentityPool
 */
export declare class CfnIdentityPool extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::IdentityPool";
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Cognito::IdentityPool.AllowUnauthenticatedIdentities`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowunauthenticatedidentities
     * @external
     */
    allowUnauthenticatedIdentities: boolean | cdk.IResolvable;
    /**
     * `AWS::Cognito::IdentityPool.AllowClassicFlow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowclassicflow
     * @external
     */
    allowClassicFlow: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::IdentityPool.CognitoEvents`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoevents
     * @external
     */
    cognitoEvents: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::IdentityPool.CognitoIdentityProviders`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoidentityproviders
     * @external
     */
    cognitoIdentityProviders: Array<CfnIdentityPool.CognitoIdentityProviderProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::IdentityPool.CognitoStreams`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitostreams
     * @external
     */
    cognitoStreams: CfnIdentityPool.CognitoStreamsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::IdentityPool.DeveloperProviderName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-developerprovidername
     * @external
     */
    developerProviderName: string | undefined;
    /**
     * `AWS::Cognito::IdentityPool.IdentityPoolName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-identitypoolname
     * @external
     */
    identityPoolName: string | undefined;
    /**
     * `AWS::Cognito::IdentityPool.OpenIdConnectProviderARNs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-openidconnectproviderarns
     * @external
     */
    openIdConnectProviderArns: string[] | undefined;
    /**
     * `AWS::Cognito::IdentityPool.PushSync`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-pushsync
     * @external
     */
    pushSync: CfnIdentityPool.PushSyncProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::IdentityPool.SamlProviderARNs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-samlproviderarns
     * @external
     */
    samlProviderArns: string[] | undefined;
    /**
     * `AWS::Cognito::IdentityPool.SupportedLoginProviders`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-supportedloginproviders
     * @external
     */
    supportedLoginProviders: any | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Cognito::IdentityPool`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnIdentityPoolProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Cognito::IdentityPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html
 * @external
 * @cloudformationResource AWS::Cognito::IdentityPool
 */
export declare namespace CfnIdentityPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html
     * @external
     */
    interface CognitoIdentityProviderProperty {
        /**
         * `CfnIdentityPool.CognitoIdentityProviderProperty.ClientId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html#cfn-cognito-identitypool-cognitoidentityprovider-clientid
         * @external
         */
        readonly clientId?: string;
        /**
         * `CfnIdentityPool.CognitoIdentityProviderProperty.ProviderName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html#cfn-cognito-identitypool-cognitoidentityprovider-providername
         * @external
         */
        readonly providerName?: string;
        /**
         * `CfnIdentityPool.CognitoIdentityProviderProperty.ServerSideTokenCheck`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html#cfn-cognito-identitypool-cognitoidentityprovider-serversidetokencheck
         * @external
         */
        readonly serverSideTokenCheck?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Cognito::IdentityPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html
 * @external
 * @cloudformationResource AWS::Cognito::IdentityPool
 */
export declare namespace CfnIdentityPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html
     * @external
     */
    interface CognitoStreamsProperty {
        /**
         * `CfnIdentityPool.CognitoStreamsProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html#cfn-cognito-identitypool-cognitostreams-rolearn
         * @external
         */
        readonly roleArn?: string;
        /**
         * `CfnIdentityPool.CognitoStreamsProperty.StreamName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html#cfn-cognito-identitypool-cognitostreams-streamname
         * @external
         */
        readonly streamName?: string;
        /**
         * `CfnIdentityPool.CognitoStreamsProperty.StreamingStatus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html#cfn-cognito-identitypool-cognitostreams-streamingstatus
         * @external
         */
        readonly streamingStatus?: string;
    }
}
/**
 * A CloudFormation `AWS::Cognito::IdentityPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html
 * @external
 * @cloudformationResource AWS::Cognito::IdentityPool
 */
export declare namespace CfnIdentityPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-pushsync.html
     * @external
     */
    interface PushSyncProperty {
        /**
         * `CfnIdentityPool.PushSyncProperty.ApplicationArns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-pushsync.html#cfn-cognito-identitypool-pushsync-applicationarns
         * @external
         */
        readonly applicationArns?: string[];
        /**
         * `CfnIdentityPool.PushSyncProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-pushsync.html#cfn-cognito-identitypool-pushsync-rolearn
         * @external
         */
        readonly roleArn?: string;
    }
}
/**
 * Properties for defining a `AWS::Cognito::IdentityPoolRoleAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html
 * @external
 */
export interface CfnIdentityPoolRoleAttachmentProps {
    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.IdentityPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-identitypoolid
     * @external
     */
    readonly identityPoolId: string;
    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.RoleMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-rolemappings
     * @external
     */
    readonly roleMappings?: {
        [key: string]: (CfnIdentityPoolRoleAttachment.RoleMappingProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.Roles`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-roles
     * @external
     */
    readonly roles?: any | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Cognito::IdentityPoolRoleAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::IdentityPoolRoleAttachment
 */
export declare class CfnIdentityPoolRoleAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::IdentityPoolRoleAttachment";
    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.IdentityPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-identitypoolid
     * @external
     */
    identityPoolId: string;
    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.RoleMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-rolemappings
     * @external
     */
    roleMappings: {
        [key: string]: (CfnIdentityPoolRoleAttachment.RoleMappingProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.Roles`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-roles
     * @external
     */
    roles: any | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Cognito::IdentityPoolRoleAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnIdentityPoolRoleAttachmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Cognito::IdentityPoolRoleAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::IdentityPoolRoleAttachment
 */
export declare namespace CfnIdentityPoolRoleAttachment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-mappingrule.html
     * @external
     */
    interface MappingRuleProperty {
        /**
         * `CfnIdentityPoolRoleAttachment.MappingRuleProperty.Claim`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-mappingrule.html#cfn-cognito-identitypoolroleattachment-mappingrule-claim
         * @external
         */
        readonly claim: string;
        /**
         * `CfnIdentityPoolRoleAttachment.MappingRuleProperty.MatchType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-mappingrule.html#cfn-cognito-identitypoolroleattachment-mappingrule-matchtype
         * @external
         */
        readonly matchType: string;
        /**
         * `CfnIdentityPoolRoleAttachment.MappingRuleProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-mappingrule.html#cfn-cognito-identitypoolroleattachment-mappingrule-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnIdentityPoolRoleAttachment.MappingRuleProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-mappingrule.html#cfn-cognito-identitypoolroleattachment-mappingrule-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::Cognito::IdentityPoolRoleAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::IdentityPoolRoleAttachment
 */
export declare namespace CfnIdentityPoolRoleAttachment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html
     * @external
     */
    interface RoleMappingProperty {
        /**
         * `CfnIdentityPoolRoleAttachment.RoleMappingProperty.AmbiguousRoleResolution`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html#cfn-cognito-identitypoolroleattachment-rolemapping-ambiguousroleresolution
         * @external
         */
        readonly ambiguousRoleResolution?: string;
        /**
         * `CfnIdentityPoolRoleAttachment.RoleMappingProperty.IdentityProvider`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html#cfn-cognito-identitypoolroleattachment-rolemapping-identityprovider
         * @external
         */
        readonly identityProvider?: string;
        /**
         * `CfnIdentityPoolRoleAttachment.RoleMappingProperty.RulesConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html#cfn-cognito-identitypoolroleattachment-rolemapping-rulesconfiguration
         * @external
         */
        readonly rulesConfiguration?: CfnIdentityPoolRoleAttachment.RulesConfigurationTypeProperty | cdk.IResolvable;
        /**
         * `CfnIdentityPoolRoleAttachment.RoleMappingProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html#cfn-cognito-identitypoolroleattachment-rolemapping-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Cognito::IdentityPoolRoleAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::IdentityPoolRoleAttachment
 */
export declare namespace CfnIdentityPoolRoleAttachment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rulesconfigurationtype.html
     * @external
     */
    interface RulesConfigurationTypeProperty {
        /**
         * `CfnIdentityPoolRoleAttachment.RulesConfigurationTypeProperty.Rules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rulesconfigurationtype.html#cfn-cognito-identitypoolroleattachment-rulesconfigurationtype-rules
         * @external
         */
        readonly rules: Array<CfnIdentityPoolRoleAttachment.MappingRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 */
export interface CfnUserPoolProps {
    /**
     * `AWS::Cognito::UserPool.AccountRecoverySetting`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-accountrecoverysetting
     * @external
     */
    readonly accountRecoverySetting?: CfnUserPool.AccountRecoverySettingProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPool.AdminCreateUserConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-admincreateuserconfig
     * @external
     */
    readonly adminCreateUserConfig?: CfnUserPool.AdminCreateUserConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPool.AliasAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-aliasattributes
     * @external
     */
    readonly aliasAttributes?: string[];
    /**
     * `AWS::Cognito::UserPool.AutoVerifiedAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-autoverifiedattributes
     * @external
     */
    readonly autoVerifiedAttributes?: string[];
    /**
     * `AWS::Cognito::UserPool.DeviceConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-deviceconfiguration
     * @external
     */
    readonly deviceConfiguration?: CfnUserPool.DeviceConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPool.EmailConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailconfiguration
     * @external
     */
    readonly emailConfiguration?: CfnUserPool.EmailConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPool.EmailVerificationMessage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailverificationmessage
     * @external
     */
    readonly emailVerificationMessage?: string;
    /**
     * `AWS::Cognito::UserPool.EmailVerificationSubject`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailverificationsubject
     * @external
     */
    readonly emailVerificationSubject?: string;
    /**
     * `AWS::Cognito::UserPool.EnabledMfas`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-enabledmfas
     * @external
     */
    readonly enabledMfas?: string[];
    /**
     * `AWS::Cognito::UserPool.LambdaConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-lambdaconfig
     * @external
     */
    readonly lambdaConfig?: CfnUserPool.LambdaConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPool.MfaConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-mfaconfiguration
     * @external
     */
    readonly mfaConfiguration?: string;
    /**
     * `AWS::Cognito::UserPool.Policies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-policies
     * @external
     */
    readonly policies?: CfnUserPool.PoliciesProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPool.Schema`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-schema
     * @external
     */
    readonly schema?: Array<CfnUserPool.SchemaAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPool.SmsAuthenticationMessage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-smsauthenticationmessage
     * @external
     */
    readonly smsAuthenticationMessage?: string;
    /**
     * `AWS::Cognito::UserPool.SmsConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-smsconfiguration
     * @external
     */
    readonly smsConfiguration?: CfnUserPool.SmsConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPool.SmsVerificationMessage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-smsverificationmessage
     * @external
     */
    readonly smsVerificationMessage?: string;
    /**
     * `AWS::Cognito::UserPool.UsernameAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-usernameattributes
     * @external
     */
    readonly usernameAttributes?: string[];
    /**
     * `AWS::Cognito::UserPool.UsernameConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-usernameconfiguration
     * @external
     */
    readonly usernameConfiguration?: CfnUserPool.UsernameConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPool.UserPoolAddOns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userpooladdons
     * @external
     */
    readonly userPoolAddOns?: CfnUserPool.UserPoolAddOnsProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPool.UserPoolName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userpoolname
     * @external
     */
    readonly userPoolName?: string;
    /**
     * `AWS::Cognito::UserPool.UserPoolTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userpooltags
     * @external
     */
    readonly userPoolTags?: any;
    /**
     * `AWS::Cognito::UserPool.VerificationMessageTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-verificationmessagetemplate
     * @external
     */
    readonly verificationMessageTemplate?: CfnUserPool.VerificationMessageTemplateProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare class CfnUserPool extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPool";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute ProviderName
     */
    readonly attrProviderName: string;
    /**
     * @external
     * @cloudformationAttribute ProviderURL
     */
    readonly attrProviderUrl: string;
    /**
     * `AWS::Cognito::UserPool.AccountRecoverySetting`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-accountrecoverysetting
     * @external
     */
    accountRecoverySetting: CfnUserPool.AccountRecoverySettingProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPool.AdminCreateUserConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-admincreateuserconfig
     * @external
     */
    adminCreateUserConfig: CfnUserPool.AdminCreateUserConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPool.AliasAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-aliasattributes
     * @external
     */
    aliasAttributes: string[] | undefined;
    /**
     * `AWS::Cognito::UserPool.AutoVerifiedAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-autoverifiedattributes
     * @external
     */
    autoVerifiedAttributes: string[] | undefined;
    /**
     * `AWS::Cognito::UserPool.DeviceConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-deviceconfiguration
     * @external
     */
    deviceConfiguration: CfnUserPool.DeviceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPool.EmailConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailconfiguration
     * @external
     */
    emailConfiguration: CfnUserPool.EmailConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPool.EmailVerificationMessage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailverificationmessage
     * @external
     */
    emailVerificationMessage: string | undefined;
    /**
     * `AWS::Cognito::UserPool.EmailVerificationSubject`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailverificationsubject
     * @external
     */
    emailVerificationSubject: string | undefined;
    /**
     * `AWS::Cognito::UserPool.EnabledMfas`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-enabledmfas
     * @external
     */
    enabledMfas: string[] | undefined;
    /**
     * `AWS::Cognito::UserPool.LambdaConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-lambdaconfig
     * @external
     */
    lambdaConfig: CfnUserPool.LambdaConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPool.MfaConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-mfaconfiguration
     * @external
     */
    mfaConfiguration: string | undefined;
    /**
     * `AWS::Cognito::UserPool.Policies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-policies
     * @external
     */
    policies: CfnUserPool.PoliciesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPool.Schema`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-schema
     * @external
     */
    schema: Array<CfnUserPool.SchemaAttributeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPool.SmsAuthenticationMessage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-smsauthenticationmessage
     * @external
     */
    smsAuthenticationMessage: string | undefined;
    /**
     * `AWS::Cognito::UserPool.SmsConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-smsconfiguration
     * @external
     */
    smsConfiguration: CfnUserPool.SmsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPool.SmsVerificationMessage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-smsverificationmessage
     * @external
     */
    smsVerificationMessage: string | undefined;
    /**
     * `AWS::Cognito::UserPool.UsernameAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-usernameattributes
     * @external
     */
    usernameAttributes: string[] | undefined;
    /**
     * `AWS::Cognito::UserPool.UsernameConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-usernameconfiguration
     * @external
     */
    usernameConfiguration: CfnUserPool.UsernameConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPool.UserPoolAddOns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userpooladdons
     * @external
     */
    userPoolAddOns: CfnUserPool.UserPoolAddOnsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPool.UserPoolName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userpoolname
     * @external
     */
    userPoolName: string | undefined;
    /**
     * `AWS::Cognito::UserPool.UserPoolTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userpooltags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Cognito::UserPool.VerificationMessageTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-verificationmessagetemplate
     * @external
     */
    verificationMessageTemplate: CfnUserPool.VerificationMessageTemplateProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Cognito::UserPool`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnUserPoolProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-accountrecoverysetting.html
     * @external
     */
    interface AccountRecoverySettingProperty {
        /**
         * `CfnUserPool.AccountRecoverySettingProperty.RecoveryMechanisms`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-accountrecoverysetting.html#cfn-cognito-userpool-accountrecoverysetting-recoverymechanisms
         * @external
         */
        readonly recoveryMechanisms?: Array<CfnUserPool.RecoveryOptionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-admincreateuserconfig.html
     * @external
     */
    interface AdminCreateUserConfigProperty {
        /**
         * `CfnUserPool.AdminCreateUserConfigProperty.AllowAdminCreateUserOnly`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-admincreateuserconfig.html#cfn-cognito-userpool-admincreateuserconfig-allowadmincreateuseronly
         * @external
         */
        readonly allowAdminCreateUserOnly?: boolean | cdk.IResolvable;
        /**
         * `CfnUserPool.AdminCreateUserConfigProperty.InviteMessageTemplate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-admincreateuserconfig.html#cfn-cognito-userpool-admincreateuserconfig-invitemessagetemplate
         * @external
         */
        readonly inviteMessageTemplate?: CfnUserPool.InviteMessageTemplateProperty | cdk.IResolvable;
        /**
         * `CfnUserPool.AdminCreateUserConfigProperty.UnusedAccountValidityDays`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-admincreateuserconfig.html#cfn-cognito-userpool-admincreateuserconfig-unusedaccountvaliditydays
         * @external
         */
        readonly unusedAccountValidityDays?: number;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-deviceconfiguration.html
     * @external
     */
    interface DeviceConfigurationProperty {
        /**
         * `CfnUserPool.DeviceConfigurationProperty.ChallengeRequiredOnNewDevice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-deviceconfiguration.html#cfn-cognito-userpool-deviceconfiguration-challengerequiredonnewdevice
         * @external
         */
        readonly challengeRequiredOnNewDevice?: boolean | cdk.IResolvable;
        /**
         * `CfnUserPool.DeviceConfigurationProperty.DeviceOnlyRememberedOnUserPrompt`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-deviceconfiguration.html#cfn-cognito-userpool-deviceconfiguration-deviceonlyrememberedonuserprompt
         * @external
         */
        readonly deviceOnlyRememberedOnUserPrompt?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-emailconfiguration.html
     * @external
     */
    interface EmailConfigurationProperty {
        /**
         * `CfnUserPool.EmailConfigurationProperty.ConfigurationSet`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-emailconfiguration.html#cfn-cognito-userpool-emailconfiguration-configurationset
         * @external
         */
        readonly configurationSet?: string;
        /**
         * `CfnUserPool.EmailConfigurationProperty.EmailSendingAccount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-emailconfiguration.html#cfn-cognito-userpool-emailconfiguration-emailsendingaccount
         * @external
         */
        readonly emailSendingAccount?: string;
        /**
         * `CfnUserPool.EmailConfigurationProperty.From`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-emailconfiguration.html#cfn-cognito-userpool-emailconfiguration-from
         * @external
         */
        readonly from?: string;
        /**
         * `CfnUserPool.EmailConfigurationProperty.ReplyToEmailAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-emailconfiguration.html#cfn-cognito-userpool-emailconfiguration-replytoemailaddress
         * @external
         */
        readonly replyToEmailAddress?: string;
        /**
         * `CfnUserPool.EmailConfigurationProperty.SourceArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-emailconfiguration.html#cfn-cognito-userpool-emailconfiguration-sourcearn
         * @external
         */
        readonly sourceArn?: string;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-invitemessagetemplate.html
     * @external
     */
    interface InviteMessageTemplateProperty {
        /**
         * `CfnUserPool.InviteMessageTemplateProperty.EmailMessage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-invitemessagetemplate.html#cfn-cognito-userpool-invitemessagetemplate-emailmessage
         * @external
         */
        readonly emailMessage?: string;
        /**
         * `CfnUserPool.InviteMessageTemplateProperty.EmailSubject`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-invitemessagetemplate.html#cfn-cognito-userpool-invitemessagetemplate-emailsubject
         * @external
         */
        readonly emailSubject?: string;
        /**
         * `CfnUserPool.InviteMessageTemplateProperty.SMSMessage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-invitemessagetemplate.html#cfn-cognito-userpool-invitemessagetemplate-smsmessage
         * @external
         */
        readonly smsMessage?: string;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-lambdaconfig.html
     * @external
     */
    interface LambdaConfigProperty {
        /**
         * `CfnUserPool.LambdaConfigProperty.CreateAuthChallenge`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-lambdaconfig.html#cfn-cognito-userpool-lambdaconfig-createauthchallenge
         * @external
         */
        readonly createAuthChallenge?: string;
        /**
         * `CfnUserPool.LambdaConfigProperty.CustomMessage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-lambdaconfig.html#cfn-cognito-userpool-lambdaconfig-custommessage
         * @external
         */
        readonly customMessage?: string;
        /**
         * `CfnUserPool.LambdaConfigProperty.DefineAuthChallenge`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-lambdaconfig.html#cfn-cognito-userpool-lambdaconfig-defineauthchallenge
         * @external
         */
        readonly defineAuthChallenge?: string;
        /**
         * `CfnUserPool.LambdaConfigProperty.PostAuthentication`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-lambdaconfig.html#cfn-cognito-userpool-lambdaconfig-postauthentication
         * @external
         */
        readonly postAuthentication?: string;
        /**
         * `CfnUserPool.LambdaConfigProperty.PostConfirmation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-lambdaconfig.html#cfn-cognito-userpool-lambdaconfig-postconfirmation
         * @external
         */
        readonly postConfirmation?: string;
        /**
         * `CfnUserPool.LambdaConfigProperty.PreAuthentication`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-lambdaconfig.html#cfn-cognito-userpool-lambdaconfig-preauthentication
         * @external
         */
        readonly preAuthentication?: string;
        /**
         * `CfnUserPool.LambdaConfigProperty.PreSignUp`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-lambdaconfig.html#cfn-cognito-userpool-lambdaconfig-presignup
         * @external
         */
        readonly preSignUp?: string;
        /**
         * `CfnUserPool.LambdaConfigProperty.PreTokenGeneration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-lambdaconfig.html#cfn-cognito-userpool-lambdaconfig-pretokengeneration
         * @external
         */
        readonly preTokenGeneration?: string;
        /**
         * `CfnUserPool.LambdaConfigProperty.UserMigration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-lambdaconfig.html#cfn-cognito-userpool-lambdaconfig-usermigration
         * @external
         */
        readonly userMigration?: string;
        /**
         * `CfnUserPool.LambdaConfigProperty.VerifyAuthChallengeResponse`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-lambdaconfig.html#cfn-cognito-userpool-lambdaconfig-verifyauthchallengeresponse
         * @external
         */
        readonly verifyAuthChallengeResponse?: string;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-numberattributeconstraints.html
     * @external
     */
    interface NumberAttributeConstraintsProperty {
        /**
         * `CfnUserPool.NumberAttributeConstraintsProperty.MaxValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-numberattributeconstraints.html#cfn-cognito-userpool-numberattributeconstraints-maxvalue
         * @external
         */
        readonly maxValue?: string;
        /**
         * `CfnUserPool.NumberAttributeConstraintsProperty.MinValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-numberattributeconstraints.html#cfn-cognito-userpool-numberattributeconstraints-minvalue
         * @external
         */
        readonly minValue?: string;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-passwordpolicy.html
     * @external
     */
    interface PasswordPolicyProperty {
        /**
         * `CfnUserPool.PasswordPolicyProperty.MinimumLength`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-passwordpolicy.html#cfn-cognito-userpool-passwordpolicy-minimumlength
         * @external
         */
        readonly minimumLength?: number;
        /**
         * `CfnUserPool.PasswordPolicyProperty.RequireLowercase`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-passwordpolicy.html#cfn-cognito-userpool-passwordpolicy-requirelowercase
         * @external
         */
        readonly requireLowercase?: boolean | cdk.IResolvable;
        /**
         * `CfnUserPool.PasswordPolicyProperty.RequireNumbers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-passwordpolicy.html#cfn-cognito-userpool-passwordpolicy-requirenumbers
         * @external
         */
        readonly requireNumbers?: boolean | cdk.IResolvable;
        /**
         * `CfnUserPool.PasswordPolicyProperty.RequireSymbols`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-passwordpolicy.html#cfn-cognito-userpool-passwordpolicy-requiresymbols
         * @external
         */
        readonly requireSymbols?: boolean | cdk.IResolvable;
        /**
         * `CfnUserPool.PasswordPolicyProperty.RequireUppercase`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-passwordpolicy.html#cfn-cognito-userpool-passwordpolicy-requireuppercase
         * @external
         */
        readonly requireUppercase?: boolean | cdk.IResolvable;
        /**
         * `CfnUserPool.PasswordPolicyProperty.TemporaryPasswordValidityDays`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-passwordpolicy.html#cfn-cognito-userpool-passwordpolicy-temporarypasswordvaliditydays
         * @external
         */
        readonly temporaryPasswordValidityDays?: number;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-policies.html
     * @external
     */
    interface PoliciesProperty {
        /**
         * `CfnUserPool.PoliciesProperty.PasswordPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-policies.html#cfn-cognito-userpool-policies-passwordpolicy
         * @external
         */
        readonly passwordPolicy?: CfnUserPool.PasswordPolicyProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-recoveryoption.html
     * @external
     */
    interface RecoveryOptionProperty {
        /**
         * `CfnUserPool.RecoveryOptionProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-recoveryoption.html#cfn-cognito-userpool-recoveryoption-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnUserPool.RecoveryOptionProperty.Priority`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-recoveryoption.html#cfn-cognito-userpool-recoveryoption-priority
         * @external
         */
        readonly priority?: number;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-schemaattribute.html
     * @external
     */
    interface SchemaAttributeProperty {
        /**
         * `CfnUserPool.SchemaAttributeProperty.AttributeDataType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-schemaattribute.html#cfn-cognito-userpool-schemaattribute-attributedatatype
         * @external
         */
        readonly attributeDataType?: string;
        /**
         * `CfnUserPool.SchemaAttributeProperty.DeveloperOnlyAttribute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-schemaattribute.html#cfn-cognito-userpool-schemaattribute-developeronlyattribute
         * @external
         */
        readonly developerOnlyAttribute?: boolean | cdk.IResolvable;
        /**
         * `CfnUserPool.SchemaAttributeProperty.Mutable`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-schemaattribute.html#cfn-cognito-userpool-schemaattribute-mutable
         * @external
         */
        readonly mutable?: boolean | cdk.IResolvable;
        /**
         * `CfnUserPool.SchemaAttributeProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-schemaattribute.html#cfn-cognito-userpool-schemaattribute-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnUserPool.SchemaAttributeProperty.NumberAttributeConstraints`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-schemaattribute.html#cfn-cognito-userpool-schemaattribute-numberattributeconstraints
         * @external
         */
        readonly numberAttributeConstraints?: CfnUserPool.NumberAttributeConstraintsProperty | cdk.IResolvable;
        /**
         * `CfnUserPool.SchemaAttributeProperty.Required`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-schemaattribute.html#cfn-cognito-userpool-schemaattribute-required
         * @external
         */
        readonly required?: boolean | cdk.IResolvable;
        /**
         * `CfnUserPool.SchemaAttributeProperty.StringAttributeConstraints`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-schemaattribute.html#cfn-cognito-userpool-schemaattribute-stringattributeconstraints
         * @external
         */
        readonly stringAttributeConstraints?: CfnUserPool.StringAttributeConstraintsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-smsconfiguration.html
     * @external
     */
    interface SmsConfigurationProperty {
        /**
         * `CfnUserPool.SmsConfigurationProperty.ExternalId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-smsconfiguration.html#cfn-cognito-userpool-smsconfiguration-externalid
         * @external
         */
        readonly externalId?: string;
        /**
         * `CfnUserPool.SmsConfigurationProperty.SnsCallerArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-smsconfiguration.html#cfn-cognito-userpool-smsconfiguration-snscallerarn
         * @external
         */
        readonly snsCallerArn?: string;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-stringattributeconstraints.html
     * @external
     */
    interface StringAttributeConstraintsProperty {
        /**
         * `CfnUserPool.StringAttributeConstraintsProperty.MaxLength`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-stringattributeconstraints.html#cfn-cognito-userpool-stringattributeconstraints-maxlength
         * @external
         */
        readonly maxLength?: string;
        /**
         * `CfnUserPool.StringAttributeConstraintsProperty.MinLength`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-stringattributeconstraints.html#cfn-cognito-userpool-stringattributeconstraints-minlength
         * @external
         */
        readonly minLength?: string;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-userpooladdons.html
     * @external
     */
    interface UserPoolAddOnsProperty {
        /**
         * `CfnUserPool.UserPoolAddOnsProperty.AdvancedSecurityMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-userpooladdons.html#cfn-cognito-userpool-userpooladdons-advancedsecuritymode
         * @external
         */
        readonly advancedSecurityMode?: string;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-usernameconfiguration.html
     * @external
     */
    interface UsernameConfigurationProperty {
        /**
         * `CfnUserPool.UsernameConfigurationProperty.CaseSensitive`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-usernameconfiguration.html#cfn-cognito-userpool-usernameconfiguration-casesensitive
         * @external
         */
        readonly caseSensitive?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPool
 */
export declare namespace CfnUserPool {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html
     * @external
     */
    interface VerificationMessageTemplateProperty {
        /**
         * `CfnUserPool.VerificationMessageTemplateProperty.DefaultEmailOption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html#cfn-cognito-userpool-verificationmessagetemplate-defaultemailoption
         * @external
         */
        readonly defaultEmailOption?: string;
        /**
         * `CfnUserPool.VerificationMessageTemplateProperty.EmailMessage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html#cfn-cognito-userpool-verificationmessagetemplate-emailmessage
         * @external
         */
        readonly emailMessage?: string;
        /**
         * `CfnUserPool.VerificationMessageTemplateProperty.EmailMessageByLink`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html#cfn-cognito-userpool-verificationmessagetemplate-emailmessagebylink
         * @external
         */
        readonly emailMessageByLink?: string;
        /**
         * `CfnUserPool.VerificationMessageTemplateProperty.EmailSubject`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html#cfn-cognito-userpool-verificationmessagetemplate-emailsubject
         * @external
         */
        readonly emailSubject?: string;
        /**
         * `CfnUserPool.VerificationMessageTemplateProperty.EmailSubjectByLink`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html#cfn-cognito-userpool-verificationmessagetemplate-emailsubjectbylink
         * @external
         */
        readonly emailSubjectByLink?: string;
        /**
         * `CfnUserPool.VerificationMessageTemplateProperty.SmsMessage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html#cfn-cognito-userpool-verificationmessagetemplate-smsmessage
         * @external
         */
        readonly smsMessage?: string;
    }
}
/**
 * Properties for defining a `AWS::Cognito::UserPoolClient`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html
 * @external
 */
export interface CfnUserPoolClientProps {
    /**
     * `AWS::Cognito::UserPoolClient.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-userpoolid
     * @external
     */
    readonly userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolClient.AccessTokenValidity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-accesstokenvalidity
     * @external
     */
    readonly accessTokenValidity?: number;
    /**
     * `AWS::Cognito::UserPoolClient.AllowedOAuthFlows`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflows
     * @external
     */
    readonly allowedOAuthFlows?: string[];
    /**
     * `AWS::Cognito::UserPoolClient.AllowedOAuthFlowsUserPoolClient`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflowsuserpoolclient
     * @external
     */
    readonly allowedOAuthFlowsUserPoolClient?: boolean | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPoolClient.AllowedOAuthScopes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthscopes
     * @external
     */
    readonly allowedOAuthScopes?: string[];
    /**
     * `AWS::Cognito::UserPoolClient.AnalyticsConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-analyticsconfiguration
     * @external
     */
    readonly analyticsConfiguration?: CfnUserPoolClient.AnalyticsConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPoolClient.CallbackURLs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-callbackurls
     * @external
     */
    readonly callbackUrLs?: string[];
    /**
     * `AWS::Cognito::UserPoolClient.ClientName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-clientname
     * @external
     */
    readonly clientName?: string;
    /**
     * `AWS::Cognito::UserPoolClient.DefaultRedirectURI`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-defaultredirecturi
     * @external
     */
    readonly defaultRedirectUri?: string;
    /**
     * `AWS::Cognito::UserPoolClient.ExplicitAuthFlows`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-explicitauthflows
     * @external
     */
    readonly explicitAuthFlows?: string[];
    /**
     * `AWS::Cognito::UserPoolClient.GenerateSecret`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-generatesecret
     * @external
     */
    readonly generateSecret?: boolean | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPoolClient.IdTokenValidity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-idtokenvalidity
     * @external
     */
    readonly idTokenValidity?: number;
    /**
     * `AWS::Cognito::UserPoolClient.LogoutURLs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-logouturls
     * @external
     */
    readonly logoutUrLs?: string[];
    /**
     * `AWS::Cognito::UserPoolClient.PreventUserExistenceErrors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-preventuserexistenceerrors
     * @external
     */
    readonly preventUserExistenceErrors?: string;
    /**
     * `AWS::Cognito::UserPoolClient.ReadAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-readattributes
     * @external
     */
    readonly readAttributes?: string[];
    /**
     * `AWS::Cognito::UserPoolClient.RefreshTokenValidity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-refreshtokenvalidity
     * @external
     */
    readonly refreshTokenValidity?: number;
    /**
     * `AWS::Cognito::UserPoolClient.SupportedIdentityProviders`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-supportedidentityproviders
     * @external
     */
    readonly supportedIdentityProviders?: string[];
    /**
     * `AWS::Cognito::UserPoolClient.TokenValidityUnits`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-tokenvalidityunits
     * @external
     */
    readonly tokenValidityUnits?: CfnUserPoolClient.TokenValidityUnitsProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPoolClient.WriteAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-writeattributes
     * @external
     */
    readonly writeAttributes?: string[];
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolClient`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolClient
 */
export declare class CfnUserPoolClient extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolClient";
    /**
     * @external
     * @cloudformationAttribute ClientSecret
     */
    readonly attrClientSecret: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Cognito::UserPoolClient.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-userpoolid
     * @external
     */
    userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolClient.AccessTokenValidity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-accesstokenvalidity
     * @external
     */
    accessTokenValidity: number | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.AllowedOAuthFlows`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflows
     * @external
     */
    allowedOAuthFlows: string[] | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.AllowedOAuthFlowsUserPoolClient`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflowsuserpoolclient
     * @external
     */
    allowedOAuthFlowsUserPoolClient: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.AllowedOAuthScopes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthscopes
     * @external
     */
    allowedOAuthScopes: string[] | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.AnalyticsConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-analyticsconfiguration
     * @external
     */
    analyticsConfiguration: CfnUserPoolClient.AnalyticsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.CallbackURLs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-callbackurls
     * @external
     */
    callbackUrLs: string[] | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.ClientName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-clientname
     * @external
     */
    clientName: string | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.DefaultRedirectURI`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-defaultredirecturi
     * @external
     */
    defaultRedirectUri: string | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.ExplicitAuthFlows`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-explicitauthflows
     * @external
     */
    explicitAuthFlows: string[] | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.GenerateSecret`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-generatesecret
     * @external
     */
    generateSecret: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.IdTokenValidity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-idtokenvalidity
     * @external
     */
    idTokenValidity: number | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.LogoutURLs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-logouturls
     * @external
     */
    logoutUrLs: string[] | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.PreventUserExistenceErrors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-preventuserexistenceerrors
     * @external
     */
    preventUserExistenceErrors: string | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.ReadAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-readattributes
     * @external
     */
    readAttributes: string[] | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.RefreshTokenValidity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-refreshtokenvalidity
     * @external
     */
    refreshTokenValidity: number | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.SupportedIdentityProviders`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-supportedidentityproviders
     * @external
     */
    supportedIdentityProviders: string[] | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.TokenValidityUnits`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-tokenvalidityunits
     * @external
     */
    tokenValidityUnits: CfnUserPoolClient.TokenValidityUnitsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPoolClient.WriteAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-writeattributes
     * @external
     */
    writeAttributes: string[] | undefined;
    /**
     * Create a new `AWS::Cognito::UserPoolClient`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserPoolClientProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolClient`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolClient
 */
export declare namespace CfnUserPoolClient {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html
     * @external
     */
    interface AnalyticsConfigurationProperty {
        /**
         * `CfnUserPoolClient.AnalyticsConfigurationProperty.ApplicationId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-applicationid
         * @external
         */
        readonly applicationId?: string;
        /**
         * `CfnUserPoolClient.AnalyticsConfigurationProperty.ExternalId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-externalid
         * @external
         */
        readonly externalId?: string;
        /**
         * `CfnUserPoolClient.AnalyticsConfigurationProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-rolearn
         * @external
         */
        readonly roleArn?: string;
        /**
         * `CfnUserPoolClient.AnalyticsConfigurationProperty.UserDataShared`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-userdatashared
         * @external
         */
        readonly userDataShared?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolClient`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolClient
 */
export declare namespace CfnUserPoolClient {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-tokenvalidityunits.html
     * @external
     */
    interface TokenValidityUnitsProperty {
        /**
         * `CfnUserPoolClient.TokenValidityUnitsProperty.AccessToken`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-tokenvalidityunits.html#cfn-cognito-userpoolclient-tokenvalidityunits-accesstoken
         * @external
         */
        readonly accessToken?: string;
        /**
         * `CfnUserPoolClient.TokenValidityUnitsProperty.IdToken`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-tokenvalidityunits.html#cfn-cognito-userpoolclient-tokenvalidityunits-idtoken
         * @external
         */
        readonly idToken?: string;
        /**
         * `CfnUserPoolClient.TokenValidityUnitsProperty.RefreshToken`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-tokenvalidityunits.html#cfn-cognito-userpoolclient-tokenvalidityunits-refreshtoken
         * @external
         */
        readonly refreshToken?: string;
    }
}
/**
 * Properties for defining a `AWS::Cognito::UserPoolDomain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html
 * @external
 */
export interface CfnUserPoolDomainProps {
    /**
     * `AWS::Cognito::UserPoolDomain.Domain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html#cfn-cognito-userpooldomain-domain
     * @external
     */
    readonly domain: string;
    /**
     * `AWS::Cognito::UserPoolDomain.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html#cfn-cognito-userpooldomain-userpoolid
     * @external
     */
    readonly userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolDomain.CustomDomainConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html#cfn-cognito-userpooldomain-customdomainconfig
     * @external
     */
    readonly customDomainConfig?: CfnUserPoolDomain.CustomDomainConfigTypeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolDomain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolDomain
 */
export declare class CfnUserPoolDomain extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolDomain";
    /**
     * `AWS::Cognito::UserPoolDomain.Domain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html#cfn-cognito-userpooldomain-domain
     * @external
     */
    domain: string;
    /**
     * `AWS::Cognito::UserPoolDomain.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html#cfn-cognito-userpooldomain-userpoolid
     * @external
     */
    userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolDomain.CustomDomainConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html#cfn-cognito-userpooldomain-customdomainconfig
     * @external
     */
    customDomainConfig: CfnUserPoolDomain.CustomDomainConfigTypeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Cognito::UserPoolDomain`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserPoolDomainProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolDomain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolDomain
 */
export declare namespace CfnUserPoolDomain {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpooldomain-customdomainconfigtype.html
     * @external
     */
    interface CustomDomainConfigTypeProperty {
        /**
         * `CfnUserPoolDomain.CustomDomainConfigTypeProperty.CertificateArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpooldomain-customdomainconfigtype.html#cfn-cognito-userpooldomain-customdomainconfigtype-certificatearn
         * @external
         */
        readonly certificateArn?: string;
    }
}
/**
 * Properties for defining a `AWS::Cognito::UserPoolGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html
 * @external
 */
export interface CfnUserPoolGroupProps {
    /**
     * `AWS::Cognito::UserPoolGroup.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html#cfn-cognito-userpoolgroup-userpoolid
     * @external
     */
    readonly userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html#cfn-cognito-userpoolgroup-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Cognito::UserPoolGroup.GroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html#cfn-cognito-userpoolgroup-groupname
     * @external
     */
    readonly groupName?: string;
    /**
     * `AWS::Cognito::UserPoolGroup.Precedence`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html#cfn-cognito-userpoolgroup-precedence
     * @external
     */
    readonly precedence?: number;
    /**
     * `AWS::Cognito::UserPoolGroup.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html#cfn-cognito-userpoolgroup-rolearn
     * @external
     */
    readonly roleArn?: string;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolGroup
 */
export declare class CfnUserPoolGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolGroup";
    /**
     * `AWS::Cognito::UserPoolGroup.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html#cfn-cognito-userpoolgroup-userpoolid
     * @external
     */
    userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html#cfn-cognito-userpoolgroup-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Cognito::UserPoolGroup.GroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html#cfn-cognito-userpoolgroup-groupname
     * @external
     */
    groupName: string | undefined;
    /**
     * `AWS::Cognito::UserPoolGroup.Precedence`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html#cfn-cognito-userpoolgroup-precedence
     * @external
     */
    precedence: number | undefined;
    /**
     * `AWS::Cognito::UserPoolGroup.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html#cfn-cognito-userpoolgroup-rolearn
     * @external
     */
    roleArn: string | undefined;
    /**
     * Create a new `AWS::Cognito::UserPoolGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserPoolGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Cognito::UserPoolIdentityProvider`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html
 * @external
 */
export interface CfnUserPoolIdentityProviderProps {
    /**
     * `AWS::Cognito::UserPoolIdentityProvider.ProviderName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html#cfn-cognito-userpoolidentityprovider-providername
     * @external
     */
    readonly providerName: string;
    /**
     * `AWS::Cognito::UserPoolIdentityProvider.ProviderType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html#cfn-cognito-userpoolidentityprovider-providertype
     * @external
     */
    readonly providerType: string;
    /**
     * `AWS::Cognito::UserPoolIdentityProvider.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html#cfn-cognito-userpoolidentityprovider-userpoolid
     * @external
     */
    readonly userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolIdentityProvider.AttributeMapping`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html#cfn-cognito-userpoolidentityprovider-attributemapping
     * @external
     */
    readonly attributeMapping?: any | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPoolIdentityProvider.IdpIdentifiers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html#cfn-cognito-userpoolidentityprovider-idpidentifiers
     * @external
     */
    readonly idpIdentifiers?: string[];
    /**
     * `AWS::Cognito::UserPoolIdentityProvider.ProviderDetails`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html#cfn-cognito-userpoolidentityprovider-providerdetails
     * @external
     */
    readonly providerDetails?: any | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolIdentityProvider`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolIdentityProvider
 */
export declare class CfnUserPoolIdentityProvider extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolIdentityProvider";
    /**
     * `AWS::Cognito::UserPoolIdentityProvider.ProviderName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html#cfn-cognito-userpoolidentityprovider-providername
     * @external
     */
    providerName: string;
    /**
     * `AWS::Cognito::UserPoolIdentityProvider.ProviderType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html#cfn-cognito-userpoolidentityprovider-providertype
     * @external
     */
    providerType: string;
    /**
     * `AWS::Cognito::UserPoolIdentityProvider.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html#cfn-cognito-userpoolidentityprovider-userpoolid
     * @external
     */
    userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolIdentityProvider.AttributeMapping`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html#cfn-cognito-userpoolidentityprovider-attributemapping
     * @external
     */
    attributeMapping: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPoolIdentityProvider.IdpIdentifiers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html#cfn-cognito-userpoolidentityprovider-idpidentifiers
     * @external
     */
    idpIdentifiers: string[] | undefined;
    /**
     * `AWS::Cognito::UserPoolIdentityProvider.ProviderDetails`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html#cfn-cognito-userpoolidentityprovider-providerdetails
     * @external
     */
    providerDetails: any | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Cognito::UserPoolIdentityProvider`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserPoolIdentityProviderProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Cognito::UserPoolResourceServer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html
 * @external
 */
export interface CfnUserPoolResourceServerProps {
    /**
     * `AWS::Cognito::UserPoolResourceServer.Identifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-identifier
     * @external
     */
    readonly identifier: string;
    /**
     * `AWS::Cognito::UserPoolResourceServer.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Cognito::UserPoolResourceServer.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-userpoolid
     * @external
     */
    readonly userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolResourceServer.Scopes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-scopes
     * @external
     */
    readonly scopes?: Array<CfnUserPoolResourceServer.ResourceServerScopeTypeProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolResourceServer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolResourceServer
 */
export declare class CfnUserPoolResourceServer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolResourceServer";
    /**
     * `AWS::Cognito::UserPoolResourceServer.Identifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-identifier
     * @external
     */
    identifier: string;
    /**
     * `AWS::Cognito::UserPoolResourceServer.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-name
     * @external
     */
    name: string;
    /**
     * `AWS::Cognito::UserPoolResourceServer.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-userpoolid
     * @external
     */
    userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolResourceServer.Scopes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-scopes
     * @external
     */
    scopes: Array<CfnUserPoolResourceServer.ResourceServerScopeTypeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Cognito::UserPoolResourceServer`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserPoolResourceServerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolResourceServer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolResourceServer
 */
export declare namespace CfnUserPoolResourceServer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolresourceserver-resourceserverscopetype.html
     * @external
     */
    interface ResourceServerScopeTypeProperty {
        /**
         * `CfnUserPoolResourceServer.ResourceServerScopeTypeProperty.ScopeDescription`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolresourceserver-resourceserverscopetype.html#cfn-cognito-userpoolresourceserver-resourceserverscopetype-scopedescription
         * @external
         */
        readonly scopeDescription: string;
        /**
         * `CfnUserPoolResourceServer.ResourceServerScopeTypeProperty.ScopeName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolresourceserver-resourceserverscopetype.html#cfn-cognito-userpoolresourceserver-resourceserverscopetype-scopename
         * @external
         */
        readonly scopeName: string;
    }
}
/**
 * Properties for defining a `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html
 * @external
 */
export interface CfnUserPoolRiskConfigurationAttachmentProps {
    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.ClientId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-clientid
     * @external
     */
    readonly clientId: string;
    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-userpoolid
     * @external
     */
    readonly userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfiguration
     * @external
     */
    readonly accountTakeoverRiskConfiguration?: CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfiguration
     * @external
     */
    readonly compromisedCredentialsRiskConfiguration?: CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfiguration
     * @external
     */
    readonly riskExceptionConfiguration?: CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolRiskConfigurationAttachment
 */
export declare class CfnUserPoolRiskConfigurationAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolRiskConfigurationAttachment";
    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.ClientId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-clientid
     * @external
     */
    clientId: string;
    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-userpoolid
     * @external
     */
    userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfiguration
     * @external
     */
    accountTakeoverRiskConfiguration: CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfiguration
     * @external
     */
    compromisedCredentialsRiskConfiguration: CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfiguration
     * @external
     */
    riskExceptionConfiguration: CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserPoolRiskConfigurationAttachmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolRiskConfigurationAttachment
 */
export declare namespace CfnUserPoolRiskConfigurationAttachment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype.html
     * @external
     */
    interface AccountTakeoverActionTypeProperty {
        /**
         * `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty.EventAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype-eventaction
         * @external
         */
        readonly eventAction: string;
        /**
         * `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty.Notify`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype-notify
         * @external
         */
        readonly notify: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolRiskConfigurationAttachment
 */
export declare namespace CfnUserPoolRiskConfigurationAttachment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html
     * @external
     */
    interface AccountTakeoverActionsTypeProperty {
        /**
         * `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty.HighAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype-highaction
         * @external
         */
        readonly highAction?: CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty | cdk.IResolvable;
        /**
         * `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty.LowAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype-lowaction
         * @external
         */
        readonly lowAction?: CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty | cdk.IResolvable;
        /**
         * `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty.MediumAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype-mediumaction
         * @external
         */
        readonly mediumAction?: CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolRiskConfigurationAttachment
 */
export declare namespace CfnUserPoolRiskConfigurationAttachment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html
     * @external
     */
    interface AccountTakeoverRiskConfigurationTypeProperty {
        /**
         * `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty.Actions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype-actions
         * @external
         */
        readonly actions: CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty | cdk.IResolvable;
        /**
         * `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty.NotifyConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype-notifyconfiguration
         * @external
         */
        readonly notifyConfiguration?: CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolRiskConfigurationAttachment
 */
export declare namespace CfnUserPoolRiskConfigurationAttachment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsactionstype.html
     * @external
     */
    interface CompromisedCredentialsActionsTypeProperty {
        /**
         * `CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsTypeProperty.EventAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsactionstype.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsactionstype-eventaction
         * @external
         */
        readonly eventAction: string;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolRiskConfigurationAttachment
 */
export declare namespace CfnUserPoolRiskConfigurationAttachment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype.html
     * @external
     */
    interface CompromisedCredentialsRiskConfigurationTypeProperty {
        /**
         * `CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty.Actions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype-actions
         * @external
         */
        readonly actions: CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsTypeProperty | cdk.IResolvable;
        /**
         * `CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty.EventFilter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype-eventfilter
         * @external
         */
        readonly eventFilter?: string[];
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolRiskConfigurationAttachment
 */
export declare namespace CfnUserPoolRiskConfigurationAttachment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html
     * @external
     */
    interface NotifyConfigurationTypeProperty {
        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.BlockEmail`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-blockemail
         * @external
         */
        readonly blockEmail?: CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty | cdk.IResolvable;
        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.From`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-from
         * @external
         */
        readonly from?: string;
        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.MfaEmail`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-mfaemail
         * @external
         */
        readonly mfaEmail?: CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty | cdk.IResolvable;
        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.NoActionEmail`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-noactionemail
         * @external
         */
        readonly noActionEmail?: CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty | cdk.IResolvable;
        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.ReplyTo`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-replyto
         * @external
         */
        readonly replyTo?: string;
        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.SourceArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-sourcearn
         * @external
         */
        readonly sourceArn: string;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolRiskConfigurationAttachment
 */
export declare namespace CfnUserPoolRiskConfigurationAttachment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html
     * @external
     */
    interface NotifyEmailTypeProperty {
        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty.HtmlBody`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyemailtype-htmlbody
         * @external
         */
        readonly htmlBody?: string;
        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty.Subject`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyemailtype-subject
         * @external
         */
        readonly subject: string;
        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty.TextBody`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyemailtype-textbody
         * @external
         */
        readonly textBody?: string;
    }
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolRiskConfigurationAttachment
 */
export declare namespace CfnUserPoolRiskConfigurationAttachment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype.html
     * @external
     */
    interface RiskExceptionConfigurationTypeProperty {
        /**
         * `CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty.BlockedIPRangeList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype-blockediprangelist
         * @external
         */
        readonly blockedIpRangeList?: string[];
        /**
         * `CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty.SkippedIPRangeList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype-skippediprangelist
         * @external
         */
        readonly skippedIpRangeList?: string[];
    }
}
/**
 * Properties for defining a `AWS::Cognito::UserPoolUICustomizationAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluicustomizationattachment.html
 * @external
 */
export interface CfnUserPoolUICustomizationAttachmentProps {
    /**
     * `AWS::Cognito::UserPoolUICustomizationAttachment.ClientId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluicustomizationattachment.html#cfn-cognito-userpooluicustomizationattachment-clientid
     * @external
     */
    readonly clientId: string;
    /**
     * `AWS::Cognito::UserPoolUICustomizationAttachment.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluicustomizationattachment.html#cfn-cognito-userpooluicustomizationattachment-userpoolid
     * @external
     */
    readonly userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolUICustomizationAttachment.CSS`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluicustomizationattachment.html#cfn-cognito-userpooluicustomizationattachment-css
     * @external
     */
    readonly css?: string;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolUICustomizationAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluicustomizationattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolUICustomizationAttachment
 */
export declare class CfnUserPoolUICustomizationAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolUICustomizationAttachment";
    /**
     * `AWS::Cognito::UserPoolUICustomizationAttachment.ClientId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluicustomizationattachment.html#cfn-cognito-userpooluicustomizationattachment-clientid
     * @external
     */
    clientId: string;
    /**
     * `AWS::Cognito::UserPoolUICustomizationAttachment.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluicustomizationattachment.html#cfn-cognito-userpooluicustomizationattachment-userpoolid
     * @external
     */
    userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolUICustomizationAttachment.CSS`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluicustomizationattachment.html#cfn-cognito-userpooluicustomizationattachment-css
     * @external
     */
    css: string | undefined;
    /**
     * Create a new `AWS::Cognito::UserPoolUICustomizationAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserPoolUICustomizationAttachmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Cognito::UserPoolUser`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html
 * @external
 */
export interface CfnUserPoolUserProps {
    /**
     * `AWS::Cognito::UserPoolUser.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-userpoolid
     * @external
     */
    readonly userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolUser.ClientMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-clientmetadata
     * @external
     */
    readonly clientMetadata?: any | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPoolUser.DesiredDeliveryMediums`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-desireddeliverymediums
     * @external
     */
    readonly desiredDeliveryMediums?: string[];
    /**
     * `AWS::Cognito::UserPoolUser.ForceAliasCreation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-forcealiascreation
     * @external
     */
    readonly forceAliasCreation?: boolean | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPoolUser.MessageAction`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-messageaction
     * @external
     */
    readonly messageAction?: string;
    /**
     * `AWS::Cognito::UserPoolUser.UserAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-userattributes
     * @external
     */
    readonly userAttributes?: Array<CfnUserPoolUser.AttributeTypeProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Cognito::UserPoolUser.Username`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-username
     * @external
     */
    readonly username?: string;
    /**
     * `AWS::Cognito::UserPoolUser.ValidationData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-validationdata
     * @external
     */
    readonly validationData?: Array<CfnUserPoolUser.AttributeTypeProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolUser`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolUser
 */
export declare class CfnUserPoolUser extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolUser";
    /**
     * `AWS::Cognito::UserPoolUser.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-userpoolid
     * @external
     */
    userPoolId: string;
    /**
     * `AWS::Cognito::UserPoolUser.ClientMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-clientmetadata
     * @external
     */
    clientMetadata: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPoolUser.DesiredDeliveryMediums`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-desireddeliverymediums
     * @external
     */
    desiredDeliveryMediums: string[] | undefined;
    /**
     * `AWS::Cognito::UserPoolUser.ForceAliasCreation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-forcealiascreation
     * @external
     */
    forceAliasCreation: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPoolUser.MessageAction`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-messageaction
     * @external
     */
    messageAction: string | undefined;
    /**
     * `AWS::Cognito::UserPoolUser.UserAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-userattributes
     * @external
     */
    userAttributes: Array<CfnUserPoolUser.AttributeTypeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Cognito::UserPoolUser.Username`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-username
     * @external
     */
    username: string | undefined;
    /**
     * `AWS::Cognito::UserPoolUser.ValidationData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html#cfn-cognito-userpooluser-validationdata
     * @external
     */
    validationData: Array<CfnUserPoolUser.AttributeTypeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Cognito::UserPoolUser`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserPoolUserProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolUser`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolUser
 */
export declare namespace CfnUserPoolUser {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpooluser-attributetype.html
     * @external
     */
    interface AttributeTypeProperty {
        /**
         * `CfnUserPoolUser.AttributeTypeProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpooluser-attributetype.html#cfn-cognito-userpooluser-attributetype-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnUserPoolUser.AttributeTypeProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpooluser-attributetype.html#cfn-cognito-userpooluser-attributetype-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * Properties for defining a `AWS::Cognito::UserPoolUserToGroupAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolusertogroupattachment.html
 * @external
 */
export interface CfnUserPoolUserToGroupAttachmentProps {
    /**
     * `AWS::Cognito::UserPoolUserToGroupAttachment.GroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolusertogroupattachment.html#cfn-cognito-userpoolusertogroupattachment-groupname
     * @external
     */
    readonly groupName: string;
    /**
     * `AWS::Cognito::UserPoolUserToGroupAttachment.Username`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolusertogroupattachment.html#cfn-cognito-userpoolusertogroupattachment-username
     * @external
     */
    readonly username: string;
    /**
     * `AWS::Cognito::UserPoolUserToGroupAttachment.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolusertogroupattachment.html#cfn-cognito-userpoolusertogroupattachment-userpoolid
     * @external
     */
    readonly userPoolId: string;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolUserToGroupAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolusertogroupattachment.html
 * @external
 * @cloudformationResource AWS::Cognito::UserPoolUserToGroupAttachment
 */
export declare class CfnUserPoolUserToGroupAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolUserToGroupAttachment";
    /**
     * `AWS::Cognito::UserPoolUserToGroupAttachment.GroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolusertogroupattachment.html#cfn-cognito-userpoolusertogroupattachment-groupname
     * @external
     */
    groupName: string;
    /**
     * `AWS::Cognito::UserPoolUserToGroupAttachment.Username`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolusertogroupattachment.html#cfn-cognito-userpoolusertogroupattachment-username
     * @external
     */
    username: string;
    /**
     * `AWS::Cognito::UserPoolUserToGroupAttachment.UserPoolId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolusertogroupattachment.html#cfn-cognito-userpoolusertogroupattachment-userpoolid
     * @external
     */
    userPoolId: string;
    /**
     * Create a new `AWS::Cognito::UserPoolUserToGroupAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserPoolUserToGroupAttachmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
