# coding: utf-8

"""
    UBIKA WAAP Gateway and Cloud API

    The UBIKA's WAAP management API provides a REST/JSON programming interface. It allows automation and scripting of WAAP administration tasks, such as management of reverse proxies and tunnels. The API documentation is shipped with the product itself. Once the product installed, you can access the documentation on the following URL https://ManagementWAAP:3001/api/v1/doc/  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ubika_waap_api_client.configuration import Configuration


class PatchTunnelLogsRealtime(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'security': 'bool',
        'security_format': 'str',
        'wam_format': 'str',
        'wam': 'bool',
        'error': 'bool',
        'access': 'bool',
        'access_log_database': 'bool',
        'syslog_destination_profiles': 'list[PatchTunnelSyslogDestinationProfilesArray]'
    }

    attribute_map = {
        'security': 'security',
        'security_format': 'securityFormat',
        'wam_format': 'wamFormat',
        'wam': 'wam',
        'error': 'error',
        'access': 'access',
        'access_log_database': 'accessLogDatabase',
        'syslog_destination_profiles': 'syslogDestinationProfiles'
    }

    def __init__(self, security=None, security_format=None, wam_format=None, wam=None, error=None, access=None, access_log_database=None, syslog_destination_profiles=None, local_vars_configuration=None):  # noqa: E501
        """PatchTunnelLogsRealtime - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._security = None
        self._security_format = None
        self._wam_format = None
        self._wam = None
        self._error = None
        self._access = None
        self._access_log_database = None
        self._syslog_destination_profiles = None
        self.discriminator = None

        if security is not None:
            self.security = security
        if security_format is not None:
            self.security_format = security_format
        if wam_format is not None:
            self.wam_format = wam_format
        if wam is not None:
            self.wam = wam
        if error is not None:
            self.error = error
        if access is not None:
            self.access = access
        if access_log_database is not None:
            self.access_log_database = access_log_database
        if syslog_destination_profiles is not None:
            self.syslog_destination_profiles = syslog_destination_profiles

    @property
    def security(self):
        """Gets the security of this PatchTunnelLogsRealtime.  # noqa: E501


        :return: The security of this PatchTunnelLogsRealtime.  # noqa: E501
        :rtype: bool
        """
        return self._security

    @security.setter
    def security(self, security):
        """Sets the security of this PatchTunnelLogsRealtime.


        :param security: The security of this PatchTunnelLogsRealtime.  # noqa: E501
        :type: bool
        """

        self._security = security

    @property
    def security_format(self):
        """Gets the security_format of this PatchTunnelLogsRealtime.  # noqa: E501


        :return: The security_format of this PatchTunnelLogsRealtime.  # noqa: E501
        :rtype: str
        """
        return self._security_format

    @security_format.setter
    def security_format(self, security_format):
        """Sets the security_format of this PatchTunnelLogsRealtime.


        :param security_format: The security_format of this PatchTunnelLogsRealtime.  # noqa: E501
        :type: str
        """

        self._security_format = security_format

    @property
    def wam_format(self):
        """Gets the wam_format of this PatchTunnelLogsRealtime.  # noqa: E501


        :return: The wam_format of this PatchTunnelLogsRealtime.  # noqa: E501
        :rtype: str
        """
        return self._wam_format

    @wam_format.setter
    def wam_format(self, wam_format):
        """Sets the wam_format of this PatchTunnelLogsRealtime.


        :param wam_format: The wam_format of this PatchTunnelLogsRealtime.  # noqa: E501
        :type: str
        """

        self._wam_format = wam_format

    @property
    def wam(self):
        """Gets the wam of this PatchTunnelLogsRealtime.  # noqa: E501


        :return: The wam of this PatchTunnelLogsRealtime.  # noqa: E501
        :rtype: bool
        """
        return self._wam

    @wam.setter
    def wam(self, wam):
        """Sets the wam of this PatchTunnelLogsRealtime.


        :param wam: The wam of this PatchTunnelLogsRealtime.  # noqa: E501
        :type: bool
        """

        self._wam = wam

    @property
    def error(self):
        """Gets the error of this PatchTunnelLogsRealtime.  # noqa: E501


        :return: The error of this PatchTunnelLogsRealtime.  # noqa: E501
        :rtype: bool
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this PatchTunnelLogsRealtime.


        :param error: The error of this PatchTunnelLogsRealtime.  # noqa: E501
        :type: bool
        """

        self._error = error

    @property
    def access(self):
        """Gets the access of this PatchTunnelLogsRealtime.  # noqa: E501


        :return: The access of this PatchTunnelLogsRealtime.  # noqa: E501
        :rtype: bool
        """
        return self._access

    @access.setter
    def access(self, access):
        """Sets the access of this PatchTunnelLogsRealtime.


        :param access: The access of this PatchTunnelLogsRealtime.  # noqa: E501
        :type: bool
        """

        self._access = access

    @property
    def access_log_database(self):
        """Gets the access_log_database of this PatchTunnelLogsRealtime.  # noqa: E501


        :return: The access_log_database of this PatchTunnelLogsRealtime.  # noqa: E501
        :rtype: bool
        """
        return self._access_log_database

    @access_log_database.setter
    def access_log_database(self, access_log_database):
        """Sets the access_log_database of this PatchTunnelLogsRealtime.


        :param access_log_database: The access_log_database of this PatchTunnelLogsRealtime.  # noqa: E501
        :type: bool
        """

        self._access_log_database = access_log_database

    @property
    def syslog_destination_profiles(self):
        """Gets the syslog_destination_profiles of this PatchTunnelLogsRealtime.  # noqa: E501


        :return: The syslog_destination_profiles of this PatchTunnelLogsRealtime.  # noqa: E501
        :rtype: list[PatchTunnelSyslogDestinationProfilesArray]
        """
        return self._syslog_destination_profiles

    @syslog_destination_profiles.setter
    def syslog_destination_profiles(self, syslog_destination_profiles):
        """Sets the syslog_destination_profiles of this PatchTunnelLogsRealtime.


        :param syslog_destination_profiles: The syslog_destination_profiles of this PatchTunnelLogsRealtime.  # noqa: E501
        :type: list[PatchTunnelSyslogDestinationProfilesArray]
        """

        self._syslog_destination_profiles = syslog_destination_profiles

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PatchTunnelLogsRealtime):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PatchTunnelLogsRealtime):
            return True

        return self.to_dict() != other.to_dict()
