# coding: utf-8

"""
    UBIKA WAAP Gateway and Cloud API

    The UBIKA's WAAP management API provides a REST/JSON programming interface. It allows automation and scripting of WAAP administration tasks, such as management of reverse proxies and tunnels. The API documentation is shipped with the product itself. Once the product installed, you can access the documentation on the following URL https://ManagementWAAP:3001/api/v1/doc/  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ubika_waap_api_client.configuration import Configuration


class PatchTunnel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'reverse_proxy': 'ApplySSLKeyUid',
        'workflow': 'CreateApplianceSysctlProfile',
        'workflow_parameters': 'list[object]',
        'application_template': 'str',
        'enabled': 'bool',
        'labels': 'list[PatchTunnelLabelsArray]',
        'network': 'PatchTunnelNetwork',
        'network_incoming_server_alias': 'list[object]',
        'performance': 'CreateTunnelPerformance',
        'logs': 'PatchTunnelLogs',
        'logs_realtime_syslog_destination_profiles': 'list[PatchTunnelSyslogDestinationProfilesArray]',
        'monitor': 'CreateTunnelMonitor',
        'advanced': 'CreateTunnelAdvanced'
    }

    attribute_map = {
        'name': 'name',
        'reverse_proxy': 'reverseProxy',
        'workflow': 'workflow',
        'workflow_parameters': 'workflowParameters',
        'application_template': 'applicationTemplate',
        'enabled': 'enabled',
        'labels': 'labels',
        'network': 'network',
        'network_incoming_server_alias': 'network.incoming.serverAlias',
        'performance': 'performance',
        'logs': 'logs',
        'logs_realtime_syslog_destination_profiles': 'logs.realtime.syslogDestinationProfiles',
        'monitor': 'monitor',
        'advanced': 'advanced'
    }

    def __init__(self, name=None, reverse_proxy=None, workflow=None, workflow_parameters=None, application_template=None, enabled=None, labels=None, network=None, network_incoming_server_alias=None, performance=None, logs=None, logs_realtime_syslog_destination_profiles=None, monitor=None, advanced=None, local_vars_configuration=None):  # noqa: E501
        """PatchTunnel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._reverse_proxy = None
        self._workflow = None
        self._workflow_parameters = None
        self._application_template = None
        self._enabled = None
        self._labels = None
        self._network = None
        self._network_incoming_server_alias = None
        self._performance = None
        self._logs = None
        self._logs_realtime_syslog_destination_profiles = None
        self._monitor = None
        self._advanced = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if reverse_proxy is not None:
            self.reverse_proxy = reverse_proxy
        if workflow is not None:
            self.workflow = workflow
        if workflow_parameters is not None:
            self.workflow_parameters = workflow_parameters
        if application_template is not None:
            self.application_template = application_template
        if enabled is not None:
            self.enabled = enabled
        if labels is not None:
            self.labels = labels
        if network is not None:
            self.network = network
        if network_incoming_server_alias is not None:
            self.network_incoming_server_alias = network_incoming_server_alias
        if performance is not None:
            self.performance = performance
        if logs is not None:
            self.logs = logs
        if logs_realtime_syslog_destination_profiles is not None:
            self.logs_realtime_syslog_destination_profiles = logs_realtime_syslog_destination_profiles
        if monitor is not None:
            self.monitor = monitor
        if advanced is not None:
            self.advanced = advanced

    @property
    def name(self):
        """Gets the name of this PatchTunnel.  # noqa: E501


        :return: The name of this PatchTunnel.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PatchTunnel.


        :param name: The name of this PatchTunnel.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def reverse_proxy(self):
        """Gets the reverse_proxy of this PatchTunnel.  # noqa: E501


        :return: The reverse_proxy of this PatchTunnel.  # noqa: E501
        :rtype: ApplySSLKeyUid
        """
        return self._reverse_proxy

    @reverse_proxy.setter
    def reverse_proxy(self, reverse_proxy):
        """Sets the reverse_proxy of this PatchTunnel.


        :param reverse_proxy: The reverse_proxy of this PatchTunnel.  # noqa: E501
        :type: ApplySSLKeyUid
        """

        self._reverse_proxy = reverse_proxy

    @property
    def workflow(self):
        """Gets the workflow of this PatchTunnel.  # noqa: E501


        :return: The workflow of this PatchTunnel.  # noqa: E501
        :rtype: CreateApplianceSysctlProfile
        """
        return self._workflow

    @workflow.setter
    def workflow(self, workflow):
        """Sets the workflow of this PatchTunnel.


        :param workflow: The workflow of this PatchTunnel.  # noqa: E501
        :type: CreateApplianceSysctlProfile
        """

        self._workflow = workflow

    @property
    def workflow_parameters(self):
        """Gets the workflow_parameters of this PatchTunnel.  # noqa: E501


        :return: The workflow_parameters of this PatchTunnel.  # noqa: E501
        :rtype: list[object]
        """
        return self._workflow_parameters

    @workflow_parameters.setter
    def workflow_parameters(self, workflow_parameters):
        """Sets the workflow_parameters of this PatchTunnel.


        :param workflow_parameters: The workflow_parameters of this PatchTunnel.  # noqa: E501
        :type: list[object]
        """

        self._workflow_parameters = workflow_parameters

    @property
    def application_template(self):
        """Gets the application_template of this PatchTunnel.  # noqa: E501


        :return: The application_template of this PatchTunnel.  # noqa: E501
        :rtype: str
        """
        return self._application_template

    @application_template.setter
    def application_template(self, application_template):
        """Sets the application_template of this PatchTunnel.


        :param application_template: The application_template of this PatchTunnel.  # noqa: E501
        :type: str
        """

        self._application_template = application_template

    @property
    def enabled(self):
        """Gets the enabled of this PatchTunnel.  # noqa: E501


        :return: The enabled of this PatchTunnel.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this PatchTunnel.


        :param enabled: The enabled of this PatchTunnel.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def labels(self):
        """Gets the labels of this PatchTunnel.  # noqa: E501


        :return: The labels of this PatchTunnel.  # noqa: E501
        :rtype: list[PatchTunnelLabelsArray]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this PatchTunnel.


        :param labels: The labels of this PatchTunnel.  # noqa: E501
        :type: list[PatchTunnelLabelsArray]
        """

        self._labels = labels

    @property
    def network(self):
        """Gets the network of this PatchTunnel.  # noqa: E501


        :return: The network of this PatchTunnel.  # noqa: E501
        :rtype: PatchTunnelNetwork
        """
        return self._network

    @network.setter
    def network(self, network):
        """Sets the network of this PatchTunnel.


        :param network: The network of this PatchTunnel.  # noqa: E501
        :type: PatchTunnelNetwork
        """

        self._network = network

    @property
    def network_incoming_server_alias(self):
        """Gets the network_incoming_server_alias of this PatchTunnel.  # noqa: E501


        :return: The network_incoming_server_alias of this PatchTunnel.  # noqa: E501
        :rtype: list[object]
        """
        return self._network_incoming_server_alias

    @network_incoming_server_alias.setter
    def network_incoming_server_alias(self, network_incoming_server_alias):
        """Sets the network_incoming_server_alias of this PatchTunnel.


        :param network_incoming_server_alias: The network_incoming_server_alias of this PatchTunnel.  # noqa: E501
        :type: list[object]
        """

        self._network_incoming_server_alias = network_incoming_server_alias

    @property
    def performance(self):
        """Gets the performance of this PatchTunnel.  # noqa: E501


        :return: The performance of this PatchTunnel.  # noqa: E501
        :rtype: CreateTunnelPerformance
        """
        return self._performance

    @performance.setter
    def performance(self, performance):
        """Sets the performance of this PatchTunnel.


        :param performance: The performance of this PatchTunnel.  # noqa: E501
        :type: CreateTunnelPerformance
        """

        self._performance = performance

    @property
    def logs(self):
        """Gets the logs of this PatchTunnel.  # noqa: E501


        :return: The logs of this PatchTunnel.  # noqa: E501
        :rtype: PatchTunnelLogs
        """
        return self._logs

    @logs.setter
    def logs(self, logs):
        """Sets the logs of this PatchTunnel.


        :param logs: The logs of this PatchTunnel.  # noqa: E501
        :type: PatchTunnelLogs
        """

        self._logs = logs

    @property
    def logs_realtime_syslog_destination_profiles(self):
        """Gets the logs_realtime_syslog_destination_profiles of this PatchTunnel.  # noqa: E501


        :return: The logs_realtime_syslog_destination_profiles of this PatchTunnel.  # noqa: E501
        :rtype: list[PatchTunnelSyslogDestinationProfilesArray]
        """
        return self._logs_realtime_syslog_destination_profiles

    @logs_realtime_syslog_destination_profiles.setter
    def logs_realtime_syslog_destination_profiles(self, logs_realtime_syslog_destination_profiles):
        """Sets the logs_realtime_syslog_destination_profiles of this PatchTunnel.


        :param logs_realtime_syslog_destination_profiles: The logs_realtime_syslog_destination_profiles of this PatchTunnel.  # noqa: E501
        :type: list[PatchTunnelSyslogDestinationProfilesArray]
        """

        self._logs_realtime_syslog_destination_profiles = logs_realtime_syslog_destination_profiles

    @property
    def monitor(self):
        """Gets the monitor of this PatchTunnel.  # noqa: E501


        :return: The monitor of this PatchTunnel.  # noqa: E501
        :rtype: CreateTunnelMonitor
        """
        return self._monitor

    @monitor.setter
    def monitor(self, monitor):
        """Sets the monitor of this PatchTunnel.


        :param monitor: The monitor of this PatchTunnel.  # noqa: E501
        :type: CreateTunnelMonitor
        """

        self._monitor = monitor

    @property
    def advanced(self):
        """Gets the advanced of this PatchTunnel.  # noqa: E501


        :return: The advanced of this PatchTunnel.  # noqa: E501
        :rtype: CreateTunnelAdvanced
        """
        return self._advanced

    @advanced.setter
    def advanced(self, advanced):
        """Sets the advanced of this PatchTunnel.


        :param advanced: The advanced of this PatchTunnel.  # noqa: E501
        :type: CreateTunnelAdvanced
        """

        self._advanced = advanced

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PatchTunnel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PatchTunnel):
            return True

        return self.to_dict() != other.to_dict()
