# coding: utf-8

"""
    UBIKA WAAP Gateway and Cloud API

    The UBIKA's WAAP management API provides a REST/JSON programming interface. It allows automation and scripting of WAAP administration tasks, such as management of reverse proxies and tunnels. The API documentation is shipped with the product itself. Once the product installed, you can access the documentation on the following URL https://ManagementWAAP:3001/api/v1/doc/  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ubika_waap_api_client.configuration import Configuration


class PatchSysctlprofile(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'kernel_shm_max': 'int',
        'net_ipv4_conf_all_rp_filter': 'int',
        'net_core_optmem_max': 'int',
        'net_ipv4_tcp_ecn': 'int',
        'net_ipv4_tcp_congestion_control': 'str',
        'net_ipv4_tcp_fack': 'int',
        'net_ipv4_tcp_sack': 'int',
        'net_ipv4_tcp_dsack': 'int',
        'net_ipv4_tcp_timestamps': 'int',
        'net_ipv4_tcp_windows_scaling': 'int',
        'net_ipv4_tcp_adv_win_scale': 'int',
        'net_ipv4_tcp_workaround_signed_windows': 'int',
        'net_ipv4_tcp_syncookies': 'int',
        'net_ipv4_tcp_fin_timeout': 'int',
        'net_ipv4_tcp_keepalive_time': 'int',
        'net_ipv4_tcp_keepalive_intvl': 'int',
        'net_ipv4_tcp_keepalive_probes': 'int',
        'net_ipv4_tcp_tw_reuse': 'int',
        'net_ipv4_tcp_max_tw_buckets': 'int',
        'net_ipv4_tcp_max_orphans': 'int',
        'net_ipv4_tcp_max_syn_backlog': 'int',
        'net_core_netdev_max_backlog': 'int',
        'net_ipv4_tcp_moderate_rcvbuf': 'int',
        'net_ipv4_tcp_rmem_min': 'int',
        'net_ipv4_tcp_rmem_default': 'int',
        'net_ipv4_tcp_rmem_max': 'int',
        'net_ipv4_tcp_wmem_min': 'int',
        'net_ipv4_tcp_wmem_default': 'int',
        'net_ipv4_tcp_wmem_max': 'int',
        'net_core_rmem_default': 'int',
        'net_core_wmem_default': 'int',
        'net_core_somaxconn': 'int',
        'net_ipv4_tcp_abort_on_overflow': 'int',
        'net_ipv4_tcp_syn_retries': 'int',
        'net_ipv4_tcp_syn_ack_retries': 'int',
        'net_ipv4_tcp_tw_recycle': 'int',
        'net_ipv4_tcp_rfc1337': 'int'
    }

    attribute_map = {
        'name': 'name',
        'kernel_shm_max': 'kernelShmMax',
        'net_ipv4_conf_all_rp_filter': 'netIpv4ConfAllRpFilter',
        'net_core_optmem_max': 'netCoreOptmemMax',
        'net_ipv4_tcp_ecn': 'netIpv4TcpEcn',
        'net_ipv4_tcp_congestion_control': 'netIpv4TcpCongestionControl',
        'net_ipv4_tcp_fack': 'netIpv4TcpFack',
        'net_ipv4_tcp_sack': 'netIpv4TcpSack',
        'net_ipv4_tcp_dsack': 'netIpv4TcpDsack',
        'net_ipv4_tcp_timestamps': 'netIpv4TcpTimestamps',
        'net_ipv4_tcp_windows_scaling': 'netIpv4TcpWindowsScaling',
        'net_ipv4_tcp_adv_win_scale': 'netIpv4TcpAdvWinScale',
        'net_ipv4_tcp_workaround_signed_windows': 'netIpv4TcpWorkaroundSignedWindows',
        'net_ipv4_tcp_syncookies': 'netIpv4TcpSyncookies',
        'net_ipv4_tcp_fin_timeout': 'netIpv4TcpFinTimeout',
        'net_ipv4_tcp_keepalive_time': 'netIpv4TcpKeepaliveTime',
        'net_ipv4_tcp_keepalive_intvl': 'netIpv4TcpKeepaliveIntvl',
        'net_ipv4_tcp_keepalive_probes': 'netIpv4TcpKeepaliveProbes',
        'net_ipv4_tcp_tw_reuse': 'netIpv4TcpTwReuse',
        'net_ipv4_tcp_max_tw_buckets': 'netIpv4TcpMaxTwBuckets',
        'net_ipv4_tcp_max_orphans': 'netIpv4TcpMaxOrphans',
        'net_ipv4_tcp_max_syn_backlog': 'netIpv4TcpMaxSynBacklog',
        'net_core_netdev_max_backlog': 'netCoreNetdevMaxBacklog',
        'net_ipv4_tcp_moderate_rcvbuf': 'netIpv4TcpModerateRcvbuf',
        'net_ipv4_tcp_rmem_min': 'netIpv4TcpRmemMin',
        'net_ipv4_tcp_rmem_default': 'netIpv4TcpRmemDefault',
        'net_ipv4_tcp_rmem_max': 'netIpv4TcpRmemMax',
        'net_ipv4_tcp_wmem_min': 'netIpv4TcpWmemMin',
        'net_ipv4_tcp_wmem_default': 'netIpv4TcpWmemDefault',
        'net_ipv4_tcp_wmem_max': 'netIpv4TcpWmemMax',
        'net_core_rmem_default': 'netCoreRmemDefault',
        'net_core_wmem_default': 'netCoreWmemDefault',
        'net_core_somaxconn': 'netCoreSomaxconn',
        'net_ipv4_tcp_abort_on_overflow': 'netIpv4TcpAbortOnOverflow',
        'net_ipv4_tcp_syn_retries': 'netIpv4TcpSynRetries',
        'net_ipv4_tcp_syn_ack_retries': 'netIpv4TcpSynAckRetries',
        'net_ipv4_tcp_tw_recycle': 'netIpv4TcpTwRecycle',
        'net_ipv4_tcp_rfc1337': 'netIpv4TcpRfc1337'
    }

    def __init__(self, name=None, kernel_shm_max=None, net_ipv4_conf_all_rp_filter=None, net_core_optmem_max=None, net_ipv4_tcp_ecn=None, net_ipv4_tcp_congestion_control=None, net_ipv4_tcp_fack=None, net_ipv4_tcp_sack=None, net_ipv4_tcp_dsack=None, net_ipv4_tcp_timestamps=None, net_ipv4_tcp_windows_scaling=None, net_ipv4_tcp_adv_win_scale=None, net_ipv4_tcp_workaround_signed_windows=None, net_ipv4_tcp_syncookies=None, net_ipv4_tcp_fin_timeout=None, net_ipv4_tcp_keepalive_time=None, net_ipv4_tcp_keepalive_intvl=None, net_ipv4_tcp_keepalive_probes=None, net_ipv4_tcp_tw_reuse=None, net_ipv4_tcp_max_tw_buckets=None, net_ipv4_tcp_max_orphans=None, net_ipv4_tcp_max_syn_backlog=None, net_core_netdev_max_backlog=None, net_ipv4_tcp_moderate_rcvbuf=None, net_ipv4_tcp_rmem_min=None, net_ipv4_tcp_rmem_default=None, net_ipv4_tcp_rmem_max=None, net_ipv4_tcp_wmem_min=None, net_ipv4_tcp_wmem_default=None, net_ipv4_tcp_wmem_max=None, net_core_rmem_default=None, net_core_wmem_default=None, net_core_somaxconn=None, net_ipv4_tcp_abort_on_overflow=None, net_ipv4_tcp_syn_retries=None, net_ipv4_tcp_syn_ack_retries=None, net_ipv4_tcp_tw_recycle=None, net_ipv4_tcp_rfc1337=None, local_vars_configuration=None):  # noqa: E501
        """PatchSysctlprofile - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._kernel_shm_max = None
        self._net_ipv4_conf_all_rp_filter = None
        self._net_core_optmem_max = None
        self._net_ipv4_tcp_ecn = None
        self._net_ipv4_tcp_congestion_control = None
        self._net_ipv4_tcp_fack = None
        self._net_ipv4_tcp_sack = None
        self._net_ipv4_tcp_dsack = None
        self._net_ipv4_tcp_timestamps = None
        self._net_ipv4_tcp_windows_scaling = None
        self._net_ipv4_tcp_adv_win_scale = None
        self._net_ipv4_tcp_workaround_signed_windows = None
        self._net_ipv4_tcp_syncookies = None
        self._net_ipv4_tcp_fin_timeout = None
        self._net_ipv4_tcp_keepalive_time = None
        self._net_ipv4_tcp_keepalive_intvl = None
        self._net_ipv4_tcp_keepalive_probes = None
        self._net_ipv4_tcp_tw_reuse = None
        self._net_ipv4_tcp_max_tw_buckets = None
        self._net_ipv4_tcp_max_orphans = None
        self._net_ipv4_tcp_max_syn_backlog = None
        self._net_core_netdev_max_backlog = None
        self._net_ipv4_tcp_moderate_rcvbuf = None
        self._net_ipv4_tcp_rmem_min = None
        self._net_ipv4_tcp_rmem_default = None
        self._net_ipv4_tcp_rmem_max = None
        self._net_ipv4_tcp_wmem_min = None
        self._net_ipv4_tcp_wmem_default = None
        self._net_ipv4_tcp_wmem_max = None
        self._net_core_rmem_default = None
        self._net_core_wmem_default = None
        self._net_core_somaxconn = None
        self._net_ipv4_tcp_abort_on_overflow = None
        self._net_ipv4_tcp_syn_retries = None
        self._net_ipv4_tcp_syn_ack_retries = None
        self._net_ipv4_tcp_tw_recycle = None
        self._net_ipv4_tcp_rfc1337 = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if kernel_shm_max is not None:
            self.kernel_shm_max = kernel_shm_max
        if net_ipv4_conf_all_rp_filter is not None:
            self.net_ipv4_conf_all_rp_filter = net_ipv4_conf_all_rp_filter
        if net_core_optmem_max is not None:
            self.net_core_optmem_max = net_core_optmem_max
        if net_ipv4_tcp_ecn is not None:
            self.net_ipv4_tcp_ecn = net_ipv4_tcp_ecn
        if net_ipv4_tcp_congestion_control is not None:
            self.net_ipv4_tcp_congestion_control = net_ipv4_tcp_congestion_control
        if net_ipv4_tcp_fack is not None:
            self.net_ipv4_tcp_fack = net_ipv4_tcp_fack
        if net_ipv4_tcp_sack is not None:
            self.net_ipv4_tcp_sack = net_ipv4_tcp_sack
        if net_ipv4_tcp_dsack is not None:
            self.net_ipv4_tcp_dsack = net_ipv4_tcp_dsack
        if net_ipv4_tcp_timestamps is not None:
            self.net_ipv4_tcp_timestamps = net_ipv4_tcp_timestamps
        if net_ipv4_tcp_windows_scaling is not None:
            self.net_ipv4_tcp_windows_scaling = net_ipv4_tcp_windows_scaling
        if net_ipv4_tcp_adv_win_scale is not None:
            self.net_ipv4_tcp_adv_win_scale = net_ipv4_tcp_adv_win_scale
        if net_ipv4_tcp_workaround_signed_windows is not None:
            self.net_ipv4_tcp_workaround_signed_windows = net_ipv4_tcp_workaround_signed_windows
        if net_ipv4_tcp_syncookies is not None:
            self.net_ipv4_tcp_syncookies = net_ipv4_tcp_syncookies
        if net_ipv4_tcp_fin_timeout is not None:
            self.net_ipv4_tcp_fin_timeout = net_ipv4_tcp_fin_timeout
        if net_ipv4_tcp_keepalive_time is not None:
            self.net_ipv4_tcp_keepalive_time = net_ipv4_tcp_keepalive_time
        if net_ipv4_tcp_keepalive_intvl is not None:
            self.net_ipv4_tcp_keepalive_intvl = net_ipv4_tcp_keepalive_intvl
        if net_ipv4_tcp_keepalive_probes is not None:
            self.net_ipv4_tcp_keepalive_probes = net_ipv4_tcp_keepalive_probes
        if net_ipv4_tcp_tw_reuse is not None:
            self.net_ipv4_tcp_tw_reuse = net_ipv4_tcp_tw_reuse
        if net_ipv4_tcp_max_tw_buckets is not None:
            self.net_ipv4_tcp_max_tw_buckets = net_ipv4_tcp_max_tw_buckets
        if net_ipv4_tcp_max_orphans is not None:
            self.net_ipv4_tcp_max_orphans = net_ipv4_tcp_max_orphans
        if net_ipv4_tcp_max_syn_backlog is not None:
            self.net_ipv4_tcp_max_syn_backlog = net_ipv4_tcp_max_syn_backlog
        if net_core_netdev_max_backlog is not None:
            self.net_core_netdev_max_backlog = net_core_netdev_max_backlog
        if net_ipv4_tcp_moderate_rcvbuf is not None:
            self.net_ipv4_tcp_moderate_rcvbuf = net_ipv4_tcp_moderate_rcvbuf
        if net_ipv4_tcp_rmem_min is not None:
            self.net_ipv4_tcp_rmem_min = net_ipv4_tcp_rmem_min
        if net_ipv4_tcp_rmem_default is not None:
            self.net_ipv4_tcp_rmem_default = net_ipv4_tcp_rmem_default
        if net_ipv4_tcp_rmem_max is not None:
            self.net_ipv4_tcp_rmem_max = net_ipv4_tcp_rmem_max
        if net_ipv4_tcp_wmem_min is not None:
            self.net_ipv4_tcp_wmem_min = net_ipv4_tcp_wmem_min
        if net_ipv4_tcp_wmem_default is not None:
            self.net_ipv4_tcp_wmem_default = net_ipv4_tcp_wmem_default
        if net_ipv4_tcp_wmem_max is not None:
            self.net_ipv4_tcp_wmem_max = net_ipv4_tcp_wmem_max
        if net_core_rmem_default is not None:
            self.net_core_rmem_default = net_core_rmem_default
        if net_core_wmem_default is not None:
            self.net_core_wmem_default = net_core_wmem_default
        if net_core_somaxconn is not None:
            self.net_core_somaxconn = net_core_somaxconn
        if net_ipv4_tcp_abort_on_overflow is not None:
            self.net_ipv4_tcp_abort_on_overflow = net_ipv4_tcp_abort_on_overflow
        if net_ipv4_tcp_syn_retries is not None:
            self.net_ipv4_tcp_syn_retries = net_ipv4_tcp_syn_retries
        if net_ipv4_tcp_syn_ack_retries is not None:
            self.net_ipv4_tcp_syn_ack_retries = net_ipv4_tcp_syn_ack_retries
        if net_ipv4_tcp_tw_recycle is not None:
            self.net_ipv4_tcp_tw_recycle = net_ipv4_tcp_tw_recycle
        if net_ipv4_tcp_rfc1337 is not None:
            self.net_ipv4_tcp_rfc1337 = net_ipv4_tcp_rfc1337

    @property
    def name(self):
        """Gets the name of this PatchSysctlprofile.  # noqa: E501


        :return: The name of this PatchSysctlprofile.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PatchSysctlprofile.


        :param name: The name of this PatchSysctlprofile.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def kernel_shm_max(self):
        """Gets the kernel_shm_max of this PatchSysctlprofile.  # noqa: E501


        :return: The kernel_shm_max of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._kernel_shm_max

    @kernel_shm_max.setter
    def kernel_shm_max(self, kernel_shm_max):
        """Sets the kernel_shm_max of this PatchSysctlprofile.


        :param kernel_shm_max: The kernel_shm_max of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._kernel_shm_max = kernel_shm_max

    @property
    def net_ipv4_conf_all_rp_filter(self):
        """Gets the net_ipv4_conf_all_rp_filter of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_conf_all_rp_filter of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_conf_all_rp_filter

    @net_ipv4_conf_all_rp_filter.setter
    def net_ipv4_conf_all_rp_filter(self, net_ipv4_conf_all_rp_filter):
        """Sets the net_ipv4_conf_all_rp_filter of this PatchSysctlprofile.


        :param net_ipv4_conf_all_rp_filter: The net_ipv4_conf_all_rp_filter of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_conf_all_rp_filter = net_ipv4_conf_all_rp_filter

    @property
    def net_core_optmem_max(self):
        """Gets the net_core_optmem_max of this PatchSysctlprofile.  # noqa: E501


        :return: The net_core_optmem_max of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_core_optmem_max

    @net_core_optmem_max.setter
    def net_core_optmem_max(self, net_core_optmem_max):
        """Sets the net_core_optmem_max of this PatchSysctlprofile.


        :param net_core_optmem_max: The net_core_optmem_max of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_core_optmem_max = net_core_optmem_max

    @property
    def net_ipv4_tcp_ecn(self):
        """Gets the net_ipv4_tcp_ecn of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_ecn of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_ecn

    @net_ipv4_tcp_ecn.setter
    def net_ipv4_tcp_ecn(self, net_ipv4_tcp_ecn):
        """Sets the net_ipv4_tcp_ecn of this PatchSysctlprofile.


        :param net_ipv4_tcp_ecn: The net_ipv4_tcp_ecn of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_ecn = net_ipv4_tcp_ecn

    @property
    def net_ipv4_tcp_congestion_control(self):
        """Gets the net_ipv4_tcp_congestion_control of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_congestion_control of this PatchSysctlprofile.  # noqa: E501
        :rtype: str
        """
        return self._net_ipv4_tcp_congestion_control

    @net_ipv4_tcp_congestion_control.setter
    def net_ipv4_tcp_congestion_control(self, net_ipv4_tcp_congestion_control):
        """Sets the net_ipv4_tcp_congestion_control of this PatchSysctlprofile.


        :param net_ipv4_tcp_congestion_control: The net_ipv4_tcp_congestion_control of this PatchSysctlprofile.  # noqa: E501
        :type: str
        """

        self._net_ipv4_tcp_congestion_control = net_ipv4_tcp_congestion_control

    @property
    def net_ipv4_tcp_fack(self):
        """Gets the net_ipv4_tcp_fack of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_fack of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_fack

    @net_ipv4_tcp_fack.setter
    def net_ipv4_tcp_fack(self, net_ipv4_tcp_fack):
        """Sets the net_ipv4_tcp_fack of this PatchSysctlprofile.


        :param net_ipv4_tcp_fack: The net_ipv4_tcp_fack of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_fack = net_ipv4_tcp_fack

    @property
    def net_ipv4_tcp_sack(self):
        """Gets the net_ipv4_tcp_sack of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_sack of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_sack

    @net_ipv4_tcp_sack.setter
    def net_ipv4_tcp_sack(self, net_ipv4_tcp_sack):
        """Sets the net_ipv4_tcp_sack of this PatchSysctlprofile.


        :param net_ipv4_tcp_sack: The net_ipv4_tcp_sack of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_sack = net_ipv4_tcp_sack

    @property
    def net_ipv4_tcp_dsack(self):
        """Gets the net_ipv4_tcp_dsack of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_dsack of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_dsack

    @net_ipv4_tcp_dsack.setter
    def net_ipv4_tcp_dsack(self, net_ipv4_tcp_dsack):
        """Sets the net_ipv4_tcp_dsack of this PatchSysctlprofile.


        :param net_ipv4_tcp_dsack: The net_ipv4_tcp_dsack of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_dsack = net_ipv4_tcp_dsack

    @property
    def net_ipv4_tcp_timestamps(self):
        """Gets the net_ipv4_tcp_timestamps of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_timestamps of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_timestamps

    @net_ipv4_tcp_timestamps.setter
    def net_ipv4_tcp_timestamps(self, net_ipv4_tcp_timestamps):
        """Sets the net_ipv4_tcp_timestamps of this PatchSysctlprofile.


        :param net_ipv4_tcp_timestamps: The net_ipv4_tcp_timestamps of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_timestamps = net_ipv4_tcp_timestamps

    @property
    def net_ipv4_tcp_windows_scaling(self):
        """Gets the net_ipv4_tcp_windows_scaling of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_windows_scaling of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_windows_scaling

    @net_ipv4_tcp_windows_scaling.setter
    def net_ipv4_tcp_windows_scaling(self, net_ipv4_tcp_windows_scaling):
        """Sets the net_ipv4_tcp_windows_scaling of this PatchSysctlprofile.


        :param net_ipv4_tcp_windows_scaling: The net_ipv4_tcp_windows_scaling of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_windows_scaling = net_ipv4_tcp_windows_scaling

    @property
    def net_ipv4_tcp_adv_win_scale(self):
        """Gets the net_ipv4_tcp_adv_win_scale of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_adv_win_scale of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_adv_win_scale

    @net_ipv4_tcp_adv_win_scale.setter
    def net_ipv4_tcp_adv_win_scale(self, net_ipv4_tcp_adv_win_scale):
        """Sets the net_ipv4_tcp_adv_win_scale of this PatchSysctlprofile.


        :param net_ipv4_tcp_adv_win_scale: The net_ipv4_tcp_adv_win_scale of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_adv_win_scale = net_ipv4_tcp_adv_win_scale

    @property
    def net_ipv4_tcp_workaround_signed_windows(self):
        """Gets the net_ipv4_tcp_workaround_signed_windows of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_workaround_signed_windows of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_workaround_signed_windows

    @net_ipv4_tcp_workaround_signed_windows.setter
    def net_ipv4_tcp_workaround_signed_windows(self, net_ipv4_tcp_workaround_signed_windows):
        """Sets the net_ipv4_tcp_workaround_signed_windows of this PatchSysctlprofile.


        :param net_ipv4_tcp_workaround_signed_windows: The net_ipv4_tcp_workaround_signed_windows of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_workaround_signed_windows = net_ipv4_tcp_workaround_signed_windows

    @property
    def net_ipv4_tcp_syncookies(self):
        """Gets the net_ipv4_tcp_syncookies of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_syncookies of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_syncookies

    @net_ipv4_tcp_syncookies.setter
    def net_ipv4_tcp_syncookies(self, net_ipv4_tcp_syncookies):
        """Sets the net_ipv4_tcp_syncookies of this PatchSysctlprofile.


        :param net_ipv4_tcp_syncookies: The net_ipv4_tcp_syncookies of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_syncookies = net_ipv4_tcp_syncookies

    @property
    def net_ipv4_tcp_fin_timeout(self):
        """Gets the net_ipv4_tcp_fin_timeout of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_fin_timeout of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_fin_timeout

    @net_ipv4_tcp_fin_timeout.setter
    def net_ipv4_tcp_fin_timeout(self, net_ipv4_tcp_fin_timeout):
        """Sets the net_ipv4_tcp_fin_timeout of this PatchSysctlprofile.


        :param net_ipv4_tcp_fin_timeout: The net_ipv4_tcp_fin_timeout of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_fin_timeout = net_ipv4_tcp_fin_timeout

    @property
    def net_ipv4_tcp_keepalive_time(self):
        """Gets the net_ipv4_tcp_keepalive_time of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_keepalive_time of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_keepalive_time

    @net_ipv4_tcp_keepalive_time.setter
    def net_ipv4_tcp_keepalive_time(self, net_ipv4_tcp_keepalive_time):
        """Sets the net_ipv4_tcp_keepalive_time of this PatchSysctlprofile.


        :param net_ipv4_tcp_keepalive_time: The net_ipv4_tcp_keepalive_time of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_keepalive_time = net_ipv4_tcp_keepalive_time

    @property
    def net_ipv4_tcp_keepalive_intvl(self):
        """Gets the net_ipv4_tcp_keepalive_intvl of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_keepalive_intvl of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_keepalive_intvl

    @net_ipv4_tcp_keepalive_intvl.setter
    def net_ipv4_tcp_keepalive_intvl(self, net_ipv4_tcp_keepalive_intvl):
        """Sets the net_ipv4_tcp_keepalive_intvl of this PatchSysctlprofile.


        :param net_ipv4_tcp_keepalive_intvl: The net_ipv4_tcp_keepalive_intvl of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_keepalive_intvl = net_ipv4_tcp_keepalive_intvl

    @property
    def net_ipv4_tcp_keepalive_probes(self):
        """Gets the net_ipv4_tcp_keepalive_probes of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_keepalive_probes of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_keepalive_probes

    @net_ipv4_tcp_keepalive_probes.setter
    def net_ipv4_tcp_keepalive_probes(self, net_ipv4_tcp_keepalive_probes):
        """Sets the net_ipv4_tcp_keepalive_probes of this PatchSysctlprofile.


        :param net_ipv4_tcp_keepalive_probes: The net_ipv4_tcp_keepalive_probes of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_keepalive_probes = net_ipv4_tcp_keepalive_probes

    @property
    def net_ipv4_tcp_tw_reuse(self):
        """Gets the net_ipv4_tcp_tw_reuse of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_tw_reuse of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_tw_reuse

    @net_ipv4_tcp_tw_reuse.setter
    def net_ipv4_tcp_tw_reuse(self, net_ipv4_tcp_tw_reuse):
        """Sets the net_ipv4_tcp_tw_reuse of this PatchSysctlprofile.


        :param net_ipv4_tcp_tw_reuse: The net_ipv4_tcp_tw_reuse of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_tw_reuse = net_ipv4_tcp_tw_reuse

    @property
    def net_ipv4_tcp_max_tw_buckets(self):
        """Gets the net_ipv4_tcp_max_tw_buckets of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_max_tw_buckets of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_max_tw_buckets

    @net_ipv4_tcp_max_tw_buckets.setter
    def net_ipv4_tcp_max_tw_buckets(self, net_ipv4_tcp_max_tw_buckets):
        """Sets the net_ipv4_tcp_max_tw_buckets of this PatchSysctlprofile.


        :param net_ipv4_tcp_max_tw_buckets: The net_ipv4_tcp_max_tw_buckets of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_max_tw_buckets = net_ipv4_tcp_max_tw_buckets

    @property
    def net_ipv4_tcp_max_orphans(self):
        """Gets the net_ipv4_tcp_max_orphans of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_max_orphans of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_max_orphans

    @net_ipv4_tcp_max_orphans.setter
    def net_ipv4_tcp_max_orphans(self, net_ipv4_tcp_max_orphans):
        """Sets the net_ipv4_tcp_max_orphans of this PatchSysctlprofile.


        :param net_ipv4_tcp_max_orphans: The net_ipv4_tcp_max_orphans of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_max_orphans = net_ipv4_tcp_max_orphans

    @property
    def net_ipv4_tcp_max_syn_backlog(self):
        """Gets the net_ipv4_tcp_max_syn_backlog of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_max_syn_backlog of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_max_syn_backlog

    @net_ipv4_tcp_max_syn_backlog.setter
    def net_ipv4_tcp_max_syn_backlog(self, net_ipv4_tcp_max_syn_backlog):
        """Sets the net_ipv4_tcp_max_syn_backlog of this PatchSysctlprofile.


        :param net_ipv4_tcp_max_syn_backlog: The net_ipv4_tcp_max_syn_backlog of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_max_syn_backlog = net_ipv4_tcp_max_syn_backlog

    @property
    def net_core_netdev_max_backlog(self):
        """Gets the net_core_netdev_max_backlog of this PatchSysctlprofile.  # noqa: E501


        :return: The net_core_netdev_max_backlog of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_core_netdev_max_backlog

    @net_core_netdev_max_backlog.setter
    def net_core_netdev_max_backlog(self, net_core_netdev_max_backlog):
        """Sets the net_core_netdev_max_backlog of this PatchSysctlprofile.


        :param net_core_netdev_max_backlog: The net_core_netdev_max_backlog of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_core_netdev_max_backlog = net_core_netdev_max_backlog

    @property
    def net_ipv4_tcp_moderate_rcvbuf(self):
        """Gets the net_ipv4_tcp_moderate_rcvbuf of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_moderate_rcvbuf of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_moderate_rcvbuf

    @net_ipv4_tcp_moderate_rcvbuf.setter
    def net_ipv4_tcp_moderate_rcvbuf(self, net_ipv4_tcp_moderate_rcvbuf):
        """Sets the net_ipv4_tcp_moderate_rcvbuf of this PatchSysctlprofile.


        :param net_ipv4_tcp_moderate_rcvbuf: The net_ipv4_tcp_moderate_rcvbuf of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_moderate_rcvbuf = net_ipv4_tcp_moderate_rcvbuf

    @property
    def net_ipv4_tcp_rmem_min(self):
        """Gets the net_ipv4_tcp_rmem_min of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_rmem_min of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_rmem_min

    @net_ipv4_tcp_rmem_min.setter
    def net_ipv4_tcp_rmem_min(self, net_ipv4_tcp_rmem_min):
        """Sets the net_ipv4_tcp_rmem_min of this PatchSysctlprofile.


        :param net_ipv4_tcp_rmem_min: The net_ipv4_tcp_rmem_min of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_rmem_min = net_ipv4_tcp_rmem_min

    @property
    def net_ipv4_tcp_rmem_default(self):
        """Gets the net_ipv4_tcp_rmem_default of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_rmem_default of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_rmem_default

    @net_ipv4_tcp_rmem_default.setter
    def net_ipv4_tcp_rmem_default(self, net_ipv4_tcp_rmem_default):
        """Sets the net_ipv4_tcp_rmem_default of this PatchSysctlprofile.


        :param net_ipv4_tcp_rmem_default: The net_ipv4_tcp_rmem_default of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_rmem_default = net_ipv4_tcp_rmem_default

    @property
    def net_ipv4_tcp_rmem_max(self):
        """Gets the net_ipv4_tcp_rmem_max of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_rmem_max of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_rmem_max

    @net_ipv4_tcp_rmem_max.setter
    def net_ipv4_tcp_rmem_max(self, net_ipv4_tcp_rmem_max):
        """Sets the net_ipv4_tcp_rmem_max of this PatchSysctlprofile.


        :param net_ipv4_tcp_rmem_max: The net_ipv4_tcp_rmem_max of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_rmem_max = net_ipv4_tcp_rmem_max

    @property
    def net_ipv4_tcp_wmem_min(self):
        """Gets the net_ipv4_tcp_wmem_min of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_wmem_min of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_wmem_min

    @net_ipv4_tcp_wmem_min.setter
    def net_ipv4_tcp_wmem_min(self, net_ipv4_tcp_wmem_min):
        """Sets the net_ipv4_tcp_wmem_min of this PatchSysctlprofile.


        :param net_ipv4_tcp_wmem_min: The net_ipv4_tcp_wmem_min of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_wmem_min = net_ipv4_tcp_wmem_min

    @property
    def net_ipv4_tcp_wmem_default(self):
        """Gets the net_ipv4_tcp_wmem_default of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_wmem_default of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_wmem_default

    @net_ipv4_tcp_wmem_default.setter
    def net_ipv4_tcp_wmem_default(self, net_ipv4_tcp_wmem_default):
        """Sets the net_ipv4_tcp_wmem_default of this PatchSysctlprofile.


        :param net_ipv4_tcp_wmem_default: The net_ipv4_tcp_wmem_default of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_wmem_default = net_ipv4_tcp_wmem_default

    @property
    def net_ipv4_tcp_wmem_max(self):
        """Gets the net_ipv4_tcp_wmem_max of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_wmem_max of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_wmem_max

    @net_ipv4_tcp_wmem_max.setter
    def net_ipv4_tcp_wmem_max(self, net_ipv4_tcp_wmem_max):
        """Sets the net_ipv4_tcp_wmem_max of this PatchSysctlprofile.


        :param net_ipv4_tcp_wmem_max: The net_ipv4_tcp_wmem_max of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_wmem_max = net_ipv4_tcp_wmem_max

    @property
    def net_core_rmem_default(self):
        """Gets the net_core_rmem_default of this PatchSysctlprofile.  # noqa: E501


        :return: The net_core_rmem_default of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_core_rmem_default

    @net_core_rmem_default.setter
    def net_core_rmem_default(self, net_core_rmem_default):
        """Sets the net_core_rmem_default of this PatchSysctlprofile.


        :param net_core_rmem_default: The net_core_rmem_default of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_core_rmem_default = net_core_rmem_default

    @property
    def net_core_wmem_default(self):
        """Gets the net_core_wmem_default of this PatchSysctlprofile.  # noqa: E501


        :return: The net_core_wmem_default of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_core_wmem_default

    @net_core_wmem_default.setter
    def net_core_wmem_default(self, net_core_wmem_default):
        """Sets the net_core_wmem_default of this PatchSysctlprofile.


        :param net_core_wmem_default: The net_core_wmem_default of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_core_wmem_default = net_core_wmem_default

    @property
    def net_core_somaxconn(self):
        """Gets the net_core_somaxconn of this PatchSysctlprofile.  # noqa: E501


        :return: The net_core_somaxconn of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_core_somaxconn

    @net_core_somaxconn.setter
    def net_core_somaxconn(self, net_core_somaxconn):
        """Sets the net_core_somaxconn of this PatchSysctlprofile.


        :param net_core_somaxconn: The net_core_somaxconn of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_core_somaxconn = net_core_somaxconn

    @property
    def net_ipv4_tcp_abort_on_overflow(self):
        """Gets the net_ipv4_tcp_abort_on_overflow of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_abort_on_overflow of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_abort_on_overflow

    @net_ipv4_tcp_abort_on_overflow.setter
    def net_ipv4_tcp_abort_on_overflow(self, net_ipv4_tcp_abort_on_overflow):
        """Sets the net_ipv4_tcp_abort_on_overflow of this PatchSysctlprofile.


        :param net_ipv4_tcp_abort_on_overflow: The net_ipv4_tcp_abort_on_overflow of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_abort_on_overflow = net_ipv4_tcp_abort_on_overflow

    @property
    def net_ipv4_tcp_syn_retries(self):
        """Gets the net_ipv4_tcp_syn_retries of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_syn_retries of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_syn_retries

    @net_ipv4_tcp_syn_retries.setter
    def net_ipv4_tcp_syn_retries(self, net_ipv4_tcp_syn_retries):
        """Sets the net_ipv4_tcp_syn_retries of this PatchSysctlprofile.


        :param net_ipv4_tcp_syn_retries: The net_ipv4_tcp_syn_retries of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_syn_retries = net_ipv4_tcp_syn_retries

    @property
    def net_ipv4_tcp_syn_ack_retries(self):
        """Gets the net_ipv4_tcp_syn_ack_retries of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_syn_ack_retries of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_syn_ack_retries

    @net_ipv4_tcp_syn_ack_retries.setter
    def net_ipv4_tcp_syn_ack_retries(self, net_ipv4_tcp_syn_ack_retries):
        """Sets the net_ipv4_tcp_syn_ack_retries of this PatchSysctlprofile.


        :param net_ipv4_tcp_syn_ack_retries: The net_ipv4_tcp_syn_ack_retries of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_syn_ack_retries = net_ipv4_tcp_syn_ack_retries

    @property
    def net_ipv4_tcp_tw_recycle(self):
        """Gets the net_ipv4_tcp_tw_recycle of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_tw_recycle of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_tw_recycle

    @net_ipv4_tcp_tw_recycle.setter
    def net_ipv4_tcp_tw_recycle(self, net_ipv4_tcp_tw_recycle):
        """Sets the net_ipv4_tcp_tw_recycle of this PatchSysctlprofile.


        :param net_ipv4_tcp_tw_recycle: The net_ipv4_tcp_tw_recycle of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_tw_recycle = net_ipv4_tcp_tw_recycle

    @property
    def net_ipv4_tcp_rfc1337(self):
        """Gets the net_ipv4_tcp_rfc1337 of this PatchSysctlprofile.  # noqa: E501


        :return: The net_ipv4_tcp_rfc1337 of this PatchSysctlprofile.  # noqa: E501
        :rtype: int
        """
        return self._net_ipv4_tcp_rfc1337

    @net_ipv4_tcp_rfc1337.setter
    def net_ipv4_tcp_rfc1337(self, net_ipv4_tcp_rfc1337):
        """Sets the net_ipv4_tcp_rfc1337 of this PatchSysctlprofile.


        :param net_ipv4_tcp_rfc1337: The net_ipv4_tcp_rfc1337 of this PatchSysctlprofile.  # noqa: E501
        :type: int
        """

        self._net_ipv4_tcp_rfc1337 = net_ipv4_tcp_rfc1337

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PatchSysctlprofile):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PatchSysctlprofile):
            return True

        return self.to_dict() != other.to_dict()
