# coding: utf-8

"""
    UBIKA WAAP Gateway and Cloud API

    The UBIKA's WAAP management API provides a REST/JSON programming interface. It allows automation and scripting of WAAP administration tasks, such as management of reverse proxies and tunnels. The API documentation is shipped with the product itself. Once the product installed, you can access the documentation on the following URL https://ManagementWAAP:3001/api/v1/doc/  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ubika_waap_api_client.configuration import Configuration


class PatchApplianceSuccess(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'data': 'PatchApplianceSuccessData',
        'data_ssh_interfaces': 'list[PatchApplianceInterfacesSuccessArray]',
        'data_snmp_interfaces': 'list[PatchApplianceInterfacesSuccessArray]',
        'data_network_devices': 'list[PatchApplianceNetworkDevicesSuccessArray]'
    }

    attribute_map = {
        'data': 'data',
        'data_ssh_interfaces': 'data.ssh.interfaces',
        'data_snmp_interfaces': 'data.snmp.interfaces',
        'data_network_devices': 'data.networkDevices'
    }

    def __init__(self, data=None, data_ssh_interfaces=None, data_snmp_interfaces=None, data_network_devices=None, local_vars_configuration=None):  # noqa: E501
        """PatchApplianceSuccess - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._data = None
        self._data_ssh_interfaces = None
        self._data_snmp_interfaces = None
        self._data_network_devices = None
        self.discriminator = None

        if data is not None:
            self.data = data
        if data_ssh_interfaces is not None:
            self.data_ssh_interfaces = data_ssh_interfaces
        if data_snmp_interfaces is not None:
            self.data_snmp_interfaces = data_snmp_interfaces
        if data_network_devices is not None:
            self.data_network_devices = data_network_devices

    @property
    def data(self):
        """Gets the data of this PatchApplianceSuccess.  # noqa: E501


        :return: The data of this PatchApplianceSuccess.  # noqa: E501
        :rtype: PatchApplianceSuccessData
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this PatchApplianceSuccess.


        :param data: The data of this PatchApplianceSuccess.  # noqa: E501
        :type: PatchApplianceSuccessData
        """

        self._data = data

    @property
    def data_ssh_interfaces(self):
        """Gets the data_ssh_interfaces of this PatchApplianceSuccess.  # noqa: E501


        :return: The data_ssh_interfaces of this PatchApplianceSuccess.  # noqa: E501
        :rtype: list[PatchApplianceInterfacesSuccessArray]
        """
        return self._data_ssh_interfaces

    @data_ssh_interfaces.setter
    def data_ssh_interfaces(self, data_ssh_interfaces):
        """Sets the data_ssh_interfaces of this PatchApplianceSuccess.


        :param data_ssh_interfaces: The data_ssh_interfaces of this PatchApplianceSuccess.  # noqa: E501
        :type: list[PatchApplianceInterfacesSuccessArray]
        """

        self._data_ssh_interfaces = data_ssh_interfaces

    @property
    def data_snmp_interfaces(self):
        """Gets the data_snmp_interfaces of this PatchApplianceSuccess.  # noqa: E501


        :return: The data_snmp_interfaces of this PatchApplianceSuccess.  # noqa: E501
        :rtype: list[PatchApplianceInterfacesSuccessArray]
        """
        return self._data_snmp_interfaces

    @data_snmp_interfaces.setter
    def data_snmp_interfaces(self, data_snmp_interfaces):
        """Sets the data_snmp_interfaces of this PatchApplianceSuccess.


        :param data_snmp_interfaces: The data_snmp_interfaces of this PatchApplianceSuccess.  # noqa: E501
        :type: list[PatchApplianceInterfacesSuccessArray]
        """

        self._data_snmp_interfaces = data_snmp_interfaces

    @property
    def data_network_devices(self):
        """Gets the data_network_devices of this PatchApplianceSuccess.  # noqa: E501


        :return: The data_network_devices of this PatchApplianceSuccess.  # noqa: E501
        :rtype: list[PatchApplianceNetworkDevicesSuccessArray]
        """
        return self._data_network_devices

    @data_network_devices.setter
    def data_network_devices(self, data_network_devices):
        """Sets the data_network_devices of this PatchApplianceSuccess.


        :param data_network_devices: The data_network_devices of this PatchApplianceSuccess.  # noqa: E501
        :type: list[PatchApplianceNetworkDevicesSuccessArray]
        """

        self._data_network_devices = data_network_devices

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PatchApplianceSuccess):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PatchApplianceSuccess):
            return True

        return self.to_dict() != other.to_dict()
