# coding: utf-8

"""
    UBIKA WAAP Gateway and Cloud API

    The UBIKA's WAAP management API provides a REST/JSON programming interface. It allows automation and scripting of WAAP administration tasks, such as management of reverse proxies and tunnels. The API documentation is shipped with the product itself. Once the product installed, you can access the documentation on the following URL https://ManagementWAAP:3001/api/v1/doc/  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ubika_waap_api_client.configuration import Configuration


class GetTunnelsSuccess(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'data': 'list[GetTunnelsDataSuccessArray]',
        'data_workflow_parameters': 'list[GetTunnelsWorkflowParametersSuccessArray]',
        'data_labels': 'list[GetTunnelsLabelsSuccessArray]',
        'data_network_incoming_server_alias': 'list[object]',
        'data_secondary_tunnels': 'list[GetTunnelsSecondaryTunnelsSuccessArray]'
    }

    attribute_map = {
        'data': 'data',
        'data_workflow_parameters': 'data.workflowParameters',
        'data_labels': 'data.labels',
        'data_network_incoming_server_alias': 'data.network.incoming.serverAlias',
        'data_secondary_tunnels': 'data.secondaryTunnels'
    }

    def __init__(self, data=None, data_workflow_parameters=None, data_labels=None, data_network_incoming_server_alias=None, data_secondary_tunnels=None, local_vars_configuration=None):  # noqa: E501
        """GetTunnelsSuccess - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._data = None
        self._data_workflow_parameters = None
        self._data_labels = None
        self._data_network_incoming_server_alias = None
        self._data_secondary_tunnels = None
        self.discriminator = None

        if data is not None:
            self.data = data
        if data_workflow_parameters is not None:
            self.data_workflow_parameters = data_workflow_parameters
        if data_labels is not None:
            self.data_labels = data_labels
        if data_network_incoming_server_alias is not None:
            self.data_network_incoming_server_alias = data_network_incoming_server_alias
        if data_secondary_tunnels is not None:
            self.data_secondary_tunnels = data_secondary_tunnels

    @property
    def data(self):
        """Gets the data of this GetTunnelsSuccess.  # noqa: E501


        :return: The data of this GetTunnelsSuccess.  # noqa: E501
        :rtype: list[GetTunnelsDataSuccessArray]
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this GetTunnelsSuccess.


        :param data: The data of this GetTunnelsSuccess.  # noqa: E501
        :type: list[GetTunnelsDataSuccessArray]
        """

        self._data = data

    @property
    def data_workflow_parameters(self):
        """Gets the data_workflow_parameters of this GetTunnelsSuccess.  # noqa: E501


        :return: The data_workflow_parameters of this GetTunnelsSuccess.  # noqa: E501
        :rtype: list[GetTunnelsWorkflowParametersSuccessArray]
        """
        return self._data_workflow_parameters

    @data_workflow_parameters.setter
    def data_workflow_parameters(self, data_workflow_parameters):
        """Sets the data_workflow_parameters of this GetTunnelsSuccess.


        :param data_workflow_parameters: The data_workflow_parameters of this GetTunnelsSuccess.  # noqa: E501
        :type: list[GetTunnelsWorkflowParametersSuccessArray]
        """

        self._data_workflow_parameters = data_workflow_parameters

    @property
    def data_labels(self):
        """Gets the data_labels of this GetTunnelsSuccess.  # noqa: E501


        :return: The data_labels of this GetTunnelsSuccess.  # noqa: E501
        :rtype: list[GetTunnelsLabelsSuccessArray]
        """
        return self._data_labels

    @data_labels.setter
    def data_labels(self, data_labels):
        """Sets the data_labels of this GetTunnelsSuccess.


        :param data_labels: The data_labels of this GetTunnelsSuccess.  # noqa: E501
        :type: list[GetTunnelsLabelsSuccessArray]
        """

        self._data_labels = data_labels

    @property
    def data_network_incoming_server_alias(self):
        """Gets the data_network_incoming_server_alias of this GetTunnelsSuccess.  # noqa: E501


        :return: The data_network_incoming_server_alias of this GetTunnelsSuccess.  # noqa: E501
        :rtype: list[object]
        """
        return self._data_network_incoming_server_alias

    @data_network_incoming_server_alias.setter
    def data_network_incoming_server_alias(self, data_network_incoming_server_alias):
        """Sets the data_network_incoming_server_alias of this GetTunnelsSuccess.


        :param data_network_incoming_server_alias: The data_network_incoming_server_alias of this GetTunnelsSuccess.  # noqa: E501
        :type: list[object]
        """

        self._data_network_incoming_server_alias = data_network_incoming_server_alias

    @property
    def data_secondary_tunnels(self):
        """Gets the data_secondary_tunnels of this GetTunnelsSuccess.  # noqa: E501


        :return: The data_secondary_tunnels of this GetTunnelsSuccess.  # noqa: E501
        :rtype: list[GetTunnelsSecondaryTunnelsSuccessArray]
        """
        return self._data_secondary_tunnels

    @data_secondary_tunnels.setter
    def data_secondary_tunnels(self, data_secondary_tunnels):
        """Sets the data_secondary_tunnels of this GetTunnelsSuccess.


        :param data_secondary_tunnels: The data_secondary_tunnels of this GetTunnelsSuccess.  # noqa: E501
        :type: list[GetTunnelsSecondaryTunnelsSuccessArray]
        """

        self._data_secondary_tunnels = data_secondary_tunnels

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetTunnelsSuccess):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GetTunnelsSuccess):
            return True

        return self.to_dict() != other.to_dict()
