# coding: utf-8

"""
    UBIKA WAAP Gateway and Cloud API

    The UBIKA's WAAP management API provides a REST/JSON programming interface. It allows automation and scripting of WAAP administration tasks, such as management of reverse proxies and tunnels. The API documentation is shipped with the product itself. Once the product installed, you can access the documentation on the following URL https://ManagementWAAP:3001/api/v1/doc/  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ubika_waap_api_client.configuration import Configuration


class GetLicensesDataSuccessArray(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'edition': 'str',
        'serial_number': 'str',
        'dedicated_management': 'bool',
        'expiration': 'float',
        'max_managed': 'str',
        'modules': 'GetLicensesDataSuccessArrayModules',
        'number_of': 'GetLicensesDataSuccessArrayNumberOf'
    }

    attribute_map = {
        'edition': 'edition',
        'serial_number': 'serialNumber',
        'dedicated_management': 'dedicatedManagement',
        'expiration': 'expiration',
        'max_managed': 'maxManaged',
        'modules': 'modules',
        'number_of': 'numberOf'
    }

    def __init__(self, edition=None, serial_number=None, dedicated_management=None, expiration=None, max_managed=None, modules=None, number_of=None, local_vars_configuration=None):  # noqa: E501
        """GetLicensesDataSuccessArray - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._edition = None
        self._serial_number = None
        self._dedicated_management = None
        self._expiration = None
        self._max_managed = None
        self._modules = None
        self._number_of = None
        self.discriminator = None

        if edition is not None:
            self.edition = edition
        if serial_number is not None:
            self.serial_number = serial_number
        if dedicated_management is not None:
            self.dedicated_management = dedicated_management
        if expiration is not None:
            self.expiration = expiration
        if max_managed is not None:
            self.max_managed = max_managed
        if modules is not None:
            self.modules = modules
        if number_of is not None:
            self.number_of = number_of

    @property
    def edition(self):
        """Gets the edition of this GetLicensesDataSuccessArray.  # noqa: E501


        :return: The edition of this GetLicensesDataSuccessArray.  # noqa: E501
        :rtype: str
        """
        return self._edition

    @edition.setter
    def edition(self, edition):
        """Sets the edition of this GetLicensesDataSuccessArray.


        :param edition: The edition of this GetLicensesDataSuccessArray.  # noqa: E501
        :type: str
        """

        self._edition = edition

    @property
    def serial_number(self):
        """Gets the serial_number of this GetLicensesDataSuccessArray.  # noqa: E501


        :return: The serial_number of this GetLicensesDataSuccessArray.  # noqa: E501
        :rtype: str
        """
        return self._serial_number

    @serial_number.setter
    def serial_number(self, serial_number):
        """Sets the serial_number of this GetLicensesDataSuccessArray.


        :param serial_number: The serial_number of this GetLicensesDataSuccessArray.  # noqa: E501
        :type: str
        """

        self._serial_number = serial_number

    @property
    def dedicated_management(self):
        """Gets the dedicated_management of this GetLicensesDataSuccessArray.  # noqa: E501


        :return: The dedicated_management of this GetLicensesDataSuccessArray.  # noqa: E501
        :rtype: bool
        """
        return self._dedicated_management

    @dedicated_management.setter
    def dedicated_management(self, dedicated_management):
        """Sets the dedicated_management of this GetLicensesDataSuccessArray.


        :param dedicated_management: The dedicated_management of this GetLicensesDataSuccessArray.  # noqa: E501
        :type: bool
        """

        self._dedicated_management = dedicated_management

    @property
    def expiration(self):
        """Gets the expiration of this GetLicensesDataSuccessArray.  # noqa: E501


        :return: The expiration of this GetLicensesDataSuccessArray.  # noqa: E501
        :rtype: float
        """
        return self._expiration

    @expiration.setter
    def expiration(self, expiration):
        """Sets the expiration of this GetLicensesDataSuccessArray.


        :param expiration: The expiration of this GetLicensesDataSuccessArray.  # noqa: E501
        :type: float
        """

        self._expiration = expiration

    @property
    def max_managed(self):
        """Gets the max_managed of this GetLicensesDataSuccessArray.  # noqa: E501


        :return: The max_managed of this GetLicensesDataSuccessArray.  # noqa: E501
        :rtype: str
        """
        return self._max_managed

    @max_managed.setter
    def max_managed(self, max_managed):
        """Sets the max_managed of this GetLicensesDataSuccessArray.


        :param max_managed: The max_managed of this GetLicensesDataSuccessArray.  # noqa: E501
        :type: str
        """

        self._max_managed = max_managed

    @property
    def modules(self):
        """Gets the modules of this GetLicensesDataSuccessArray.  # noqa: E501


        :return: The modules of this GetLicensesDataSuccessArray.  # noqa: E501
        :rtype: GetLicensesDataSuccessArrayModules
        """
        return self._modules

    @modules.setter
    def modules(self, modules):
        """Sets the modules of this GetLicensesDataSuccessArray.


        :param modules: The modules of this GetLicensesDataSuccessArray.  # noqa: E501
        :type: GetLicensesDataSuccessArrayModules
        """

        self._modules = modules

    @property
    def number_of(self):
        """Gets the number_of of this GetLicensesDataSuccessArray.  # noqa: E501


        :return: The number_of of this GetLicensesDataSuccessArray.  # noqa: E501
        :rtype: GetLicensesDataSuccessArrayNumberOf
        """
        return self._number_of

    @number_of.setter
    def number_of(self, number_of):
        """Sets the number_of of this GetLicensesDataSuccessArray.


        :param number_of: The number_of of this GetLicensesDataSuccessArray.  # noqa: E501
        :type: GetLicensesDataSuccessArrayNumberOf
        """

        self._number_of = number_of

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetLicensesDataSuccessArray):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GetLicensesDataSuccessArray):
            return True

        return self.to_dict() != other.to_dict()
