# coding: utf-8

"""
    UBIKA WAAP Gateway and Cloud API

    The UBIKA's WAAP management API provides a REST/JSON programming interface. It allows automation and scripting of WAAP administration tasks, such as management of reverse proxies and tunnels. The API documentation is shipped with the product itself. Once the product installed, you can access the documentation on the following URL https://ManagementWAAP:3001/api/v1/doc/  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ubika_waap_api_client.configuration import Configuration


class Apply(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'reverse_proxies': 'list[ApplyReverseProxiesArray]',
        'cold_restart': 'bool',
        'tunnels': 'list[ApplyTunnelsArray]',
        'secondary_tunnels': 'list[ApplySecondaryTunnelsArray]',
        'appliances': 'list[ApplyAppliancesArray]',
        'network_devices': 'list[ApplyNetworkDevicesArray]',
        'ssl_key_uid': 'ApplySSLKeyUid'
    }

    attribute_map = {
        'reverse_proxies': 'reverseProxies',
        'cold_restart': 'coldRestart',
        'tunnels': 'tunnels',
        'secondary_tunnels': 'secondaryTunnels',
        'appliances': 'appliances',
        'network_devices': 'networkDevices',
        'ssl_key_uid': 'SSLKeyUid'
    }

    def __init__(self, reverse_proxies=None, cold_restart=None, tunnels=None, secondary_tunnels=None, appliances=None, network_devices=None, ssl_key_uid=None, local_vars_configuration=None):  # noqa: E501
        """Apply - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._reverse_proxies = None
        self._cold_restart = None
        self._tunnels = None
        self._secondary_tunnels = None
        self._appliances = None
        self._network_devices = None
        self._ssl_key_uid = None
        self.discriminator = None

        if reverse_proxies is not None:
            self.reverse_proxies = reverse_proxies
        if cold_restart is not None:
            self.cold_restart = cold_restart
        if tunnels is not None:
            self.tunnels = tunnels
        if secondary_tunnels is not None:
            self.secondary_tunnels = secondary_tunnels
        if appliances is not None:
            self.appliances = appliances
        if network_devices is not None:
            self.network_devices = network_devices
        if ssl_key_uid is not None:
            self.ssl_key_uid = ssl_key_uid

    @property
    def reverse_proxies(self):
        """Gets the reverse_proxies of this Apply.  # noqa: E501


        :return: The reverse_proxies of this Apply.  # noqa: E501
        :rtype: list[ApplyReverseProxiesArray]
        """
        return self._reverse_proxies

    @reverse_proxies.setter
    def reverse_proxies(self, reverse_proxies):
        """Sets the reverse_proxies of this Apply.


        :param reverse_proxies: The reverse_proxies of this Apply.  # noqa: E501
        :type: list[ApplyReverseProxiesArray]
        """

        self._reverse_proxies = reverse_proxies

    @property
    def cold_restart(self):
        """Gets the cold_restart of this Apply.  # noqa: E501


        :return: The cold_restart of this Apply.  # noqa: E501
        :rtype: bool
        """
        return self._cold_restart

    @cold_restart.setter
    def cold_restart(self, cold_restart):
        """Sets the cold_restart of this Apply.


        :param cold_restart: The cold_restart of this Apply.  # noqa: E501
        :type: bool
        """

        self._cold_restart = cold_restart

    @property
    def tunnels(self):
        """Gets the tunnels of this Apply.  # noqa: E501


        :return: The tunnels of this Apply.  # noqa: E501
        :rtype: list[ApplyTunnelsArray]
        """
        return self._tunnels

    @tunnels.setter
    def tunnels(self, tunnels):
        """Sets the tunnels of this Apply.


        :param tunnels: The tunnels of this Apply.  # noqa: E501
        :type: list[ApplyTunnelsArray]
        """

        self._tunnels = tunnels

    @property
    def secondary_tunnels(self):
        """Gets the secondary_tunnels of this Apply.  # noqa: E501


        :return: The secondary_tunnels of this Apply.  # noqa: E501
        :rtype: list[ApplySecondaryTunnelsArray]
        """
        return self._secondary_tunnels

    @secondary_tunnels.setter
    def secondary_tunnels(self, secondary_tunnels):
        """Sets the secondary_tunnels of this Apply.


        :param secondary_tunnels: The secondary_tunnels of this Apply.  # noqa: E501
        :type: list[ApplySecondaryTunnelsArray]
        """

        self._secondary_tunnels = secondary_tunnels

    @property
    def appliances(self):
        """Gets the appliances of this Apply.  # noqa: E501


        :return: The appliances of this Apply.  # noqa: E501
        :rtype: list[ApplyAppliancesArray]
        """
        return self._appliances

    @appliances.setter
    def appliances(self, appliances):
        """Sets the appliances of this Apply.


        :param appliances: The appliances of this Apply.  # noqa: E501
        :type: list[ApplyAppliancesArray]
        """

        self._appliances = appliances

    @property
    def network_devices(self):
        """Gets the network_devices of this Apply.  # noqa: E501


        :return: The network_devices of this Apply.  # noqa: E501
        :rtype: list[ApplyNetworkDevicesArray]
        """
        return self._network_devices

    @network_devices.setter
    def network_devices(self, network_devices):
        """Sets the network_devices of this Apply.


        :param network_devices: The network_devices of this Apply.  # noqa: E501
        :type: list[ApplyNetworkDevicesArray]
        """

        self._network_devices = network_devices

    @property
    def ssl_key_uid(self):
        """Gets the ssl_key_uid of this Apply.  # noqa: E501


        :return: The ssl_key_uid of this Apply.  # noqa: E501
        :rtype: ApplySSLKeyUid
        """
        return self._ssl_key_uid

    @ssl_key_uid.setter
    def ssl_key_uid(self, ssl_key_uid):
        """Sets the ssl_key_uid of this Apply.


        :param ssl_key_uid: The ssl_key_uid of this Apply.  # noqa: E501
        :type: ApplySSLKeyUid
        """

        self._ssl_key_uid = ssl_key_uid

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Apply):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Apply):
            return True

        return self.to_dict() != other.to_dict()
