# coding: utf-8

"""
    UBIKA WAAP Gateway and Cloud API

    The UBIKA's WAAP management API provides a REST/JSON programming interface. It allows automation and scripting of WAAP administration tasks, such as management of reverse proxies and tunnels. The API documentation is shipped with the product itself. Once the product installed, you can access the documentation on the following URL https://ManagementWAAP:3001/api/v1/doc/  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ubika_waap_api_client.api_client import ApiClient
from ubika_waap_api_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_network_interface(self, add_network_interface, **kwargs):  # noqa: E501
        """Create a network interface  # noqa: E501

        Create a new network interface  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_network_interface(add_network_interface, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AddNetworkInterface add_network_interface: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AddNetworkInterfaceSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_network_interface_with_http_info(add_network_interface, **kwargs)  # noqa: E501

    def add_network_interface_with_http_info(self, add_network_interface, **kwargs):  # noqa: E501
        """Create a network interface  # noqa: E501

        Create a new network interface  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_network_interface_with_http_info(add_network_interface, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AddNetworkInterface add_network_interface: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AddNetworkInterfaceSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'add_network_interface'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_network_interface" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'add_network_interface' is set
        if self.api_client.client_side_validation and ('add_network_interface' not in local_var_params or  # noqa: E501
                                                        local_var_params['add_network_interface'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `add_network_interface` when calling `add_network_interface`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_network_interface' in local_var_params:
            body_params = local_var_params['add_network_interface']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/networkdevices/interfaces', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddNetworkInterfaceSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_reverse_proxy(self, add_reverse_proxy, **kwargs):  # noqa: E501
        """Create a reverse proxy  # noqa: E501

        Create a new reverse proxy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_reverse_proxy(add_reverse_proxy, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AddReverseProxy add_reverse_proxy: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AddReverseProxySuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_reverse_proxy_with_http_info(add_reverse_proxy, **kwargs)  # noqa: E501

    def add_reverse_proxy_with_http_info(self, add_reverse_proxy, **kwargs):  # noqa: E501
        """Create a reverse proxy  # noqa: E501

        Create a new reverse proxy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_reverse_proxy_with_http_info(add_reverse_proxy, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AddReverseProxy add_reverse_proxy: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AddReverseProxySuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'add_reverse_proxy'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_reverse_proxy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'add_reverse_proxy' is set
        if self.api_client.client_side_validation and ('add_reverse_proxy' not in local_var_params or  # noqa: E501
                                                        local_var_params['add_reverse_proxy'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `add_reverse_proxy` when calling `add_reverse_proxy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_reverse_proxy' in local_var_params:
            body_params = local_var_params['add_reverse_proxy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/reverseproxies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddReverseProxySuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_reverse_proxy_profile(self, add_reverse_proxy_profile, **kwargs):  # noqa: E501
        """Create a reverse proxy profile  # noqa: E501

        Create a new reverse proxy profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_reverse_proxy_profile(add_reverse_proxy_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AddReverseProxyProfile add_reverse_proxy_profile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AddReverseProxyProfileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_reverse_proxy_profile_with_http_info(add_reverse_proxy_profile, **kwargs)  # noqa: E501

    def add_reverse_proxy_profile_with_http_info(self, add_reverse_proxy_profile, **kwargs):  # noqa: E501
        """Create a reverse proxy profile  # noqa: E501

        Create a new reverse proxy profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_reverse_proxy_profile_with_http_info(add_reverse_proxy_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AddReverseProxyProfile add_reverse_proxy_profile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AddReverseProxyProfileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'add_reverse_proxy_profile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_reverse_proxy_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'add_reverse_proxy_profile' is set
        if self.api_client.client_side_validation and ('add_reverse_proxy_profile' not in local_var_params or  # noqa: E501
                                                        local_var_params['add_reverse_proxy_profile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `add_reverse_proxy_profile` when calling `add_reverse_proxy_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_reverse_proxy_profile' in local_var_params:
            body_params = local_var_params['add_reverse_proxy_profile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/reverseproxyprofiles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddReverseProxyProfileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def addsslprofiles(self, addsslprofiles, **kwargs):  # noqa: E501
        """Create SSL Profile  # noqa: E501

        Create a new SSL Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.addsslprofiles(addsslprofiles, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Addsslprofiles addsslprofiles: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AddsslprofilesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.addsslprofiles_with_http_info(addsslprofiles, **kwargs)  # noqa: E501

    def addsslprofiles_with_http_info(self, addsslprofiles, **kwargs):  # noqa: E501
        """Create SSL Profile  # noqa: E501

        Create a new SSL Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.addsslprofiles_with_http_info(addsslprofiles, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Addsslprofiles addsslprofiles: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AddsslprofilesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'addsslprofiles'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method addsslprofiles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'addsslprofiles' is set
        if self.api_client.client_side_validation and ('addsslprofiles' not in local_var_params or  # noqa: E501
                                                        local_var_params['addsslprofiles'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `addsslprofiles` when calling `addsslprofiles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'addsslprofiles' in local_var_params:
            body_params = local_var_params['addsslprofiles']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/sslprofiles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddsslprofilesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def apply(self, apply, **kwargs):  # noqa: E501
        """Apply items  # noqa: E501

        While applying a tunnel, parent reverse proxy is automatically applied (but it don't apply other child tunnels of parent reverseproxy).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.apply(apply, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Apply apply: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApplySuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.apply_with_http_info(apply, **kwargs)  # noqa: E501

    def apply_with_http_info(self, apply, **kwargs):  # noqa: E501
        """Apply items  # noqa: E501

        While applying a tunnel, parent reverse proxy is automatically applied (but it don't apply other child tunnels of parent reverseproxy).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.apply_with_http_info(apply, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Apply apply: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApplySuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'apply'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method apply" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'apply' is set
        if self.api_client.client_side_validation and ('apply' not in local_var_params or  # noqa: E501
                                                        local_var_params['apply'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `apply` when calling `apply`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'apply' in local_var_params:
            body_params = local_var_params['apply']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/apply', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplySuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_accesslogprofile(self, create_accesslogprofile, **kwargs):  # noqa: E501
        """Create an access log profile  # noqa: E501

        Create a new access log profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_accesslogprofile(create_accesslogprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateAccesslogprofile create_accesslogprofile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateAccesslogprofileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_accesslogprofile_with_http_info(create_accesslogprofile, **kwargs)  # noqa: E501

    def create_accesslogprofile_with_http_info(self, create_accesslogprofile, **kwargs):  # noqa: E501
        """Create an access log profile  # noqa: E501

        Create a new access log profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_accesslogprofile_with_http_info(create_accesslogprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateAccesslogprofile create_accesslogprofile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateAccesslogprofileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_accesslogprofile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_accesslogprofile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_accesslogprofile' is set
        if self.api_client.client_side_validation and ('create_accesslogprofile' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_accesslogprofile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_accesslogprofile` when calling `create_accesslogprofile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_accesslogprofile' in local_var_params:
            body_params = local_var_params['create_accesslogprofile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/accesslogprofiles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateAccesslogprofileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_alerting_destinations(self, create_alerting_destinations, **kwargs):  # noqa: E501
        """Create an alerting destination  # noqa: E501

        Create a new alerting destination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_alerting_destinations(create_alerting_destinations, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateAlertingDestinations create_alerting_destinations: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateAlertingDestinationsSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_alerting_destinations_with_http_info(create_alerting_destinations, **kwargs)  # noqa: E501

    def create_alerting_destinations_with_http_info(self, create_alerting_destinations, **kwargs):  # noqa: E501
        """Create an alerting destination  # noqa: E501

        Create a new alerting destination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_alerting_destinations_with_http_info(create_alerting_destinations, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateAlertingDestinations create_alerting_destinations: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateAlertingDestinationsSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_alerting_destinations'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_alerting_destinations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_alerting_destinations' is set
        if self.api_client.client_side_validation and ('create_alerting_destinations' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_alerting_destinations'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_alerting_destinations` when calling `create_alerting_destinations`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_alerting_destinations' in local_var_params:
            body_params = local_var_params['create_alerting_destinations']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alertingdestinations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateAlertingDestinationsSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_appliance(self, create_appliance, **kwargs):  # noqa: E501
        """Create an appliance  # noqa: E501

        Create a new appliance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_appliance(create_appliance, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateAppliance create_appliance: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateApplianceSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_appliance_with_http_info(create_appliance, **kwargs)  # noqa: E501

    def create_appliance_with_http_info(self, create_appliance, **kwargs):  # noqa: E501
        """Create an appliance  # noqa: E501

        Create a new appliance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_appliance_with_http_info(create_appliance, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateAppliance create_appliance: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateApplianceSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_appliance'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_appliance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_appliance' is set
        if self.api_client.client_side_validation and ('create_appliance' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_appliance'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_appliance` when calling `create_appliance`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_appliance' in local_var_params:
            body_params = local_var_params['create_appliance']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/appliances', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateApplianceSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_blacklist(self, create_blacklist, **kwargs):  # noqa: E501
        """Create a blacklist  # noqa: E501

        Create a new blacklist  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_blacklist(create_blacklist, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateBlacklist create_blacklist: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateBlacklistSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_blacklist_with_http_info(create_blacklist, **kwargs)  # noqa: E501

    def create_blacklist_with_http_info(self, create_blacklist, **kwargs):  # noqa: E501
        """Create a blacklist  # noqa: E501

        Create a new blacklist  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_blacklist_with_http_info(create_blacklist, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateBlacklist create_blacklist: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateBlacklistSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_blacklist'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_blacklist" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_blacklist' is set
        if self.api_client.client_side_validation and ('create_blacklist' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_blacklist'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_blacklist` when calling `create_blacklist`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_blacklist' in local_var_params:
            body_params = local_var_params['create_blacklist']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blacklists', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateBlacklistSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_blacklist_exception(self, create_blacklist_exception, **kwargs):  # noqa: E501
        """Create a blacklist exception  # noqa: E501

        Create a new blacklist exception  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_blacklist_exception(create_blacklist_exception, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateBlacklistException create_blacklist_exception: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateBlacklistExceptionSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_blacklist_exception_with_http_info(create_blacklist_exception, **kwargs)  # noqa: E501

    def create_blacklist_exception_with_http_info(self, create_blacklist_exception, **kwargs):  # noqa: E501
        """Create a blacklist exception  # noqa: E501

        Create a new blacklist exception  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_blacklist_exception_with_http_info(create_blacklist_exception, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateBlacklistException create_blacklist_exception: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateBlacklistExceptionSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_blacklist_exception'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_blacklist_exception" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_blacklist_exception' is set
        if self.api_client.client_side_validation and ('create_blacklist_exception' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_blacklist_exception'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_blacklist_exception` when calling `create_blacklist_exception`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_blacklist_exception' in local_var_params:
            body_params = local_var_params['create_blacklist_exception']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blacklists/exceptions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateBlacklistExceptionSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ca_certificate(self, **kwargs):  # noqa: E501
        """Create a CA certificate of the specific bundle  # noqa: E501

        Create the CA certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ca_certificate(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_md5: The md5sum of uploaded file. To ensure that data is not corrupted traversing the network, user may use the header.                          <br />If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>.
        :param str name:
        :param str bundle_uid:
        :param file upload:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateCACertificateSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_ca_certificate_with_http_info(**kwargs)  # noqa: E501

    def create_ca_certificate_with_http_info(self, **kwargs):  # noqa: E501
        """Create a CA certificate of the specific bundle  # noqa: E501

        Create the CA certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ca_certificate_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_md5: The md5sum of uploaded file. To ensure that data is not corrupted traversing the network, user may use the header.                          <br />If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>.
        :param str name:
        :param str bundle_uid:
        :param file upload:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateCACertificateSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'content_md5',
            'name',
            'bundle_uid',
            'upload'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ca_certificate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'content_md5' in local_var_params:
            header_params['Content-MD5'] = local_var_params['content_md5']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'bundle_uid' in local_var_params:
            form_params.append(('bundleUid', local_var_params['bundle_uid']))  # noqa: E501
        if 'upload' in local_var_params:
            local_var_files['upload'] = local_var_params['upload']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles/ca', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateCACertificateSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_certificate(self, **kwargs):  # noqa: E501
        """Create a certificate  # noqa: E501

        Create the certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_certificate(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_md5: The md5sum of uploaded file. To ensure that data is not corrupted traversing the network, user may use the header.                          <br />If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>.
        :param str name:
        :param str password:
        :param file pkcs12:
        :param file key:
        :param file crt:
        :param file chain:
        :param str type:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateCertificateSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_certificate_with_http_info(**kwargs)  # noqa: E501

    def create_certificate_with_http_info(self, **kwargs):  # noqa: E501
        """Create a certificate  # noqa: E501

        Create the certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_certificate_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_md5: The md5sum of uploaded file. To ensure that data is not corrupted traversing the network, user may use the header.                          <br />If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>.
        :param str name:
        :param str password:
        :param file pkcs12:
        :param file key:
        :param file crt:
        :param file chain:
        :param str type:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateCertificateSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'content_md5',
            'name',
            'password',
            'pkcs12',
            'key',
            'crt',
            'chain',
            'type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_certificate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'content_md5' in local_var_params:
            header_params['Content-MD5'] = local_var_params['content_md5']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'password' in local_var_params:
            form_params.append(('password', local_var_params['password']))  # noqa: E501
        if 'pkcs12' in local_var_params:
            local_var_files['pkcs12'] = local_var_params['pkcs12']  # noqa: E501
        if 'key' in local_var_params:
            local_var_files['key'] = local_var_params['key']  # noqa: E501
        if 'crt' in local_var_params:
            local_var_files['crt'] = local_var_params['crt']  # noqa: E501
        if 'chain' in local_var_params:
            local_var_files['chain'] = local_var_params['chain']  # noqa: E501
        if 'type' in local_var_params:
            form_params.append(('type', local_var_params['type']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificates/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateCertificateSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_certificates_bundle(self, create_certificates_bundle, **kwargs):  # noqa: E501
        """Create a certificates bundle  # noqa: E501

        Create a new certificates bundle  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_certificates_bundle(create_certificates_bundle, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateCertificatesBundle create_certificates_bundle: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateCertificatesBundleSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_certificates_bundle_with_http_info(create_certificates_bundle, **kwargs)  # noqa: E501

    def create_certificates_bundle_with_http_info(self, create_certificates_bundle, **kwargs):  # noqa: E501
        """Create a certificates bundle  # noqa: E501

        Create a new certificates bundle  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_certificates_bundle_with_http_info(create_certificates_bundle, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateCertificatesBundle create_certificates_bundle: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateCertificatesBundleSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_certificates_bundle'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_certificates_bundle" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_certificates_bundle' is set
        if self.api_client.client_side_validation and ('create_certificates_bundle' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_certificates_bundle'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_certificates_bundle` when calling `create_certificates_bundle`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_certificates_bundle' in local_var_params:
            body_params = local_var_params['create_certificates_bundle']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateCertificatesBundleSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_compression_profile(self, create_compression_profile, **kwargs):  # noqa: E501
        """Create a compression profile  # noqa: E501

        Create a new compression profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_compression_profile(create_compression_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateCompressionProfile create_compression_profile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateCompressionProfileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_compression_profile_with_http_info(create_compression_profile, **kwargs)  # noqa: E501

    def create_compression_profile_with_http_info(self, create_compression_profile, **kwargs):  # noqa: E501
        """Create a compression profile  # noqa: E501

        Create a new compression profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_compression_profile_with_http_info(create_compression_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateCompressionProfile create_compression_profile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateCompressionProfileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_compression_profile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_compression_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_compression_profile' is set
        if self.api_client.client_side_validation and ('create_compression_profile' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_compression_profile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_compression_profile` when calling `create_compression_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_compression_profile' in local_var_params:
            body_params = local_var_params['create_compression_profile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/compressionprofiles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateCompressionProfileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_crl_certificate(self, **kwargs):  # noqa: E501
        """Create a CRL certificate of the specific bundle  # noqa: E501

        Create the CRL certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_crl_certificate(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_md5: The md5sum of uploaded file. To ensure that data is not corrupted traversing the network, user may use the header.                          <br />If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>.
        :param str name:
        :param str bundle_uid:
        :param file upload:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateCRLCertificateSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_crl_certificate_with_http_info(**kwargs)  # noqa: E501

    def create_crl_certificate_with_http_info(self, **kwargs):  # noqa: E501
        """Create a CRL certificate of the specific bundle  # noqa: E501

        Create the CRL certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_crl_certificate_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_md5: The md5sum of uploaded file. To ensure that data is not corrupted traversing the network, user may use the header.                          <br />If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>.
        :param str name:
        :param str bundle_uid:
        :param file upload:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateCRLCertificateSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'content_md5',
            'name',
            'bundle_uid',
            'upload'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_crl_certificate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'content_md5' in local_var_params:
            header_params['Content-MD5'] = local_var_params['content_md5']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'bundle_uid' in local_var_params:
            form_params.append(('bundleUid', local_var_params['bundle_uid']))  # noqa: E501
        if 'upload' in local_var_params:
            local_var_files['upload'] = local_var_params['upload']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles/crl', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateCRLCertificateSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_icx(self, create_icx, **kwargs):  # noqa: E501
        """Create an ICX configuration  # noqa: E501

        Create a new ICX configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_icx(create_icx, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateIcx create_icx: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateIcxSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_icx_with_http_info(create_icx, **kwargs)  # noqa: E501

    def create_icx_with_http_info(self, create_icx, **kwargs):  # noqa: E501
        """Create an ICX configuration  # noqa: E501

        Create a new ICX configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_icx_with_http_info(create_icx, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateIcx create_icx: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateIcxSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_icx'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_icx" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_icx' is set
        if self.api_client.client_side_validation and ('create_icx' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_icx'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_icx` when calling `create_icx`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_icx' in local_var_params:
            body_params = local_var_params['create_icx']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateIcxSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_icx_category(self, create_icx_category, **kwargs):  # noqa: E501
        """Create an ICX Category  # noqa: E501

        Create a new ICX category  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_icx_category(create_icx_category, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateIcxCategory create_icx_category: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateIcxCategorySuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_icx_category_with_http_info(create_icx_category, **kwargs)  # noqa: E501

    def create_icx_category_with_http_info(self, create_icx_category, **kwargs):  # noqa: E501
        """Create an ICX Category  # noqa: E501

        Create a new ICX category  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_icx_category_with_http_info(create_icx_category, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateIcxCategory create_icx_category: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateIcxCategorySuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_icx_category'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_icx_category" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_icx_category' is set
        if self.api_client.client_side_validation and ('create_icx_category' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_icx_category'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_icx_category` when calling `create_icx_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_icx_category' in local_var_params:
            body_params = local_var_params['create_icx_category']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx/categories', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateIcxCategorySuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_icx_rule(self, create_icx_rule, **kwargs):  # noqa: E501
        """Create an ICX Rule  # noqa: E501

        Create a new ICX Rule  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_icx_rule(create_icx_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateIcxRule create_icx_rule: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateIcxRuleSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_icx_rule_with_http_info(create_icx_rule, **kwargs)  # noqa: E501

    def create_icx_rule_with_http_info(self, create_icx_rule, **kwargs):  # noqa: E501
        """Create an ICX Rule  # noqa: E501

        Create a new ICX Rule  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_icx_rule_with_http_info(create_icx_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateIcxRule create_icx_rule: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateIcxRuleSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_icx_rule'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_icx_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_icx_rule' is set
        if self.api_client.client_side_validation and ('create_icx_rule' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_icx_rule'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_icx_rule` when calling `create_icx_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_icx_rule' in local_var_params:
            body_params = local_var_params['create_icx_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx/categories/rules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateIcxRuleSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_label(self, create_label, **kwargs):  # noqa: E501
        """Create a label  # noqa: E501

        Create a new label  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_label(create_label, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateLabel create_label: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateLabelSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_label_with_http_info(create_label, **kwargs)  # noqa: E501

    def create_label_with_http_info(self, create_label, **kwargs):  # noqa: E501
        """Create a label  # noqa: E501

        Create a new label  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_label_with_http_info(create_label, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateLabel create_label: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateLabelSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_label'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_label" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_label' is set
        if self.api_client.client_side_validation and ('create_label' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_label'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_label` when calling `create_label`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_label' in local_var_params:
            body_params = local_var_params['create_label']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateLabelSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_logfilter(self, **kwargs):  # noqa: E501
        """Create a new Logfilter  # noqa: E501

        Create the logfilter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_logfilter(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_md5: The md5sum of uploaded file. To ensure that data is not corrupted traversing the network, user may use the header.                          <br />If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>.
        :param str name:
        :param str description:
        :param file upload:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateLogfilterSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_logfilter_with_http_info(**kwargs)  # noqa: E501

    def create_logfilter_with_http_info(self, **kwargs):  # noqa: E501
        """Create a new Logfilter  # noqa: E501

        Create the logfilter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_logfilter_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_md5: The md5sum of uploaded file. To ensure that data is not corrupted traversing the network, user may use the header.                          <br />If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>.
        :param str name:
        :param str description:
        :param file upload:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateLogfilterSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'content_md5',
            'name',
            'description',
            'upload'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_logfilter" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'content_md5' in local_var_params:
            header_params['Content-MD5'] = local_var_params['content_md5']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'description' in local_var_params:
            form_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'upload' in local_var_params:
            local_var_files['upload'] = local_var_params['upload']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/logfilters', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateLogfilterSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_normalization(self, create_normalization, **kwargs):  # noqa: E501
        """Create a normalization configuration  # noqa: E501

        Create a new normalization configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_normalization(create_normalization, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateNormalization create_normalization: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateNormalizationSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_normalization_with_http_info(create_normalization, **kwargs)  # noqa: E501

    def create_normalization_with_http_info(self, create_normalization, **kwargs):  # noqa: E501
        """Create a normalization configuration  # noqa: E501

        Create a new normalization configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_normalization_with_http_info(create_normalization, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateNormalization create_normalization: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateNormalizationSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_normalization'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_normalization" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_normalization' is set
        if self.api_client.client_side_validation and ('create_normalization' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_normalization'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_normalization` when calling `create_normalization`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_normalization' in local_var_params:
            body_params = local_var_params['create_normalization']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/normalization', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateNormalizationSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ntp(self, create_ntp, **kwargs):  # noqa: E501
        """Create a ntp  # noqa: E501

        Create a new ntp  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ntp(create_ntp, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateNtp create_ntp: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateNtpSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_ntp_with_http_info(create_ntp, **kwargs)  # noqa: E501

    def create_ntp_with_http_info(self, create_ntp, **kwargs):  # noqa: E501
        """Create a ntp  # noqa: E501

        Create a new ntp  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ntp_with_http_info(create_ntp, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateNtp create_ntp: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateNtpSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_ntp'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ntp" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_ntp' is set
        if self.api_client.client_side_validation and ('create_ntp' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_ntp'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_ntp` when calling `create_ntp`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_ntp' in local_var_params:
            body_params = local_var_params['create_ntp']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ntp', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateNtpSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ocsp_certificate(self, **kwargs):  # noqa: E501
        """Create a OCSP certificate of the specific bundle  # noqa: E501

        Create the OCSP certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ocsp_certificate(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_md5: The md5sum of uploaded file. To ensure that data is not corrupted traversing the network, user may use the header.                          <br />If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>.
        :param str name:
        :param str bundle_uid:
        :param file upload:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateOCSPCertificateSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_ocsp_certificate_with_http_info(**kwargs)  # noqa: E501

    def create_ocsp_certificate_with_http_info(self, **kwargs):  # noqa: E501
        """Create a OCSP certificate of the specific bundle  # noqa: E501

        Create the OCSP certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ocsp_certificate_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_md5: The md5sum of uploaded file. To ensure that data is not corrupted traversing the network, user may use the header.                          <br />If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>.
        :param str name:
        :param str bundle_uid:
        :param file upload:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateOCSPCertificateSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'content_md5',
            'name',
            'bundle_uid',
            'upload'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ocsp_certificate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'content_md5' in local_var_params:
            header_params['Content-MD5'] = local_var_params['content_md5']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'bundle_uid' in local_var_params:
            form_params.append(('bundleUid', local_var_params['bundle_uid']))  # noqa: E501
        if 'upload' in local_var_params:
            local_var_files['upload'] = local_var_params['upload']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles/ocsp', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateOCSPCertificateSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ramdisk_cache(self, create_ramdisk_cache, **kwargs):  # noqa: E501
        """Create a Ramdisk cache profile  # noqa: E501

        Create a Ramdisk cache profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ramdisk_cache(create_ramdisk_cache, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateRamdiskCache create_ramdisk_cache: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateRamdiskCacheSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_ramdisk_cache_with_http_info(create_ramdisk_cache, **kwargs)  # noqa: E501

    def create_ramdisk_cache_with_http_info(self, create_ramdisk_cache, **kwargs):  # noqa: E501
        """Create a Ramdisk cache profile  # noqa: E501

        Create a Ramdisk cache profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ramdisk_cache_with_http_info(create_ramdisk_cache, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateRamdiskCache create_ramdisk_cache: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateRamdiskCacheSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_ramdisk_cache'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ramdisk_cache" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_ramdisk_cache' is set
        if self.api_client.client_side_validation and ('create_ramdisk_cache' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_ramdisk_cache'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_ramdisk_cache` when calling `create_ramdisk_cache`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_ramdisk_cache' in local_var_params:
            body_params = local_var_params['create_ramdisk_cache']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ramdiskcacheprofiles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateRamdiskCacheSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_requesttimeoutprofile(self, create_requesttimeoutprofile, **kwargs):  # noqa: E501
        """Create an request timeout profile  # noqa: E501

        Create a new request timeout profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_requesttimeoutprofile(create_requesttimeoutprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateRequesttimeoutprofile create_requesttimeoutprofile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateRequesttimeoutprofileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_requesttimeoutprofile_with_http_info(create_requesttimeoutprofile, **kwargs)  # noqa: E501

    def create_requesttimeoutprofile_with_http_info(self, create_requesttimeoutprofile, **kwargs):  # noqa: E501
        """Create an request timeout profile  # noqa: E501

        Create a new request timeout profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_requesttimeoutprofile_with_http_info(create_requesttimeoutprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateRequesttimeoutprofile create_requesttimeoutprofile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateRequesttimeoutprofileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_requesttimeoutprofile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_requesttimeoutprofile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_requesttimeoutprofile' is set
        if self.api_client.client_side_validation and ('create_requesttimeoutprofile' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_requesttimeoutprofile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_requesttimeoutprofile` when calling `create_requesttimeoutprofile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_requesttimeoutprofile' in local_var_params:
            body_params = local_var_params['create_requesttimeoutprofile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/requesttimeoutprofiles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateRequesttimeoutprofileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_scoringlist(self, create_scoringlist, **kwargs):  # noqa: E501
        """Create a scoringlist configuration  # noqa: E501

        Create a new scoringlist configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_scoringlist(create_scoringlist, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateScoringlist create_scoringlist: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateScoringlistSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_scoringlist_with_http_info(create_scoringlist, **kwargs)  # noqa: E501

    def create_scoringlist_with_http_info(self, create_scoringlist, **kwargs):  # noqa: E501
        """Create a scoringlist configuration  # noqa: E501

        Create a new scoringlist configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_scoringlist_with_http_info(create_scoringlist, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateScoringlist create_scoringlist: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateScoringlistSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_scoringlist'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_scoringlist" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_scoringlist' is set
        if self.api_client.client_side_validation and ('create_scoringlist' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_scoringlist'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_scoringlist` when calling `create_scoringlist`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_scoringlist' in local_var_params:
            body_params = local_var_params['create_scoringlist']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/scoringlist', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateScoringlistSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_scoringlist_exception(self, create_scoringlist_exception, **kwargs):  # noqa: E501
        """Create a scoringlist exception  # noqa: E501

        Create a new scoringlist exception  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_scoringlist_exception(create_scoringlist_exception, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateScoringlistException create_scoringlist_exception: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateScoringlistExceptionSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_scoringlist_exception_with_http_info(create_scoringlist_exception, **kwargs)  # noqa: E501

    def create_scoringlist_exception_with_http_info(self, create_scoringlist_exception, **kwargs):  # noqa: E501
        """Create a scoringlist exception  # noqa: E501

        Create a new scoringlist exception  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_scoringlist_exception_with_http_info(create_scoringlist_exception, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateScoringlistException create_scoringlist_exception: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateScoringlistExceptionSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_scoringlist_exception'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_scoringlist_exception" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_scoringlist_exception' is set
        if self.api_client.client_side_validation and ('create_scoringlist_exception' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_scoringlist_exception'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_scoringlist_exception` when calling `create_scoringlist_exception`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_scoringlist_exception' in local_var_params:
            body_params = local_var_params['create_scoringlist_exception']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/scoringlist/exceptions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateScoringlistExceptionSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_secondary_tunnel(self, create_secondary_tunnel, **kwargs):  # noqa: E501
        """Create a secondary tunnel  # noqa: E501

        Create a new secondary tunnel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_secondary_tunnel(create_secondary_tunnel, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateSecondaryTunnel create_secondary_tunnel: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateSecondaryTunnelSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_secondary_tunnel_with_http_info(create_secondary_tunnel, **kwargs)  # noqa: E501

    def create_secondary_tunnel_with_http_info(self, create_secondary_tunnel, **kwargs):  # noqa: E501
        """Create a secondary tunnel  # noqa: E501

        Create a new secondary tunnel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_secondary_tunnel_with_http_info(create_secondary_tunnel, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateSecondaryTunnel create_secondary_tunnel: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateSecondaryTunnelSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_secondary_tunnel'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_secondary_tunnel" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_secondary_tunnel' is set
        if self.api_client.client_side_validation and ('create_secondary_tunnel' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_secondary_tunnel'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_secondary_tunnel` when calling `create_secondary_tunnel`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_secondary_tunnel' in local_var_params:
            body_params = local_var_params['create_secondary_tunnel']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/secondarytunnels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSecondaryTunnelSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_security_exception_profile(self, create_security_exception_profile, **kwargs):  # noqa: E501
        """Create a Security Exception Profile  # noqa: E501

        Create a security exception profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_security_exception_profile(create_security_exception_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateSecurityExceptionProfile create_security_exception_profile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateSecurityExceptionProfileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_security_exception_profile_with_http_info(create_security_exception_profile, **kwargs)  # noqa: E501

    def create_security_exception_profile_with_http_info(self, create_security_exception_profile, **kwargs):  # noqa: E501
        """Create a Security Exception Profile  # noqa: E501

        Create a security exception profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_security_exception_profile_with_http_info(create_security_exception_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateSecurityExceptionProfile create_security_exception_profile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateSecurityExceptionProfileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_security_exception_profile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_security_exception_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_security_exception_profile' is set
        if self.api_client.client_side_validation and ('create_security_exception_profile' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_security_exception_profile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_security_exception_profile` when calling `create_security_exception_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_security_exception_profile' in local_var_params:
            body_params = local_var_params['create_security_exception_profile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securityexceptions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSecurityExceptionProfileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_sysctlprofile(self, create_sysctlprofile, **kwargs):  # noqa: E501
        """Create a Sysctl profile  # noqa: E501

        Create a new Sysctl profile<br> This item lets you manage profiles for configuring the Linux kernel TCP/IP stack. More details on sysctl parameters can be found on the Linux kernel documentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sysctlprofile(create_sysctlprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateSysctlprofile create_sysctlprofile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateSysctlprofileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_sysctlprofile_with_http_info(create_sysctlprofile, **kwargs)  # noqa: E501

    def create_sysctlprofile_with_http_info(self, create_sysctlprofile, **kwargs):  # noqa: E501
        """Create a Sysctl profile  # noqa: E501

        Create a new Sysctl profile<br> This item lets you manage profiles for configuring the Linux kernel TCP/IP stack. More details on sysctl parameters can be found on the Linux kernel documentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sysctlprofile_with_http_info(create_sysctlprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateSysctlprofile create_sysctlprofile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateSysctlprofileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_sysctlprofile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sysctlprofile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_sysctlprofile' is set
        if self.api_client.client_side_validation and ('create_sysctlprofile' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_sysctlprofile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_sysctlprofile` when calling `create_sysctlprofile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_sysctlprofile' in local_var_params:
            body_params = local_var_params['create_sysctlprofile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/sysctl', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSysctlprofileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_tunnel(self, create_tunnel, **kwargs):  # noqa: E501
        """Create a tunnel  # noqa: E501

        Create a new tunnel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tunnel(create_tunnel, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateTunnel create_tunnel: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreateTunnelSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_tunnel_with_http_info(create_tunnel, **kwargs)  # noqa: E501

    def create_tunnel_with_http_info(self, create_tunnel, **kwargs):  # noqa: E501
        """Create a tunnel  # noqa: E501

        Create a new tunnel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tunnel_with_http_info(create_tunnel, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateTunnel create_tunnel: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreateTunnelSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'create_tunnel'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tunnel" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_tunnel' is set
        if self.api_client.client_side_validation and ('create_tunnel' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_tunnel'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_tunnel` when calling `create_tunnel`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_tunnel' in local_var_params:
            body_params = local_var_params['create_tunnel']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tunnels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateTunnelSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_accesslogprofile(self, **kwargs):  # noqa: E501
        """Delete an access log profile  # noqa: E501

        Delete an access log profile. You must specify an access log profile uid or an profile name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_accesslogprofile(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Accesslog Profile uid.
        :param str name: Accesslog Profile name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelAccesslogprofileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_accesslogprofile_with_http_info(**kwargs)  # noqa: E501

    def del_accesslogprofile_with_http_info(self, **kwargs):  # noqa: E501
        """Delete an access log profile  # noqa: E501

        Delete an access log profile. You must specify an access log profile uid or an profile name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_accesslogprofile_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Accesslog Profile uid.
        :param str name: Accesslog Profile name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelAccesslogprofileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_accesslogprofile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/accesslogprofiles', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelAccesslogprofileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_alerting_destination(self, **kwargs):  # noqa: E501
        """Delete an alerting destination  # noqa: E501

        Delete an alerting destination. You must specify an alerting destination uid or an alerting destination name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_alerting_destination(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Alerting destination uid.
        :param str name: Alerting destination name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelAlertingDestinationSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_alerting_destination_with_http_info(**kwargs)  # noqa: E501

    def del_alerting_destination_with_http_info(self, **kwargs):  # noqa: E501
        """Delete an alerting destination  # noqa: E501

        Delete an alerting destination. You must specify an alerting destination uid or an alerting destination name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_alerting_destination_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Alerting destination uid.
        :param str name: Alerting destination name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelAlertingDestinationSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_alerting_destination" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alertingdestinations', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelAlertingDestinationSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_appliance(self, uid, **kwargs):  # noqa: E501
        """Delete an appliance  # noqa: E501

        Delete an appliance. You must specify an appliance uid or an appliance name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_appliance(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Appliance uid. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelApplianceSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_appliance_with_http_info(uid, **kwargs)  # noqa: E501

    def del_appliance_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete an appliance  # noqa: E501

        Delete an appliance. You must specify an appliance uid or an appliance name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_appliance_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Appliance uid. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelApplianceSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_appliance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_appliance`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/appliances', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelApplianceSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_blacklist(self, uid, **kwargs):  # noqa: E501
        """Delete a blacklist  # noqa: E501

        Delete a blacklist. You must specify a blacklist uid or a blacklist name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_blacklist(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Blacklist uid or name. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelBlacklistSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_blacklist_with_http_info(uid, **kwargs)  # noqa: E501

    def del_blacklist_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a blacklist  # noqa: E501

        Delete a blacklist. You must specify a blacklist uid or a blacklist name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_blacklist_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Blacklist uid or name. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelBlacklistSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_blacklist" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_blacklist`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blacklists', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelBlacklistSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_blacklist_exception(self, uid, **kwargs):  # noqa: E501
        """Delete a blacklist exception  # noqa: E501

        Delete a blacklist exception. You must specify a blacklist uid and a blacklist exception uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_blacklist_exception(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Uid of the new blacklist exception. (required)
        :param str blacklist_uid: Blacklist uid.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelBlacklistExceptionSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_blacklist_exception_with_http_info(uid, **kwargs)  # noqa: E501

    def del_blacklist_exception_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a blacklist exception  # noqa: E501

        Delete a blacklist exception. You must specify a blacklist uid and a blacklist exception uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_blacklist_exception_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Uid of the new blacklist exception. (required)
        :param str blacklist_uid: Blacklist uid.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelBlacklistExceptionSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'blacklist_uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_blacklist_exception" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_blacklist_exception`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'blacklist_uid' in local_var_params and local_var_params['blacklist_uid'] is not None:  # noqa: E501
            query_params.append(('blacklistUid', local_var_params['blacklist_uid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blacklists/exceptions', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelBlacklistExceptionSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_ca_certificate_bundle(self, uid, **kwargs):  # noqa: E501
        """Delete a CA certificates  # noqa: E501

        Delete a CA certificates. You must specify a CA certificate uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_ca_certificate_bundle(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: CA Certificate uid. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelCACertificateBundleSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_ca_certificate_bundle_with_http_info(uid, **kwargs)  # noqa: E501

    def del_ca_certificate_bundle_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a CA certificates  # noqa: E501

        Delete a CA certificates. You must specify a CA certificate uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_ca_certificate_bundle_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: CA Certificate uid. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelCACertificateBundleSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_ca_certificate_bundle" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_ca_certificate_bundle`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles/ca', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelCACertificateBundleSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_certificates_bundle(self, **kwargs):  # noqa: E501
        """Delete a certificates bundle  # noqa: E501

        Delete a certificates bundle. You must specify a certificates bundle uid or a certificates bundle name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_certificates_bundle(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the certificates bundle.
        :param str name: Name of the certificates bundle.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelCertificatesBundleSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_certificates_bundle_with_http_info(**kwargs)  # noqa: E501

    def del_certificates_bundle_with_http_info(self, **kwargs):  # noqa: E501
        """Delete a certificates bundle  # noqa: E501

        Delete a certificates bundle. You must specify a certificates bundle uid or a certificates bundle name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_certificates_bundle_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the certificates bundle.
        :param str name: Name of the certificates bundle.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelCertificatesBundleSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_certificates_bundle" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelCertificatesBundleSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_compression_profile(self, uid, **kwargs):  # noqa: E501
        """Delete a compression profile  # noqa: E501

        Delete a compression profile. You must specify a compression profile uid or a compression profile name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_compression_profile(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Compression profile uid or name. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelCompressionProfileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_compression_profile_with_http_info(uid, **kwargs)  # noqa: E501

    def del_compression_profile_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a compression profile  # noqa: E501

        Delete a compression profile. You must specify a compression profile uid or a compression profile name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_compression_profile_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Compression profile uid or name. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelCompressionProfileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_compression_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_compression_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/compressionprofiles', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelCompressionProfileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_crl_certificate_bundle(self, uid, **kwargs):  # noqa: E501
        """Delete a CRL certificates  # noqa: E501

        Delete a CRL certificates. You must specify a CRL certificate uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_crl_certificate_bundle(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: CRL Certificate uid. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelCRLCertificateBundleSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_crl_certificate_bundle_with_http_info(uid, **kwargs)  # noqa: E501

    def del_crl_certificate_bundle_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a CRL certificates  # noqa: E501

        Delete a CRL certificates. You must specify a CRL certificate uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_crl_certificate_bundle_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: CRL Certificate uid. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelCRLCertificateBundleSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_crl_certificate_bundle" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_crl_certificate_bundle`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles/crl', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelCRLCertificateBundleSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_icx(self, uid, **kwargs):  # noqa: E501
        """Delete an ICX configuration  # noqa: E501

        Delete an ICX configuration. You must specify an ICX configuration uid or a ICX configuration name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_icx(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: ICX configuration uid or name. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelIcxSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_icx_with_http_info(uid, **kwargs)  # noqa: E501

    def del_icx_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete an ICX configuration  # noqa: E501

        Delete an ICX configuration. You must specify an ICX configuration uid or a ICX configuration name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_icx_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: ICX configuration uid or name. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelIcxSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_icx" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_icx`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelIcxSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_icx_category(self, icx_uid, uid, **kwargs):  # noqa: E501
        """Delete an ICX Category  # noqa: E501

        Delete an ICX category. You must specify an ICX category uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_icx_category(icx_uid, uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str uid: ICX category uid. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelIcxCategorySuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_icx_category_with_http_info(icx_uid, uid, **kwargs)  # noqa: E501

    def del_icx_category_with_http_info(self, icx_uid, uid, **kwargs):  # noqa: E501
        """Delete an ICX Category  # noqa: E501

        Delete an ICX category. You must specify an ICX category uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_icx_category_with_http_info(icx_uid, uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str uid: ICX category uid. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelIcxCategorySuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'icx_uid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_icx_category" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'icx_uid' is set
        if self.api_client.client_side_validation and ('icx_uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['icx_uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `icx_uid` when calling `del_icx_category`")  # noqa: E501
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_icx_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'icx_uid' in local_var_params and local_var_params['icx_uid'] is not None:  # noqa: E501
            query_params.append(('icxUid', local_var_params['icx_uid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx/categories', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelIcxCategorySuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_icx_rule(self, icx_uid, category_uid, uid, **kwargs):  # noqa: E501
        """Delete an ICX Rule  # noqa: E501

        Delete an ICX rule. You must specify an ICX category uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_icx_rule(icx_uid, category_uid, uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str category_uid: ICX category uid. (required)
        :param str uid: ICX rule uid. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelIcxRuleSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_icx_rule_with_http_info(icx_uid, category_uid, uid, **kwargs)  # noqa: E501

    def del_icx_rule_with_http_info(self, icx_uid, category_uid, uid, **kwargs):  # noqa: E501
        """Delete an ICX Rule  # noqa: E501

        Delete an ICX rule. You must specify an ICX category uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_icx_rule_with_http_info(icx_uid, category_uid, uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str category_uid: ICX category uid. (required)
        :param str uid: ICX rule uid. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelIcxRuleSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'icx_uid',
            'category_uid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_icx_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'icx_uid' is set
        if self.api_client.client_side_validation and ('icx_uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['icx_uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `icx_uid` when calling `del_icx_rule`")  # noqa: E501
        # verify the required parameter 'category_uid' is set
        if self.api_client.client_side_validation and ('category_uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['category_uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `category_uid` when calling `del_icx_rule`")  # noqa: E501
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_icx_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'icx_uid' in local_var_params and local_var_params['icx_uid'] is not None:  # noqa: E501
            query_params.append(('icxUid', local_var_params['icx_uid']))  # noqa: E501
        if 'category_uid' in local_var_params and local_var_params['category_uid'] is not None:  # noqa: E501
            query_params.append(('categoryUid', local_var_params['category_uid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx/categories/rules', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelIcxRuleSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_label(self, uid, **kwargs):  # noqa: E501
        """Delete a label  # noqa: E501

        Delete a label. You must specify a label uid or a label name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_label(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Label uid or name. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelLabelSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_label_with_http_info(uid, **kwargs)  # noqa: E501

    def del_label_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a label  # noqa: E501

        Delete a label. You must specify a label uid or a label name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_label_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Label uid or name. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelLabelSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_label" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_label`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/labels', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelLabelSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_normalization(self, uid, **kwargs):  # noqa: E501
        """Delete a normalization configuration  # noqa: E501

        Delete a normalization configuration. You must specify a normalization configuration uid or a normalization configuration name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_normalization(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Normalization configuration uid or name. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelNormalizationSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_normalization_with_http_info(uid, **kwargs)  # noqa: E501

    def del_normalization_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a normalization configuration  # noqa: E501

        Delete a normalization configuration. You must specify a normalization configuration uid or a normalization configuration name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_normalization_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Normalization configuration uid or name. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelNormalizationSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_normalization" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_normalization`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/normalization', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelNormalizationSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_ntp(self, uid, **kwargs):  # noqa: E501
        """Delete a ntp  # noqa: E501

        Delete a ntp. You must specify a ntp uid or a ntp name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_ntp(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Ntp uid or name. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelNtpSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_ntp_with_http_info(uid, **kwargs)  # noqa: E501

    def del_ntp_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a ntp  # noqa: E501

        Delete a ntp. You must specify a ntp uid or a ntp name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_ntp_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Ntp uid or name. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelNtpSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_ntp" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_ntp`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ntp', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelNtpSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_ocsp_certificate_bundle(self, uid, **kwargs):  # noqa: E501
        """Delete a OCSP certificates  # noqa: E501

        Delete a OCSP certificates. You must specify a OCSP certificate uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_ocsp_certificate_bundle(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: OCSP Certificate uid. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelOCSPCertificateBundleSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_ocsp_certificate_bundle_with_http_info(uid, **kwargs)  # noqa: E501

    def del_ocsp_certificate_bundle_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a OCSP certificates  # noqa: E501

        Delete a OCSP certificates. You must specify a OCSP certificate uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_ocsp_certificate_bundle_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: OCSP Certificate uid. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelOCSPCertificateBundleSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_ocsp_certificate_bundle" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_ocsp_certificate_bundle`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles/ocsp', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelOCSPCertificateBundleSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_ramdisk_cache(self, uid, **kwargs):  # noqa: E501
        """Delete a Ramdisk cache  # noqa: E501

        Delete a label. You must specify a Ramdisk cache uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_ramdisk_cache(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Ramdisk cache uid or name. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelRamdiskCacheSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_ramdisk_cache_with_http_info(uid, **kwargs)  # noqa: E501

    def del_ramdisk_cache_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a Ramdisk cache  # noqa: E501

        Delete a label. You must specify a Ramdisk cache uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_ramdisk_cache_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Ramdisk cache uid or name. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelRamdiskCacheSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_ramdisk_cache" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_ramdisk_cache`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ramdiskcacheprofiles', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelRamdiskCacheSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_requesttimeoutprofile(self, uid, **kwargs):  # noqa: E501
        """Delete an request timeout profile  # noqa: E501

        Delete an request timeout profile. You must specify an request timeout profile uid or an profile name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_requesttimeoutprofile(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Accesslog Profile uid or name. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelRequesttimeoutprofileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_requesttimeoutprofile_with_http_info(uid, **kwargs)  # noqa: E501

    def del_requesttimeoutprofile_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete an request timeout profile  # noqa: E501

        Delete an request timeout profile. You must specify an request timeout profile uid or an profile name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_requesttimeoutprofile_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Accesslog Profile uid or name. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelRequesttimeoutprofileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_requesttimeoutprofile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_requesttimeoutprofile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/requesttimeoutprofiles', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelRequesttimeoutprofileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_scoringlist(self, uid, **kwargs):  # noqa: E501
        """Delete a scoringlist configuration  # noqa: E501

        Delete a scoringlist. You must specify a scoringlist configuration uid or a scoringlist configuration name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_scoringlist(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Scoringlist configuration uid or name. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelScoringlistSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_scoringlist_with_http_info(uid, **kwargs)  # noqa: E501

    def del_scoringlist_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a scoringlist configuration  # noqa: E501

        Delete a scoringlist. You must specify a scoringlist configuration uid or a scoringlist configuration name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_scoringlist_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Scoringlist configuration uid or name. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelScoringlistSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_scoringlist" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_scoringlist`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/scoringlist', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelScoringlistSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_scoringlist_exception(self, uid, **kwargs):  # noqa: E501
        """Delete a scoringlist exception  # noqa: E501

        Delete a scoringlist exception. You must specify a scoringlist uid and a scoringlist exception uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_scoringlist_exception(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Uid of the new scoringlist exception. (required)
        :param str scoringlist_uid: Scoringlist uid.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelScoringlistExceptionSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_scoringlist_exception_with_http_info(uid, **kwargs)  # noqa: E501

    def del_scoringlist_exception_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a scoringlist exception  # noqa: E501

        Delete a scoringlist exception. You must specify a scoringlist uid and a scoringlist exception uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_scoringlist_exception_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Uid of the new scoringlist exception. (required)
        :param str scoringlist_uid: Scoringlist uid.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelScoringlistExceptionSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'scoringlist_uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_scoringlist_exception" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_scoringlist_exception`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scoringlist_uid' in local_var_params and local_var_params['scoringlist_uid'] is not None:  # noqa: E501
            query_params.append(('scoringlistUid', local_var_params['scoringlist_uid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/scoringlist/exceptions', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelScoringlistExceptionSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_secondadry_tunnel(self, uid, **kwargs):  # noqa: E501
        """Delete a secondary tunnel  # noqa: E501

        Delete a secondary tunnel. You must specify a secondary tunnel uid or a secondary tunnel name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_secondadry_tunnel(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Secondary Tunnel uid. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelSecondadryTunnelSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_secondadry_tunnel_with_http_info(uid, **kwargs)  # noqa: E501

    def del_secondadry_tunnel_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a secondary tunnel  # noqa: E501

        Delete a secondary tunnel. You must specify a secondary tunnel uid or a secondary tunnel name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_secondadry_tunnel_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Secondary Tunnel uid. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelSecondadryTunnelSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_secondadry_tunnel" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_secondadry_tunnel`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/secondarytunnels', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelSecondadryTunnelSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_security_exception_profile(self, uid, **kwargs):  # noqa: E501
        """Delete a security exception profile  # noqa: E501

        Delete a security exception profile. You must specify a security exception profile uid or an profile name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_security_exception_profile(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: security exception profile uid or name. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelSecurityExceptionProfileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_security_exception_profile_with_http_info(uid, **kwargs)  # noqa: E501

    def del_security_exception_profile_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a security exception profile  # noqa: E501

        Delete a security exception profile. You must specify a security exception profile uid or an profile name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_security_exception_profile_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: security exception profile uid or name. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelSecurityExceptionProfileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_security_exception_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_security_exception_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securityexceptions', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelSecurityExceptionProfileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_sysctlprofile(self, uid, **kwargs):  # noqa: E501
        """Delete a Sysctl profile  # noqa: E501

        Delete a Sysctl profile. You must specify a Sysctl profile uid or a Sysctl profile name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_sysctlprofile(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Sysctl profile uid or name. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelSysctlprofileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_sysctlprofile_with_http_info(uid, **kwargs)  # noqa: E501

    def del_sysctlprofile_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a Sysctl profile  # noqa: E501

        Delete a Sysctl profile. You must specify a Sysctl profile uid or a Sysctl profile name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_sysctlprofile_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Sysctl profile uid or name. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelSysctlprofileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_sysctlprofile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_sysctlprofile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/sysctl', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelSysctlprofileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def del_tunnel(self, uid, **kwargs):  # noqa: E501
        """Delete a tunnel  # noqa: E501

        Delete a tunnel. You must specify a tunnel uid or a tunnel name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_tunnel(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Tunnel uid. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DelTunnelSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.del_tunnel_with_http_info(uid, **kwargs)  # noqa: E501

    def del_tunnel_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a tunnel  # noqa: E501

        Delete a tunnel. You must specify a tunnel uid or a tunnel name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.del_tunnel_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Tunnel uid. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DelTunnelSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method del_tunnel" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `del_tunnel`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tunnels', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DelTunnelSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_certificate(self, uid, **kwargs):  # noqa: E501
        """Delete a certificate  # noqa: E501

        Delete a certificate. You must specify a certificate uid or a certificate name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_certificate(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Select certificate to delete (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeleteCertificateSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_certificate_with_http_info(uid, **kwargs)  # noqa: E501

    def delete_certificate_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a certificate  # noqa: E501

        Delete a certificate. You must specify a certificate uid or a certificate name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_certificate_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Select certificate to delete (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeleteCertificateSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_certificate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `delete_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificates', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteCertificateSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_networ_interface(self, uid, **kwargs):  # noqa: E501
        """Delete a network interface  # noqa: E501

        Delete a network interface. You must specify a network interface uid or a network interface name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_networ_interface(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: The network interface's UID we want to delete. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeleteNetworInterfaceSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_networ_interface_with_http_info(uid, **kwargs)  # noqa: E501

    def delete_networ_interface_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a network interface  # noqa: E501

        Delete a network interface. You must specify a network interface uid or a network interface name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_networ_interface_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: The network interface's UID we want to delete. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeleteNetworInterfaceSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_networ_interface" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `delete_networ_interface`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/networkdevices/interfaces', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteNetworInterfaceSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_reverse_proxies(self, uid, **kwargs):  # noqa: E501
        """Delete a reverse proxy  # noqa: E501

        Delete a reverse proxy. You must specify a reverse proxy uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_reverse_proxies(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: The reverse proxy's UID we want to delete. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeleteReverseProxiesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_reverse_proxies_with_http_info(uid, **kwargs)  # noqa: E501

    def delete_reverse_proxies_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a reverse proxy  # noqa: E501

        Delete a reverse proxy. You must specify a reverse proxy uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_reverse_proxies_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: The reverse proxy's UID we want to delete. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeleteReverseProxiesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_reverse_proxies" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `delete_reverse_proxies`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/reverseproxies', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteReverseProxiesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_reverse_proxy_profile(self, uid, **kwargs):  # noqa: E501
        """Delete a reverse proxy profile  # noqa: E501

        Delete a reverse proxy profile. You must specify a reverse proxy profile uid or a reverse proxy profile name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_reverse_proxy_profile(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Select Reverse proxy profile to delete (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeleteReverseProxyProfileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_reverse_proxy_profile_with_http_info(uid, **kwargs)  # noqa: E501

    def delete_reverse_proxy_profile_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a reverse proxy profile  # noqa: E501

        Delete a reverse proxy profile. You must specify a reverse proxy profile uid or a reverse proxy profile name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_reverse_proxy_profile_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Select Reverse proxy profile to delete (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeleteReverseProxyProfileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_reverse_proxy_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `delete_reverse_proxy_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/reverseproxyprofiles', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteReverseProxyProfileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deletesslprofiles(self, uid, **kwargs):  # noqa: E501
        """Delete a SSL Profile  # noqa: E501

        Delete a SSL Profile. You must specify a SSL Profile uid or a SSL Profile name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deletesslprofiles(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Select SSL Profile to delete (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeletesslprofilesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deletesslprofiles_with_http_info(uid, **kwargs)  # noqa: E501

    def deletesslprofiles_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Delete a SSL Profile  # noqa: E501

        Delete a SSL Profile. You must specify a SSL Profile uid or a SSL Profile name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deletesslprofiles_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Select SSL Profile to delete (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeletesslprofilesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletesslprofiles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `deletesslprofiles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/sslprofiles', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeletesslprofilesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_ca_certificate(self, uid, **kwargs):  # noqa: E501
        """Download CA Certificates File  # noqa: E501

        Download the special CA certificate file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_ca_certificate(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: CA certificate uid. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DownloadCACertificateSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.download_ca_certificate_with_http_info(uid, **kwargs)  # noqa: E501

    def download_ca_certificate_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Download CA Certificates File  # noqa: E501

        Download the special CA certificate file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_ca_certificate_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: CA certificate uid. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DownloadCACertificateSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_ca_certificate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `download_ca_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles/ca/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DownloadCACertificateSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_caocsp_certificate(self, uid, **kwargs):  # noqa: E501
        """Download CAOCSP Certificates File  # noqa: E501

        Download the special CAOCSP certificate file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_caocsp_certificate(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: CAOCSP certificate uid. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DownloadCAOCSPCertificateSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.download_caocsp_certificate_with_http_info(uid, **kwargs)  # noqa: E501

    def download_caocsp_certificate_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Download CAOCSP Certificates File  # noqa: E501

        Download the special CAOCSP certificate file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_caocsp_certificate_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: CAOCSP certificate uid. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DownloadCAOCSPCertificateSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_caocsp_certificate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `download_caocsp_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles/ocsp/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DownloadCAOCSPCertificateSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_certificate(self, uid, **kwargs):  # noqa: E501
        """Download certificate File  # noqa: E501

        Download the special certificate file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_certificate(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Certificate uid. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DownloadCertificateSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.download_certificate_with_http_info(uid, **kwargs)  # noqa: E501

    def download_certificate_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Download certificate File  # noqa: E501

        Download the special certificate file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_certificate_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Certificate uid. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DownloadCertificateSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_certificate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `download_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificates/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DownloadCertificateSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_crl_certificate(self, uid, **kwargs):  # noqa: E501
        """Download CRL Certificates File  # noqa: E501

        Download the special CRL certificate file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_crl_certificate(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: CRL certificate uid. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DownloadCRLCertificateSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.download_crl_certificate_with_http_info(uid, **kwargs)  # noqa: E501

    def download_crl_certificate_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Download CRL Certificates File  # noqa: E501

        Download the special CRL certificate file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_crl_certificate_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: CRL certificate uid. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DownloadCRLCertificateSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_crl_certificate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `download_crl_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles/crl/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DownloadCRLCertificateSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_log_filter(self, uid, **kwargs):  # noqa: E501
        """Download LogFilter File  # noqa: E501

        Download the special logfilter file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_log_filter(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: logfilter's uid. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DownloadLogFilterSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.download_log_filter_with_http_info(uid, **kwargs)  # noqa: E501

    def download_log_filter_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Download LogFilter File  # noqa: E501

        Download the special logfilter file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_log_filter_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: logfilter's uid. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DownloadLogFilterSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_log_filter" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `download_log_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/logfilters/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DownloadLogFilterSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def file_upload(self, **kwargs):  # noqa: E501
        """Send a file  # noqa: E501

        Create a temporary file to be used later by the api, The file expire after 30 secondes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_upload(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param file file:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileUploadSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.file_upload_with_http_info(**kwargs)  # noqa: E501

    def file_upload_with_http_info(self, **kwargs):  # noqa: E501
        """Send a file  # noqa: E501

        Create a temporary file to be used later by the api, The file expire after 30 secondes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_upload_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param file file:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileUploadSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method file_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileUploadSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_access_log_profiles(self, **kwargs):  # noqa: E501
        """Get access log profiles  # noqa: E501

        Get access log profiles. You can specify an access log profile uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access_log_profiles(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Access log Profile uid.
        :param str name: Access log Profile name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetAccessLogProfilesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_access_log_profiles_with_http_info(**kwargs)  # noqa: E501

    def get_access_log_profiles_with_http_info(self, **kwargs):  # noqa: E501
        """Get access log profiles  # noqa: E501

        Get access log profiles. You can specify an access log profile uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access_log_profiles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Access log Profile uid.
        :param str name: Access log Profile name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetAccessLogProfilesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_access_log_profiles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/accesslogprofiles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAccessLogProfilesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alertingdestinations(self, **kwargs):  # noqa: E501
        """Get alerting destinations  # noqa: E501

        Get alerting destinations. You can specify an alerting destination uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alertingdestinations(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Alerting destination uid.
        :param str name: Alerting destination name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetAlertingdestinationsSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_alertingdestinations_with_http_info(**kwargs)  # noqa: E501

    def get_alertingdestinations_with_http_info(self, **kwargs):  # noqa: E501
        """Get alerting destinations  # noqa: E501

        Get alerting destinations. You can specify an alerting destination uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alertingdestinations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Alerting destination uid.
        :param str name: Alerting destination name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetAlertingdestinationsSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alertingdestinations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alertingdestinations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAlertingdestinationsSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_appliances(self, **kwargs):  # noqa: E501
        """Get appliances  # noqa: E501

        Get appliances. You can specify an appliance uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_appliances(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Appliance name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetAppliancesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_appliances_with_http_info(**kwargs)  # noqa: E501

    def get_appliances_with_http_info(self, **kwargs):  # noqa: E501
        """Get appliances  # noqa: E501

        Get appliances. You can specify an appliance uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_appliances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Appliance name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetAppliancesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_appliances" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/appliances', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAppliancesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_blacklist_exceptions(self, uid, **kwargs):  # noqa: E501
        """Get blacklist exceptions  # noqa: E501

        Get blacklist exceptions. You have to set a specify blacklist uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_blacklist_exceptions(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Blacklist exception uid (uid) or Blacklist uid (blacklistUid). (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetBlacklistExceptionsSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_blacklist_exceptions_with_http_info(uid, **kwargs)  # noqa: E501

    def get_blacklist_exceptions_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Get blacklist exceptions  # noqa: E501

        Get blacklist exceptions. You have to set a specify blacklist uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_blacklist_exceptions_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Blacklist exception uid (uid) or Blacklist uid (blacklistUid). (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetBlacklistExceptionsSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_blacklist_exceptions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `get_blacklist_exceptions`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blacklists/exceptions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetBlacklistExceptionsSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_blacklist_templates(self, **kwargs):  # noqa: E501
        """Get blacklist templates  # noqa: E501

        Get blacklist templates. You can specify a blacklist template uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_blacklist_templates(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Blacklist template uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetBlacklistTemplatesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_blacklist_templates_with_http_info(**kwargs)  # noqa: E501

    def get_blacklist_templates_with_http_info(self, **kwargs):  # noqa: E501
        """Get blacklist templates  # noqa: E501

        Get blacklist templates. You can specify a blacklist template uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_blacklist_templates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Blacklist template uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetBlacklistTemplatesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_blacklist_templates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blacklisttemplates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetBlacklistTemplatesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_blacklists(self, **kwargs):  # noqa: E501
        """Get blacklists  # noqa: E501

        Get blacklists. You can specify a blacklist uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_blacklists(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Blacklist uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetBlacklistsSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_blacklists_with_http_info(**kwargs)  # noqa: E501

    def get_blacklists_with_http_info(self, **kwargs):  # noqa: E501
        """Get blacklists  # noqa: E501

        Get blacklists. You can specify a blacklist uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_blacklists_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Blacklist uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetBlacklistsSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_blacklists" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blacklists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetBlacklistsSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ca_certificates(self, **kwargs):  # noqa: E501
        """Get CA certificates of bundle  # noqa: E501

        Get CA certificates. You can specify a certificate bundle uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ca_certificates(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str bundle_uid: Certificate Bundle uid or CA Certificates uid. The bundleUid is required when filtering with uid.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetCACertificatesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_ca_certificates_with_http_info(**kwargs)  # noqa: E501

    def get_ca_certificates_with_http_info(self, **kwargs):  # noqa: E501
        """Get CA certificates of bundle  # noqa: E501

        Get CA certificates. You can specify a certificate bundle uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ca_certificates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str bundle_uid: Certificate Bundle uid or CA Certificates uid. The bundleUid is required when filtering with uid.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetCACertificatesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'bundle_uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ca_certificates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'bundle_uid' in local_var_params and local_var_params['bundle_uid'] is not None:  # noqa: E501
            query_params.append(('bundleUid', local_var_params['bundle_uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles/ca', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetCACertificatesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_certificates(self, **kwargs):  # noqa: E501
        """Get certificates  # noqa: E501

        Get certificates. You can specify a certificates uid or name. You can also filter by label uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_certificates(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Return a filtered list
        :param str label_name: Return a list that is filtered by label
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetCertificatesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_certificates_with_http_info(**kwargs)  # noqa: E501

    def get_certificates_with_http_info(self, **kwargs):  # noqa: E501
        """Get certificates  # noqa: E501

        Get certificates. You can specify a certificates uid or name. You can also filter by label uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_certificates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Return a filtered list
        :param str label_name: Return a list that is filtered by label
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetCertificatesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name',
            'label_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_certificates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'label_name' in local_var_params and local_var_params['label_name'] is not None:  # noqa: E501
            query_params.append(('labelName', local_var_params['label_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetCertificatesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_certificates_bundles(self, **kwargs):  # noqa: E501
        """Get certificates bundles  # noqa: E501

        Get certificates bundles. You can specify a certificates bundle uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_certificates_bundles(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Certificates Bundle uid.
        :param str name: Certificates Bundle name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetCertificatesBundlesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_certificates_bundles_with_http_info(**kwargs)  # noqa: E501

    def get_certificates_bundles_with_http_info(self, **kwargs):  # noqa: E501
        """Get certificates bundles  # noqa: E501

        Get certificates bundles. You can specify a certificates bundle uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_certificates_bundles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Certificates Bundle uid.
        :param str name: Certificates Bundle name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetCertificatesBundlesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_certificates_bundles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetCertificatesBundlesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_compression_profiles(self, **kwargs):  # noqa: E501
        """Get compression profiles  # noqa: E501

        Get compression profiles. You can specify a compression profile uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_compression_profiles(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Compression profile uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetCompressionProfilesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_compression_profiles_with_http_info(**kwargs)  # noqa: E501

    def get_compression_profiles_with_http_info(self, **kwargs):  # noqa: E501
        """Get compression profiles  # noqa: E501

        Get compression profiles. You can specify a compression profile uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_compression_profiles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Compression profile uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetCompressionProfilesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_compression_profiles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/compressionprofiles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetCompressionProfilesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_crl_certificates(self, **kwargs):  # noqa: E501
        """Get CRL certificates of bundle  # noqa: E501

        Get CRL certificates. You can specify a certificate bundle uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crl_certificates(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str bundle_uid: Certificate Bundle uid or CRL Certificates uid. The bundleUid is required when filtering with uid.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetCRLCertificatesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_crl_certificates_with_http_info(**kwargs)  # noqa: E501

    def get_crl_certificates_with_http_info(self, **kwargs):  # noqa: E501
        """Get CRL certificates of bundle  # noqa: E501

        Get CRL certificates. You can specify a certificate bundle uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crl_certificates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str bundle_uid: Certificate Bundle uid or CRL Certificates uid. The bundleUid is required when filtering with uid.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetCRLCertificatesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'bundle_uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crl_certificates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'bundle_uid' in local_var_params and local_var_params['bundle_uid'] is not None:  # noqa: E501
            query_params.append(('bundleUid', local_var_params['bundle_uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles/crl', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetCRLCertificatesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_icx(self, **kwargs):  # noqa: E501
        """Get ICX configurations  # noqa: E501

        Get ICX. You can specify an ICX configuration uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_icx(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: ICX configuration uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetIcxSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_icx_with_http_info(**kwargs)  # noqa: E501

    def get_icx_with_http_info(self, **kwargs):  # noqa: E501
        """Get ICX configurations  # noqa: E501

        Get ICX. You can specify an ICX configuration uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_icx_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: ICX configuration uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetIcxSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_icx" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetIcxSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_icx_categories(self, icx_uid, **kwargs):  # noqa: E501
        """Get ICX Categories  # noqa: E501

        Get ICX Categories. You can specify an ICX categories uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_icx_categories(icx_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str name: ICX categories name or uid.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetIcxCategoriesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_icx_categories_with_http_info(icx_uid, **kwargs)  # noqa: E501

    def get_icx_categories_with_http_info(self, icx_uid, **kwargs):  # noqa: E501
        """Get ICX Categories  # noqa: E501

        Get ICX Categories. You can specify an ICX categories uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_icx_categories_with_http_info(icx_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str name: ICX categories name or uid.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetIcxCategoriesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'icx_uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_icx_categories" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'icx_uid' is set
        if self.api_client.client_side_validation and ('icx_uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['icx_uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `icx_uid` when calling `get_icx_categories`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'icx_uid' in local_var_params and local_var_params['icx_uid'] is not None:  # noqa: E501
            query_params.append(('icxUid', local_var_params['icx_uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx/categories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetIcxCategoriesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_icx_filter_pattern(self, **kwargs):  # noqa: E501
        """Get all ICX filter pattern  # noqa: E501

        Get ICX templates. You can specify an ICX template uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_icx_filter_pattern(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: ICX filter pattern uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetIcxFilterPatternSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_icx_filter_pattern_with_http_info(**kwargs)  # noqa: E501

    def get_icx_filter_pattern_with_http_info(self, **kwargs):  # noqa: E501
        """Get all ICX filter pattern  # noqa: E501

        Get ICX templates. You can specify an ICX template uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_icx_filter_pattern_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: ICX filter pattern uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetIcxFilterPatternSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_icx_filter_pattern" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx/pattern', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetIcxFilterPatternSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_icx_rules(self, icx_uid, category_uid, **kwargs):  # noqa: E501
        """Get ICX Rules  # noqa: E501

        Get ICX Rules. You can specify an ICX rules uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_icx_rules(icx_uid, category_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str category_uid: ICX category uid. (required)
        :param str name: ICX rules uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetIcxRulesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_icx_rules_with_http_info(icx_uid, category_uid, **kwargs)  # noqa: E501

    def get_icx_rules_with_http_info(self, icx_uid, category_uid, **kwargs):  # noqa: E501
        """Get ICX Rules  # noqa: E501

        Get ICX Rules. You can specify an ICX rules uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_icx_rules_with_http_info(icx_uid, category_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str category_uid: ICX category uid. (required)
        :param str name: ICX rules uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetIcxRulesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'icx_uid',
            'category_uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_icx_rules" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'icx_uid' is set
        if self.api_client.client_side_validation and ('icx_uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['icx_uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `icx_uid` when calling `get_icx_rules`")  # noqa: E501
        # verify the required parameter 'category_uid' is set
        if self.api_client.client_side_validation and ('category_uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['category_uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `category_uid` when calling `get_icx_rules`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'icx_uid' in local_var_params and local_var_params['icx_uid'] is not None:  # noqa: E501
            query_params.append(('icxUid', local_var_params['icx_uid']))  # noqa: E501
        if 'category_uid' in local_var_params and local_var_params['category_uid'] is not None:  # noqa: E501
            query_params.append(('categoryUid', local_var_params['category_uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx/categories/rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetIcxRulesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_icx_templates(self, **kwargs):  # noqa: E501
        """Get ICX templates  # noqa: E501

        Get ICX templates. You can specify an ICX template uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_icx_templates(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: ICX template uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetIcxTemplatesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_icx_templates_with_http_info(**kwargs)  # noqa: E501

    def get_icx_templates_with_http_info(self, **kwargs):  # noqa: E501
        """Get ICX templates  # noqa: E501

        Get ICX templates. You can specify an ICX template uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_icx_templates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: ICX template uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetIcxTemplatesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_icx_templates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icxtemplates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetIcxTemplatesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_labels(self, **kwargs):  # noqa: E501
        """Get labels  # noqa: E501

        Get labels. You can specify a label uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_labels(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Label uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetLabelsSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_labels_with_http_info(**kwargs)  # noqa: E501

    def get_labels_with_http_info(self, **kwargs):  # noqa: E501
        """Get labels  # noqa: E501

        Get labels. You can specify a label uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_labels_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Label uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetLabelsSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_labels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetLabelsSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_licenses(self, **kwargs):  # noqa: E501
        """Get licenses  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_licenses(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetLicensesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_licenses_with_http_info(**kwargs)  # noqa: E501

    def get_licenses_with_http_info(self, **kwargs):  # noqa: E501
        """Get licenses  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_licenses_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetLicensesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_licenses" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/licenses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetLicensesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_log_filter(self, **kwargs):  # noqa: E501
        """Get LogFilters  # noqa: E501

        Get logfilters. You can specify a LogFilter uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_log_filter(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: logfilter uid.
        :param str name: logfilter name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetLogFilterSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_log_filter_with_http_info(**kwargs)  # noqa: E501

    def get_log_filter_with_http_info(self, **kwargs):  # noqa: E501
        """Get LogFilters  # noqa: E501

        Get logfilters. You can specify a LogFilter uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_log_filter_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: logfilter uid.
        :param str name: logfilter name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetLogFilterSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_log_filter" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/logfilters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetLogFilterSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_network_devices(self, **kwargs):  # noqa: E501
        """Get network devices  # noqa: E501

        Get network devices. You can specify a network devices uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_devices(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the network devices.
        :param str appliance_uid: Appliance uid of the network devices.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetNetworkDevicesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_network_devices_with_http_info(**kwargs)  # noqa: E501

    def get_network_devices_with_http_info(self, **kwargs):  # noqa: E501
        """Get network devices  # noqa: E501

        Get network devices. You can specify a network devices uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_devices_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the network devices.
        :param str appliance_uid: Appliance uid of the network devices.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetNetworkDevicesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'appliance_uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_network_devices" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'appliance_uid' in local_var_params and local_var_params['appliance_uid'] is not None:  # noqa: E501
            query_params.append(('applianceUid', local_var_params['appliance_uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/networkdevices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetNetworkDevicesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_network_interfaces(self, **kwargs):  # noqa: E501
        """Get network interfaces  # noqa: E501

        Get network interfaces. You can specify a network interfaces uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_interfaces(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Identifier of the network interfaces.
        :param str appliance_uid: Appliance uid of the network interface.
        :param str ip: Filter on a specific IP. We can use wildcard like 192.168.0.*
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetNetworkInterfacesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_network_interfaces_with_http_info(**kwargs)  # noqa: E501

    def get_network_interfaces_with_http_info(self, **kwargs):  # noqa: E501
        """Get network interfaces  # noqa: E501

        Get network interfaces. You can specify a network interfaces uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_interfaces_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Identifier of the network interfaces.
        :param str appliance_uid: Appliance uid of the network interface.
        :param str ip: Filter on a specific IP. We can use wildcard like 192.168.0.*
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetNetworkInterfacesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name',
            'appliance_uid',
            'ip'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_network_interfaces" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'appliance_uid' in local_var_params and local_var_params['appliance_uid'] is not None:  # noqa: E501
            query_params.append(('applianceUid', local_var_params['appliance_uid']))  # noqa: E501
        if 'ip' in local_var_params and local_var_params['ip'] is not None:  # noqa: E501
            query_params.append(('ip', local_var_params['ip']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/networkdevices/interfaces', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetNetworkInterfacesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_normalization(self, **kwargs):  # noqa: E501
        """Get normalization configurations  # noqa: E501

        Get Normalization. You can specify an normalization configuration uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_normalization(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Normalization configuration uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetNormalizationSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_normalization_with_http_info(**kwargs)  # noqa: E501

    def get_normalization_with_http_info(self, **kwargs):  # noqa: E501
        """Get normalization configurations  # noqa: E501

        Get Normalization. You can specify an normalization configuration uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_normalization_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Normalization configuration uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetNormalizationSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_normalization" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/normalization', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetNormalizationSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ntps(self, **kwargs):  # noqa: E501
        """Get ntps  # noqa: E501

        Get ntps. You can specify a ntp uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ntps(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Ntp name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetNtpsSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_ntps_with_http_info(**kwargs)  # noqa: E501

    def get_ntps_with_http_info(self, **kwargs):  # noqa: E501
        """Get ntps  # noqa: E501

        Get ntps. You can specify a ntp uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ntps_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Ntp name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetNtpsSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ntps" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ntp', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetNtpsSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ocsp_certificates(self, **kwargs):  # noqa: E501
        """Get OCSP certificates of bundle  # noqa: E501

        Get OCSP certificates. You can specify a certificate bundle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ocsp_certificates(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str bundle_uid: Certificate Bundle uid or OCSP Certificates uid. The bundleUid is required when filtering with uid.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetOCSPCertificatesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_ocsp_certificates_with_http_info(**kwargs)  # noqa: E501

    def get_ocsp_certificates_with_http_info(self, **kwargs):  # noqa: E501
        """Get OCSP certificates of bundle  # noqa: E501

        Get OCSP certificates. You can specify a certificate bundle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ocsp_certificates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str bundle_uid: Certificate Bundle uid or OCSP Certificates uid. The bundleUid is required when filtering with uid.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetOCSPCertificatesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'bundle_uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ocsp_certificates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'bundle_uid' in local_var_params and local_var_params['bundle_uid'] is not None:  # noqa: E501
            query_params.append(('bundleUid', local_var_params['bundle_uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles/ocsp', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetOCSPCertificatesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ramdisk_cache(self, **kwargs):  # noqa: E501
        """Get Ramdisk cache profile  # noqa: E501

        Get Ramdisk cache profiles. You can specify a Ramdisk cache profile uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ramdisk_cache(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Ramdisk cache profile uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetRamdiskCacheSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_ramdisk_cache_with_http_info(**kwargs)  # noqa: E501

    def get_ramdisk_cache_with_http_info(self, **kwargs):  # noqa: E501
        """Get Ramdisk cache profile  # noqa: E501

        Get Ramdisk cache profiles. You can specify a Ramdisk cache profile uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ramdisk_cache_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Ramdisk cache profile uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetRamdiskCacheSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ramdisk_cache" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ramdiskcacheprofiles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetRamdiskCacheSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_requesttimeoutprofiles(self, **kwargs):  # noqa: E501
        """Get request timeout profiles  # noqa: E501

        Get request timeout profiles. You can specify an request timeout profile uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_requesttimeoutprofiles(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: request timeout Profile uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetRequesttimeoutprofilesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_requesttimeoutprofiles_with_http_info(**kwargs)  # noqa: E501

    def get_requesttimeoutprofiles_with_http_info(self, **kwargs):  # noqa: E501
        """Get request timeout profiles  # noqa: E501

        Get request timeout profiles. You can specify an request timeout profile uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_requesttimeoutprofiles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: request timeout Profile uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetRequesttimeoutprofilesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_requesttimeoutprofiles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/requesttimeoutprofiles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetRequesttimeoutprofilesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_reverse_proxies(self, **kwargs):  # noqa: E501
        """Get reverse proxies  # noqa: E501

        Get reverse proxies. You can specify a reverse proxy uid or name. You can also filter by label uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reverse_proxies(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the reverse proxies.
        :param str name: Name identifier of the reverse proxies.
        :param str label_uid: Label uid.
        :param str label_name: Label name.
        :param str appliance_uid: Appliance uid of the reverse proxies
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetReverseProxiesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_reverse_proxies_with_http_info(**kwargs)  # noqa: E501

    def get_reverse_proxies_with_http_info(self, **kwargs):  # noqa: E501
        """Get reverse proxies  # noqa: E501

        Get reverse proxies. You can specify a reverse proxy uid or name. You can also filter by label uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reverse_proxies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the reverse proxies.
        :param str name: Name identifier of the reverse proxies.
        :param str label_uid: Label uid.
        :param str label_name: Label name.
        :param str appliance_uid: Appliance uid of the reverse proxies
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetReverseProxiesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'name',
            'label_uid',
            'label_name',
            'appliance_uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reverse_proxies" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'label_uid' in local_var_params and local_var_params['label_uid'] is not None:  # noqa: E501
            query_params.append(('labelUid', local_var_params['label_uid']))  # noqa: E501
        if 'label_name' in local_var_params and local_var_params['label_name'] is not None:  # noqa: E501
            query_params.append(('labelName', local_var_params['label_name']))  # noqa: E501
        if 'appliance_uid' in local_var_params and local_var_params['appliance_uid'] is not None:  # noqa: E501
            query_params.append(('applianceUid', local_var_params['appliance_uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/reverseproxies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetReverseProxiesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_reverse_proxy_profiles(self, **kwargs):  # noqa: E501
        """Get reverse proxy profiles  # noqa: E501

        Get reverse proxy profiles. You can specify a reverse proxy profiles uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reverse_proxy_profiles(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Reverse proxy profile uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetReverseProxyProfilesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_reverse_proxy_profiles_with_http_info(**kwargs)  # noqa: E501

    def get_reverse_proxy_profiles_with_http_info(self, **kwargs):  # noqa: E501
        """Get reverse proxy profiles  # noqa: E501

        Get reverse proxy profiles. You can specify a reverse proxy profiles uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reverse_proxy_profiles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Reverse proxy profile uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetReverseProxyProfilesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reverse_proxy_profiles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/reverseproxyprofiles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetReverseProxyProfilesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_scoringlist_exceptions(self, **kwargs):  # noqa: E501
        """Get scoringlist exceptions  # noqa: E501

        Get scoringlist exceptions. You have to set a specify scoringlist uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scoringlist_exceptions(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str scoringlist_uid: Scoringlist uid.
        :param str uid: Scoringlist exception uid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetScoringlistExceptionsSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_scoringlist_exceptions_with_http_info(**kwargs)  # noqa: E501

    def get_scoringlist_exceptions_with_http_info(self, **kwargs):  # noqa: E501
        """Get scoringlist exceptions  # noqa: E501

        Get scoringlist exceptions. You have to set a specify scoringlist uid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scoringlist_exceptions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str scoringlist_uid: Scoringlist uid.
        :param str uid: Scoringlist exception uid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetScoringlistExceptionsSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'scoringlist_uid',
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scoringlist_exceptions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scoringlist_uid' in local_var_params and local_var_params['scoringlist_uid'] is not None:  # noqa: E501
            query_params.append(('scoringlistUid', local_var_params['scoringlist_uid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/scoringlist/exceptions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetScoringlistExceptionsSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_scoringlist_templates(self, **kwargs):  # noqa: E501
        """Get scoringlist templates  # noqa: E501

        Get scoringlist templates. You can specify a scoringlist template uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scoringlist_templates(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Scoringlist template uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetScoringlistTemplatesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_scoringlist_templates_with_http_info(**kwargs)  # noqa: E501

    def get_scoringlist_templates_with_http_info(self, **kwargs):  # noqa: E501
        """Get scoringlist templates  # noqa: E501

        Get scoringlist templates. You can specify a scoringlist template uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scoringlist_templates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Scoringlist template uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetScoringlistTemplatesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scoringlist_templates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/scoringlist/templates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetScoringlistTemplatesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_scoringlists(self, **kwargs):  # noqa: E501
        """Get scoringlist configurations  # noqa: E501

        Get scoringlist configurations. You can specify a scoringlist configuration uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scoringlists(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Scoringlist configuration uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetScoringlistsSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_scoringlists_with_http_info(**kwargs)  # noqa: E501

    def get_scoringlists_with_http_info(self, **kwargs):  # noqa: E501
        """Get scoringlist configurations  # noqa: E501

        Get scoringlist configurations. You can specify a scoringlist configuration uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scoringlists_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Scoringlist configuration uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetScoringlistsSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scoringlists" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/scoringlist', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetScoringlistsSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_secondary_tunnels(self, **kwargs):  # noqa: E501
        """Get secondary tunnels  # noqa: E501

        Get secondary tunnels. You can specify a secondary tunnel uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_secondary_tunnels(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Secondary Tunnel uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetSecondaryTunnelsSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_secondary_tunnels_with_http_info(**kwargs)  # noqa: E501

    def get_secondary_tunnels_with_http_info(self, **kwargs):  # noqa: E501
        """Get secondary tunnels  # noqa: E501

        Get secondary tunnels. You can specify a secondary tunnel uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_secondary_tunnels_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Secondary Tunnel uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetSecondaryTunnelsSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_secondary_tunnels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/secondarytunnels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSecondaryTunnelsSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_exception_profiles(self, **kwargs):  # noqa: E501
        """Get Security Exception Profiles  # noqa: E501

        Get security exception profiles. You can specify a security exception profile uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_exception_profiles(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: security exception profile uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetSecurityExceptionProfilesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_security_exception_profiles_with_http_info(**kwargs)  # noqa: E501

    def get_security_exception_profiles_with_http_info(self, **kwargs):  # noqa: E501
        """Get Security Exception Profiles  # noqa: E501

        Get security exception profiles. You can specify a security exception profile uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_exception_profiles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: security exception profile uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetSecurityExceptionProfilesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_exception_profiles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securityexceptions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSecurityExceptionProfilesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sslprofiles(self, name, **kwargs):  # noqa: E501
        """Get SSL Profiles  # noqa: E501

        Get SSL Profiles. You can specify a SSL Profiles uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sslprofiles(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Return a filtered list (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetSslprofilesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_sslprofiles_with_http_info(name, **kwargs)  # noqa: E501

    def get_sslprofiles_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get SSL Profiles  # noqa: E501

        Get SSL Profiles. You can specify a SSL Profiles uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sslprofiles_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Return a filtered list (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetSslprofilesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sslprofiles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `get_sslprofiles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/sslprofiles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSslprofilesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_static_blacklists(self, **kwargs):  # noqa: E501
        """Get static blacklists  # noqa: E501

        Get static blacklists. You can specify a static blacklist uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_blacklists(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Static blacklist uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetStaticBlacklistsSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_static_blacklists_with_http_info(**kwargs)  # noqa: E501

    def get_static_blacklists_with_http_info(self, **kwargs):  # noqa: E501
        """Get static blacklists  # noqa: E501

        Get static blacklists. You can specify a static blacklist uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_blacklists_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Static blacklist uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetStaticBlacklistsSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_static_blacklists" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/staticblacklists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetStaticBlacklistsSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_static_scoringlists(self, **kwargs):  # noqa: E501
        """Get static scoringlists  # noqa: E501

        Get static scoringlists. You can specify a static scoringlist uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_scoringlists(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Static scoringlist uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetStaticScoringlistsSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_static_scoringlists_with_http_info(**kwargs)  # noqa: E501

    def get_static_scoringlists_with_http_info(self, **kwargs):  # noqa: E501
        """Get static scoringlists  # noqa: E501

        Get static scoringlists. You can specify a static scoringlist uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_scoringlists_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Static scoringlist uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetStaticScoringlistsSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_static_scoringlists" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/scoringlist/statics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetStaticScoringlistsSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sysctlprofiles(self, **kwargs):  # noqa: E501
        """Get Sysctl profiles  # noqa: E501

        Get Sysctl profiles. You can specify a Sysctl profile uid or name.<br> This item lets you manage profiles for configuring the Linux kernel TCP/IP stack. More details on sysctl parameters can be found on the Linux kernel documentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sysctlprofiles(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Sysctl profile uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetSysctlprofilesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_sysctlprofiles_with_http_info(**kwargs)  # noqa: E501

    def get_sysctlprofiles_with_http_info(self, **kwargs):  # noqa: E501
        """Get Sysctl profiles  # noqa: E501

        Get Sysctl profiles. You can specify a Sysctl profile uid or name.<br> This item lets you manage profiles for configuring the Linux kernel TCP/IP stack. More details on sysctl parameters can be found on the Linux kernel documentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sysctlprofiles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Sysctl profile uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetSysctlprofilesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sysctlprofiles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/sysctl', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSysctlprofilesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tunnels(self, **kwargs):  # noqa: E501
        """Get tunnels  # noqa: E501

        Get tunnels. You can specify a tunnel uid or name. You can also filter by label uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tunnels(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Tunnel name.
        :param str uid: Tunnel uid.
        :param str label_uid: Label uid.
        :param str label_name: Label name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetTunnelsSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_tunnels_with_http_info(**kwargs)  # noqa: E501

    def get_tunnels_with_http_info(self, **kwargs):  # noqa: E501
        """Get tunnels  # noqa: E501

        Get tunnels. You can specify a tunnel uid or name. You can also filter by label uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tunnels_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Tunnel name.
        :param str uid: Tunnel uid.
        :param str label_uid: Label uid.
        :param str label_name: Label name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetTunnelsSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name',
            'uid',
            'label_uid',
            'label_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tunnels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'label_uid' in local_var_params and local_var_params['label_uid'] is not None:  # noqa: E501
            query_params.append(('labelUid', local_var_params['label_uid']))  # noqa: E501
        if 'label_name' in local_var_params and local_var_params['label_name'] is not None:  # noqa: E501
            query_params.append(('labelName', local_var_params['label_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tunnels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetTunnelsSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def getnormalizationtemplate(self, **kwargs):  # noqa: E501
        """Get normalization templates  # noqa: E501

        Get normalization templates. You can specify a normalization template uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.getnormalizationtemplate(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Normalization template uid or name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetnormalizationtemplateSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.getnormalizationtemplate_with_http_info(**kwargs)  # noqa: E501

    def getnormalizationtemplate_with_http_info(self, **kwargs):  # noqa: E501
        """Get normalization templates  # noqa: E501

        Get normalization templates. You can specify a normalization template uid or name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.getnormalizationtemplate_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Normalization template uid or name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetnormalizationtemplateSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method getnormalizationtemplate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/normalization/templates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetnormalizationtemplateSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_accesslogprofile(self, patch_accesslogprofile, **kwargs):  # noqa: E501
        """Patch an access log profile  # noqa: E501

        Patch an existing access log profile. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_accesslogprofile(patch_accesslogprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param PatchAccesslogprofile patch_accesslogprofile: (required)
        :param str uid: Accesslog Profile uid.
        :param str name: Accesslog Profile name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchAccesslogprofileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_accesslogprofile_with_http_info(patch_accesslogprofile, **kwargs)  # noqa: E501

    def patch_accesslogprofile_with_http_info(self, patch_accesslogprofile, **kwargs):  # noqa: E501
        """Patch an access log profile  # noqa: E501

        Patch an existing access log profile. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_accesslogprofile_with_http_info(patch_accesslogprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param PatchAccesslogprofile patch_accesslogprofile: (required)
        :param str uid: Accesslog Profile uid.
        :param str name: Accesslog Profile name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchAccesslogprofileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'patch_accesslogprofile',
            'uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_accesslogprofile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'patch_accesslogprofile' is set
        if self.api_client.client_side_validation and ('patch_accesslogprofile' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_accesslogprofile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_accesslogprofile` when calling `patch_accesslogprofile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_accesslogprofile' in local_var_params:
            body_params = local_var_params['patch_accesslogprofile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/accesslogprofiles', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchAccesslogprofileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_alerting_destination(self, patch_alerting_destination, **kwargs):  # noqa: E501
        """Patch an alerting destination  # noqa: E501

        Patch an alerting destination. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_alerting_destination(patch_alerting_destination, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param PatchAlertingDestination patch_alerting_destination: (required)
        :param str uid: Alerting destination uid.
        :param str name: Alerting destination name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchAlertingDestinationSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_alerting_destination_with_http_info(patch_alerting_destination, **kwargs)  # noqa: E501

    def patch_alerting_destination_with_http_info(self, patch_alerting_destination, **kwargs):  # noqa: E501
        """Patch an alerting destination  # noqa: E501

        Patch an alerting destination. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_alerting_destination_with_http_info(patch_alerting_destination, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param PatchAlertingDestination patch_alerting_destination: (required)
        :param str uid: Alerting destination uid.
        :param str name: Alerting destination name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchAlertingDestinationSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'patch_alerting_destination',
            'uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_alerting_destination" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'patch_alerting_destination' is set
        if self.api_client.client_side_validation and ('patch_alerting_destination' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_alerting_destination'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_alerting_destination` when calling `patch_alerting_destination`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_alerting_destination' in local_var_params:
            body_params = local_var_params['patch_alerting_destination']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/alertingdestinations', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchAlertingDestinationSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_appliance(self, uid, patch_appliance, **kwargs):  # noqa: E501
        """Patch an appliance  # noqa: E501

        Patch an existing appliance. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_appliance(uid, patch_appliance, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Appliance uid. (required)
        :param PatchAppliance patch_appliance: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchApplianceSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_appliance_with_http_info(uid, patch_appliance, **kwargs)  # noqa: E501

    def patch_appliance_with_http_info(self, uid, patch_appliance, **kwargs):  # noqa: E501
        """Patch an appliance  # noqa: E501

        Patch an existing appliance. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_appliance_with_http_info(uid, patch_appliance, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Appliance uid. (required)
        :param PatchAppliance patch_appliance: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchApplianceSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_appliance'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_appliance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_appliance`")  # noqa: E501
        # verify the required parameter 'patch_appliance' is set
        if self.api_client.client_side_validation and ('patch_appliance' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_appliance'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_appliance` when calling `patch_appliance`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_appliance' in local_var_params:
            body_params = local_var_params['patch_appliance']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/appliances', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchApplianceSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_blacklist(self, uid, patch_blacklist, **kwargs):  # noqa: E501
        """Patch a blacklist  # noqa: E501

        Patch an existing blacklist. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_blacklist(uid, patch_blacklist, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Blacklist uid or name. (required)
        :param PatchBlacklist patch_blacklist: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchBlacklistSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_blacklist_with_http_info(uid, patch_blacklist, **kwargs)  # noqa: E501

    def patch_blacklist_with_http_info(self, uid, patch_blacklist, **kwargs):  # noqa: E501
        """Patch a blacklist  # noqa: E501

        Patch an existing blacklist. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_blacklist_with_http_info(uid, patch_blacklist, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Blacklist uid or name. (required)
        :param PatchBlacklist patch_blacklist: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchBlacklistSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_blacklist'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_blacklist" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_blacklist`")  # noqa: E501
        # verify the required parameter 'patch_blacklist' is set
        if self.api_client.client_side_validation and ('patch_blacklist' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_blacklist'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_blacklist` when calling `patch_blacklist`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_blacklist' in local_var_params:
            body_params = local_var_params['patch_blacklist']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blacklists', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchBlacklistSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_blacklist_exception(self, uid, patch_blacklist_exception, **kwargs):  # noqa: E501
        """Patch a blacklist exception  # noqa: E501

        Patch an existing blacklist exception. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_blacklist_exception(uid, patch_blacklist_exception, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Uid of the new blacklist exception. (required)
        :param PatchBlacklistException patch_blacklist_exception: (required)
        :param str blacklist_uid: Blacklist uid.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchBlacklistExceptionSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_blacklist_exception_with_http_info(uid, patch_blacklist_exception, **kwargs)  # noqa: E501

    def patch_blacklist_exception_with_http_info(self, uid, patch_blacklist_exception, **kwargs):  # noqa: E501
        """Patch a blacklist exception  # noqa: E501

        Patch an existing blacklist exception. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_blacklist_exception_with_http_info(uid, patch_blacklist_exception, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Uid of the new blacklist exception. (required)
        :param PatchBlacklistException patch_blacklist_exception: (required)
        :param str blacklist_uid: Blacklist uid.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchBlacklistExceptionSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_blacklist_exception',
            'blacklist_uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_blacklist_exception" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_blacklist_exception`")  # noqa: E501
        # verify the required parameter 'patch_blacklist_exception' is set
        if self.api_client.client_side_validation and ('patch_blacklist_exception' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_blacklist_exception'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_blacklist_exception` when calling `patch_blacklist_exception`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'blacklist_uid' in local_var_params and local_var_params['blacklist_uid'] is not None:  # noqa: E501
            query_params.append(('blacklistUid', local_var_params['blacklist_uid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_blacklist_exception' in local_var_params:
            body_params = local_var_params['patch_blacklist_exception']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blacklists/exceptions', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchBlacklistExceptionSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_certificate(self, uid, patch_certificate, **kwargs):  # noqa: E501
        """Patch a certificate  # noqa: E501

        Patch a certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_certificate(uid, patch_certificate, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Certificate's uid. (required)
        :param PatchCertificate patch_certificate: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchCertificateSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_certificate_with_http_info(uid, patch_certificate, **kwargs)  # noqa: E501

    def patch_certificate_with_http_info(self, uid, patch_certificate, **kwargs):  # noqa: E501
        """Patch a certificate  # noqa: E501

        Patch a certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_certificate_with_http_info(uid, patch_certificate, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Certificate's uid. (required)
        :param PatchCertificate patch_certificate: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchCertificateSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_certificate'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_certificate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_certificate`")  # noqa: E501
        # verify the required parameter 'patch_certificate' is set
        if self.api_client.client_side_validation and ('patch_certificate' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_certificate'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_certificate` when calling `patch_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_certificate' in local_var_params:
            body_params = local_var_params['patch_certificate']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificates/import', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchCertificateSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_certificates_bundle(self, patch_certificates_bundle, **kwargs):  # noqa: E501
        """Patch a certificates bundle  # noqa: E501

        Patch an existing certificates bundle. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_certificates_bundle(patch_certificates_bundle, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param PatchCertificatesBundle patch_certificates_bundle: (required)
        :param str uid: Identifier of the certificates bundle.
        :param str name: Name of the certificates bundle.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchCertificatesBundleSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_certificates_bundle_with_http_info(patch_certificates_bundle, **kwargs)  # noqa: E501

    def patch_certificates_bundle_with_http_info(self, patch_certificates_bundle, **kwargs):  # noqa: E501
        """Patch a certificates bundle  # noqa: E501

        Patch an existing certificates bundle. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_certificates_bundle_with_http_info(patch_certificates_bundle, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param PatchCertificatesBundle patch_certificates_bundle: (required)
        :param str uid: Identifier of the certificates bundle.
        :param str name: Name of the certificates bundle.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchCertificatesBundleSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'patch_certificates_bundle',
            'uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_certificates_bundle" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'patch_certificates_bundle' is set
        if self.api_client.client_side_validation and ('patch_certificates_bundle' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_certificates_bundle'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_certificates_bundle` when calling `patch_certificates_bundle`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_certificates_bundle' in local_var_params:
            body_params = local_var_params['patch_certificates_bundle']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchCertificatesBundleSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_compression_profile(self, uid, patch_compression_profile, **kwargs):  # noqa: E501
        """Patch a compression profile  # noqa: E501

        Patch a existing compression profile. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_compression_profile(uid, patch_compression_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Compression profile uid or name. (required)
        :param PatchCompressionProfile patch_compression_profile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchCompressionProfileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_compression_profile_with_http_info(uid, patch_compression_profile, **kwargs)  # noqa: E501

    def patch_compression_profile_with_http_info(self, uid, patch_compression_profile, **kwargs):  # noqa: E501
        """Patch a compression profile  # noqa: E501

        Patch a existing compression profile. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_compression_profile_with_http_info(uid, patch_compression_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Compression profile uid or name. (required)
        :param PatchCompressionProfile patch_compression_profile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchCompressionProfileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_compression_profile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_compression_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_compression_profile`")  # noqa: E501
        # verify the required parameter 'patch_compression_profile' is set
        if self.api_client.client_side_validation and ('patch_compression_profile' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_compression_profile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_compression_profile` when calling `patch_compression_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_compression_profile' in local_var_params:
            body_params = local_var_params['patch_compression_profile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/compressionprofiles', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchCompressionProfileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_icx(self, uid, patch_icx, **kwargs):  # noqa: E501
        """Patch an ICX configuration  # noqa: E501

        Patch an existing ICX configuration. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_icx(uid, patch_icx, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: ICX configuration uid or name. (required)
        :param PatchIcx patch_icx: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchIcxSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_icx_with_http_info(uid, patch_icx, **kwargs)  # noqa: E501

    def patch_icx_with_http_info(self, uid, patch_icx, **kwargs):  # noqa: E501
        """Patch an ICX configuration  # noqa: E501

        Patch an existing ICX configuration. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_icx_with_http_info(uid, patch_icx, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: ICX configuration uid or name. (required)
        :param PatchIcx patch_icx: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchIcxSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_icx'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_icx" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_icx`")  # noqa: E501
        # verify the required parameter 'patch_icx' is set
        if self.api_client.client_side_validation and ('patch_icx' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_icx'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_icx` when calling `patch_icx`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_icx' in local_var_params:
            body_params = local_var_params['patch_icx']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchIcxSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_icx_category(self, icx_uid, uid, patch_icx_category, **kwargs):  # noqa: E501
        """Patch an ICX Category  # noqa: E501

        Patch an existing ICX category. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_icx_category(icx_uid, uid, patch_icx_category, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str uid: ICX category uid. (required)
        :param PatchIcxCategory patch_icx_category: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchIcxCategorySuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_icx_category_with_http_info(icx_uid, uid, patch_icx_category, **kwargs)  # noqa: E501

    def patch_icx_category_with_http_info(self, icx_uid, uid, patch_icx_category, **kwargs):  # noqa: E501
        """Patch an ICX Category  # noqa: E501

        Patch an existing ICX category. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_icx_category_with_http_info(icx_uid, uid, patch_icx_category, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str uid: ICX category uid. (required)
        :param PatchIcxCategory patch_icx_category: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchIcxCategorySuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'icx_uid',
            'uid',
            'patch_icx_category'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_icx_category" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'icx_uid' is set
        if self.api_client.client_side_validation and ('icx_uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['icx_uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `icx_uid` when calling `patch_icx_category`")  # noqa: E501
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_icx_category`")  # noqa: E501
        # verify the required parameter 'patch_icx_category' is set
        if self.api_client.client_side_validation and ('patch_icx_category' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_icx_category'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_icx_category` when calling `patch_icx_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'icx_uid' in local_var_params and local_var_params['icx_uid'] is not None:  # noqa: E501
            query_params.append(('icxUid', local_var_params['icx_uid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_icx_category' in local_var_params:
            body_params = local_var_params['patch_icx_category']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx/categories', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchIcxCategorySuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_icx_rule(self, icx_uid, category_uid, uid, patch_icx_rule, **kwargs):  # noqa: E501
        """Patch an ICX Rule  # noqa: E501

        Patch an existing ICX rule. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_icx_rule(icx_uid, category_uid, uid, patch_icx_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str category_uid: ICX category uid. (required)
        :param str uid: ICX rule uid. (required)
        :param PatchIcxRule patch_icx_rule: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchIcxRuleSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_icx_rule_with_http_info(icx_uid, category_uid, uid, patch_icx_rule, **kwargs)  # noqa: E501

    def patch_icx_rule_with_http_info(self, icx_uid, category_uid, uid, patch_icx_rule, **kwargs):  # noqa: E501
        """Patch an ICX Rule  # noqa: E501

        Patch an existing ICX rule. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_icx_rule_with_http_info(icx_uid, category_uid, uid, patch_icx_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str category_uid: ICX category uid. (required)
        :param str uid: ICX rule uid. (required)
        :param PatchIcxRule patch_icx_rule: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchIcxRuleSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'icx_uid',
            'category_uid',
            'uid',
            'patch_icx_rule'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_icx_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'icx_uid' is set
        if self.api_client.client_side_validation and ('icx_uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['icx_uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `icx_uid` when calling `patch_icx_rule`")  # noqa: E501
        # verify the required parameter 'category_uid' is set
        if self.api_client.client_side_validation and ('category_uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['category_uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `category_uid` when calling `patch_icx_rule`")  # noqa: E501
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_icx_rule`")  # noqa: E501
        # verify the required parameter 'patch_icx_rule' is set
        if self.api_client.client_side_validation and ('patch_icx_rule' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_icx_rule'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_icx_rule` when calling `patch_icx_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'icx_uid' in local_var_params and local_var_params['icx_uid'] is not None:  # noqa: E501
            query_params.append(('icxUid', local_var_params['icx_uid']))  # noqa: E501
        if 'category_uid' in local_var_params and local_var_params['category_uid'] is not None:  # noqa: E501
            query_params.append(('categoryUid', local_var_params['category_uid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_icx_rule' in local_var_params:
            body_params = local_var_params['patch_icx_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx/categories/rules', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchIcxRuleSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_label(self, uid, patch_label, **kwargs):  # noqa: E501
        """Patch a label  # noqa: E501

        Patch an existing label. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_label(uid, patch_label, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Label uid or name. (required)
        :param PatchLabel patch_label: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchLabelSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_label_with_http_info(uid, patch_label, **kwargs)  # noqa: E501

    def patch_label_with_http_info(self, uid, patch_label, **kwargs):  # noqa: E501
        """Patch a label  # noqa: E501

        Patch an existing label. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_label_with_http_info(uid, patch_label, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Label uid or name. (required)
        :param PatchLabel patch_label: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchLabelSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_label'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_label" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_label`")  # noqa: E501
        # verify the required parameter 'patch_label' is set
        if self.api_client.client_side_validation and ('patch_label' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_label'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_label` when calling `patch_label`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_label' in local_var_params:
            body_params = local_var_params['patch_label']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/labels', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchLabelSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_network_interface(self, name, patch_network_interface, **kwargs):  # noqa: E501
        """Patch a network interface  # noqa: E501

        Patch a existing network interface. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_network_interface(name, patch_network_interface, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Identifier of the network interface. (required)
        :param PatchNetworkInterface patch_network_interface: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchNetworkInterfaceSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_network_interface_with_http_info(name, patch_network_interface, **kwargs)  # noqa: E501

    def patch_network_interface_with_http_info(self, name, patch_network_interface, **kwargs):  # noqa: E501
        """Patch a network interface  # noqa: E501

        Patch a existing network interface. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_network_interface_with_http_info(name, patch_network_interface, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Identifier of the network interface. (required)
        :param PatchNetworkInterface patch_network_interface: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchNetworkInterfaceSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name',
            'patch_network_interface'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_network_interface" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `patch_network_interface`")  # noqa: E501
        # verify the required parameter 'patch_network_interface' is set
        if self.api_client.client_side_validation and ('patch_network_interface' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_network_interface'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_network_interface` when calling `patch_network_interface`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_network_interface' in local_var_params:
            body_params = local_var_params['patch_network_interface']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/networkdevices/interfaces', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchNetworkInterfaceSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_normalization(self, uid, patch_normalization, **kwargs):  # noqa: E501
        """Patch a normalization configurattion  # noqa: E501

        Patch an existing normalization configuration. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_normalization(uid, patch_normalization, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Normalization configuration uid or name. (required)
        :param PatchNormalization patch_normalization: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchNormalizationSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_normalization_with_http_info(uid, patch_normalization, **kwargs)  # noqa: E501

    def patch_normalization_with_http_info(self, uid, patch_normalization, **kwargs):  # noqa: E501
        """Patch a normalization configurattion  # noqa: E501

        Patch an existing normalization configuration. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_normalization_with_http_info(uid, patch_normalization, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Normalization configuration uid or name. (required)
        :param PatchNormalization patch_normalization: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchNormalizationSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_normalization'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_normalization" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_normalization`")  # noqa: E501
        # verify the required parameter 'patch_normalization' is set
        if self.api_client.client_side_validation and ('patch_normalization' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_normalization'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_normalization` when calling `patch_normalization`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_normalization' in local_var_params:
            body_params = local_var_params['patch_normalization']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/normalization', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchNormalizationSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_ntp(self, uid, patch_ntp, **kwargs):  # noqa: E501
        """Patch a ntp  # noqa: E501

        Patch an existing ntp. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_ntp(uid, patch_ntp, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Ntp uid or name. (required)
        :param PatchNtp patch_ntp: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchNtpSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_ntp_with_http_info(uid, patch_ntp, **kwargs)  # noqa: E501

    def patch_ntp_with_http_info(self, uid, patch_ntp, **kwargs):  # noqa: E501
        """Patch a ntp  # noqa: E501

        Patch an existing ntp. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_ntp_with_http_info(uid, patch_ntp, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Ntp uid or name. (required)
        :param PatchNtp patch_ntp: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchNtpSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_ntp'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_ntp" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_ntp`")  # noqa: E501
        # verify the required parameter 'patch_ntp' is set
        if self.api_client.client_side_validation and ('patch_ntp' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_ntp'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_ntp` when calling `patch_ntp`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_ntp' in local_var_params:
            body_params = local_var_params['patch_ntp']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ntp', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchNtpSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_ramdisk_cache(self, uid, patch_ramdisk_cache, **kwargs):  # noqa: E501
        """Patch a Ramdisk cache profile  # noqa: E501

        Patch an existing Ramdisk cache profile. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_ramdisk_cache(uid, patch_ramdisk_cache, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Ramdisk cache uid or name. (required)
        :param PatchRamdiskCache patch_ramdisk_cache: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchRamdiskCacheSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_ramdisk_cache_with_http_info(uid, patch_ramdisk_cache, **kwargs)  # noqa: E501

    def patch_ramdisk_cache_with_http_info(self, uid, patch_ramdisk_cache, **kwargs):  # noqa: E501
        """Patch a Ramdisk cache profile  # noqa: E501

        Patch an existing Ramdisk cache profile. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_ramdisk_cache_with_http_info(uid, patch_ramdisk_cache, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Ramdisk cache uid or name. (required)
        :param PatchRamdiskCache patch_ramdisk_cache: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchRamdiskCacheSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_ramdisk_cache'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_ramdisk_cache" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_ramdisk_cache`")  # noqa: E501
        # verify the required parameter 'patch_ramdisk_cache' is set
        if self.api_client.client_side_validation and ('patch_ramdisk_cache' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_ramdisk_cache'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_ramdisk_cache` when calling `patch_ramdisk_cache`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_ramdisk_cache' in local_var_params:
            body_params = local_var_params['patch_ramdisk_cache']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ramdiskcacheprofiles', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchRamdiskCacheSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_requesttimeoutprofile(self, uid, patch_requesttimeoutprofile, **kwargs):  # noqa: E501
        """Patch an request timeout profile  # noqa: E501

        Patch an existing request timeout profile. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_requesttimeoutprofile(uid, patch_requesttimeoutprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Accesslog Profile uid or name. (required)
        :param PatchRequesttimeoutprofile patch_requesttimeoutprofile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchRequesttimeoutprofileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_requesttimeoutprofile_with_http_info(uid, patch_requesttimeoutprofile, **kwargs)  # noqa: E501

    def patch_requesttimeoutprofile_with_http_info(self, uid, patch_requesttimeoutprofile, **kwargs):  # noqa: E501
        """Patch an request timeout profile  # noqa: E501

        Patch an existing request timeout profile. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_requesttimeoutprofile_with_http_info(uid, patch_requesttimeoutprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Accesslog Profile uid or name. (required)
        :param PatchRequesttimeoutprofile patch_requesttimeoutprofile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchRequesttimeoutprofileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_requesttimeoutprofile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_requesttimeoutprofile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_requesttimeoutprofile`")  # noqa: E501
        # verify the required parameter 'patch_requesttimeoutprofile' is set
        if self.api_client.client_side_validation and ('patch_requesttimeoutprofile' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_requesttimeoutprofile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_requesttimeoutprofile` when calling `patch_requesttimeoutprofile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_requesttimeoutprofile' in local_var_params:
            body_params = local_var_params['patch_requesttimeoutprofile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/requesttimeoutprofiles', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchRequesttimeoutprofileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_reverse_proxy(self, uid, patch_reverse_proxy, **kwargs):  # noqa: E501
        """Patch a reverse proxy  # noqa: E501

        Patch a existing reverse proxy. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_reverse_proxy(uid, patch_reverse_proxy, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the reverse proxy. (required)
        :param PatchReverseProxy patch_reverse_proxy: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchReverseProxySuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_reverse_proxy_with_http_info(uid, patch_reverse_proxy, **kwargs)  # noqa: E501

    def patch_reverse_proxy_with_http_info(self, uid, patch_reverse_proxy, **kwargs):  # noqa: E501
        """Patch a reverse proxy  # noqa: E501

        Patch a existing reverse proxy. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_reverse_proxy_with_http_info(uid, patch_reverse_proxy, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the reverse proxy. (required)
        :param PatchReverseProxy patch_reverse_proxy: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchReverseProxySuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_reverse_proxy'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_reverse_proxy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_reverse_proxy`")  # noqa: E501
        # verify the required parameter 'patch_reverse_proxy' is set
        if self.api_client.client_side_validation and ('patch_reverse_proxy' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_reverse_proxy'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_reverse_proxy` when calling `patch_reverse_proxy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_reverse_proxy' in local_var_params:
            body_params = local_var_params['patch_reverse_proxy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/reverseproxies', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchReverseProxySuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_reverse_proxy_profile(self, uid, patch_reverse_proxy_profile, **kwargs):  # noqa: E501
        """Patch a reverse proxy profile  # noqa: E501

        Patch a existing reverse proxy profile. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_reverse_proxy_profile(uid, patch_reverse_proxy_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Reverse proxy profile uid or name. (required)
        :param PatchReverseProxyProfile patch_reverse_proxy_profile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchReverseProxyProfileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_reverse_proxy_profile_with_http_info(uid, patch_reverse_proxy_profile, **kwargs)  # noqa: E501

    def patch_reverse_proxy_profile_with_http_info(self, uid, patch_reverse_proxy_profile, **kwargs):  # noqa: E501
        """Patch a reverse proxy profile  # noqa: E501

        Patch a existing reverse proxy profile. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_reverse_proxy_profile_with_http_info(uid, patch_reverse_proxy_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Reverse proxy profile uid or name. (required)
        :param PatchReverseProxyProfile patch_reverse_proxy_profile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchReverseProxyProfileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_reverse_proxy_profile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_reverse_proxy_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_reverse_proxy_profile`")  # noqa: E501
        # verify the required parameter 'patch_reverse_proxy_profile' is set
        if self.api_client.client_side_validation and ('patch_reverse_proxy_profile' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_reverse_proxy_profile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_reverse_proxy_profile` when calling `patch_reverse_proxy_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_reverse_proxy_profile' in local_var_params:
            body_params = local_var_params['patch_reverse_proxy_profile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/reverseproxyprofiles', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchReverseProxyProfileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_scoringlist(self, uid, patch_scoringlist, **kwargs):  # noqa: E501
        """Patch a scoringlist configuration  # noqa: E501

        Patch an existing scoringlist. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_scoringlist(uid, patch_scoringlist, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Scoringlist uid or name. (required)
        :param PatchScoringlist patch_scoringlist: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchScoringlistSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_scoringlist_with_http_info(uid, patch_scoringlist, **kwargs)  # noqa: E501

    def patch_scoringlist_with_http_info(self, uid, patch_scoringlist, **kwargs):  # noqa: E501
        """Patch a scoringlist configuration  # noqa: E501

        Patch an existing scoringlist. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_scoringlist_with_http_info(uid, patch_scoringlist, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Scoringlist uid or name. (required)
        :param PatchScoringlist patch_scoringlist: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchScoringlistSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_scoringlist'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_scoringlist" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_scoringlist`")  # noqa: E501
        # verify the required parameter 'patch_scoringlist' is set
        if self.api_client.client_side_validation and ('patch_scoringlist' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_scoringlist'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_scoringlist` when calling `patch_scoringlist`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_scoringlist' in local_var_params:
            body_params = local_var_params['patch_scoringlist']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/scoringlist', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchScoringlistSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_scoringlist_exception(self, uid, patch_scoringlist_exception, **kwargs):  # noqa: E501
        """Patch a scoringlist exception  # noqa: E501

        Patch an existing scoringlist exception. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_scoringlist_exception(uid, patch_scoringlist_exception, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Uid of the new scoringlist exception. (required)
        :param PatchScoringlistException patch_scoringlist_exception: (required)
        :param str scoringlist_uid: Scoringlist uid.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchScoringlistExceptionSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_scoringlist_exception_with_http_info(uid, patch_scoringlist_exception, **kwargs)  # noqa: E501

    def patch_scoringlist_exception_with_http_info(self, uid, patch_scoringlist_exception, **kwargs):  # noqa: E501
        """Patch a scoringlist exception  # noqa: E501

        Patch an existing scoringlist exception. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_scoringlist_exception_with_http_info(uid, patch_scoringlist_exception, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Uid of the new scoringlist exception. (required)
        :param PatchScoringlistException patch_scoringlist_exception: (required)
        :param str scoringlist_uid: Scoringlist uid.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchScoringlistExceptionSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_scoringlist_exception',
            'scoringlist_uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_scoringlist_exception" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_scoringlist_exception`")  # noqa: E501
        # verify the required parameter 'patch_scoringlist_exception' is set
        if self.api_client.client_side_validation and ('patch_scoringlist_exception' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_scoringlist_exception'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_scoringlist_exception` when calling `patch_scoringlist_exception`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scoringlist_uid' in local_var_params and local_var_params['scoringlist_uid'] is not None:  # noqa: E501
            query_params.append(('scoringlistUid', local_var_params['scoringlist_uid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_scoringlist_exception' in local_var_params:
            body_params = local_var_params['patch_scoringlist_exception']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/scoringlist/exceptions', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchScoringlistExceptionSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_secondary_tunnel(self, uid, patch_secondary_tunnel, **kwargs):  # noqa: E501
        """Patch a secondary tunnel  # noqa: E501

        Patch an existing secondary tunnel. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_secondary_tunnel(uid, patch_secondary_tunnel, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Secondary Tunnel uid. (required)
        :param PatchSecondaryTunnel patch_secondary_tunnel: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchSecondaryTunnelSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_secondary_tunnel_with_http_info(uid, patch_secondary_tunnel, **kwargs)  # noqa: E501

    def patch_secondary_tunnel_with_http_info(self, uid, patch_secondary_tunnel, **kwargs):  # noqa: E501
        """Patch a secondary tunnel  # noqa: E501

        Patch an existing secondary tunnel. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_secondary_tunnel_with_http_info(uid, patch_secondary_tunnel, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Secondary Tunnel uid. (required)
        :param PatchSecondaryTunnel patch_secondary_tunnel: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchSecondaryTunnelSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_secondary_tunnel'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_secondary_tunnel" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_secondary_tunnel`")  # noqa: E501
        # verify the required parameter 'patch_secondary_tunnel' is set
        if self.api_client.client_side_validation and ('patch_secondary_tunnel' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_secondary_tunnel'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_secondary_tunnel` when calling `patch_secondary_tunnel`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_secondary_tunnel' in local_var_params:
            body_params = local_var_params['patch_secondary_tunnel']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/secondarytunnels', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchSecondaryTunnelSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_security_exception_profile(self, uid, patch_security_exception_profile, **kwargs):  # noqa: E501
        """Patch a Security Exception Profile  # noqa: E501

        Patch a security exception profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_security_exception_profile(uid, patch_security_exception_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Security Exception Profile uid or name. (required)
        :param PatchSecurityExceptionProfile patch_security_exception_profile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchSecurityExceptionProfileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_security_exception_profile_with_http_info(uid, patch_security_exception_profile, **kwargs)  # noqa: E501

    def patch_security_exception_profile_with_http_info(self, uid, patch_security_exception_profile, **kwargs):  # noqa: E501
        """Patch a Security Exception Profile  # noqa: E501

        Patch a security exception profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_security_exception_profile_with_http_info(uid, patch_security_exception_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Security Exception Profile uid or name. (required)
        :param PatchSecurityExceptionProfile patch_security_exception_profile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchSecurityExceptionProfileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_security_exception_profile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_security_exception_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_security_exception_profile`")  # noqa: E501
        # verify the required parameter 'patch_security_exception_profile' is set
        if self.api_client.client_side_validation and ('patch_security_exception_profile' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_security_exception_profile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_security_exception_profile` when calling `patch_security_exception_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_security_exception_profile' in local_var_params:
            body_params = local_var_params['patch_security_exception_profile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securityexceptions', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchSecurityExceptionProfileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_sysctlprofile(self, uid, patch_sysctlprofile, **kwargs):  # noqa: E501
        """Patch a Sysctl profile  # noqa: E501

        Patch an existing Sysctl profile. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_sysctlprofile(uid, patch_sysctlprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Sysctl profile uid or name. (required)
        :param PatchSysctlprofile patch_sysctlprofile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchSysctlprofileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_sysctlprofile_with_http_info(uid, patch_sysctlprofile, **kwargs)  # noqa: E501

    def patch_sysctlprofile_with_http_info(self, uid, patch_sysctlprofile, **kwargs):  # noqa: E501
        """Patch a Sysctl profile  # noqa: E501

        Patch an existing Sysctl profile. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_sysctlprofile_with_http_info(uid, patch_sysctlprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Sysctl profile uid or name. (required)
        :param PatchSysctlprofile patch_sysctlprofile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchSysctlprofileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_sysctlprofile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_sysctlprofile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_sysctlprofile`")  # noqa: E501
        # verify the required parameter 'patch_sysctlprofile' is set
        if self.api_client.client_side_validation and ('patch_sysctlprofile' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_sysctlprofile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_sysctlprofile` when calling `patch_sysctlprofile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_sysctlprofile' in local_var_params:
            body_params = local_var_params['patch_sysctlprofile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/sysctl', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchSysctlprofileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_tunnel(self, uid, patch_tunnel, **kwargs):  # noqa: E501
        """Patch a tunnel  # noqa: E501

        Patch an existing tunnel. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_tunnel(uid, patch_tunnel, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Tunnel uid. (required)
        :param PatchTunnel patch_tunnel: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatchTunnelSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_tunnel_with_http_info(uid, patch_tunnel, **kwargs)  # noqa: E501

    def patch_tunnel_with_http_info(self, uid, patch_tunnel, **kwargs):  # noqa: E501
        """Patch a tunnel  # noqa: E501

        Patch an existing tunnel. You just have to specify the attributes with changed values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_tunnel_with_http_info(uid, patch_tunnel, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Tunnel uid. (required)
        :param PatchTunnel patch_tunnel: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatchTunnelSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'patch_tunnel'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_tunnel" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `patch_tunnel`")  # noqa: E501
        # verify the required parameter 'patch_tunnel' is set
        if self.api_client.client_side_validation and ('patch_tunnel' not in local_var_params or  # noqa: E501
                                                        local_var_params['patch_tunnel'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patch_tunnel` when calling `patch_tunnel`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_tunnel' in local_var_params:
            body_params = local_var_params['patch_tunnel']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tunnels', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatchTunnelSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_log_filter(self, uid, body, **kwargs):  # noqa: E501
        """Upload LogFilter File  # noqa: E501

        Upload the special logfilter file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_log_filter(uid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: logfilter's uid. (required)
        :param file body: (required)
        :param str content_md5: The md5sum of uploaded file. To ensure that data is not corrupted traversing the network, user may use the header.                          <br />If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PutLogFilterSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_log_filter_with_http_info(uid, body, **kwargs)  # noqa: E501

    def put_log_filter_with_http_info(self, uid, body, **kwargs):  # noqa: E501
        """Upload LogFilter File  # noqa: E501

        Upload the special logfilter file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_log_filter_with_http_info(uid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: logfilter's uid. (required)
        :param file body: (required)
        :param str content_md5: The md5sum of uploaded file. To ensure that data is not corrupted traversing the network, user may use the header.                          <br />If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PutLogFilterSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'body',
            'content_md5'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_log_filter" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `put_log_filter`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `put_log_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}
        if 'content_md5' in local_var_params:
            header_params['Content-MD5'] = local_var_params['content_md5']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/txt'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/logfilters/import', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PutLogFilterSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def setsslprofiles(self, uid, setsslprofiles, **kwargs):  # noqa: E501
        """Update a SSL Profile  # noqa: E501

        Update the SSL Profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.setsslprofiles(uid, setsslprofiles, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Select SSL Profile to update (required)
        :param Setsslprofiles setsslprofiles: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SetsslprofilesSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.setsslprofiles_with_http_info(uid, setsslprofiles, **kwargs)  # noqa: E501

    def setsslprofiles_with_http_info(self, uid, setsslprofiles, **kwargs):  # noqa: E501
        """Update a SSL Profile  # noqa: E501

        Update the SSL Profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.setsslprofiles_with_http_info(uid, setsslprofiles, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Select SSL Profile to update (required)
        :param Setsslprofiles setsslprofiles: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SetsslprofilesSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'setsslprofiles'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method setsslprofiles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `setsslprofiles`")  # noqa: E501
        # verify the required parameter 'setsslprofiles' is set
        if self.api_client.client_side_validation and ('setsslprofiles' not in local_var_params or  # noqa: E501
                                                        local_var_params['setsslprofiles'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `setsslprofiles` when calling `setsslprofiles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'setsslprofiles' in local_var_params:
            body_params = local_var_params['setsslprofiles']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/sslprofiles', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SetsslprofilesSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def shutdown(self, shutdown, **kwargs):  # noqa: E501
        """Shutdown/Halt the system  # noqa: E501

        Shutdown/Halt the system  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.shutdown(shutdown, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Shutdown shutdown: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ShutdownSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.shutdown_with_http_info(shutdown, **kwargs)  # noqa: E501

    def shutdown_with_http_info(self, shutdown, **kwargs):  # noqa: E501
        """Shutdown/Halt the system  # noqa: E501

        Shutdown/Halt the system  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.shutdown_with_http_info(shutdown, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Shutdown shutdown: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ShutdownSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'shutdown'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method shutdown" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'shutdown' is set
        if self.api_client.client_side_validation and ('shutdown' not in local_var_params or  # noqa: E501
                                                        local_var_params['shutdown'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `shutdown` when calling `shutdown`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'shutdown' in local_var_params:
            body_params = local_var_params['shutdown']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/appliances/shutdown', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShutdownSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tunnel_backend_status(self, uid, **kwargs):  # noqa: E501
        """Get backend status  # noqa: E501

        Get the backend status of a tunnel. You must specify a tunnel uid or a tunnel name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tunnel_backend_status(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Tunnel uid or name. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TunnelBackendStatusSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.tunnel_backend_status_with_http_info(uid, **kwargs)  # noqa: E501

    def tunnel_backend_status_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Get backend status  # noqa: E501

        Get the backend status of a tunnel. You must specify a tunnel uid or a tunnel name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tunnel_backend_status_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Tunnel uid or name. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TunnelBackendStatusSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tunnel_backend_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `tunnel_backend_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/status/tunnels/backend', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TunnelBackendStatusSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tunnel_listening_status(self, uid, **kwargs):  # noqa: E501
        """Get listening status  # noqa: E501

        Get the listening status of a tunnel. You must specify a tunnel uid or a tunnel name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tunnel_listening_status(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Tunnel uid or name. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TunnelListeningStatusSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.tunnel_listening_status_with_http_info(uid, **kwargs)  # noqa: E501

    def tunnel_listening_status_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Get listening status  # noqa: E501

        Get the listening status of a tunnel. You must specify a tunnel uid or a tunnel name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tunnel_listening_status_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Tunnel uid or name. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TunnelListeningStatusSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tunnel_listening_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `tunnel_listening_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/status/tunnels/listening', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TunnelListeningStatusSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tunnel_runtime_information(self, uid, **kwargs):  # noqa: E501
        """Get runtime information  # noqa: E501

        Get the runtime information of a tunnel. You must specify a tunnel uid or a tunnel name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tunnel_runtime_information(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Tunnel uid or name. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TunnelRuntimeInformationSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.tunnel_runtime_information_with_http_info(uid, **kwargs)  # noqa: E501

    def tunnel_runtime_information_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Get runtime information  # noqa: E501

        Get the runtime information of a tunnel. You must specify a tunnel uid or a tunnel name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tunnel_runtime_information_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Tunnel uid or name. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TunnelRuntimeInformationSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tunnel_runtime_information" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `tunnel_runtime_information`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/status/tunnels/runtime', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TunnelRuntimeInformationSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_accesslogprofile(self, update_accesslogprofile, **kwargs):  # noqa: E501
        """Update an access log profile  # noqa: E501

        Update an access log profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_accesslogprofile(update_accesslogprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UpdateAccesslogprofile update_accesslogprofile: (required)
        :param str uid: Identifier of the access log profile.
        :param str name: Name of the access log profile.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateAccesslogprofileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_accesslogprofile_with_http_info(update_accesslogprofile, **kwargs)  # noqa: E501

    def update_accesslogprofile_with_http_info(self, update_accesslogprofile, **kwargs):  # noqa: E501
        """Update an access log profile  # noqa: E501

        Update an access log profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_accesslogprofile_with_http_info(update_accesslogprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UpdateAccesslogprofile update_accesslogprofile: (required)
        :param str uid: Identifier of the access log profile.
        :param str name: Name of the access log profile.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateAccesslogprofileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'update_accesslogprofile',
            'uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_accesslogprofile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'update_accesslogprofile' is set
        if self.api_client.client_side_validation and ('update_accesslogprofile' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_accesslogprofile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_accesslogprofile` when calling `update_accesslogprofile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_accesslogprofile' in local_var_params:
            body_params = local_var_params['update_accesslogprofile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/accesslogprofiles', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateAccesslogprofileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_blacklist(self, uid, update_blacklist, **kwargs):  # noqa: E501
        """Update a blacklist  # noqa: E501

        Update the special blacklist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_blacklist(uid, update_blacklist, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the blacklist. (required)
        :param UpdateBlacklist update_blacklist: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateBlacklistSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_blacklist_with_http_info(uid, update_blacklist, **kwargs)  # noqa: E501

    def update_blacklist_with_http_info(self, uid, update_blacklist, **kwargs):  # noqa: E501
        """Update a blacklist  # noqa: E501

        Update the special blacklist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_blacklist_with_http_info(uid, update_blacklist, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the blacklist. (required)
        :param UpdateBlacklist update_blacklist: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateBlacklistSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'update_blacklist'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_blacklist" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_blacklist`")  # noqa: E501
        # verify the required parameter 'update_blacklist' is set
        if self.api_client.client_side_validation and ('update_blacklist' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_blacklist'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_blacklist` when calling `update_blacklist`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_blacklist' in local_var_params:
            body_params = local_var_params['update_blacklist']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blacklists', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateBlacklistSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_blacklist_exception(self, uid, update_blacklist_exception, **kwargs):  # noqa: E501
        """Update a blacklist exception  # noqa: E501

        Update the special blacklist exception.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_blacklist_exception(uid, update_blacklist_exception, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Uid of the new blacklist exception. (required)
        :param UpdateBlacklistException update_blacklist_exception: (required)
        :param str blacklist_uid: Blacklist uid.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateBlacklistExceptionSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_blacklist_exception_with_http_info(uid, update_blacklist_exception, **kwargs)  # noqa: E501

    def update_blacklist_exception_with_http_info(self, uid, update_blacklist_exception, **kwargs):  # noqa: E501
        """Update a blacklist exception  # noqa: E501

        Update the special blacklist exception.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_blacklist_exception_with_http_info(uid, update_blacklist_exception, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Uid of the new blacklist exception. (required)
        :param UpdateBlacklistException update_blacklist_exception: (required)
        :param str blacklist_uid: Blacklist uid.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateBlacklistExceptionSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'update_blacklist_exception',
            'blacklist_uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_blacklist_exception" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_blacklist_exception`")  # noqa: E501
        # verify the required parameter 'update_blacklist_exception' is set
        if self.api_client.client_side_validation and ('update_blacklist_exception' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_blacklist_exception'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_blacklist_exception` when calling `update_blacklist_exception`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'blacklist_uid' in local_var_params and local_var_params['blacklist_uid'] is not None:  # noqa: E501
            query_params.append(('blacklistUid', local_var_params['blacklist_uid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_blacklist_exception' in local_var_params:
            body_params = local_var_params['update_blacklist_exception']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blacklists/exceptions', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateBlacklistExceptionSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_certificate(self, uid, **kwargs):  # noqa: E501
        """Update a certificate  # noqa: E501

        Update the certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_certificate(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Certificate's uid. (required)
        :param str content_md5: The md5sum of uploaded file. To ensure that data is not corrupted traversing the network, user may use the header.                          <br />If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>.
        :param str password: The password of the certificate
        :param str type: The type of the certificate
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateCertificateSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_certificate_with_http_info(uid, **kwargs)  # noqa: E501

    def update_certificate_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Update a certificate  # noqa: E501

        Update the certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_certificate_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Certificate's uid. (required)
        :param str content_md5: The md5sum of uploaded file. To ensure that data is not corrupted traversing the network, user may use the header.                          <br />If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>.
        :param str password: The password of the certificate
        :param str type: The type of the certificate
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateCertificateSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'content_md5',
            'password',
            'type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_certificate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'password' in local_var_params and local_var_params['password'] is not None:  # noqa: E501
            query_params.append(('password', local_var_params['password']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = {}
        if 'content_md5' in local_var_params:
            header_params['Content-MD5'] = local_var_params['content_md5']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificates/import', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateCertificateSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_certificates_bundle(self, update_certificates_bundle, **kwargs):  # noqa: E501
        """Update a certificates bundle  # noqa: E501

        Upload the special certificates bundle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_certificates_bundle(update_certificates_bundle, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UpdateCertificatesBundle update_certificates_bundle: (required)
        :param str uid: Identifier of the certificates bundle.
        :param str name: Name of the certificates bundle.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateCertificatesBundleSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_certificates_bundle_with_http_info(update_certificates_bundle, **kwargs)  # noqa: E501

    def update_certificates_bundle_with_http_info(self, update_certificates_bundle, **kwargs):  # noqa: E501
        """Update a certificates bundle  # noqa: E501

        Upload the special certificates bundle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_certificates_bundle_with_http_info(update_certificates_bundle, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UpdateCertificatesBundle update_certificates_bundle: (required)
        :param str uid: Identifier of the certificates bundle.
        :param str name: Name of the certificates bundle.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateCertificatesBundleSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'update_certificates_bundle',
            'uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_certificates_bundle" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'update_certificates_bundle' is set
        if self.api_client.client_side_validation and ('update_certificates_bundle' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_certificates_bundle'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_certificates_bundle` when calling `update_certificates_bundle`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_certificates_bundle' in local_var_params:
            body_params = local_var_params['update_certificates_bundle']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/certificatesbundles', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateCertificatesBundleSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_compression_profile(self, uid, update_compression_profile, **kwargs):  # noqa: E501
        """Update a compression profile  # noqa: E501

        Update a existing compression profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_compression_profile(uid, update_compression_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Compression profile uid or name. (required)
        :param UpdateCompressionProfile update_compression_profile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateCompressionProfileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_compression_profile_with_http_info(uid, update_compression_profile, **kwargs)  # noqa: E501

    def update_compression_profile_with_http_info(self, uid, update_compression_profile, **kwargs):  # noqa: E501
        """Update a compression profile  # noqa: E501

        Update a existing compression profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_compression_profile_with_http_info(uid, update_compression_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Compression profile uid or name. (required)
        :param UpdateCompressionProfile update_compression_profile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateCompressionProfileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'update_compression_profile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_compression_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_compression_profile`")  # noqa: E501
        # verify the required parameter 'update_compression_profile' is set
        if self.api_client.client_side_validation and ('update_compression_profile' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_compression_profile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_compression_profile` when calling `update_compression_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_compression_profile' in local_var_params:
            body_params = local_var_params['update_compression_profile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/compressionprofiles', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateCompressionProfileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_icx(self, uid, update_icx, **kwargs):  # noqa: E501
        """Update an ICX configuration  # noqa: E501

        Update the ICX configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_icx(uid, update_icx, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the ICX configuration. (required)
        :param UpdateIcx update_icx: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateIcxSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_icx_with_http_info(uid, update_icx, **kwargs)  # noqa: E501

    def update_icx_with_http_info(self, uid, update_icx, **kwargs):  # noqa: E501
        """Update an ICX configuration  # noqa: E501

        Update the ICX configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_icx_with_http_info(uid, update_icx, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the ICX configuration. (required)
        :param UpdateIcx update_icx: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateIcxSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'update_icx'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_icx" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_icx`")  # noqa: E501
        # verify the required parameter 'update_icx' is set
        if self.api_client.client_side_validation and ('update_icx' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_icx'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_icx` when calling `update_icx`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_icx' in local_var_params:
            body_params = local_var_params['update_icx']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateIcxSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_icx_category(self, icx_uid, uid, update_icx_category, **kwargs):  # noqa: E501
        """Update an ICX Category  # noqa: E501

        Update the ICX category.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_icx_category(icx_uid, uid, update_icx_category, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str uid: ICX category uid. (required)
        :param UpdateIcxCategory update_icx_category: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateIcxCategorySuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_icx_category_with_http_info(icx_uid, uid, update_icx_category, **kwargs)  # noqa: E501

    def update_icx_category_with_http_info(self, icx_uid, uid, update_icx_category, **kwargs):  # noqa: E501
        """Update an ICX Category  # noqa: E501

        Update the ICX category.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_icx_category_with_http_info(icx_uid, uid, update_icx_category, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str uid: ICX category uid. (required)
        :param UpdateIcxCategory update_icx_category: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateIcxCategorySuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'icx_uid',
            'uid',
            'update_icx_category'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_icx_category" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'icx_uid' is set
        if self.api_client.client_side_validation and ('icx_uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['icx_uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `icx_uid` when calling `update_icx_category`")  # noqa: E501
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_icx_category`")  # noqa: E501
        # verify the required parameter 'update_icx_category' is set
        if self.api_client.client_side_validation and ('update_icx_category' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_icx_category'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_icx_category` when calling `update_icx_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'icx_uid' in local_var_params and local_var_params['icx_uid'] is not None:  # noqa: E501
            query_params.append(('icxUid', local_var_params['icx_uid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_icx_category' in local_var_params:
            body_params = local_var_params['update_icx_category']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx/categories', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateIcxCategorySuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_icx_rule(self, icx_uid, category_uid, uid, update_icx_rule, **kwargs):  # noqa: E501
        """Update an ICX Rule  # noqa: E501

        Update the ICX rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_icx_rule(icx_uid, category_uid, uid, update_icx_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str category_uid: ICX category uid. (required)
        :param str uid: ICX rule uid. (required)
        :param UpdateIcxRule update_icx_rule: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateIcxRuleSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_icx_rule_with_http_info(icx_uid, category_uid, uid, update_icx_rule, **kwargs)  # noqa: E501

    def update_icx_rule_with_http_info(self, icx_uid, category_uid, uid, update_icx_rule, **kwargs):  # noqa: E501
        """Update an ICX Rule  # noqa: E501

        Update the ICX rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_icx_rule_with_http_info(icx_uid, category_uid, uid, update_icx_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str icx_uid: ICX uid. (required)
        :param str category_uid: ICX category uid. (required)
        :param str uid: ICX rule uid. (required)
        :param UpdateIcxRule update_icx_rule: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateIcxRuleSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'icx_uid',
            'category_uid',
            'uid',
            'update_icx_rule'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_icx_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'icx_uid' is set
        if self.api_client.client_side_validation and ('icx_uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['icx_uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `icx_uid` when calling `update_icx_rule`")  # noqa: E501
        # verify the required parameter 'category_uid' is set
        if self.api_client.client_side_validation and ('category_uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['category_uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `category_uid` when calling `update_icx_rule`")  # noqa: E501
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_icx_rule`")  # noqa: E501
        # verify the required parameter 'update_icx_rule' is set
        if self.api_client.client_side_validation and ('update_icx_rule' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_icx_rule'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_icx_rule` when calling `update_icx_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'icx_uid' in local_var_params and local_var_params['icx_uid'] is not None:  # noqa: E501
            query_params.append(('icxUid', local_var_params['icx_uid']))  # noqa: E501
        if 'category_uid' in local_var_params and local_var_params['category_uid'] is not None:  # noqa: E501
            query_params.append(('categoryUid', local_var_params['category_uid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_icx_rule' in local_var_params:
            body_params = local_var_params['update_icx_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/icx/categories/rules', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateIcxRuleSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_label(self, uid, update_label, **kwargs):  # noqa: E501
        """Update a label  # noqa: E501

        Upload the special label.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_label(uid, update_label, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the label. (required)
        :param UpdateLabel update_label: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateLabelSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_label_with_http_info(uid, update_label, **kwargs)  # noqa: E501

    def update_label_with_http_info(self, uid, update_label, **kwargs):  # noqa: E501
        """Update a label  # noqa: E501

        Upload the special label.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_label_with_http_info(uid, update_label, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the label. (required)
        :param UpdateLabel update_label: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateLabelSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'update_label'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_label" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_label`")  # noqa: E501
        # verify the required parameter 'update_label' is set
        if self.api_client.client_side_validation and ('update_label' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_label'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_label` when calling `update_label`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_label' in local_var_params:
            body_params = local_var_params['update_label']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/labels', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateLabelSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_network_interface(self, name, update_network_interface, **kwargs):  # noqa: E501
        """Update a network interface  # noqa: E501

        Update a existing network interface  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_network_interface(name, update_network_interface, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Identifier of the network interface. (required)
        :param UpdateNetworkInterface update_network_interface: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateNetworkInterfaceSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_network_interface_with_http_info(name, update_network_interface, **kwargs)  # noqa: E501

    def update_network_interface_with_http_info(self, name, update_network_interface, **kwargs):  # noqa: E501
        """Update a network interface  # noqa: E501

        Update a existing network interface  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_network_interface_with_http_info(name, update_network_interface, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Identifier of the network interface. (required)
        :param UpdateNetworkInterface update_network_interface: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateNetworkInterfaceSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name',
            'update_network_interface'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_network_interface" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `update_network_interface`")  # noqa: E501
        # verify the required parameter 'update_network_interface' is set
        if self.api_client.client_side_validation and ('update_network_interface' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_network_interface'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_network_interface` when calling `update_network_interface`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_network_interface' in local_var_params:
            body_params = local_var_params['update_network_interface']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/networkdevices/interfaces', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateNetworkInterfaceSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ntp(self, uid, update_ntp, **kwargs):  # noqa: E501
        """Update a ntp  # noqa: E501

        Upload the special ntp.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ntp(uid, update_ntp, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the ntp. (required)
        :param UpdateNtp update_ntp: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateNtpSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_ntp_with_http_info(uid, update_ntp, **kwargs)  # noqa: E501

    def update_ntp_with_http_info(self, uid, update_ntp, **kwargs):  # noqa: E501
        """Update a ntp  # noqa: E501

        Upload the special ntp.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ntp_with_http_info(uid, update_ntp, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the ntp. (required)
        :param UpdateNtp update_ntp: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateNtpSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'update_ntp'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ntp" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_ntp`")  # noqa: E501
        # verify the required parameter 'update_ntp' is set
        if self.api_client.client_side_validation and ('update_ntp' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_ntp'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_ntp` when calling `update_ntp`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_ntp' in local_var_params:
            body_params = local_var_params['update_ntp']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ntp', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateNtpSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ramdisk_cache(self, uid, update_ramdisk_cache, **kwargs):  # noqa: E501
        """Update a Ramdisk cache profile  # noqa: E501

        Upload the Ramdisk cache profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ramdisk_cache(uid, update_ramdisk_cache, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the Ramdisk cache profile. (required)
        :param UpdateRamdiskCache update_ramdisk_cache: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateRamdiskCacheSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_ramdisk_cache_with_http_info(uid, update_ramdisk_cache, **kwargs)  # noqa: E501

    def update_ramdisk_cache_with_http_info(self, uid, update_ramdisk_cache, **kwargs):  # noqa: E501
        """Update a Ramdisk cache profile  # noqa: E501

        Upload the Ramdisk cache profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ramdisk_cache_with_http_info(uid, update_ramdisk_cache, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the Ramdisk cache profile. (required)
        :param UpdateRamdiskCache update_ramdisk_cache: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateRamdiskCacheSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'update_ramdisk_cache'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ramdisk_cache" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_ramdisk_cache`")  # noqa: E501
        # verify the required parameter 'update_ramdisk_cache' is set
        if self.api_client.client_side_validation and ('update_ramdisk_cache' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_ramdisk_cache'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_ramdisk_cache` when calling `update_ramdisk_cache`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_ramdisk_cache' in local_var_params:
            body_params = local_var_params['update_ramdisk_cache']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ramdiskcacheprofiles', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateRamdiskCacheSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_requesttimeoutprofile(self, uid, update_requesttimeoutprofile, **kwargs):  # noqa: E501
        """Update an request timeout profile  # noqa: E501

        Update an request timeout profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_requesttimeoutprofile(uid, update_requesttimeoutprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the request timeout profile. (required)
        :param UpdateRequesttimeoutprofile update_requesttimeoutprofile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateRequesttimeoutprofileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_requesttimeoutprofile_with_http_info(uid, update_requesttimeoutprofile, **kwargs)  # noqa: E501

    def update_requesttimeoutprofile_with_http_info(self, uid, update_requesttimeoutprofile, **kwargs):  # noqa: E501
        """Update an request timeout profile  # noqa: E501

        Update an request timeout profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_requesttimeoutprofile_with_http_info(uid, update_requesttimeoutprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the request timeout profile. (required)
        :param UpdateRequesttimeoutprofile update_requesttimeoutprofile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateRequesttimeoutprofileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'update_requesttimeoutprofile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_requesttimeoutprofile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_requesttimeoutprofile`")  # noqa: E501
        # verify the required parameter 'update_requesttimeoutprofile' is set
        if self.api_client.client_side_validation and ('update_requesttimeoutprofile' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_requesttimeoutprofile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_requesttimeoutprofile` when calling `update_requesttimeoutprofile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_requesttimeoutprofile' in local_var_params:
            body_params = local_var_params['update_requesttimeoutprofile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/requesttimeoutprofiles', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateRequesttimeoutprofileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_reverse_proxy(self, uid, update_reverse_proxy, **kwargs):  # noqa: E501
        """Update a reverse proxy  # noqa: E501

        Update a existing reverse proxy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_reverse_proxy(uid, update_reverse_proxy, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the reverse proxy. (required)
        :param UpdateReverseProxy update_reverse_proxy: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateReverseProxySuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_reverse_proxy_with_http_info(uid, update_reverse_proxy, **kwargs)  # noqa: E501

    def update_reverse_proxy_with_http_info(self, uid, update_reverse_proxy, **kwargs):  # noqa: E501
        """Update a reverse proxy  # noqa: E501

        Update a existing reverse proxy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_reverse_proxy_with_http_info(uid, update_reverse_proxy, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the reverse proxy. (required)
        :param UpdateReverseProxy update_reverse_proxy: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateReverseProxySuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'update_reverse_proxy'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_reverse_proxy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_reverse_proxy`")  # noqa: E501
        # verify the required parameter 'update_reverse_proxy' is set
        if self.api_client.client_side_validation and ('update_reverse_proxy' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_reverse_proxy'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_reverse_proxy` when calling `update_reverse_proxy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_reverse_proxy' in local_var_params:
            body_params = local_var_params['update_reverse_proxy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/reverseproxies', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateReverseProxySuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_reverse_proxy_profile(self, uid, update_reverse_proxy_profile, **kwargs):  # noqa: E501
        """Update a reverse proxy profile  # noqa: E501

        Update a existing reverse proxy profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_reverse_proxy_profile(uid, update_reverse_proxy_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Reverse proxy profile uid or name. (required)
        :param UpdateReverseProxyProfile update_reverse_proxy_profile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateReverseProxyProfileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_reverse_proxy_profile_with_http_info(uid, update_reverse_proxy_profile, **kwargs)  # noqa: E501

    def update_reverse_proxy_profile_with_http_info(self, uid, update_reverse_proxy_profile, **kwargs):  # noqa: E501
        """Update a reverse proxy profile  # noqa: E501

        Update a existing reverse proxy profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_reverse_proxy_profile_with_http_info(uid, update_reverse_proxy_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Reverse proxy profile uid or name. (required)
        :param UpdateReverseProxyProfile update_reverse_proxy_profile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateReverseProxyProfileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'update_reverse_proxy_profile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_reverse_proxy_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_reverse_proxy_profile`")  # noqa: E501
        # verify the required parameter 'update_reverse_proxy_profile' is set
        if self.api_client.client_side_validation and ('update_reverse_proxy_profile' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_reverse_proxy_profile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_reverse_proxy_profile` when calling `update_reverse_proxy_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_reverse_proxy_profile' in local_var_params:
            body_params = local_var_params['update_reverse_proxy_profile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/reverseproxyprofiles', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateReverseProxyProfileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_scoringlist(self, uid, update_scoringlist, **kwargs):  # noqa: E501
        """Update a scoringlist configuration  # noqa: E501

        Update the special scoringlist configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_scoringlist(uid, update_scoringlist, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the scoringlist configuration. (required)
        :param UpdateScoringlist update_scoringlist: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateScoringlistSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_scoringlist_with_http_info(uid, update_scoringlist, **kwargs)  # noqa: E501

    def update_scoringlist_with_http_info(self, uid, update_scoringlist, **kwargs):  # noqa: E501
        """Update a scoringlist configuration  # noqa: E501

        Update the special scoringlist configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_scoringlist_with_http_info(uid, update_scoringlist, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Identifier of the scoringlist configuration. (required)
        :param UpdateScoringlist update_scoringlist: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateScoringlistSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'update_scoringlist'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_scoringlist" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_scoringlist`")  # noqa: E501
        # verify the required parameter 'update_scoringlist' is set
        if self.api_client.client_side_validation and ('update_scoringlist' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_scoringlist'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_scoringlist` when calling `update_scoringlist`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_scoringlist' in local_var_params:
            body_params = local_var_params['update_scoringlist']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/scoringlist', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateScoringlistSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_scoringlist_exception(self, uid, update_scoringlist_exception, **kwargs):  # noqa: E501
        """Update a scoringlist exception  # noqa: E501

        Update the special scoringlist exception.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_scoringlist_exception(uid, update_scoringlist_exception, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Uid of the new scoringlist exception. (required)
        :param UpdateScoringlistException update_scoringlist_exception: (required)
        :param str scoringlist_uid: Scoringlist uid.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateScoringlistExceptionSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_scoringlist_exception_with_http_info(uid, update_scoringlist_exception, **kwargs)  # noqa: E501

    def update_scoringlist_exception_with_http_info(self, uid, update_scoringlist_exception, **kwargs):  # noqa: E501
        """Update a scoringlist exception  # noqa: E501

        Update the special scoringlist exception.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_scoringlist_exception_with_http_info(uid, update_scoringlist_exception, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: Uid of the new scoringlist exception. (required)
        :param UpdateScoringlistException update_scoringlist_exception: (required)
        :param str scoringlist_uid: Scoringlist uid.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateScoringlistExceptionSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'update_scoringlist_exception',
            'scoringlist_uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_scoringlist_exception" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_scoringlist_exception`")  # noqa: E501
        # verify the required parameter 'update_scoringlist_exception' is set
        if self.api_client.client_side_validation and ('update_scoringlist_exception' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_scoringlist_exception'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_scoringlist_exception` when calling `update_scoringlist_exception`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scoringlist_uid' in local_var_params and local_var_params['scoringlist_uid'] is not None:  # noqa: E501
            query_params.append(('scoringlistUid', local_var_params['scoringlist_uid']))  # noqa: E501
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_scoringlist_exception' in local_var_params:
            body_params = local_var_params['update_scoringlist_exception']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/scoringlist/exceptions', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateScoringlistExceptionSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_security_exception_profile(self, uid, update_security_exception_profile, **kwargs):  # noqa: E501
        """Update a Security Exception Profile  # noqa: E501

        Update a security exception profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_security_exception_profile(uid, update_security_exception_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: security exception profile uid or name. (required)
        :param UpdateSecurityExceptionProfile update_security_exception_profile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateSecurityExceptionProfileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_security_exception_profile_with_http_info(uid, update_security_exception_profile, **kwargs)  # noqa: E501

    def update_security_exception_profile_with_http_info(self, uid, update_security_exception_profile, **kwargs):  # noqa: E501
        """Update a Security Exception Profile  # noqa: E501

        Update a security exception profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_security_exception_profile_with_http_info(uid, update_security_exception_profile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str uid: security exception profile uid or name. (required)
        :param UpdateSecurityExceptionProfile update_security_exception_profile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateSecurityExceptionProfileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'uid',
            'update_security_exception_profile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_security_exception_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uid' is set
        if self.api_client.client_side_validation and ('uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uid` when calling `update_security_exception_profile`")  # noqa: E501
        # verify the required parameter 'update_security_exception_profile' is set
        if self.api_client.client_side_validation and ('update_security_exception_profile' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_security_exception_profile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_security_exception_profile` when calling `update_security_exception_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_security_exception_profile' in local_var_params:
            body_params = local_var_params['update_security_exception_profile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securityexceptions', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateSecurityExceptionProfileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_sysctlprofile(self, name, update_sysctlprofile, **kwargs):  # noqa: E501
        """Update a Sysctl profile  # noqa: E501

        Upload the special Sysctl profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sysctlprofile(name, update_sysctlprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Identifier of the Sysctl profile. (required)
        :param UpdateSysctlprofile update_sysctlprofile: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateSysctlprofileSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_sysctlprofile_with_http_info(name, update_sysctlprofile, **kwargs)  # noqa: E501

    def update_sysctlprofile_with_http_info(self, name, update_sysctlprofile, **kwargs):  # noqa: E501
        """Update a Sysctl profile  # noqa: E501

        Upload the special Sysctl profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sysctlprofile_with_http_info(name, update_sysctlprofile, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Identifier of the Sysctl profile. (required)
        :param UpdateSysctlprofile update_sysctlprofile: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateSysctlprofileSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name',
            'update_sysctlprofile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_sysctlprofile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `update_sysctlprofile`")  # noqa: E501
        # verify the required parameter 'update_sysctlprofile' is set
        if self.api_client.client_side_validation and ('update_sysctlprofile' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_sysctlprofile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_sysctlprofile` when calling `update_sysctlprofile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_sysctlprofile' in local_var_params:
            body_params = local_var_params['update_sysctlprofile']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/sysctl', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateSysctlprofileSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tunnel(self, update_tunnel, **kwargs):  # noqa: E501
        """Update a tunnel  # noqa: E501

        Update an existing tunnel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tunnel(update_tunnel, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UpdateTunnel update_tunnel: (required)
        :param str uid: Tunnel uid.
        :param str name: Tunnel name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdateTunnelSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_tunnel_with_http_info(update_tunnel, **kwargs)  # noqa: E501

    def update_tunnel_with_http_info(self, update_tunnel, **kwargs):  # noqa: E501
        """Update a tunnel  # noqa: E501

        Update an existing tunnel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tunnel_with_http_info(update_tunnel, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UpdateTunnel update_tunnel: (required)
        :param str uid: Tunnel uid.
        :param str name: Tunnel name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdateTunnelSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'update_tunnel',
            'uid',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tunnel" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'update_tunnel' is set
        if self.api_client.client_side_validation and ('update_tunnel' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_tunnel'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_tunnel` when calling `update_tunnel`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params and local_var_params['uid'] is not None:  # noqa: E501
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_tunnel' in local_var_params:
            body_params = local_var_params['update_tunnel']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tunnels', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateTunnelSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_license(self, **kwargs):  # noqa: E501
        """Upload a license file  # noqa: E501

        Upload a license file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_license(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_md5: The md5sum of uploaded file. If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>
        :param file upload:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UploadLicenseSuccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upload_license_with_http_info(**kwargs)  # noqa: E501

    def upload_license_with_http_info(self, **kwargs):  # noqa: E501
        """Upload a license file  # noqa: E501

        Upload a license file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_license_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_md5: The md5sum of uploaded file. If you use cURL, specify <code>-H \"Content-MD5: b063ea6ddd4af4e20ab27e7fb8e62079\"</code>
        :param file upload:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UploadLicenseSuccess, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'content_md5',
            'upload'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_license" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'content_md5' in local_var_params:
            header_params['Content-MD5'] = local_var_params['content_md5']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'upload' in local_var_params:
            local_var_files['upload'] = local_var_params['upload']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/licenses', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UploadLicenseSuccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
