/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

public abstract class ScriptedPageProcessor {
    protected String title;
    protected int level;

    public ScriptedPageProcessor(String title, int level) {
        this.title = title;
        this.level = level;
    }

    public String process(String content) throws Exception {
        StringBuilder outcome = new StringBuilder();
        int cursor = 0;
        while (cursor < content.length()) {
            if (this.nextIs(content, cursor, "[%")) {
                cursor = this.processEntry(outcome, content, cursor, "%]");
                continue;
            }
            if (this.nextIs(content, cursor, "<%")) {
                cursor = this.processEntry(outcome, content, cursor, "%>");
                continue;
            }
            outcome.append(content.charAt(cursor));
            ++cursor;
        }
        return outcome.toString();
    }

    private int processEntry(StringBuilder outcome, String content, int cursor, String endText) throws Exception {
        int start;
        for (int end = start = cursor + endText.length(); end < content.length(); ++end) {
            if (!this.nextIs(content, end, endText)) continue;
            outcome.append(this.process(this.getContent(content.substring(start, end))));
            return end + endText.length();
        }
        throw new FHIRException("unterminated insert sequence");
    }

    private String getContent(String command) throws Exception {
        if (Utilities.noString(command) || command.startsWith("!")) {
            return "";
        }
        String[] parts = command.split("\\ ");
        return this.processCommand(command, parts);
    }

    protected String processCommand(String command, String[] com) throws Exception {
        if (com[0].equals("title")) {
            return this.title;
        }
        if (com[0].equals("xtitle")) {
            return Utilities.escapeXml(this.title);
        }
        if (com[0].equals("level")) {
            return this.genlevel();
        }
        if (com[0].equals("settitle")) {
            this.title = command.substring(9).replace("{", "<%").replace("}", "%>");
            return "";
        }
        throw new FHIRException("Unknown command " + com[0]);
    }

    private boolean nextIs(String content, int cursor, String value) {
        if (cursor + value.length() > content.length()) {
            return false;
        }
        String v = content.substring(cursor, cursor + value.length());
        return v.equals(value);
    }

    public String genlevel() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.level; ++i) {
            b.append("../");
        }
        return b.toString();
    }
}

