/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationrequestStatus {
    ACTIVE,
    ONHOLD,
    CANCELLED,
    COMPLETED,
    ENTEREDINERROR,
    STOPPED,
    DRAFT,
    UNKNOWN,
    NULL;


    public static MedicationrequestStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("on-hold".equals(codeString)) {
            return ONHOLD;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("stopped".equals(codeString)) {
            return STOPPED;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown MedicationrequestStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case ONHOLD: {
                return "on-hold";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case STOPPED: {
                return "stopped";
            }
            case DRAFT: {
                return "draft";
            }
            case UNKNOWN: {
                return "unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/CodeSystem/medicationrequest-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "The prescription is 'actionable', but not all actions that are implied by it have occurred yet.";
            }
            case ONHOLD: {
                return "Actions implied by the prescription are to be temporarily halted, but are expected to continue later.  May also be called 'suspended'.";
            }
            case CANCELLED: {
                return "The prescription has been withdrawn before any administrations have occurred";
            }
            case COMPLETED: {
                return "All actions that are implied by the prescription have occurred.";
            }
            case ENTEREDINERROR: {
                return "Some of the actions that are implied by the medication request may have occurred.  For example, the medication may have been dispensed and the patient may have taken some of the medication.  Clinical decision support systems should take this status into account";
            }
            case STOPPED: {
                return "Actions implied by the prescription are to be permanently halted, before all of the administrations occurred. This should not be used if the original order was entered in error";
            }
            case DRAFT: {
                return "The prescription is not yet 'actionable', e.g. it is a work in progress, requires sign-off, verification\u00a0or\u00a0needs to be run through decision support process.";
            }
            case UNKNOWN: {
                return "The authoring/source system does not know which of the status values currently applies for this observation. Note: This concept is not to be used for 'other' - one of the listed statuses is presumed to apply, but the authoring/source system does not know which.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case ONHOLD: {
                return "On Hold";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case STOPPED: {
                return "Stopped";
            }
            case DRAFT: {
                return "Draft";
            }
            case UNKNOWN: {
                return "Unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

