/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationdispenseStatus {
    PREPARATION,
    INPROGRESS,
    CANCELLED,
    ONHOLD,
    COMPLETED,
    ENTEREDINERROR,
    STOPPED,
    DECLINED,
    UNKNOWN,
    NULL;


    public static MedicationdispenseStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("preparation".equals(codeString)) {
            return PREPARATION;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("on-hold".equals(codeString)) {
            return ONHOLD;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("stopped".equals(codeString)) {
            return STOPPED;
        }
        if ("declined".equals(codeString)) {
            return DECLINED;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown MedicationdispenseStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PREPARATION: {
                return "preparation";
            }
            case INPROGRESS: {
                return "in-progress";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case ONHOLD: {
                return "on-hold";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case STOPPED: {
                return "stopped";
            }
            case DECLINED: {
                return "declined";
            }
            case UNKNOWN: {
                return "unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/medicationdispense-status";
    }

    public String getDefinition() {
        switch (this) {
            case PREPARATION: {
                return "The core event has not started yet, but some staging activities have begun (e.g. initial compounding or packaging of medication). Preparation stages may be tracked for billing purposes.";
            }
            case INPROGRESS: {
                return "The dispensed product is ready for pickup.";
            }
            case CANCELLED: {
                return "The dispensed product was not and will never be picked up by the patient.";
            }
            case ONHOLD: {
                return "The dispense process is paused while waiting for an external event to reactivate the dispense.  For example, new stock has arrived or the prescriber has called.";
            }
            case COMPLETED: {
                return "The dispensed product has been picked up.";
            }
            case ENTEREDINERROR: {
                return "The dispense was entered in error and therefore nullified.";
            }
            case STOPPED: {
                return "Actions implied by the dispense have been permanently halted, before all of them occurred.";
            }
            case DECLINED: {
                return "The dispense was declined and not performed.";
            }
            case UNKNOWN: {
                return "The authoring system does not know which of the status values applies for this medication dispense.  Note: this concept is not to be used for other - one of the listed statuses is presumed to apply, it's just now known which one.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PREPARATION: {
                return "Preparation";
            }
            case INPROGRESS: {
                return "In Progress";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case ONHOLD: {
                return "On Hold";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case STOPPED: {
                return "Stopped";
            }
            case DECLINED: {
                return "Declined";
            }
            case UNKNOWN: {
                return "Unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

