/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.PrimitiveType;

@DatatypeDef(name="uri")
public class UriType
extends PrimitiveType<String> {
    private static final long serialVersionUID = 3L;

    public UriType() {
    }

    public UriType(String theValue) {
        this.setValueAsString(theValue);
    }

    public UriType(URI theValue) {
        this.setValue(theValue.toString());
    }

    @Override
    public UriType copy() {
        UriType ret = new UriType((String)this.getValue());
        this.copyValues(ret);
        return ret;
    }

    @Override
    protected String encode(String theValue) {
        return theValue;
    }

    public boolean equals(String theString) {
        return StringUtils.equals(this.getValueAsString(), theString);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        String normalize = this.normalize((String)this.getValue());
        result = 31 * result + (normalize == null ? 0 : normalize.hashCode());
        return result;
    }

    private String normalize(String theValue) {
        if (theValue == null) {
            return null;
        }
        try {
            URI retVal = new URI((String)this.getValue()).normalize();
            String urlString = retVal.toString();
            if (urlString.endsWith("/") && urlString.length() > 1) {
                retVal = new URI(urlString.substring(0, urlString.length() - 1));
            }
            return retVal.toASCIIString();
        }
        catch (URISyntaxException e) {
            return theValue;
        }
    }

    @Override
    protected String parse(String theValue) {
        return theValue;
    }

    public static OidType fromOid(String theOid) {
        if (theOid == null) {
            return new OidType();
        }
        return new OidType("urn:oid:" + theOid);
    }

    @Override
    public boolean equalsDeep(Base obj) {
        if (!super.equalsDeep(obj)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UriType other = (UriType)obj;
        if (this.getValue() == null && other.getValue() == null) {
            return true;
        }
        if (this.getValue() == null || other.getValue() == null) {
            return false;
        }
        if (((String)this.getValue()).equals(other.getValue())) {
            return true;
        }
        String normalize = this.normalize((String)this.getValue());
        String normalize2 = this.normalize((String)other.getValue());
        return normalize.equals(normalize2);
    }

    @Override
    public String fhirType() {
        return "uri";
    }
}

