/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.phonetic.ApacheEncoder;
import ca.uhn.fhir.context.phonetic.IPhoneticEncoder;
import ca.uhn.fhir.context.phonetic.NumericEncoder;
import ca.uhn.fhir.context.phonetic.PhoneticEncoderEnum;
import org.apache.commons.codec.language.Caverphone1;
import org.apache.commons.codec.language.Caverphone2;
import org.apache.commons.codec.language.ColognePhonetic;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.MatchRatingApproachEncoder;
import org.apache.commons.codec.language.Metaphone;
import org.apache.commons.codec.language.Nysiis;
import org.apache.commons.codec.language.RefinedSoundex;
import org.apache.commons.codec.language.Soundex;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhoneticEncoderUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(PhoneticEncoderUtil.class);

    private PhoneticEncoderUtil() {
    }

    public static IPhoneticEncoder getEncoder(String theString) {
        Integer encoderMaxString;
        ParsedValues values2 = PhoneticEncoderUtil.parseIntValue(theString);
        String encoderType = values2.getEncoderString();
        IPhoneticEncoder encoder = PhoneticEncoderUtil.getEncoderFromString(encoderType, encoderMaxString = values2.getMaxCodeLength());
        if (encoder != null) {
            return encoder;
        }
        ourLog.warn("Invalid phonetic param string " + theString);
        return null;
    }

    private static ParsedValues parseIntValue(String theString) {
        String encoderType = null;
        Integer encoderMaxString = null;
        int braceIndex = theString.indexOf("(");
        if (braceIndex != -1) {
            int len = theString.length();
            if (theString.charAt(len - 1) == ')') {
                encoderType = theString.substring(0, braceIndex);
                String num = theString.substring(braceIndex + 1, len - 1);
                try {
                    encoderMaxString = Integer.parseInt(num);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (encoderMaxString == null || encoderMaxString < 0) {
                    ourLog.error("Invalid encoder max character length: " + num);
                    encoderType = null;
                }
            }
        } else {
            encoderType = theString;
        }
        return new ParsedValues(encoderType, encoderMaxString);
    }

    private static IPhoneticEncoder getEncoderFromString(String theName, Integer theMax) {
        IPhoneticEncoder encoder = null;
        PhoneticEncoderEnum enumVal = EnumUtils.getEnum(PhoneticEncoderEnum.class, theName);
        if (enumVal != null) {
            switch (enumVal) {
                case CAVERPHONE1: {
                    Caverphone1 caverphone1 = new Caverphone1();
                    encoder = new ApacheEncoder(theName, caverphone1);
                    break;
                }
                case CAVERPHONE2: {
                    Caverphone2 caverphone2 = new Caverphone2();
                    encoder = new ApacheEncoder(theName, caverphone2);
                    break;
                }
                case COLOGNE: {
                    ColognePhonetic colognePhonetic = new ColognePhonetic();
                    encoder = new ApacheEncoder(theName, colognePhonetic);
                    break;
                }
                case DOUBLE_METAPHONE: {
                    DoubleMetaphone doubleMetaphone = new DoubleMetaphone();
                    if (theMax != null) {
                        doubleMetaphone.setMaxCodeLen(theMax);
                    }
                    encoder = new ApacheEncoder(theName, doubleMetaphone);
                    break;
                }
                case MATCH_RATING_APPROACH: {
                    MatchRatingApproachEncoder matchRatingApproachEncoder = new MatchRatingApproachEncoder();
                    encoder = new ApacheEncoder(theName, matchRatingApproachEncoder);
                    break;
                }
                case METAPHONE: {
                    Metaphone metaphone = new Metaphone();
                    if (theMax != null) {
                        metaphone.setMaxCodeLen(theMax);
                    }
                    encoder = new ApacheEncoder(theName, metaphone);
                    break;
                }
                case NYSIIS: {
                    Nysiis nysiis = new Nysiis();
                    encoder = new ApacheEncoder(theName, nysiis);
                    break;
                }
                case NYSIIS_LONG: {
                    Nysiis nysiis1_long = new Nysiis(false);
                    encoder = new ApacheEncoder(theName, nysiis1_long);
                    break;
                }
                case REFINED_SOUNDEX: {
                    RefinedSoundex refinedSoundex = new RefinedSoundex();
                    encoder = new ApacheEncoder(theName, refinedSoundex);
                    break;
                }
                case SOUNDEX: {
                    Soundex soundex = new Soundex();
                    encoder = new ApacheEncoder(theName, soundex);
                    break;
                }
                case NUMERIC: {
                    encoder = new NumericEncoder();
                    break;
                }
                default: {
                    ourLog.error("Unhandled PhoneticParamEnum value " + enumVal.name());
                }
            }
        }
        return encoder;
    }

    private static class ParsedValues {
        private final Integer maxCodeLength;
        private final String encoderString;

        public ParsedValues(String theString, Integer theMaxCode) {
            this.maxCodeLength = theMaxCode;
            this.encoderString = theString;
        }

        public Integer getMaxCodeLength() {
            return this.maxCodeLength;
        }

        public String getEncoderString() {
            return this.encoderString;
        }
    }
}

