/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FhirVersionIndependentConcept
implements Comparable<FhirVersionIndependentConcept> {
    private final String mySystem;
    private final String mySystemVersion;
    private final String myCode;
    private final String myDisplay;
    private int myHashCode;

    public FhirVersionIndependentConcept(String theSystem, String theCode) {
        this(theSystem, theCode, null);
    }

    public FhirVersionIndependentConcept(String theSystem, String theCode, String theDisplay) {
        this(theSystem, theCode, theDisplay, null);
    }

    public FhirVersionIndependentConcept(String theSystem, String theCode, String theDisplay, String theSystemVersion) {
        this.mySystem = theSystem;
        this.mySystemVersion = theSystemVersion;
        this.myCode = theCode;
        this.myDisplay = theDisplay;
        this.myHashCode = new HashCodeBuilder(17, 37).append(this.mySystem).append(this.myCode).toHashCode();
    }

    public String getDisplay() {
        return this.myDisplay;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public String getSystemVersion() {
        return this.mySystemVersion;
    }

    public String getCode() {
        return this.myCode;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        FhirVersionIndependentConcept that = (FhirVersionIndependentConcept)theO;
        return new EqualsBuilder().append(this.mySystem, that.mySystem).append(this.myCode, that.myCode).isEquals();
    }

    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    public int compareTo(FhirVersionIndependentConcept theOther) {
        CompareToBuilder b = new CompareToBuilder();
        b.append(this.mySystem, theOther.getSystem());
        b.append(this.myCode, theOther.getCode());
        return b.toComparison();
    }

    public String toString() {
        return "[" + this.mySystem + "|" + this.myCode + "]";
    }
}

