/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param.binder;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.param.binder.BaseBinder;
import ca.uhn.fhir.rest.param.binder.IParamBinder;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.List;

public final class QueryParameterAndBinder
extends BaseBinder<IQueryParameterAnd<?>>
implements IParamBinder<IQueryParameterAnd<?>> {
    public QueryParameterAndBinder(Class<? extends IQueryParameterAnd<?>> theType, List<Class<? extends IQueryParameterType>> theCompositeTypes) {
        super(theType, theCompositeTypes);
    }

    @Override
    public List<IQueryParameterOr<?>> encode(FhirContext theContext, IQueryParameterAnd<?> theString) throws InternalErrorException {
        List<IQueryParameterOr<?>> retVal = theString.getValuesAsQueryTokens();
        return retVal;
    }

    @Override
    public IQueryParameterAnd<?> parse(FhirContext theContext, String theParamName, List<QualifiedParamList> theString) throws InternalErrorException, InvalidRequestException {
        IQueryParameterAnd dt;
        try {
            dt = (IQueryParameterAnd)this.newInstance();
            dt.setValuesAsQueryTokens(theContext, theParamName, theString);
        }
        catch (SecurityException e) {
            throw new InternalErrorException(Msg.code(1952) + e);
        }
        return dt;
    }
}

