/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.util.CoverageIgnore;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class ReferenceParam
extends BaseParam {
    private String myChain;
    private String myResourceType;
    private String myBaseUrl;
    private String myValue;
    private String myIdPart;
    private Boolean myMdmExpand;

    public ReferenceParam() {
    }

    public ReferenceParam(String theValue) {
        this.setValueAsQueryToken(null, null, null, theValue);
    }

    public ReferenceParam(String theChain, String theValue) {
        this.setValueAsQueryToken(null, null, null, theValue);
        this.setChain(theChain);
    }

    public ReferenceParam(String theResourceType, String theChain, String theValue) {
        Object qualifier = "";
        if (StringUtils.isNotBlank(theResourceType)) {
            qualifier = ":" + theResourceType;
        }
        if (StringUtils.isNotBlank(theChain)) {
            qualifier = (String)qualifier + "." + theChain;
        }
        this.setValueAsQueryToken(null, null, (String)qualifier, theValue);
    }

    public ReferenceParam(IIdType theValue) {
        if (theValue != null) {
            this.setValueAsQueryToken(null, null, null, theValue.getValue());
        }
    }

    private String defaultGetQueryParameterQualifier() {
        StringBuilder b = new StringBuilder();
        if (StringUtils.isNotBlank(this.myChain)) {
            if (StringUtils.isNotBlank(this.getResourceType())) {
                b.append(':');
                b.append(this.getResourceType());
            }
            b.append('.');
            b.append(this.myChain);
        }
        if (b.length() != 0) {
            return b.toString();
        }
        return null;
    }

    @Override
    String doGetQueryParameterQualifier() {
        return this.myMdmExpand != null ? ":mdm" : this.defaultGetQueryParameterQualifier();
    }

    @Override
    String doGetValueAsQueryToken(FhirContext theContext) {
        if (StringUtils.isBlank(this.getResourceType())) {
            return this.myValue;
        }
        if (StringUtils.isBlank(this.getChain()) && StringUtils.isNotBlank(this.getResourceType())) {
            return this.getResourceType() + "/" + this.getIdPart();
        }
        return this.myValue;
    }

    @Override
    void doSetValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theValue) {
        String q;
        if (":mdm".equals(theQualifier)) {
            this.myMdmExpand = true;
            theQualifier = "";
        }
        if (StringUtils.isNotBlank(q = theQualifier)) {
            if (q.startsWith(":")) {
                int nextIdx = q.indexOf(46);
                if (nextIdx != -1) {
                    this.myChain = q.substring(nextIdx + 1);
                    this.myResourceType = q.substring(1, nextIdx);
                } else {
                    this.myChain = null;
                    this.myResourceType = q.substring(1);
                }
                this.myValue = theValue;
                this.myIdPart = theValue;
                IdDt id = new IdDt(theValue);
                if (!id.hasBaseUrl() && id.hasIdPart() && id.hasResourceType() && id.getResourceType().equals(this.myResourceType)) {
                    this.myIdPart = id.getIdPart();
                }
            } else if (q.startsWith(".")) {
                this.myChain = q.substring(1);
                this.myResourceType = null;
                this.myValue = theValue;
                this.myIdPart = theValue;
            }
        } else {
            this.myChain = null;
            this.myValue = theValue;
            IdDt id = new IdDt(theValue);
            this.myResourceType = id.getResourceType();
            this.myIdPart = id.getIdPart();
            this.myBaseUrl = id.getBaseUrl();
        }
    }

    @CoverageIgnore
    public String getBaseUrl() {
        return this.myBaseUrl;
    }

    public boolean isMdmExpand() {
        return this.myMdmExpand != null && this.myMdmExpand != false;
    }

    public ReferenceParam setMdmExpand(boolean theMdmExpand) {
        this.myMdmExpand = theMdmExpand;
        return this;
    }

    public String getChain() {
        return this.myChain;
    }

    public ReferenceParam setChain(String theChain) {
        this.myChain = theChain;
        return this;
    }

    @CoverageIgnore
    public String getIdPart() {
        return this.myIdPart;
    }

    @CoverageIgnore
    public BigDecimal getIdPartAsBigDecimal() {
        return new IdDt(this.myValue).getIdPartAsBigDecimal();
    }

    @CoverageIgnore
    public Long getIdPartAsLong() {
        return new IdDt(this.myValue).getIdPartAsLong();
    }

    public String getResourceType() {
        if (StringUtils.isNotBlank(this.myResourceType)) {
            return this.myResourceType;
        }
        if (StringUtils.isBlank(this.myChain)) {
            return new IdDt(this.myValue).getResourceType();
        }
        return null;
    }

    public Class<? extends IBaseResource> getResourceType(FhirContext theCtx) {
        if (StringUtils.isBlank(this.getResourceType())) {
            return null;
        }
        return theCtx.getResourceDefinition(this.getResourceType()).getImplementingClass();
    }

    public String getValue() {
        return this.myValue;
    }

    public ReferenceParam setValue(String theValue) {
        IdDt id = new IdDt(theValue);
        String qualifier = null;
        if (id.hasResourceType()) {
            qualifier = ":" + id.getResourceType();
        }
        this.setValueAsQueryToken(null, null, qualifier, id.getIdPart());
        return this;
    }

    public boolean hasResourceType() {
        return StringUtils.isNotBlank(this.myResourceType);
    }

    @Override
    protected boolean isSupportsChain() {
        return true;
    }

    public DateParam toDateParam(FhirContext theContext) {
        DateParam retVal = new DateParam();
        retVal.setValueAsQueryToken(theContext, null, null, this.getValueAsQueryToken(theContext));
        return retVal;
    }

    public NumberParam toNumberParam(FhirContext theContext) {
        NumberParam retVal = new NumberParam();
        retVal.setValueAsQueryToken(theContext, null, null, this.getValueAsQueryToken(theContext));
        return retVal;
    }

    public QuantityParam toQuantityParam(FhirContext theContext) {
        QuantityParam retVal = new QuantityParam();
        retVal.setValueAsQueryToken(theContext, null, null, this.getValueAsQueryToken(theContext));
        return retVal;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        if (StringUtils.isNotBlank(this.myChain)) {
            b.append("chain", this.myChain);
        }
        b.append("value", this.getValue());
        return b.build();
    }

    public StringParam toStringParam(FhirContext theContext) {
        StringParam retVal = new StringParam();
        retVal.setValueAsQueryToken(theContext, null, null, this.getValueAsQueryToken(theContext));
        return retVal;
    }

    public TokenParam toTokenParam(FhirContext theContext) {
        TokenParam retVal = new TokenParam();
        retVal.setValueAsQueryToken(theContext, null, null, this.getValueAsQueryToken(theContext));
        return retVal;
    }

    public boolean isIdPartValidLong() {
        return IdDt.isValidLong(this.getIdPart());
    }
}

