/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.annotation.Delete;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.client.method.BaseOutcomeReturningMethodBinding;
import ca.uhn.fhir.rest.param.ParameterUtil;
import java.lang.reflect.Method;
import org.hl7.fhir.instance.model.api.IBaseResource;

public abstract class BaseOutcomeReturningMethodBindingWithResourceIdButNoResourceBody
extends BaseOutcomeReturningMethodBinding {
    private String myResourceName;
    private Integer myIdParameterIndex;

    public BaseOutcomeReturningMethodBindingWithResourceIdButNoResourceBody(Method theMethod, FhirContext theContext, Object theProvider, Class<?> theMethodAnnotationType, Class<? extends IBaseResource> theResourceTypeFromAnnotation) {
        super(theMethod, theContext, theMethodAnnotationType, theProvider);
        Class<? extends IBaseResource> resourceType = theResourceTypeFromAnnotation;
        if (resourceType == IBaseResource.class) {
            throw new ConfigurationException(Msg.code(1474) + "Can not determine resource type for method '" + theMethod.getName() + "' on type " + theMethod.getDeclaringClass().getCanonicalName() + " - Did you forget to include the resourceType() value on the @" + Delete.class.getSimpleName() + " method annotation?");
        }
        RuntimeResourceDefinition def = theContext.getResourceDefinition(resourceType);
        this.myResourceName = def.getName();
        this.myIdParameterIndex = ParameterUtil.findIdParameterIndex(theMethod, this.getContext());
        if (this.myIdParameterIndex == null) {
            throw new ConfigurationException(Msg.code(1475) + "Method '" + theMethod.getName() + "' on type '" + theMethod.getDeclaringClass().getCanonicalName() + "' has no parameter annotated with the @" + IdParam.class.getSimpleName() + " annotation");
        }
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    protected Integer getIdParameterIndex() {
        return this.myIdParameterIndex;
    }
}

