/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology;

import au.csiro.pathling.fhirpath.encoding.ImmutableCoding;
import au.csiro.pathling.fhirpath.encoding.SimpleCoding;
import au.csiro.pathling.terminology.BaseMapping;
import au.csiro.pathling.terminology.ConceptTranslator;
import au.csiro.pathling.utilities.Preconditions;
import ca.uhn.fhir.context.FhirContext;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.UriType;

public final class TranslateMapping
extends BaseMapping {
    private TranslateMapping() {
    }

    @Nonnull
    public static Bundle toRequestBundle(@Nonnull Iterable<SimpleCoding> codings, @Nonnull String conceptMapUrl, boolean reverse) {
        Bundle translateBatch = new Bundle();
        translateBatch.setType(Bundle.BundleType.BATCH);
        codings.forEach(coding -> {
            Bundle.BundleEntryComponent entry = translateBatch.addEntry();
            Bundle.BundleEntryRequestComponent request = entry.getRequest();
            request.setMethod(Bundle.HTTPVerb.POST);
            request.setUrl("ConceptMap/$translate");
            Parameters parameters = new Parameters();
            entry.setResource(parameters);
            parameters.addParameter().setName("url").setValue(new UriType(conceptMapUrl));
            parameters.addParameter("reverse", reverse);
            parameters.addParameter().setName("coding").setValue(coding.toCoding());
        });
        return translateBatch;
    }

    @Nonnull
    public static ConceptTranslator fromResponseBundle(@Nonnull Bundle responseBundle, @Nonnull List<SimpleCoding> inputCodes, @Nonnull Collection<Enumerations.ConceptMapEquivalence> equivalences, @Nonnull FhirContext fhirContext) {
        Preconditions.checkResponse("batch-response".equals(responseBundle.getType().toCode()), "Expected bundle type 'batch-response' but got: '%s'", responseBundle.getType().toCode());
        Preconditions.checkResponse(inputCodes.size() == responseBundle.getEntry().size(), "The size of the response bundle: %s does not match the size of the request bundle: %s", inputCodes.size(), responseBundle.getEntry().size());
        Set equivalenceCodes = equivalences.stream().map(Enumerations.ConceptMapEquivalence::toCode).collect(Collectors.toSet());
        Stream<List> outputEntries = responseBundle.getEntry().stream().map(e -> TranslateMapping.parametersFromEntry(e, fhirContext)).map(TranslateMapping::entriesFromParameters).map(s2 -> s2.filter(e -> equivalenceCodes.contains(e.getEquivalence().getCode())).map(TranslationEntry::getConcept).map(ImmutableCoding::of).collect(Collectors.toUnmodifiableList()));
        Stream<Pair> pairs = Streams.zip(inputCodes.stream(), outputEntries, Pair::of);
        return new ConceptTranslator(pairs.filter(p -> !((List)p.getValue()).isEmpty()).collect(Collectors.toUnmodifiableMap(Pair::getKey, Pair::getValue)));
    }

    @Nonnull
    private static Stream<TranslationEntry> entriesFromParameters(@Nonnull Parameters parameters) {
        return parameters.getParameterBool("result") ? parameters.getParameter().stream().filter(pc -> "match".equals(pc.getName())).map(pc -> TranslateMapping.partToBean(pc, TranslationEntry::new)) : Stream.empty();
    }

    public static class TranslationEntry {
        @Nonnull
        private Coding concept;
        @Nonnull
        private CodeType equivalence;

        @Nonnull
        public Coding getConcept() {
            return this.concept;
        }

        @Nonnull
        public CodeType getEquivalence() {
            return this.equivalence;
        }

        public void setConcept(@Nonnull Coding concept) {
            if (concept == null) {
                throw new NullPointerException("concept is marked non-null but is null");
            }
            this.concept = concept;
        }

        public void setEquivalence(@Nonnull CodeType equivalence) {
            if (equivalence == null) {
                throw new NullPointerException("equivalence is marked non-null but is null");
            }
            this.equivalence = equivalence;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TranslationEntry)) {
                return false;
            }
            TranslationEntry other = (TranslationEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Coding this$concept = this.getConcept();
            Coding other$concept = other.getConcept();
            if (this$concept == null ? other$concept != null : !this$concept.equals(other$concept)) {
                return false;
            }
            CodeType this$equivalence = this.getEquivalence();
            CodeType other$equivalence = other.getEquivalence();
            return !(this$equivalence == null ? other$equivalence != null : !this$equivalence.equals(other$equivalence));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TranslationEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Coding $concept = this.getConcept();
            result = result * 59 + ($concept == null ? 43 : $concept.hashCode());
            CodeType $equivalence = this.getEquivalence();
            result = result * 59 + ($equivalence == null ? 43 : ((Object)$equivalence).hashCode());
            return result;
        }

        public String toString() {
            return "TranslateMapping.TranslationEntry(concept=" + this.getConcept() + ", equivalence=" + this.getEquivalence() + ")";
        }
    }
}

