/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhirpath.encoding;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.r4.model.Coding;

public class SimpleCoding
implements Serializable {
    private static final long serialVersionUID = 6509272647875353748L;
    @Nullable
    private String system;
    @Nullable
    private String code;
    @Nullable
    private String version;

    public SimpleCoding(@Nullable String system, @Nullable String code) {
        this(system, code, null);
    }

    public SimpleCoding(@Nonnull Coding coding) {
        this.system = coding.getSystem();
        this.code = coding.getCode();
        this.version = coding.getVersion();
    }

    @Nonnull
    public Coding toCoding() {
        Coding coding = new Coding(this.system, this.code, null);
        coding.setVersion(this.version);
        return coding;
    }

    public boolean isDefined() {
        return this.system != null && this.code != null;
    }

    public boolean isVersioned() {
        return this.version != null;
    }

    @Nonnull
    public SimpleCoding toNonVersioned() {
        return this.isVersioned() ? new SimpleCoding(this.system, this.code) : this;
    }

    @Nullable
    public String getSystem() {
        return this.system;
    }

    @Nullable
    public String getCode() {
        return this.code;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public void setSystem(@Nullable String system) {
        this.system = system;
    }

    public void setCode(@Nullable String code) {
        this.code = code;
    }

    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleCoding)) {
            return false;
        }
        SimpleCoding other = (SimpleCoding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$system = this.getSystem();
        String other$system = other.getSystem();
        if (this$system == null ? other$system != null : !this$system.equals(other$system)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleCoding;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $system = this.getSystem();
        result = result * 59 + ($system == null ? 43 : $system.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public String toString() {
        return "SimpleCoding(system=" + this.getSystem() + ", code=" + this.getCode() + ", version=" + this.getVersion() + ")";
    }

    public SimpleCoding() {
    }

    public SimpleCoding(@Nullable String system, @Nullable String code, @Nullable String version) {
        this.system = system;
        this.code = code;
        this.version = version;
    }
}

