/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhir;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.annotation.Elements;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.RequiredParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Transaction;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import ca.uhn.fhir.rest.client.api.ServerValidationModeEnum;
import ca.uhn.fhir.rest.client.interceptor.LoggingInterceptor;
import ca.uhn.fhir.rest.param.UriParam;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.Logger;

public interface TerminologyClient
extends IRestfulClient {
    @Search
    @Nullable
    public List<CodeSystem> searchCodeSystems(@Nonnull @RequiredParam(name="url") UriParam var1, @Nonnull @Elements Set<String> var2);

    @Operation(name="$expand", type=ValueSet.class)
    @Nullable
    public ValueSet expand(@Nonnull @OperationParam(name="valueSet") ValueSet var1, @Nonnull @OperationParam(name="count") IntegerType var2);

    @Operation(name="$closure")
    public ConceptMap initialiseClosure(@Nonnull @OperationParam(name="name") StringType var1);

    @Operation(name="$closure")
    @Nullable
    public ConceptMap closure(@Nonnull @OperationParam(name="name") StringType var1, @Nonnull @OperationParam(name="concept") List<Coding> var2);

    @Transaction
    @Nullable
    public Bundle batch(@Nonnull @TransactionParam Bundle var1);

    @Nonnull
    public static TerminologyClient build(@Nonnull FhirContext fhirContext, @Nonnull String terminologyServerUrl, int socketTimeout, boolean verboseRequestLogging, @Nonnull Logger logger) {
        IRestfulClientFactory restfulClientFactory = fhirContext.getRestfulClientFactory();
        restfulClientFactory.setSocketTimeout(socketTimeout);
        restfulClientFactory.setServerValidationMode(ServerValidationModeEnum.NEVER);
        TerminologyClient terminologyClient = restfulClientFactory.newClient(TerminologyClient.class, terminologyServerUrl);
        LoggingInterceptor loggingInterceptor = new LoggingInterceptor();
        loggingInterceptor.setLogger(logger);
        loggingInterceptor.setLogRequestSummary(true);
        loggingInterceptor.setLogResponseSummary(true);
        if (verboseRequestLogging) {
            loggingInterceptor.setLogRequestHeaders(true);
            loggingInterceptor.setLogRequestBody(true);
            loggingInterceptor.setLogResponseHeaders(true);
            loggingInterceptor.setLogResponseBody(true);
        }
        terminologyClient.registerInterceptor(loggingInterceptor);
        return terminologyClient;
    }
}

