/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhir;

import au.csiro.pathling.encoders.FhirEncoders;
import au.csiro.pathling.fhir.TerminologyClient;
import au.csiro.pathling.fhir.TerminologyServiceFactory;
import au.csiro.pathling.terminology.DefaultTerminologyService;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.terminology.UUIDFactory;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class DefaultTerminologyServiceFactory
implements TerminologyServiceFactory {
    private static final long serialVersionUID = 8862251697418622614L;
    @Nonnull
    private final FhirVersionEnum fhirVersion;
    @Nonnull
    private final String terminologyServerUrl;
    private final int socketTimeout;
    private final boolean verboseRequestLogging;

    public DefaultTerminologyServiceFactory(@Nonnull FhirContext fhirContext, @Nonnull String terminologyServerUrl, int socketTimeout, boolean verboseRequestLogging) {
        this.fhirVersion = fhirContext.getVersion().getVersion();
        this.terminologyServerUrl = terminologyServerUrl;
        this.socketTimeout = socketTimeout;
        this.verboseRequestLogging = verboseRequestLogging;
    }

    @Override
    @Nonnull
    public TerminologyService buildService(@Nonnull Logger logger) {
        return this.buildService(logger, UUID::randomUUID);
    }

    @Nonnull
    public TerminologyService buildService(@Nonnull Logger logger, @Nonnull UUIDFactory uuidFactory) {
        TerminologyClient terminologyClient = TerminologyClient.build(FhirEncoders.contextFor(this.fhirVersion), this.terminologyServerUrl, this.socketTimeout, this.verboseRequestLogging, logger);
        return new DefaultTerminologyService(FhirEncoders.contextFor(this.fhirVersion), terminologyClient, uuidFactory);
    }
}

