/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.encoders;

import au.csiro.pathling.encoders.EncoderContext;
import au.csiro.pathling.encoders.EncoderSettings;
import au.csiro.pathling.encoders.SerializerBuilder$;
import au.csiro.pathling.encoders.SerializerBuilderProcessor;
import au.csiro.pathling.encoders.datatypes.DataTypeMappings;
import au.csiro.pathling.schema.SchemaVisitor$;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.ObjectType;
import org.hl7.fhir.instance.model.api.IBaseResource;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0006\r\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00036\u0001\u0011\u0005a\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003<\u0001\u0011\u0005!kB\u0003w\u0019!\u0005qOB\u0003\f\u0019!\u0005\u0001\u0010C\u00036\u0011\u0011\u0005\u0011\u0010C\u0003{\u0011\u0011\u00051PA\tTKJL\u0017\r\\5{KJ\u0014U/\u001b7eKJT!!\u0004\b\u0002\u0011\u0015t7m\u001c3feNT!a\u0004\t\u0002\u0011A\fG\u000f\u001b7j]\u001eT!!\u0005\n\u0002\u000b\r\u001c\u0018N]8\u000b\u0003M\t!!Y;\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u0017\u0019D\u0017N]\"p]R,\u0007\u0010\u001e\t\u0003=\u001dj\u0011a\b\u0006\u0003A\u0005\nqaY8oi\u0016DHO\u0003\u0002#G\u0005!a\r[5s\u0015\t!S%A\u0002vQ:T\u0011AJ\u0001\u0003G\u0006L!\u0001K\u0010\u0003\u0017\u0019C\u0017N]\"p]R,\u0007\u0010^\u0001\t[\u0006\u0004\b/\u001b8hgB\u00111FL\u0007\u0002Y)\u0011Q\u0006D\u0001\nI\u0006$\u0018\r^=qKNL!a\f\u0017\u0003!\u0011\u000bG/\u0019+za\u0016l\u0015\r\u001d9j]\u001e\u001c\u0018AB2p]\u001aLw\r\u0005\u00023g5\tA\"\u0003\u00025\u0019\tyQI\\2pI\u0016\u00148+\u001a;uS:<7/\u0001\u0004=S:LGO\u0010\u000b\u0005oaJ$\b\u0005\u00023\u0001!)A\u0004\u0002a\u0001;!)\u0011\u0006\u0002a\u0001U!)\u0001\u0007\u0002a\u0001c\u0005y!-^5mIN+'/[1mSj,'\u000f\u0006\u0002>\u001bB\u0011ahS\u0007\u0002\u007f)\u0011\u0001)Q\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002C\u0007\u0006A1-\u0019;bYf\u001cHO\u0003\u0002E\u000b\u0006\u00191/\u001d7\u000b\u0005\u0019;\u0015!B:qCJ\\'B\u0001%J\u0003\u0019\t\u0007/Y2iK*\t!*A\u0002pe\u001eL!\u0001T \u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0003O\u000b\u0001\u0007q*\u0001\nsKN|WO]2f\t\u00164\u0017N\\5uS>t\u0007C\u0001\u0010Q\u0013\t\tvDA\rSk:$\u0018.\\3SKN|WO]2f\t\u00164\u0017N\\5uS>tWCA*d)\tiD\u000bC\u0003V\r\u0001\u0007a+A\u0007sKN|WO]2f\u00072\f7o\u001d\t\u0004/z\u000bgB\u0001-]!\tI\u0006$D\u0001[\u0015\tYF#\u0001\u0004=e>|GOP\u0005\u0003;b\ta\u0001\u0015:fI\u00164\u0017BA0a\u0005\u0015\u0019E.Y:t\u0015\ti\u0006\u0004\u0005\u0002cG2\u0001A!\u00023\u0007\u0005\u0004)'!\u0001+\u0012\u0005\u0019L\u0007CA\fh\u0013\tA\u0007DA\u0004O_RD\u0017N\\4\u0011\u0005)$X\"A6\u000b\u00051l\u0017aA1qS*\u0011an\\\u0001\u0006[>$W\r\u001c\u0006\u0003aF\f\u0001\"\u001b8ti\u0006t7-\u001a\u0006\u0003EIT!a]%\u0002\u0007!dw'\u0003\u0002vW\ni\u0011JQ1tKJ+7o\\;sG\u0016\f\u0011cU3sS\u0006d\u0017N_3s\u0005VLG\u000eZ3s!\t\u0011\u0004b\u0005\u0002\t-Q\tq/A\u0003baBd\u0017\u0010\u0006\u00028y\")\u0001E\u0003a\u0001{B\u0011!G`\u0005\u0003\u007f2\u0011a\"\u00128d_\u0012,'oQ8oi\u0016DH\u000f")
public class SerializerBuilder {
    private final FhirContext fhirContext;
    private final DataTypeMappings mappings;
    private final EncoderSettings config;

    public static SerializerBuilder apply(EncoderContext encoderContext) {
        return SerializerBuilder$.MODULE$.apply(encoderContext);
    }

    public Expression buildSerializer(RuntimeResourceDefinition resourceDefinition) {
        Class fhirClass = resourceDefinition.getImplementingClass();
        BoundReference inputObject = new BoundReference(0, (DataType)new ObjectType(fhirClass), true);
        return SchemaVisitor$.MODULE$.traverseResource(resourceDefinition, new SerializerBuilderProcessor((Expression)inputObject, this.fhirContext, this.mappings, this.config));
    }

    public <T extends IBaseResource> Expression buildSerializer(Class<T> resourceClass) {
        return this.buildSerializer(this.fhirContext.getResourceDefinition(resourceClass));
    }

    public SerializerBuilder(FhirContext fhirContext, DataTypeMappings mappings, EncoderSettings config) {
        this.fhirContext = fhirContext;
        this.mappings = mappings;
        this.config = config;
    }
}

