#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ..schema_config.json_scalar import custom_scalars
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config


# fmt: off
QUERY: List[str] = ["""
query getSentiment($input: String!) {
  result: callSentimentAnalysis(input: $input) {
    label
    score
  }
}

"""
]


class getSentiment:
    @dataclass(frozen=True)
    class getSentimentData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class SentimentAnalysisResult(DataClassJsonMixin):
            label: Optional[str]
            score: Optional[Number]

        result: Optional[List[SentimentAnalysisResult]]

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: str) -> List[Optional[getSentimentData.SentimentAnalysisResult]]:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.getSentimentData.from_dict(response_text)
        return res.result

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: str) -> List[Optional[getSentimentData.SentimentAnalysisResult]]:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.getSentimentData.from_dict(response_text)
        return res.result
