#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ..schema_config.json_scalar import custom_scalars
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from gql_client.runtime.enum_utils import enum_field_metadata
from .enum.relation import Relation


# fmt: off
QUERY: List[str] = ["""
query getConceptnetRelations($input: String!, $relation: Relation!) {
  result: callPredictRelation(input: $input, relation: $relation) {
    predictions: result
  }
}

"""
]


class getConceptnetRelations:
    @dataclass(frozen=True)
    class getConceptnetRelationsData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class RelationResult(DataClassJsonMixin):
            predictions: Optional[List[str]]

        result: Optional[RelationResult]

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: str, relation: Relation) -> Optional[getConceptnetRelationsData.RelationResult]:
        variables: Dict[str, Any] = {"input": input, "relation": relation}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.getConceptnetRelationsData.from_dict(response_text)
        return res.result

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: str, relation: Relation) -> Optional[getConceptnetRelationsData.RelationResult]:
        variables: Dict[str, Any] = {"input": input, "relation": relation}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.getConceptnetRelationsData.from_dict(response_text)
        return res.result
