# -*- coding: utf-8 -*-
import re
import sys
import json
import yaml
import os
from os.path import basename, dirname, isfile
# from pyspark.sql import Row, SparkSession


class SparkUtils(object):
    spark = None
    fonte = None

    def __init__(self, fonte=""):
        self.spark = None
        self.fonte = fonte
        # if not os.name in ["nt", "posix"]:
        self.spark = self.getSparkSession(fonte= self.fonte)


    def getSparkSession(self, fonte = "default", queue = "default", qt_exec_master = "*"):
        resourceManager = "localhost:8088"
        try:
            # .config("spark.master", "spark://192.168.99.101:7077")\
            _spark = SparkSession.builder\
                .appName("billing-" + fonte)\
                .config("spark.yarn.queue", queue)\
                .config("spark.sql.catalogImplementation", "hive")\
                .config("spark.sql.warehouse.dir", "/user/hive/warehouse")\
                .config("spark.shuffle.service.enabled", "true")\
                .config("spark.executor.cores", "1")\
                .config("spark.executor.memory", "1G")\
                .config("spark.driver.memory", "1G")\
                .config("spark.ui.port", "4066")\
                .config("spark.dynamicAllocation.enabled", "true")\
                .config("spark.hadoop.yarn.resourcemanager.webapp.address", resourceManager)\
                .config("spark.sql.broadcastTimeout", "36000")\
                .config("spark.eventLog.enabled", "false")\
                .enableHiveSupport()\
                .getOrCreate()
            return _spark

        except Exception as e:
            print(e)



#old 
# .config("spark.dynamicAllocation.minExecutors", "2")\
# .config("spark.dynamicAllocation.maxExecutors", "120")\
# .config("spark.executor.extraJavaOptions", "-XX:+PrintGCDetails -XX:+PrintGCTimeStamps")\
# .config("spark.driver.extraJavaOptions", "-XX:+UseG1GC -Dhdp.version=2.6.4.0-91 -XX:ConcGCThreads=4")\
# .config("spark.executor.extraJavaOptions", "-XX:+UseG1GC -Dhdp.version=2.6.4.0-91 -XX:ConcGCThreads=4")\

#'spark.executor.extraJavaOptions=-XX:+UseParallelGC -XX:ParallelGCThreads=16' \
# Spark SQL
#'/usr/hdp/current/spark2-client/bin/spark-sql' \
# '--master' \
# 'yarn'
# '--conf' \
# 'spark.app.name=spark-sql' \
# '--conf' \
# 'spark.task.maxFailures=12' \
# '--conf' \
# 'spark.sql.codegen=true' \
# '--conf' \
# 'spark.executor.extraJavaOptions=-XX:+UseG1GC -XX:ParallelGCThreads=16' \
# '--conf' \
# 'spark.dynamicAllocation.executorIdleTimeout=60s' \
# '--conf' \
# 'spark.dynamicAllocation.minExecutors=3' \
# '--conf' \
# 'spark.executor.memory=12g' \
# '--conf' \
# 'spark.kryoserializer.buffer.max=2000m' \
# '--conf' \
# 'spark.dynamicAllocation.initialExecutors=3' \
# '--conf' \
# 'spark.sql.tungsten.enabled=true' \
# '--conf' \
# 'spark.driver.maxResultSize=15g' \
# '--conf' \
# 'spark.executor.cores=10' \
# '--conf' \
# 'spark.ui.port=5100' \
# '--conf' \
# 'spark.streaming.backpressure.enabled=true' \
# '--conf' \
# 'spark.driver.memory=18g' \
# '--conf' \
# 'spark.network.timeout=300' \
# '--conf' \
# 'spark.dynamicAllocation.schedulerBacklogTimeout=1s' \
# '--conf' \
# 'spark.executor.instances=3' \
# '--conf' \
# 'spark.speculation=true' \
# '--conf' \
# 'spark.shuffle.service.enabled=true' \
# '--conf' \
# 'spark.sql.unsafe.enabled=true' \
# '--conf' \
# 'spark.executor.heartbeatInterval=60006' \
# '--conf' \
# 'spark.dynamicAllocation.enabled=true' \
# '--conf' \
# 'spark.yarn.queue=faturamento' \
# '--conf' \
# 'spark.yarn.driver.memoryOverhead=3000' \
# '--conf' \
# 'spark.sql.orc.filterPushdown=true' \
# '--conf' \
# 'spark.kryoserializer.buffer=64k' \
# '--conf' \
# 'spark.yarn.am.waitTime=10' \
# '--conf' \
# 'spark.dynamicAllocation.cachedExecutorIdleTimeout=120s' \
# '--conf' \
# 'spark.dynamicAllocation.sustainedSchedulerBacklogTimeout=1s' \
# '--conf' \
# 'spark.yarn.scheduler.heartbeat.interval-ms=2000' \
# '--conf' \
# #'spark.dynamicAllocation.maxExecutors=250' \
# '--conf' \
# 'spark.yarn.containerLauncherMaxThreads=25' \
# '--conf' \
# 'spark.serializer=org.apache.spark.serializer.KryoSerializer' \
# '--conf' \
# 'spark.yarn.am.memoryOverhead=1843' \
# '--conf' \
# 'spark.yarn.executor.memoryOverhead=3000' $@



# Generated by Apache Ambari. Fri Oct 20 20:04:07 2017
# spark.driver.extraLibraryPath /usr/hdp/current/hadoop-client/lib/native:/usr/hdp/current/hadoop-client/lib/native/Linux-amd64-64
# spark.eventLog.dir hdfs:///spark2-history/
# spark.eventLog.enabled true
# spark.executor.extraLibraryPath /usr/hdp/current/hadoop-client/lib/native:/usr/hdp/current/hadoop-client/lib/native/Linux-amd64-64
# spark.history.fs.logDirectory hdfs:///spark2-history/
# spark.history.kerberos.keytab /etc/security/keytabs/spark.headless.keytab
# spark.history.kerberos.principal spark-tlvbrprdk@BIGDATA.REDECORP.BR
# spark.history.provider org.apache.spark.deploy.history.FsHistoryProvider
# spark.history.ui.port 18081
# spark.yarn.historyServer.address brtlvlts0791co.bigdata.redecorp.br:18081
# spark.yarn.queue default
# #spark.dynamicAllocation.enabled true
# #spark.dynamicAllocation.initialExecutors 5
# #spark.dynamicAllocation.maxExecutors 100
# #spark.dynamicAllocation.minExecutors 1
# spark.yarn.am.memory 1g
# spark.yarn.containerLauncherMaxThreads 25
# spark.yarn.driver.memoryOverhead 384
# spark.yarn.executor.memoryOverhead 384
# spark.yarn.historyServer.address brtlvlts0790co.bigdata.redecorp.br:18080
# spark.yarn.preserve.staging.files false
# spark.yarn.queue default
# spark.yarn.scheduler.heartbeat.interval-ms 5000
# spark.yarn.submit.file.replication 3
# #yarn.nodemanager.aux-services mapreduce_shuffle,spark_shuffle
# #yarn.nodemanager.auxservices.spark_shuffle.class org.apache.spark.network.yarn.YarnShuffleService
# spark.executor.memory 2g
# spark.executor.extraLibraryPath /usr/hdp/current/hadoop-client/lib/native:/usr/hdp/current/hadoop-client/lib/native/Linux-amd64-64