# Generated by Django 3.0.6 on 2020-05-21 23:03

import address.models
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import phonenumber_field.modelfields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('address', '0002_auto_20160213_1726'),
    ]

    operations = [
        migrations.CreateModel(
            name='OrganizationModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prime_number', models.UUIDField(default=uuid.uuid4, editable=False, help_text='prime number is unique code for any master data', verbose_name='prime number')),
                ('name', models.CharField(default=None, help_text='Humanized name of master data', max_length=100, verbose_name='name')),
                ('registration_number', models.CharField(max_length=500)),
            ],
            options={
                'verbose_name': 'organization',
                'verbose_name_plural': 'organizations',
            },
        ),
        migrations.CreateModel(
            name='PersonModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prime_number', models.UUIDField(default=uuid.uuid4, editable=False, help_text='prime number is unique code for any master data', verbose_name='prime number')),
                ('name', models.CharField(default=None, help_text='Humanized name of master data', max_length=100, verbose_name='name')),
                ('name_prefix', models.CharField(blank=True, choices=[('junior', 'Junior'), ('senior', 'Senior'), ('doctor', 'Doctor'), ('professor', 'Professor'), ('widow', 'Widow')], default=None, max_length=10, null=True)),
                ('first_name', models.CharField(max_length=100)),
                ('middle_name', models.CharField(blank=True, default=None, max_length=100, null=True)),
                ('last_name', models.CharField(max_length=100)),
                ('name_suffix', models.CharField(blank=True, default=None, max_length=10, null=True)),
                ('birthdate', models.DateField()),
                ('birthplace', models.CharField(max_length=200)),
                ('name_of_mother', models.CharField(default=None, max_length=200)),
                ('tax_number', models.CharField(max_length=100)),
                ('primary', models.CharField(max_length=100, verbose_name='nationality')),
                ('inland_resident', models.BooleanField(help_text='Has inland address.', verbose_name='has inland residence')),
                ('gender', models.CharField(blank=True, choices=[('female', 'Female'), ('male', 'Male')], default=None, max_length=10, null=True)),
                ('phone_number', phonenumber_field.modelfields.PhoneNumberField(help_text='Phone number, desc.', max_length=128, region=None, verbose_name='phone number')),
                ('email', models.EmailField(help_text='Primary email address', max_length=254, verbose_name='email')),
                ('permanent_address', address.models.AddressField(help_text='Permanent address, desc.', on_delete=django.db.models.deletion.CASCADE, related_name='permanent_residents', to='address.Address', verbose_name='permanent address')),
                ('temporary_address', address.models.AddressField(blank=True, default=None, help_text='temporary address, desc.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='termorary_residents', to='address.Address', verbose_name='temporary address')),
            ],
            options={
                'verbose_name': 'person',
                'verbose_name_plural': 'people',
            },
        ),
        migrations.CreateModel(
            name='EmploymentModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prime_number', models.UUIDField(default=uuid.uuid4, editable=False, help_text='prime number is unique code for any master data', verbose_name='prime number')),
                ('name', models.CharField(default=None, help_text='Humanized name of master data', max_length=100, verbose_name='name')),
                ('begin', models.DateTimeField(default=django.utils.timezone.now)),
                ('end', models.DateTimeField(blank=True, default=None, null=True)),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='corgy_mdm.OrganizationModel')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='corgy_mdm.PersonModel')),
            ],
            options={
                'verbose_name': 'employee',
                'verbose_name_plural': 'employees',
            },
        ),
    ]
