from typing import Any, Callable, Optional, Sequence

from kombu.connection import Connection
from kombu.message import Message
from kombu.messaging import Consumer as MessagingConsumer
from kombu.messaging import Producer
from kombu.transport.base import Channel
from kombu.utils.limits import TokenBucket

class ConsumerMixin:
    connect_max_retries: Optional[int]
    should_stop: bool
    def get_consumers(
        self, Consumer: Callable[..., MessagingConsumer], channel: Channel
    ) -> Sequence[MessagingConsumer]: ...
    def on_connection_revived(self) -> None: ...
    def on_consume_ready(
        self,
        connection: Connection,
        channel: Channel,
        consumers: Sequence[MessagingConsumer],
        **kwargs: Any
    ) -> None: ...
    def on_consume_end(self, connection: Connection, channel: Channel) -> None: ...
    def on_iteration(self) -> None: ...
    def on_decode_error(self, message: Message, exc: Exception) -> None: ...
    def on_connection_error(self, exc: Exception, interval: int) -> None: ...
    def extra_context(self, connection: Connection, channel: Channel) -> None: ...
    def run(self, _tokens: int = ..., **kwargs: Any) -> None: ...
    def consumer_context(
        self, **kwargs: Any
    ) -> tuple[Connection, Channel, Sequence[MessagingConsumer]]: ...
    def consume(
        self,
        limit: Optional[int] = ...,
        timeout: Optional[int] = ...,
        safety_interval: int = ...,
        **kwargs: Any
    ) -> None: ...
    def maybe_conn_error(self, fun: Optional[Callable[..., Any]]) -> Any: ...
    def create_connection(self) -> Connection: ...
    def establish_connection(self) -> Connection: ...
    def Consumer(self) -> tuple[Connection, Channel, Sequence[MessagingConsumer]]: ...
    @property
    def restart_limit(self) -> TokenBucket: ...
    @property
    def connection_errors(self) -> Sequence[Exception]: ...
    @property
    def channel_errors(self) -> Sequence[Exception]: ...

class ConsumerProducerMixin(ConsumerMixin):
    def on_consume_end(self, connection: Connection, channel: Channel) -> None: ...
    @property
    def producer(self) -> Producer: ...
    @property
    def producer_connection(self) -> Connection: ...
