"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallAwsService = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * A StepFunctions task to call an AWS service API.
 *
 * @stability stable
 */
class CallAwsService extends sfn.TaskStateBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_CallAwsServiceProps(props);
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: props.iamResources,
                // The prefix and the action name are case insensitive
                // https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_action.html
                actions: [(_b = props.iamAction) !== null && _b !== void 0 ? _b : `${props.service}:${props.action}`],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        var _b;
        let service = this.props.service;
        if (!core_1.Token.isUnresolved(service)) {
            service = service.toLowerCase();
        }
        return {
            Resource: task_utils_1.integrationResourceArn('aws-sdk', `${service}:${this.props.action}`, this.props.integrationPattern),
            Parameters: (_b = sfn.FieldUtils.renderObject(this.props.parameters)) !== null && _b !== void 0 ? _b : {},
        };
    }
}
exports.CallAwsService = CallAwsService;
_a = JSII_RTTI_SYMBOL_1;
CallAwsService[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.CallAwsService", version: "1.136.0" };
//# sourceMappingURL=data:application/json;base64,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