"""Regex patterns for /data/sim/ filename patterns.

These patterns are arranged by descending frequency for best
performance.
"""


regex_patterns = [
    ####################################################################################
    # First, Programmatically Generated Patterns
    ####################################################################################
    r"Level2_(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"TopSimulator_IC\d+_corsika_icetop\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2((\.|_)eff\d+)_IC\d+-\d\d\d\d_corsika_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_corsika_icetop\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"hits\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"detector((\.|_)eff\d+)_IC\d+-\d\d\d\d_corsika_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_IC\d+_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_corsika_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Detector_IC\d+_corsika_icetop\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Propagated_IC\d+_corsika_icetop\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_genie_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_genie_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_genie_NuTau_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_nugen_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_corsika_icetop\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_data_Run\d+_Subrun(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.dst(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_ic\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"unweighted_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_genie_numu_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.mcpes\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_nugen_numu_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_MuonGun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_MuonGun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)\.genie_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)\.genie_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_SLOP(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_bg_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2b\.corsika_it_\d+_ic\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_genie_NuMu_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_numu_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.mcpes\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)\.genie_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)\.genie_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.mcpes\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)\.genie_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)\.genie_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level4_corsika_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_nugen_nutau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_nugen_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_genie_nutau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSNInjector(DAT\d+)(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+(_|\.)\d+)_eff(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_nugen_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_CSCD(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3_iti3-\d+_sibyll-fluka_os100_p(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_CORSIKA_\d+msec_atmod_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_ic\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.L1(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_nugen_numu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3_iti3-\d+_sibyll-fluka_os100_fe(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_genie_nutau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_genie_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_EHE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_genie_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3_iti3-\d+_sibyll-fluka_os100_o(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3_iti3-\d+_sibyll-fluka_os100_he(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3_iti3-\d+_sibyll-fluka_os100_si(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_DOMoversize_\d+_corsika_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_ic\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"photons_DOMeff_all_PEs_IC\d+-\d\d\d\d_corsika_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_genie_NuE_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"PINGU_mDOM_genie_\d+strings_\d+dps_((S|s)tep\d+)\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"PINGU_mDOM_genie_\d+strings_\d+dps_RawData\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_VuvuzelaPureNoise_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_genie_nutau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE1((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_genie_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE1((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_genie_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE1((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.mcpes((\.|_)eff\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)\.genie_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))((\.|_)eff\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.mcpes((\.|_)eff\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)\.genie_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))((\.|_)eff\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)\.genie_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))((\.|_)eff\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)\.genie_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))((\.|_)eff\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.mcpes((\.|_)eff\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)\.genie_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))((\.|_)eff\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)\.genie_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))((\.|_)eff\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_IC\d+_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_EHE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MuonGun_Level2FADCfixed_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_numu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level4_nugen_numu_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_nugen_nutau_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_nugen_nue_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_nugen_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_nugen_numu_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_dom_eff_((\d+)(_|\.)(\d+))_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_nugen_numu_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_nugen_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_nugen_dom_eff_((\d+)(_|\.)(\d+))_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_NuE_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MuonGun_Level2_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Monopole_KYG1_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_NuTau_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"M_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_nugen_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"muongun_(IC\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.clsim(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level5b_(IC\d+\.\d\d\d\d)_genie_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"hit((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_corsika_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))-\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCPEs_merged_DOMoversize_\d+_corsika_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_5comp_(sibyll\d\.\d[a-z]?)_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"detector_DOMoversize_\d+_corsika_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3_iti3-\d+_epos_os100_he(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3_iti3-\d+_epos_os100_si(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3_iti3-\d+_epos_os100_o(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_nugen_nue_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3_iti3-\d+_epos_os100_p(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3_iti3-\d+_epos_os100_fe(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_Merged_Muons_Emin_((\d+)(_|\.)(\d+))_TeV_Emax_((\d+)(_|\.)(\d+))_PeV_Gamma_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_RunNumber_\d+_Seed_\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MonoSim_((\d+)(_|\.)(\d+)(_|\.)\d+(_|\.)\d+)_((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+(_|\.)\d+)_lv_\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Monopole_(KYG1_distr_\d+)_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MM_Isotropic_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_PINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"muongun_(IC\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.generated(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_((Pass|pass|PASS)\d+)_(IC\d+\.\d\d\d\d)_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_((Pass|pass|PASS)\d+)_(IC\d+\.\d\d\d\d)_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level4_nugen_nutau_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.photons(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.photons(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.photons(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_numu_ic\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)\.\d\d\d\d_nugen_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_nugen_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuE_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_corsika_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_NuE_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_NuE_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuTau_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuMu_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_NuTau_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_NuTau_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"SMT\d+_(IC\d+\.\d\d\d\d)_wimp_sun_(m\d+)_(ch\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_NuMu_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_NuMu_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_NuMu_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_Merged_Muons_Emin_((\d+)(_|\.)(\d+))_TeV_Emax_((\d+)(_|\.)(\d+))_PeV_Gamma_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_RunNumber_\d+_Seed_\d+_L1_L2_(IC\d\d\d\d)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_nugen_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2\.corsika_ic\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_wimp_sun_(m\d+)_(ch\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_nugen_nutau_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Monopole_KYG1_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_nugen_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_((Pass|pass|PASS)\d+)_(IC\d+\.\d\d\d\d)_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_nugen_nutau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_nugen_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level1_genie_pingu((v|V)\d+)_numu_postEBugFix_rangeCut\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_weighted_deltaCP_\d+_MultiNest_PID(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_nugen_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_nugen_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_nugen_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_\$steering\(mctype\)_mcpes\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"noiseonly_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level1_genie_pingu((v|V)\d+)_nutau_postEBugFix_rangeCut\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_weighted_deltaCP_\d+_MultiNest_PID(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"oscNext_muongun_((S|s)tep\d+)_((Pass|pass|PASS)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_\d+ms_CORSIKA_atmod_((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+(_|\.)\d+)_\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level1_genie_pingu((v|V)\d+)_nue_postEBugFix_rangeCut\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_weighted_deltaCP_\d+_MultiNest_PID(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_nugen_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_nugen_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_ic\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.L2a(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_nugen_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_nugen_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_numu_IC\d+((\.|_)eff\d+)_vuvu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_genie_NuTau_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_nue_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_nue_slope\d+_ic\d+_matrix\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"L1Monopole_(KYG1_distr_\d+)_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSNInjectoricemodel(DAT\d+)(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_nugen_nutau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"hit((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"RunSNInjCLSim-((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\[\d+\]\.jasper-usradm\.westgrid\.ca(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"photons_DOMoversize_\d+_corsika_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSNInjectorspice_mie(DAT\d+)(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"SFrame_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"L1Monopole_KYG1_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika-hits\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSNInjector(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((Pass|pass|PASS)\d+)\.(IC\d+\.\d\d\d\d)_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((Pass|pass|PASS)\d+)\.(IC\d+\.\d\d\d\d)_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_muon(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_nugen_nutau_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_low_energy(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_Earth_WIMP(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MakeSNI\d+MCTrees_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_NuMu_bin((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_nugen_nue_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.finished(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_NuMu_bin((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_numu_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_ic\d+_dc((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3\.corsika_ic\d+_twr\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MuonGun_ICUpgrade\.((v|V)\d+)\.mixed\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_nugen_nutau_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_pingu((v|V)\d+)_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_(IC\d+\.\d\d\d\d)_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_genie_numu((\.|_)eff\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MM_Isotropic_((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_mu_e((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_genie_nue((\.|_)eff\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_genie_nutau((\.|_)eff\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"oscNext_muongun_level1_((Pass|pass|PASS)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuTau_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_triggered(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"RunSNInjCLSim-((?P<alpha>\d+)(_|\.)(?P<beta>\d+))-\d+\.jasper-usradm\.westgrid\.ca(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_newNoise_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_genie_nutaubar((\.|_)eff\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika\.out(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_genie_nuebar((\.|_)eff\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_genie_numubar((\.|_)eff\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"All_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MM_KYG_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MuonGun_((S|s)tep\d+)_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MM_KYG_((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mmc(?P<single>\d+)_(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_genie_nuebar((\.|_)eff\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_genie_nue((\.|_)eff\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_genie_numubar((\.|_)eff\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_genie_numu((\.|_)eff\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_mu_slope\d+_ic\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_genie_NuMu_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuE_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_triggered(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_genie_NuE_pingu_((v|V)\d+)_pDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuMu_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_triggered(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"oscNext_muongun_level2_((Pass|pass|PASS)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_nue_IC\d+((\.|_)eff\d+)_vuvu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_corsika_IC\d+\.((\d+)(_|\.)(\d+))_\d+-((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_genie_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_genie_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"gen_noiseonly_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)\.\d\d\d\d_nugen_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_nutau_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_ICU_((v|V)\d+)_mixed\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_Muons_Emin_((\d+)(_|\.)(\d+))_TeV_Emax_((\d+)(_|\.)(\d+))_PeV_Gamma_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_RunNumber_\d+_Seed_\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_nue_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_IC\d+_nugen_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_output_mixed\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_nugen_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_newNoise_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_mu_e((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_nugen_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_nutau_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_genie_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_mu_slope\d+_ic\d+_matrix\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_numu_slope\d+_ic\d+_matrix\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_nutau_slope\d+_ic\d+_matrix\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_tau_slope\d+_ic\d+_matrix\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_nue_slope\d+_ic\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_numu_slope\d+_ic\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_nutau_slope\d+_ic\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_tau_slope\d+_ic\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level4_nugen_nue_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_\d\d\d\d\.(?P<single>\d+)_((v|V)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_All_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_All_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_All_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_genie_NuE_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.clsim(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_genie_((\d+)(_|\.)(\d+)(_|\.)\d+)_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"bare-muons_\d+e\d+-GeV_at-\d+-meters\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"DetTopSimulator_IC\d+_corsika_icetop\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_Gen_setXOmega_\d+_mcpes((\.|_)eff\d+)\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+(_|\.)\d+)_eff(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_numu_twr\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Generation_MuonGun_ICUpgrade\.((v|V)\d+)\.mixed\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Photon_MuonGun_ICUpgrade\.((v|V)\d+)\.mixed\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_nugen_numu((\.|_)eff\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_nutau_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_nue_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Monopoles_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_nutau_IC\d+((\.|_)eff\d+)_vuvu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"All_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_CORSIKA_\d+msec_atmod_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_DOMLauncher_Noise(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_CORSIKA_\d+msec_atmod_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_genie_nutau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"L1_noiseonly_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_Muons_PINGU_Emin_\d+_GeV_Emax_\d+_TeV_RunNumber_\d+_Seed_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+\.(?P<single>\d+)_corrected_((v|V)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genieOnly_pingu((v|V)\d+)_numu_rangeCut_noHoleIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_genie_((\d+)(_|\.)(\d+)(_|\.)\d+)_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"L2_noiseonly_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_nue_rangeCut_noHoleIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_IC\d+_nugen_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_genie_((\d+)(_|\.)(\d+)(_|\.)\d+)_nutau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_nutau_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_genie_nutau_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_corsika_ic\d+_dc((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"PINGU_mDOM_genie_\d+strings_\d+dps_basicfits\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_tau_e((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_nugen_nue_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_nugen_nue_mcpes\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.ellipse-abs\.\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_nugen_nue_mcpes\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.ellipse-scat\.\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_nugen_nue_mcpes\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.ellipse-abs-scat\.(m\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_nugen_nue_mcpes\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika\.out\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"PINGUcorsika\.out\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSNInjectoricemodel_plus_ten_percent_absorption(DAT\d+)(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_genie_NuMu_pingu_((v|V)\d+)_pDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_genie_NuTau_pingu_((v|V)\d+)_pDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_genie_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2a_IC\d+_genie_nutau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_nuebar\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_numubar\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"PINGU_mDOM_genie_\d+strings_\d+dps_MCPE\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"PINGU_mDOM_genie_\d+strings_\d+dps_photons\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_genie_nutau_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_numu_rangeCut_noHoleIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_newNoise_nutau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_genie_nue_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_corsika_scattering_((P|p)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_corsika_scat_absorption_m7\.1\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_corsika_absorption_((P|p)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_genie_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_ic\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.L3(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_corsika_scattering_((P|p)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_corsika_absorption_((P|p)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_corsika_scat_absorption_m7\.1\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_lowdt\.finished(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"PFFilt_(IC\d+\.\d\d\d\d)_wimp_sun_(m\d+)_(ch\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3_iti3-\d+_sibyll-fluka_ATM\d+_fe(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_nutau_rangeCut_noHoleIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genieOnly_pingu((v|V)\d+)_nutau_rangeCut_noHoleIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_CORSIKA_\d+msec_atmod_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_DOMLauncher_Noise_\d+percent_higher_noise_rate(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_genie_nutau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_genie_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genieOnly_pingu((v|V)\d+)_nue_rangeCut_noHoleIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"SMT\d+_(IC\d+\.\d\d\d\d)_wimp_earth_(m\d+)_(ch\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2\d+_(IC\d+\.\d\d\d\d)_wimp_earth_(m\d+)_(ch\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_(IC\d+\.\d\d\d\d)_wimp_earth_(m\d+)_(ch\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_highE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_(IC\d+\.\d\d\d\d)_wimp_earth_(m\d+)_(ch\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_lowE\.with\d+BDT(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_(IC\d+\.\d\d\d\d)_wimp_earth_(m\d+)_(ch\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"PFFilt_(IC\d+\.\d\d\d\d)_wimp_earth_(m\d+)_(ch\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_ICU_((v|V)\d+)_pdom\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mmc_ucr_CORSIKA_\d+_SIBYLL_F\d+slope\d+_OCT_emin((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_glue\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"we-(m\d+)-(ch\d+)-sun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_numu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_genie_numu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genieOnly_pingu((v|V)\d+)_numu_rangeCut_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_numu_rangeCut_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"L2CEM_CORSIKA_\d+_SIBYLL_F\d+slope\d+_OCT_emin((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_ic\d+eSpice_mmc_ucr_CORSIKA_\d+_SIBYLL_F\d+slope\d+_OCT_emin((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_genie_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE1((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Gen_setXOmega_\d+_mcpes((\.|_)eff\d+)\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_genie_nutaubar((\.|_)eff\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_genie_nutau((\.|_)eff\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"L1CEM_CORSIKA_\d+_SIBYLL_F\d+slope\d+_OCT_emin((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"L1CEMic\d+_ic\d+eSpice_CORSIKA_\d+_SIBYLL_F\d+slope\d+_OCT_emin((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuMu_pingu_((v|V)\d+)_pDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuMu_pingu_((v|V)\d+)_mDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+\.(?P<single>\d+)_official(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_genie_nutau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE1((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_genie_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE1((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_ic\.\d+A\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_ic\.\d+B\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_ic\.\d+C\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_genie_nue_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_nue_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_ICU_((v|V)\d+)_mdom\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_Muons_Emin_((\d+)(_|\.)(\d+))_TeV_Emax_((\d+)(_|\.)(\d+))_PeV_Gamma_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_RunNumber_\d+_Seed_\d+_L1_L2_(IC\d\d\d\d)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_Muons_Emin_((\d+)(_|\.)(\d+))_TeV_Emax_((\d+)(_|\.)(\d+))_PeV_Gamma_((\d+)(_|\.)(\d+))_RunNumber_\d+_Seed_\d+_detector_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_Muons_Emin_((\d+)(_|\.)(\d+))_TeV_Emax_((\d+)(_|\.)(\d+))_PeV_Gamma_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_RunNumber_\d+_Seed_\d+_detector__L1(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_Muons_Emin_((\d+)(_|\.)(\d+))_TeV_Emax_((\d+)(_|\.)(\d+))_PeV_Gamma_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_RunNumber_\d+_Seed_\d+_detector_L2(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_ICU_((v|V)\d+)_degg\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSNInjectoricemodel_minus_seven_percent_both(DAT\d+)(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSNInjectoricemodel_minus_seven_percent_scatter_plus_seven_percent_absorption(DAT\d+)(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSNInjectoricemodel_minus_ten_percent_absorption(DAT\d+)(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSNInjectoricemodel_minus_ten_percent_scatter(DAT\d+)(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSNInjectoricemodel_plus_seven_percent_both(DAT\d+)(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSNInjectoricemodel_plus_seven_percent_scatter_minus_seven_percent_absorption(DAT\d+)(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSNInjectoricemodel_plus_ten_percent_scatter(DAT\d+)(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level1_IC\d+_corsika_ic\d+_dc((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)_EHE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level1_IC\d+_corsika_ic\d+_dc((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_corsika_ic\d+_dc((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)_cm\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"PINGU_mDOM_genie_\d+strings_\d+dps_pulses\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"CORSIKA_\d+msec_atmod_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_DOMLauncher_Noise_\d+percent_higher_noise_rate_triggered(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"SimpleInjector_RunSimpleGenerator\.pbs_\d+\.gm-\d+r\d+-n(?P<single>\d+)\.guillimin\.clumeq\.ca(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_corsika_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_mu_e\d+_GZKweighted\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_mu_e\d+_allweighted\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"TauL2_EHE_CORSIKA_\d+_SIBYLL_F\d+slope\d+_OCT_emin((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+\.(?P<single>\d+)_corrected(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_reweight_axialMass\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_CORSIKA_\d+msec_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_DOMLauncher_Noise(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_CORSIKA_\d+msec_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genieOnly_pingu((v|V)\d+)_nue_rangeCut_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_nue_rangeCut_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_nutau_rangeCut_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuE_A_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((S|s)tep\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuE_B_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((S|s)tep\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuE_C_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((S|s)tep\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuE_D_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((S|s)tep\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_All_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"noiseonly_IC\d+_triggered_dt((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Muon_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Muon_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Electron_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_All_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Tau_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_pingu((v|V)\d+)_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Tau_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Electron_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_noise\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuE_pingu_((v|V)\d+)_pDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"L1_ic\d+eSpice_mmc_ucr_CORSIKA_\d+_SIBYLL_F\d+slope\d+_OCT_emin((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genieOnly_pingu((v|V)\d+)_nutau_rangeCut_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_nue_reweight_axialMass\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_nutau_reweight_axialMass\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_pingu((v|V)\d+)_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_pingu((v|V)\d+)_nutau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuE_pingu_((v|V)\d+)_mDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_genie_numu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_lowE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_genie_numu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_genie_numu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_highE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_All_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_All_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_nutau_e((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_IC\d+EHELevel_iron_Spice_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_IC\d+EHELevel_proton_Spice_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"nugen_nue_twr\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_\d\d\d\d\.(?P<single>\d+)_((v|V)\d+)_OctSnow(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_numu_rangeCut_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_nutau_rangeCut_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"VuvuzelaPureNoise_ICUpgrade\.((v|V)\d+)\.mixed\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"polyplopia_DOMoversize_\d+_corsika_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_nue_rangeCut_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Electron_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly_MuonProp(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Electron_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly_MuonProp(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Muon_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly_MuonProp(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Muon_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly_MuonProp(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuE_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly_MuonProp(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuMu_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly_MuonProp(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Tau_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly_MuonProp(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Tau_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly_MuonProp(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_ic\.((\d+)(_|\.)(\d+))\.L3\.\d+mCleaned((?P<alpha>\d+)(_|\.)(?P<beta>\d+))mTriggered\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_nue_e((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_numu_e((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_Muon_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_Muon_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_Muon_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_Muon_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_Muon_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_Muon_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_Muons_Gamma_((\d+)(_|\.)(\d+))_Emin_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_TeV_Emax_\d+_PeV_RunNumber_\d+_Seed_\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genieOnly_pingu((v|V)\d+)_nue_spiceLea_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genieOnly_pingu((v|V)\d+)_numu_spiceLea_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genieOnly_pingu((v|V)\d+)_nutau_spiceLea_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_nue_spiceLea_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_numu_spiceLea_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_nutau_spiceLea_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_MuonGun\.truth_events_no_cuts\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_numu_spiceLea_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_nue_spiceLea_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_nutau_reweight_axialMass\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_nutau_spiceLea_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"TopSimulator_IC\d+_corsika_icetop\.(?P<single>\d+)\.\d\d\d\d(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_numu_reweight_axialMass\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_All_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_All_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_nue_reweight_axialMass\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_Tau_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_Tau_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_Tau_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_Tau_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_Tau_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_Tau_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+_Merged(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_Electron_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_Electron_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_Electron_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_Electron_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_Electron_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_Electron_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"VuvuzelaPureNoise_ICUpgrade\.((v|V)\d+)\.sDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2b\.corsika_it\d+_ic\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Propagated_IC\d+_corsika_icetop\.(?P<single>\d+)\.\d\d\d\d(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_corsika_icetop\.(?P<single>\d+)\.\d\d\d\d(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Detector_IC\d+_corsika_icetop\.(?P<single>\d+)\.\d\d\d\d(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Electron_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Electron_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3_iti3-\d+_epos-fluka_ATM\d+_fe(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3_iti3-\d+_qgsjet\d+-fluka_ATM\d+_fe(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level3_iti3-\d+_sibyll-geisha_ATM\d+_fe(DAT\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Muon_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Muon_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuTau_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Tau_CC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Tau_NC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuTau_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_DOMoversize_\d+_corsika_(?P<single>\d+)_\d\d\d\d(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_genie_NuE_pingu_((v|V)\d+)_pDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_nugen_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_IC\d+_corsika_icetop\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_IT(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_nugen_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"bare-muons_\d+e\d+-GeV_at-(?P<single>\d+)-meters(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuTau_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly_MuonProp(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_reweight_axialMass\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_weighted(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+_TWR\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_tau_e((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2level2_pingu((v|V)\d+)_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"VuvuzelaPureNoise_ICUpgrade\.((v|V)\d+)\.D-Egg\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"VuvuzelaPureNoise_ICUpgrade\.((v|V)\d+)\.mDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"L3_IC\d+_e((\d+)(_|\.)(\d+))_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE1((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"unweighted_\d\d\d\d(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)\.\d\d\d\d_nugen_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_muongun_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"muongun_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Generation_MuonGun_Monopole\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuTau_pingu_((v|V)\d+)_mDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuTau_pingu_((v|V)\d+)_pDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_numu_GENIEsyst_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genieOnly_pingu((v|V)\d+)_numu_GENIEsyst_holeIcePINGU\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_genie_NuMu_pingu_((v|V)\d+)_pDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_genie_NuTau_pingu_((v|V)\d+)_pDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2level2_pingu((v|V)\d+)_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"it\d+-sim-H\.E((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.(DAT\d+)\.le((v|V)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)a_nue_reducedDomEff\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_nue_goodWavedeform\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"it\d+-sim-Fe\.E((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.(DAT\d+)\.le((v|V)\d+)-\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level1_genie_pingu((v|V)\d+)_nutau_postEBugFix_rangeCut\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_nutau_goodWavedeform\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_numu_goodWavedeform\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level1_genie_pingu((v|V)\d+)_nue_postEBugFix_rangeCut\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)a_nutau_reducedDomEff\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)b_numu_reducedPDomEff_\d+((P|p)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"bug\.(IC\d+\.\d\d\d\d)_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"fix\.(IC\d+\.\d\d\d\d)_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)a_numu_reducedDomEff\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level5b_(IC\d+\.\d\d\d\d)_genie_numu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))XX(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)_numu_properNoise\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level1_genie_pingu((v|V)\d+)_numu_postEBugFix_rangeCut\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuMu_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2level2_pingu((v|V)\d+)_nutau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"it\d+-sim-H\.E((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.(DAT\d+)\.le((v|V)\d+)-\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"S-frame(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_Level2_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"it\d+-sim-Fe\.E((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.(DAT\d+)\.le((v|V)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_nugen_numu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_highE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_nugen_numu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_lowE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_nugen_numu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_CORSIKA_\d+msec_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"All_GR\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly_MuonProp(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_genie_NuE_pingu_((v|V)\d+)_mDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuTau_B_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((S|s)tep\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuMu_A_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((S|s)tep\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuMu_B_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((S|s)tep\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuMu_C_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((S|s)tep\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuMu_D_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((S|s)tep\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuTau_A_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((S|s)tep\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuTau_C_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((S|s)tep\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuTau_D_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((S|s)tep\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"breakparttest_(?P<single>\d+)_(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_muongun_(IC\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_nugen_nue_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_highE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_nugen_nue_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_lowE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_nugen_nue_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"L1CEM_SPICE_CORSIKA_\d+_SIBYLL_F\d+slope\d+_OCT_emin((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_highE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_lowE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)b_nue_reducedPDomEff_\d+((P|p)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_IC\d+_nugen_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_it\d+_ic\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"detector_DOMoversize_\d+_corsika_(?P<single>\d+)_\d\d\d\d(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCPEs_merged_DOMoversize_\d+_corsika_(?P<single>\d+)_\d\d\d\d(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_reweight_part((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+:\d\d\d\d_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_Merged_Muons_Emin_((\d+)(_|\.)(\d+))_TeV_Emax_((\d+)(_|\.)(\d+))_PeV_Gamma_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_RunNumber_\d\d\d\d_Seed_\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_nue_domLaunchTest_fixed\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_nue_domLaunchTest_intermed\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_numu_revertAll\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_SLOP(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_NuMu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_corsika\.((\d+)(_|\.)(\d+))\.DOMeff((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_PEs(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"hits\.(IC\d+\.\d\d\d\d)_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuTau_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_level1\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuTau_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_level1\d+_tmp(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuMu_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_level1\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_genie_pingu((v|V)\d+)b_nutau_reducedPDomEff_\d+((P|p)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_NuE_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuE_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_level1\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_5comp_(sibyll\d\.\d[a-z]?)_\d\d\d\d(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_NuTau_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"old((S|s)tep\d+)_new((S|s)tep\d+)\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)\.genie_NuMu\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_nugen_NuTau\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"temp_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_numu_domLaunchTest_fixed\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_NuE_pingu_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_genie_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE((P|p)\d+)\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ucr_CORSIKA_\d+_SIBYLL_F\d+slope\d+_OCT_emin((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_glue\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"All_GR\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuMu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_All_GR\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_All_GR\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_All_GR\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_genie_nue_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_genie_nue_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_highE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_genie_nue_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_lowE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuE_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.az\d+_p(DAT\d+)_(?P<single>\d+)\.spv\.s\.pre(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.az\d+_p(DAT\d+)_(?P<single>\d+)\.spv\.s\.reco(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+\.(?P<single>\d+)_corrected_((v|V)\d+)_NovSnow(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"L1CEMic\d+_ic\d+f_CORSIKA_\d+_SIBYLL_F\d+slope\d+_OCT_emin((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Final_MCSample_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSample_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_nutau_goodWavedeform\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"TopSimulator_detector_IC\d+_corsika_icetop\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuTau_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.az\d+_fe(DAT\d+)_(?P<single>\d+)\.spv\.s\.pre(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.az\d+_fe(DAT\d+)_(?P<single>\d+)\.spv\.s\.reco(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE1((P|p)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)\.\d\d\d\d_nugen_NuE\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_ic\.(?P<single>\d+)\.\d\d\d\d\.L2a(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuMu_NuGenCCNC\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_poly(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+_Merged_Muons_Emin_((\d+)(_|\.)(\d+))_TeV_Emax_((\d+)(_|\.)(\d+))_PeV_Gamma_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_RunNumber_\d\d\d\d_Seed_\d+_L1_L2_(IC\d\d\d\d)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+\.(?P<single>\d+)_L2a(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_numu_domLaunchTest_fixed\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_weighted(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)a_nutau_reducedDomEff\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"L1CEMic\d+_ic\d+f_CORSIKA_\d+_SIBYLL_F\d+slope\d+_MAR_emin((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_genie_nutau_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+\.(?P<single>\d+)_candidate(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_genie_nutau_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_highE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_genie_nutau_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_lowE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_\d\d\d\d\.(?P<single>\d+)_((v|V)\d+)_NovSnow(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FinalLevel_All_NuGenAll\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_All_NuGenAll\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_All_NuGenAll\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_ICUpgrade\.((v|V)\d+)\.mixed\.((v|V)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_Gen_setBOmega_\d+_mcpes((\.|_)eff\d+)\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Final_MCSample_\d+_DC_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSample_\d+_DC_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Truth_MCSample_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"RunSNInjCLSim-\d\d\d\d_(?P<single>\d+)[\d\d\d\d]\.jasper-usradm\.westgrid\.ca(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.DOMeff\d+_PEs(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_numu_goodWavedeform\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)_nue_goodWavedeform\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_(?P<single>\d+)_\d\d\d\d(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"RunSNInjCLSim-\d\d\d\d_(?P<single>\d+)-\d\d\d\d\.jasper-usradm\.westgrid\.ca(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"photons_DOMoversize_\d+_corsika_(?P<single>\d+)_\d\d\d\d(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"juliet_mu_e(?P<single>\d+)\.\d\d\d\d(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"it\d+-sim-He\.E((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.(DAT\d+)\.le((v|V)\d+)-\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"it\d+-sim-O\.E((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.(DAT\d+)\.le((v|V)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_genie_nue\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)\.DE1((P|p)\d+)\.((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_pingu((v|V)\d+)a_nue_reducedDomEff\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"it\d+-sim-He\.E((?P<alpha>\d+)(_|\.)(?P<beta>\d+))\.(DAT\d+)\.le((v|V)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_corsika_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)-\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Final_MCSample_nominal_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSample_nominal_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"photons\.Sunflower_\d+m_CORSIKA\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Sunflower_\d+m_CORSIKA\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_5comp_(sibyll\d\.\d[a-z]?)_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_AVG_\d+-\d+_PASS(?P<single>\d+)_SPE_withStdNoise(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"TweakedGeoCalibDetectorStatus\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GCS(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_photons_ICU_((v|V)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"genie_numu_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"oscNext_corsika_((S|s)tep\d+)_((Pass|pass|PASS)\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_\d\d\d\d\.(?P<single>\d+)_icesi(m\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_ICUpgrade\.((v|V)\d+)\.D-Egg\.((v|V)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_ICUpgrade\.((v|V)\d+)\.mDOM\.((v|V)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Dozier_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_ICUpgrade\.((v|V)\d+)\.mixed_mergedGeo\.((v|V)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+_DC((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"CORSIKA_\d+msec_atmod_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_DOMLauncher_Noise_\d+percent_higher_noise_rate(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((S|s)tep\d+)_genie_NuE_pingu_((v|V)\d+)_mDOM\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.arrang_fe(DAT\d+)_(?P<single>\d+)\.spv\.pre(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.arrang_fe(DAT\d+)_(?P<single>\d+)\.spv\.reco(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.arrang_fe(DAT\d+)_(?P<single>\d+)\.spv\.reco\.pbd(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.arrang_p(DAT\d+)_(?P<single>\d+)\.spv\.pre(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.arrang_p(DAT\d+)_(?P<single>\d+)\.spv\.reco(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.arrang_p(DAT\d+)_(?P<single>\d+)\.spv\.reco\.pbd(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IceTop_IC\d+_corsika_icetop\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.june_fe(DAT\d+)_(?P<single>\d+)\.spv\.s\.pre(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.june_fe(DAT\d+)_(?P<single>\d+)\.spv\.s\.reco(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.june_p(DAT\d+)_(?P<single>\d+)\.spv\.s\.pre(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.june_p(DAT\d+)_(?P<single>\d+)\.spv\.s\.reco(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Sframe(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"\d+_atmod(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Ellett_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Gilmour_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_Gen_setAOmega_\d+_mcpes((\.|_)eff\d+)\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_AVG_\d+-\d+_PASS(?P<single>\d+)_SPE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_\$steering\(outfile\)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Final_MCSample_nominal_DC_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSample_nominal_DC_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Truth_MCSample_nominal_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+\.All_((Pass|pass|PASS)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_pingu((v|V)\d+)_nue_redEff\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_pingu((v|V)\d+)_nue_spiceLea\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"level2_pingu((v|V)\d+)_nue_varyEff\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NuTau_AA_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((S|s)tep\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_\d\d\d\d_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)\.\d\d\d\d_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"(IC\d+\.\d\d\d\d)_\d\d\d\d_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"failed_Level2_corsika_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+\.(?P<single>\d+)_correctedgeo(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"failed_corsika_ic\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_All_None\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_default(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_All_None\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.az\d+_fe(DAT\d+)_big(?P<single>\d+)\.spv\.s\.pre(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.az\d+_fe(DAT\d+)_big(?P<single>\d+)\.spv\.s\.reco(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.az\d+_p(DAT\d+)_big(?P<single>\d+)\.spv\.s\.pre(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"ama\.mmc\.az\d+_p(DAT\d+)_big(?P<single>\d+)\.spv\.s\.reco(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_CORSIKA\d+msec_atmod_(?P<single>\d+)_DOMLauncher_Noise(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+\.(?P<single>\d+)_change(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Zezel_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_Upgrade\.((v|V)\d+)_s\d+_d(?P<single>\d+)_D-Egg(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_Upgrade\.((v|V)\d+)_s\d+_d(?P<single>\d+)_mDOM(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_Upgrade\.((v|V)\d+)_s\d+_d(?P<single>\d+)_sDOM(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_Experimental\.((v|V)\d+)_mixed(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_Experimental\.((v|V)\d+)_sDOM(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+\.\d+_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level\d+_pingu((v|V)\d+)_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika\.in(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"IC\d+-GCD(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_CORSIKA\d+msec_atmod_\d+_DOMLauncher_Noise_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_PINGU\.\d+_corrected_((v|V)\d+)_((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)m_Trig(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"L3_IC\d+_muongun\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"NEW_GeoCalibDetectorStatus_IC\d+_DC((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"failed_nugen_numu_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus\d+Str\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_CORSIKA_(?P<single>\d+)msec(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"test_long_corsika_(?P<single>\d+)musec(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"PINGU_mDOM_genie_\d+strings_\d+dps_FiniteReco\.(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+\.(?P<single>\d+)\.noP(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+\.\d+_L2a_HQERDE((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_IC\d+\.\d+_corrected_HQERDE((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"L1Monopole_KYG1_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_\d+(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"failed_Level2_nugen_numu_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"HigherRate_\d+percentlong_CORSIKA_\d+msec_atmod_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"CORSIKA_\d+msec_atmod_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_((as\.flasher|clsim-|err_s|only_muons|base|untriggered).*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_AVG_\d+-\d+_PASS(?P<single>\d+)_SPE_withScaledNoise(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_AVG_\d+-(?P<single>\d+)_UNITY_default(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_AVG_\d+-(?P<single>\d+)_UNITY_default_withStdNoise(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"large(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"o(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"muongun(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"breakparttest(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_CORKSIKA_(?P<single>\d+)musec(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_CORKSIKA_(?P<single>\d+)musec_Noise_DOMLauncher(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_CORKSIKA_(?P<single>\d+)musec_NoNoise_DOMLauncher(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"test_long_corsika_DOMLauncher_Noise(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"test_long_corsika_DOMLauncher_NoNoise(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"test_long_corsika_DOMLauncher_NoNoise_(?P<single>\d+)musec(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"test_long_corsika(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"test_long_corsika_newDOMLauncher_Noise_(?P<single>\d+)msec(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"test_long_corsika_newDOMLauncher_Noise_(?P<single>\d+)musec(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"test_long_corsika_newDOMLauncher_NoNoise_(?P<single>\d+)msec(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"test_long_corsika_newDOMLauncher_NoNoise_(?P<single>\d+)musec(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"test_long_corsika_newpolyplopia(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"FullShenGarching(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Test(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"TWCleaningCheck(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"TWCleaning_redoTrig_test(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"BasicRecoTest(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"PINGU_mDOM_genie_\d+strings_\d+dps_pulses\.(?P<single>\d+)\.TEST(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MakeSNI\d+MCTrees_(?P<single>\d+)_pruned(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"test_script_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"test_script(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"test_SN(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"test_snsample(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mc_cascade_nue_CC(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mc_cascade_nue_NC(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mc_casc_track_hor_down_numubar(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mc_casc_track_hor_up_numubar(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mc_casc_track_vert_down_numubar(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mc_casc_track_vert_up_numubar(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mc_casc_track_hor_down_numu(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mc_casc_track_hor_up_numu(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mc_casc_track_vert_down_numu(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mc_casc_track_vert_up_numu(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mc_hor_track_numubar(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mc_vert_down_track_numubar(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mc_vert_up_track_numubar(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"mc_veryvert_trackstr_numubar(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika\.combined\.out\.(?P<single>\d+)files(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel(?P<single>\d+)BCombinedDetector(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodelCombinedDetector(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel_minus_seven_percent_bothCombinedDetector(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel_minus_seven_percent_scatter_plus_seven_percent_absorptionCombinedDetector(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel_minus_ten_percent_absorptionCombinedDetector(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel_minus_ten_percent_scatterCombinedDetector(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel_plus_seven_percent_bothCombinedDetector(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel_plus_seven_percent_scatter_minus_seven_percent_absorptionCombinedDetector(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel_plus_ten_percent_absorptionCombinedDetector(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel_plus_ten_percent_scatterCombinedDetector(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)spice_mie(?P<single>\d+)BCombinedDetector(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel(?P<single>\d+)BCombinedDetectorNew(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodelCombinedDetectorNew(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel_minus_seven_percent_bothCombinedDetectorNew(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel_minus_seven_percent_scatter_plus_seven_percent_absorptionCombinedDetectorNew(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel_minus_ten_percent_absorptionCombinedDetectorNew(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel_minus_ten_percent_scatterCombinedDetectorNew(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel_plus_seven_percent_bothCombinedDetectorNew(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)icemodel_plus_seven_percent_scatter_minus_seven_percent_absorptionCombinedDetectorNew(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(DAT\d+)spice_mie(?P<single>\d+)BCombinedDetectorNew(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_ICUpgrade\.((v|V)\d+)\.mixed_noGap\.((v|V)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Jokinen_\d+_s\d+_d(?P<single>\d+)_pDOM_reduced(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_ICUpgrade\.((v|V)\d+)\.sDOM\.V*(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_PINGU\.\d+_corrected_((v|V)\d+)_(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_PINGU\.(?P<single>\d+)_corrected_((v|V)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"event_display_numu_nue_((v|V)\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Amadan_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Anderson_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)a_Zezel_reducedDomEff_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Barilko_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Belfour_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Corson_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Domi_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Francis_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Gould_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Harris_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Horton_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Iafrate_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Jokinen_\d+_s\d+_d\d+_w(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Joseph_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Kaberle_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Lindros_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_McCabe_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Newbury_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Olczyk_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Potvin_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Quinn_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Roberts_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Shanahan_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Sundin_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Tucker_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Ullman_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Vaive_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Williams_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Zezel_varyDomEff_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Jokinen_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)_Hoglund_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_pingu_((v|V)\d+)((P|p)\d+)_Hoak_\d+_s\d+_d(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_genie_numu_\d+_\d\d\d\d_L2_dlbugfixed_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_genie_genie_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_highE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_genie_genie_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_lowE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_genie_numu_\d+_\d\d\d\d_L2_dlbugfixed_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_highE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_genie_numu_\d+_\d\d\d\d_L2_dlbugfixed_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_lowE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_nugen_nutau_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_highE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_nugen_nutau_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files_lowE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_nugen_nutau_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+)(_|\.)\d+)files(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"failed_Level2a_IC\d+_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"failed_Level2_IC\d+_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_SLOP(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"M_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_upToPPC(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"corsika_photons_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"long_CORSIKA_\d+msec_atmod_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_DOMLauncher_Noise_Triggered(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"photons_DOMefficieny_\d+_corsika_((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_corsika_IC\d+\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_itonly(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level2_(IC\d+\.\d\d\d\d)_data_Run\d+_Subrun((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_(IC\d+\.\d\d\d\d)_corsika\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_highE(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_nugen_numu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_CSCD(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_nugen_numu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_low_energy(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3_nugen_numu_(IC\d+\.\d\d\d\d)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_muon(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"__trash_Level2_(IC\d+\.\d\d\d\d)_wimp_sun_(m\d+)_(ch\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"Level3a_(IC\d+\.\d\d\d\d)_wimp_earth_(m\d+)_(ch\d+)\.((?P<alpha>\d+)(_|\.)(?P<beta>\d+))_highE\.strange_FR_events(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    ####################################################################################
    # Now, Handwritten Patterns
    ####################################################################################
    r"MCSNInjector(spice_mie|icemodel)?([a-zA-Z_]*)(\d+MeV)(?P<single>\d+)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"GeoCalibDetectorStatus_ICUpgrade\.((v|V)\d+)\.sDOM\.((v|V)(\d+|\*))(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
    r"MCSN(\d+MeV)([a-zA-Z_]*)(1B)?([a-zA-Z_]*)(\.i3|\.i3\.gz|\.i3\.bz2|\.i3\.zst)$",
]
