# coding: utf-8

"""
    DocuSign Click API

    Elastic signing (also known as DocuSign Click)  lets you capture consent to standard agreement terms with a single click: terms and conditions, terms of service, terms of use, privacy policies, and more. The Click API lets you include this customizable elastic template solution in your DocuSign integrations.  # noqa: E501

    OpenAPI spec version: v1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from docusign_click.client.configuration import Configuration


class ServiceVersion(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'version': 'str',
        'version_url': 'str'
    }

    attribute_map = {
        'version': 'version',
        'version_url': 'versionUrl'
    }

    def __init__(self, _configuration=None, **kwargs):  # noqa: E501
        """ServiceVersion - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._version = None
        self._version_url = None
        self.discriminator = None

        setattr(self, "_{}".format('version'), kwargs.get('version', None))
        setattr(self, "_{}".format('version_url'), kwargs.get('version_url', None))

    @property
    def version(self):
        """Gets the version of this ServiceVersion.  # noqa: E501

        The human-readable semver version string.  # noqa: E501

        :return: The version of this ServiceVersion.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this ServiceVersion.

        The human-readable semver version string.  # noqa: E501

        :param version: The version of this ServiceVersion.  # noqa: E501
        :type: str
        """

        self._version = version

    @property
    def version_url(self):
        """Gets the version_url of this ServiceVersion.  # noqa: E501

        The URL where this version of the API can be found.  # noqa: E501

        :return: The version_url of this ServiceVersion.  # noqa: E501
        :rtype: str
        """
        return self._version_url

    @version_url.setter
    def version_url(self, version_url):
        """Sets the version_url of this ServiceVersion.

        The URL where this version of the API can be found.  # noqa: E501

        :param version_url: The version_url of this ServiceVersion.  # noqa: E501
        :type: str
        """

        self._version_url = version_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ServiceVersion, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServiceVersion):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ServiceVersion):
            return True

        return self.to_dict() != other.to_dict()
