# coding: utf-8

"""
    DocuSign Click API

    Elastic signing (also known as DocuSign Click)  lets you capture consent to standard agreement terms with a single click: terms and conditions, terms of service, terms of use, privacy policies, and more. The Click API lets you include this customizable elastic template solution in your DocuSign integrations.  # noqa: E501

    OpenAPI spec version: v1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from docusign_click.client.configuration import Configuration


class DisplaySettings(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'action_button_alignment': 'str',
        'allow_client_only': 'bool',
        'allowed_hosts': 'list[str]',
        'brand_id': 'str',
        'consent_button_text': 'str',
        'consent_text': 'str',
        'decline_button_text': 'str',
        'display_name': 'str',
        'document_display': 'str',
        'downloadable': 'bool',
        'format': 'str',
        'has_decline_button': 'bool',
        'must_read': 'bool',
        'must_view': 'bool',
        'record_decline_responses': 'bool',
        'require_accept': 'bool',
        'send_to_email': 'bool',
        'statement_alignment': 'str'
    }

    attribute_map = {
        'action_button_alignment': 'actionButtonAlignment',
        'allow_client_only': 'allowClientOnly',
        'allowed_hosts': 'allowedHosts',
        'brand_id': 'brandId',
        'consent_button_text': 'consentButtonText',
        'consent_text': 'consentText',
        'decline_button_text': 'declineButtonText',
        'display_name': 'displayName',
        'document_display': 'documentDisplay',
        'downloadable': 'downloadable',
        'format': 'format',
        'has_decline_button': 'hasDeclineButton',
        'must_read': 'mustRead',
        'must_view': 'mustView',
        'record_decline_responses': 'recordDeclineResponses',
        'require_accept': 'requireAccept',
        'send_to_email': 'sendToEmail',
        'statement_alignment': 'statementAlignment'
    }

    def __init__(self, _configuration=None, **kwargs):  # noqa: E501
        """DisplaySettings - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._action_button_alignment = None
        self._allow_client_only = None
        self._allowed_hosts = None
        self._brand_id = None
        self._consent_button_text = None
        self._consent_text = None
        self._decline_button_text = None
        self._display_name = None
        self._document_display = None
        self._downloadable = None
        self._format = None
        self._has_decline_button = None
        self._must_read = None
        self._must_view = None
        self._record_decline_responses = None
        self._require_accept = None
        self._send_to_email = None
        self._statement_alignment = None
        self.discriminator = None

        setattr(self, "_{}".format('action_button_alignment'), kwargs.get('action_button_alignment', None))
        setattr(self, "_{}".format('allow_client_only'), kwargs.get('allow_client_only', None))
        setattr(self, "_{}".format('allowed_hosts'), kwargs.get('allowed_hosts', None))
        setattr(self, "_{}".format('brand_id'), kwargs.get('brand_id', None))
        setattr(self, "_{}".format('consent_button_text'), kwargs.get('consent_button_text', None))
        setattr(self, "_{}".format('consent_text'), kwargs.get('consent_text', None))
        setattr(self, "_{}".format('decline_button_text'), kwargs.get('decline_button_text', None))
        setattr(self, "_{}".format('display_name'), kwargs.get('display_name', None))
        setattr(self, "_{}".format('document_display'), kwargs.get('document_display', None))
        setattr(self, "_{}".format('downloadable'), kwargs.get('downloadable', None))
        setattr(self, "_{}".format('format'), kwargs.get('format', None))
        setattr(self, "_{}".format('has_decline_button'), kwargs.get('has_decline_button', None))
        setattr(self, "_{}".format('must_read'), kwargs.get('must_read', None))
        setattr(self, "_{}".format('must_view'), kwargs.get('must_view', None))
        setattr(self, "_{}".format('record_decline_responses'), kwargs.get('record_decline_responses', None))
        setattr(self, "_{}".format('require_accept'), kwargs.get('require_accept', None))
        setattr(self, "_{}".format('send_to_email'), kwargs.get('send_to_email', None))
        setattr(self, "_{}".format('statement_alignment'), kwargs.get('statement_alignment', None))

    @property
    def action_button_alignment(self):
        """Gets the action_button_alignment of this DisplaySettings.  # noqa: E501

        Position of the Accept button in the agreement. One of   - `right` - `left`   # noqa: E501

        :return: The action_button_alignment of this DisplaySettings.  # noqa: E501
        :rtype: str
        """
        return self._action_button_alignment

    @action_button_alignment.setter
    def action_button_alignment(self, action_button_alignment):
        """Sets the action_button_alignment of this DisplaySettings.

        Position of the Accept button in the agreement. One of   - `right` - `left`   # noqa: E501

        :param action_button_alignment: The action_button_alignment of this DisplaySettings.  # noqa: E501
        :type: str
        """

        self._action_button_alignment = action_button_alignment

    @property
    def allow_client_only(self):
        """Gets the allow_client_only of this DisplaySettings.  # noqa: E501

        When **true,** this agreement can be be used in client-only integrations.  # noqa: E501

        :return: The allow_client_only of this DisplaySettings.  # noqa: E501
        :rtype: bool
        """
        return self._allow_client_only

    @allow_client_only.setter
    def allow_client_only(self, allow_client_only):
        """Sets the allow_client_only of this DisplaySettings.

        When **true,** this agreement can be be used in client-only integrations.  # noqa: E501

        :param allow_client_only: The allow_client_only of this DisplaySettings.  # noqa: E501
        :type: bool
        """

        self._allow_client_only = allow_client_only

    @property
    def allowed_hosts(self):
        """Gets the allowed_hosts of this DisplaySettings.  # noqa: E501

        Hosts that can host the clickwrap.  It is an error if the clickwrap didn't come from one of these hosts.   # noqa: E501

        :return: The allowed_hosts of this DisplaySettings.  # noqa: E501
        :rtype: list[str]
        """
        return self._allowed_hosts

    @allowed_hosts.setter
    def allowed_hosts(self, allowed_hosts):
        """Sets the allowed_hosts of this DisplaySettings.

        Hosts that can host the clickwrap.  It is an error if the clickwrap didn't come from one of these hosts.   # noqa: E501

        :param allowed_hosts: The allowed_hosts of this DisplaySettings.  # noqa: E501
        :type: list[str]
        """

        self._allowed_hosts = allowed_hosts

    @property
    def brand_id(self):
        """Gets the brand_id of this DisplaySettings.  # noqa: E501

        The signing brand ID.  # noqa: E501

        :return: The brand_id of this DisplaySettings.  # noqa: E501
        :rtype: str
        """
        return self._brand_id

    @brand_id.setter
    def brand_id(self, brand_id):
        """Sets the brand_id of this DisplaySettings.

        The signing brand ID.  # noqa: E501

        :param brand_id: The brand_id of this DisplaySettings.  # noqa: E501
        :type: str
        """

        self._brand_id = brand_id

    @property
    def consent_button_text(self):
        """Gets the consent_button_text of this DisplaySettings.  # noqa: E501

        Text on the agree button.  # noqa: E501

        :return: The consent_button_text of this DisplaySettings.  # noqa: E501
        :rtype: str
        """
        return self._consent_button_text

    @consent_button_text.setter
    def consent_button_text(self, consent_button_text):
        """Sets the consent_button_text of this DisplaySettings.

        Text on the agree button.  # noqa: E501

        :param consent_button_text: The consent_button_text of this DisplaySettings.  # noqa: E501
        :type: str
        """

        self._consent_button_text = consent_button_text

    @property
    def consent_text(self):
        """Gets the consent_text of this DisplaySettings.  # noqa: E501

        The statement prefixing the Electronic Record and Signature Disclosure agreement.  # noqa: E501

        :return: The consent_text of this DisplaySettings.  # noqa: E501
        :rtype: str
        """
        return self._consent_text

    @consent_text.setter
    def consent_text(self, consent_text):
        """Sets the consent_text of this DisplaySettings.

        The statement prefixing the Electronic Record and Signature Disclosure agreement.  # noqa: E501

        :param consent_text: The consent_text of this DisplaySettings.  # noqa: E501
        :type: str
        """

        self._consent_text = consent_text

    @property
    def decline_button_text(self):
        """Gets the decline_button_text of this DisplaySettings.  # noqa: E501

        The text on the decline button.  # noqa: E501

        :return: The decline_button_text of this DisplaySettings.  # noqa: E501
        :rtype: str
        """
        return self._decline_button_text

    @decline_button_text.setter
    def decline_button_text(self, decline_button_text):
        """Sets the decline_button_text of this DisplaySettings.

        The text on the decline button.  # noqa: E501

        :param decline_button_text: The decline_button_text of this DisplaySettings.  # noqa: E501
        :type: str
        """

        self._decline_button_text = decline_button_text

    @property
    def display_name(self):
        """Gets the display_name of this DisplaySettings.  # noqa: E501

        The display name of the user agreement.  # noqa: E501

        :return: The display_name of this DisplaySettings.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this DisplaySettings.

        The display name of the user agreement.  # noqa: E501

        :param display_name: The display_name of this DisplaySettings.  # noqa: E501
        :type: str
        """

        self._display_name = display_name

    @property
    def document_display(self):
        """Gets the document_display of this DisplaySettings.  # noqa: E501

        Display type: link, document or pdf  # noqa: E501

        :return: The document_display of this DisplaySettings.  # noqa: E501
        :rtype: str
        """
        return self._document_display

    @document_display.setter
    def document_display(self, document_display):
        """Sets the document_display of this DisplaySettings.

        Display type: link, document or pdf  # noqa: E501

        :param document_display: The document_display of this DisplaySettings.  # noqa: E501
        :type: str
        """

        self._document_display = document_display

    @property
    def downloadable(self):
        """Gets the downloadable of this DisplaySettings.  # noqa: E501

        **True** if the agreement is downloadable.  # noqa: E501

        :return: The downloadable of this DisplaySettings.  # noqa: E501
        :rtype: bool
        """
        return self._downloadable

    @downloadable.setter
    def downloadable(self, downloadable):
        """Sets the downloadable of this DisplaySettings.

        **True** if the agreement is downloadable.  # noqa: E501

        :param downloadable: The downloadable of this DisplaySettings.  # noqa: E501
        :type: bool
        """

        self._downloadable = downloadable

    @property
    def format(self):
        """Gets the format of this DisplaySettings.  # noqa: E501

        Display format: inline or modal.  # noqa: E501

        :return: The format of this DisplaySettings.  # noqa: E501
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this DisplaySettings.

        Display format: inline or modal.  # noqa: E501

        :param format: The format of this DisplaySettings.  # noqa: E501
        :type: str
        """

        self._format = format

    @property
    def has_decline_button(self):
        """Gets the has_decline_button of this DisplaySettings.  # noqa: E501

        **True** if the agreement has a decline button.  # noqa: E501

        :return: The has_decline_button of this DisplaySettings.  # noqa: E501
        :rtype: bool
        """
        return self._has_decline_button

    @has_decline_button.setter
    def has_decline_button(self, has_decline_button):
        """Sets the has_decline_button of this DisplaySettings.

        **True** if the agreement has a decline button.  # noqa: E501

        :param has_decline_button: The has_decline_button of this DisplaySettings.  # noqa: E501
        :type: bool
        """

        self._has_decline_button = has_decline_button

    @property
    def must_read(self):
        """Gets the must_read of this DisplaySettings.  # noqa: E501

        **True** if the user needs to scroll to the end of the document.  # noqa: E501

        :return: The must_read of this DisplaySettings.  # noqa: E501
        :rtype: bool
        """
        return self._must_read

    @must_read.setter
    def must_read(self, must_read):
        """Sets the must_read of this DisplaySettings.

        **True** if the user needs to scroll to the end of the document.  # noqa: E501

        :param must_read: The must_read of this DisplaySettings.  # noqa: E501
        :type: bool
        """

        self._must_read = must_read

    @property
    def must_view(self):
        """Gets the must_view of this DisplaySettings.  # noqa: E501

        **True** if the user must view the document.  # noqa: E501

        :return: The must_view of this DisplaySettings.  # noqa: E501
        :rtype: bool
        """
        return self._must_view

    @must_view.setter
    def must_view(self, must_view):
        """Sets the must_view of this DisplaySettings.

        **True** if the user must view the document.  # noqa: E501

        :param must_view: The must_view of this DisplaySettings.  # noqa: E501
        :type: bool
        """

        self._must_view = must_view

    @property
    def record_decline_responses(self):
        """Gets the record_decline_responses of this DisplaySettings.  # noqa: E501

        When **true,** this agreement records decline actions.  # noqa: E501

        :return: The record_decline_responses of this DisplaySettings.  # noqa: E501
        :rtype: bool
        """
        return self._record_decline_responses

    @record_decline_responses.setter
    def record_decline_responses(self, record_decline_responses):
        """Sets the record_decline_responses of this DisplaySettings.

        When **true,** this agreement records decline actions.  # noqa: E501

        :param record_decline_responses: The record_decline_responses of this DisplaySettings.  # noqa: E501
        :type: bool
        """

        self._record_decline_responses = record_decline_responses

    @property
    def require_accept(self):
        """Gets the require_accept of this DisplaySettings.  # noqa: E501

        **True** if a checkbox is required to accept.  # noqa: E501

        :return: The require_accept of this DisplaySettings.  # noqa: E501
        :rtype: bool
        """
        return self._require_accept

    @require_accept.setter
    def require_accept(self, require_accept):
        """Sets the require_accept of this DisplaySettings.

        **True** if a checkbox is required to accept.  # noqa: E501

        :param require_accept: The require_accept of this DisplaySettings.  # noqa: E501
        :type: bool
        """

        self._require_accept = require_accept

    @property
    def send_to_email(self):
        """Gets the send_to_email of this DisplaySettings.  # noqa: E501

        **True** if send to email is applicable.  # noqa: E501

        :return: The send_to_email of this DisplaySettings.  # noqa: E501
        :rtype: bool
        """
        return self._send_to_email

    @send_to_email.setter
    def send_to_email(self, send_to_email):
        """Sets the send_to_email of this DisplaySettings.

        **True** if send to email is applicable.  # noqa: E501

        :param send_to_email: The send_to_email of this DisplaySettings.  # noqa: E501
        :type: bool
        """

        self._send_to_email = send_to_email

    @property
    def statement_alignment(self):
        """Gets the statement_alignment of this DisplaySettings.  # noqa: E501

        Position of the agreement statement. One of   - `top` - `bottom`   # noqa: E501

        :return: The statement_alignment of this DisplaySettings.  # noqa: E501
        :rtype: str
        """
        return self._statement_alignment

    @statement_alignment.setter
    def statement_alignment(self, statement_alignment):
        """Sets the statement_alignment of this DisplaySettings.

        Position of the agreement statement. One of   - `top` - `bottom`   # noqa: E501

        :param statement_alignment: The statement_alignment of this DisplaySettings.  # noqa: E501
        :type: str
        """

        self._statement_alignment = statement_alignment

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DisplaySettings, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DisplaySettings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DisplaySettings):
            return True

        return self.to_dict() != other.to_dict()
